/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ASTErrorUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprFactory;
import org.apache.hadoop.hive.ql.parse.type.JoinTypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckProcFactory;

public class JoinCondTypeCheckProcFactory<T>
extends TypeCheckProcFactory<T> {
    protected JoinCondTypeCheckProcFactory(ExprFactory<T> factory) {
        super(factory);
    }

    @Override
    protected TypeCheckProcFactory.ColumnExprProcessor getColumnExprProcessor() {
        return new JoinCondColumnExprProcessor();
    }

    @Override
    protected TypeCheckProcFactory.DefaultExprProcessor getDefaultExprProcessor() {
        return new JoinCondDefaultExprProcessor();
    }

    public class JoinCondColumnExprProcessor
    extends TypeCheckProcFactory.ColumnExprProcessor {
        public JoinCondColumnExprProcessor() {
            super(JoinCondTypeCheckProcFactory.this);
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ASTNode parent;
            JoinTypeCheckCtx ctx = (JoinTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode aSTNode = parent = stack.size() > 1 ? (ASTNode)stack.get(stack.size() - 2) : null;
            if (expr.getType() != 1276) {
                ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)expr), expr);
                return null;
            }
            assert (expr.getChildCount() == 1);
            String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            boolean qualifiedAccess = parent != null && parent.getType() == 16;
            ColumnInfo colInfo = null;
            if (!qualifiedAccess) {
                colInfo = this.getColInfo(ctx, null, tableOrCol, expr);
                return JoinCondTypeCheckProcFactory.this.exprFactory.createColumnRefExpr(colInfo, ctx.getInputRRList());
            }
            if (this.hasTableAlias(ctx, tableOrCol, expr)) {
                return null;
            }
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_TABLE_ALIAS.getMsg(), (ASTNode)expr));
        }

        private boolean hasTableAlias(JoinTypeCheckCtx ctx, String tabName, ASTNode expr) throws SemanticException {
            int tblAliasCnt = 0;
            for (RowResolver rr : ctx.getInputRRList()) {
                if (!rr.hasTableAlias(tabName)) continue;
                ++tblAliasCnt;
            }
            if (tblAliasCnt == 0 && ctx.getOuterRR() != null && ctx.getOuterRR().hasTableAlias(tabName)) {
                ++tblAliasCnt;
            }
            if (tblAliasCnt > 1) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN.getMsg(), (ASTNode)expr));
            }
            return tblAliasCnt == 1;
        }

        private ColumnInfo getColInfo(JoinTypeCheckCtx ctx, String tabName, String colAlias, ASTNode expr) throws SemanticException {
            ColumnInfo cInfoToRet = null;
            for (RowResolver rr : ctx.getInputRRList()) {
                ColumnInfo tmp = rr.get(tabName, colAlias);
                if (tmp == null) continue;
                if (cInfoToRet != null) {
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN.getMsg(), (ASTNode)expr));
                }
                cInfoToRet = tmp;
            }
            return cInfoToRet;
        }
    }

    protected class JoinCondDefaultExprProcessor
    extends TypeCheckProcFactory.DefaultExprProcessor {
        protected JoinCondDefaultExprProcessor() {
            super(JoinCondTypeCheckProcFactory.this);
        }

        @Override
        protected List<String> getReferenceableColumnAliases(TypeCheckCtx ctx) {
            JoinTypeCheckCtx jCtx = (JoinTypeCheckCtx)ctx;
            ArrayList<String> possibleColumnNames = new ArrayList<String>();
            for (RowResolver rr : jCtx.getInputRRList()) {
                possibleColumnNames.addAll(rr.getReferenceableColumnAliases(null, -1));
            }
            return possibleColumnNames;
        }

        @Override
        protected T processQualifiedColRef(TypeCheckCtx ctx, ASTNode expr, Object ... nodeOutputs) throws SemanticException {
            JoinTypeCheckCtx jctx = (JoinTypeCheckCtx)ctx;
            String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText());
            ColumnInfo colInfo = this.getColInfo((JoinTypeCheckCtx)ctx, tableAlias, JoinCondTypeCheckProcFactory.this.exprFactory.getConstantValueAsString(nodeOutputs[1]), expr);
            if (colInfo == null) {
                ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (Tree)expr.getChild(1)), expr);
                return null;
            }
            ColumnInfo newColumnInfo = new ColumnInfo(colInfo);
            newColumnInfo.setTabAlias(tableAlias);
            ArrayList<RowResolver> listRR = new ArrayList<RowResolver>(jctx.getInputRRList());
            if (jctx.getOuterRR() != null) {
                listRR.add(jctx.getOuterRR());
            }
            return JoinCondTypeCheckProcFactory.this.exprFactory.createColumnRefExpr(newColumnInfo, listRR);
        }

        private ColumnInfo getColInfo(JoinTypeCheckCtx ctx, String tabName, String colAlias, ASTNode expr) throws SemanticException {
            ColumnInfo cInfoToRet = null;
            for (RowResolver rr : ctx.getInputRRList()) {
                ColumnInfo tmp = rr.get(tabName, colAlias);
                if (tmp == null) continue;
                if (cInfoToRet != null) {
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN.getMsg(), (ASTNode)expr));
                }
                cInfoToRet = tmp;
            }
            if (cInfoToRet == null && ctx.getOuterRR() != null) {
                cInfoToRet = ctx.getOuterRR().get(tabName, colAlias);
            }
            return cInfoToRet;
        }
    }
}

