/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hive.common.util.HiveStringUtils;

public class UpdatedMetaDataTracker {
    private List<UpdateMetaData> updateMetaDataList = new ArrayList<UpdateMetaData>();
    private Map<String, Integer> updateMetaDataMap = new HashMap<String, Integer>();
    private boolean needCommitTxn = false;

    public void setNeedCommitTxn(boolean needCommitTxn) {
        this.needCommitTxn = needCommitTxn;
    }

    public boolean isNeedCommitTxn() {
        return this.needCommitTxn;
    }

    public void copyUpdatedMetadata(UpdatedMetaDataTracker other) {
        int size = this.updateMetaDataList.size();
        for (UpdateMetaData updateMetaDataOther : other.updateMetaDataList) {
            String key = this.getKey(this.normalizeIdentifier(updateMetaDataOther.getDbName()), this.normalizeIdentifier(updateMetaDataOther.getTableName()));
            Integer idx = this.updateMetaDataMap.get(key);
            if (idx == null) {
                this.updateMetaDataList.add(updateMetaDataOther);
                this.updateMetaDataMap.put(key, size++);
                continue;
            }
            if (updateMetaDataOther.partitionsList == null || updateMetaDataOther.partitionsList.size() == 0) continue;
            UpdateMetaData updateMetaData = this.updateMetaDataList.get(idx);
            for (Map<String, String> partSpec : updateMetaDataOther.partitionsList) {
                updateMetaData.addPartition(partSpec);
            }
        }
        this.needCommitTxn = other.needCommitTxn;
    }

    public void set(String replState, String dbName, String tableName, Map<String, String> partSpec) throws SemanticException {
        if (dbName == null) {
            throw new SemanticException("db name can not be null");
        }
        if (dbName.contains(".") || tableName != null && tableName.contains(".")) {
            throw new SemanticException("Invalid DB or table name." + dbName + "::" + (tableName != null ? tableName : ""));
        }
        String key = this.getKey(this.normalizeIdentifier(dbName), this.normalizeIdentifier(tableName));
        Integer idx = this.updateMetaDataMap.get(key);
        if (idx == null) {
            this.updateMetaDataList.add(new UpdateMetaData(replState, dbName, tableName, partSpec));
            this.updateMetaDataMap.put(key, this.updateMetaDataList.size() - 1);
        } else {
            this.updateMetaDataList.get(idx).addPartition(partSpec);
        }
    }

    public void addPartition(String dbName, String tableName, Map<String, String> partSpec) throws SemanticException {
        if (dbName == null) {
            throw new SemanticException("db name can not be null");
        }
        String key = this.getKey(this.normalizeIdentifier(dbName), this.normalizeIdentifier(tableName));
        Integer idx = this.updateMetaDataMap.get(key);
        if (idx == null) {
            throw new SemanticException("add partition to metadata map failed as list is not yet set for table : " + key);
        }
        this.updateMetaDataList.get(idx).addPartition(partSpec);
    }

    public List<UpdateMetaData> getUpdateMetaDataList() {
        return this.updateMetaDataList;
    }

    private String getKey(String dbName, String tableName) {
        if (tableName == null) {
            return dbName + ".*";
        }
        return dbName + "." + tableName;
    }

    private String normalizeIdentifier(String name) {
        return name == null ? null : HiveStringUtils.normalizeIdentifier((String)name);
    }

    public static class UpdateMetaData {
        private String replState;
        private String dbName;
        private String tableName;
        private List<Map<String, String>> partitionsList;

        UpdateMetaData(String replState, String dbName, String tableName, Map<String, String> partSpec) {
            this.replState = replState;
            this.dbName = dbName;
            this.tableName = tableName;
            this.partitionsList = new ArrayList<Map<String, String>>();
            if (partSpec != null) {
                this.partitionsList.add(partSpec);
            }
        }

        public String getReplState() {
            return this.replState;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<Map<String, String>> getPartitionsList() {
            return this.partitionsList;
        }

        public void addPartition(Map<String, String> partSpec) {
            this.partitionsList.add(partSpec);
        }
    }
}

