/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;

public class HiveSequenceFileInputFormat<K extends LongWritable, V extends BytesRefArrayWritable>
extends SequenceFileInputFormat<K, V> {
    private static final ThreadLocal<Set<FileStatus>> fileStatuses = new ThreadLocal();

    public HiveSequenceFileInputFormat() {
        this.setMinSplitSize(102400L);
    }

    public void setFiles(Set<FileStatus> files) {
        fileStatuses.set(files);
    }

    protected FileStatus[] listStatus(JobConf job) throws IOException {
        try {
            if (CollectionUtils.isEmpty((Collection)fileStatuses.get())) {
                FileStatus[] fileStatusArray = super.listStatus(job);
                return fileStatusArray;
            }
            FileStatus[] fileStatusArray = fileStatuses.get().toArray(new FileStatus[0]);
            return fileStatusArray;
        }
        finally {
            fileStatuses.remove();
        }
    }
}

