/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableContainerBase;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastNonMatchedIterator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastValueStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastLongHashMapContainer
extends VectorMapJoinFastHashTableContainerBase
implements VectorMapJoinLongHashMap,
MemoryEstimate {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastLongHashMapContainer.class);
    private final VectorMapJoinFastLongHashMap[] vectorMapJoinFastLongHashMaps;
    private final BinarySortableDeserializeRead keyBinarySortableDeserializeRead;
    private final VectorMapJoinDesc.HashTableKeyType hashTableKeyType;
    private final int numThreads;
    private final boolean minMaxEnabled;

    public VectorMapJoinFastLongHashMapContainer(boolean isFullOuter, boolean minMaxEnabled, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount, TableDesc tableDesc, int numHTs) {
        this.hashTableKeyType = hashTableKeyType;
        this.vectorMapJoinFastLongHashMaps = new VectorMapJoinFastLongHashMap[numHTs];
        LOG.info("Initializing {} HT Containers ", (Object)numHTs);
        for (int i = 0; i < numHTs; ++i) {
            this.vectorMapJoinFastLongHashMaps[i] = new VectorMapJoinFastLongHashMap(isFullOuter, minMaxEnabled, hashTableKeyType, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount, tableDesc);
        }
        PrimitiveTypeInfo[] primitiveTypeInfos = new PrimitiveTypeInfo[]{hashTableKeyType.getPrimitiveTypeInfo()};
        this.keyBinarySortableDeserializeRead = BinarySortableDeserializeRead.with((TypeInfo[])primitiveTypeInfos, (boolean)false, (Properties)tableDesc.getProperties());
        this.numThreads = numHTs;
        this.minMaxEnabled = minMaxEnabled;
    }

    @Override
    public boolean useMinMax() {
        return this.minMaxEnabled;
    }

    @Override
    public long min() {
        long min = Long.MAX_VALUE;
        for (int i = 0; i < this.numThreads; ++i) {
            long currentMin = this.vectorMapJoinFastLongHashMaps[i].min();
            if (currentMin >= min) continue;
            min = currentMin;
        }
        return min;
    }

    @Override
    public long max() {
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.numThreads; ++i) {
            long currentMax = this.vectorMapJoinFastLongHashMaps[i].max();
            if (currentMax <= max) continue;
            max = currentMax;
        }
        return max;
    }

    @Override
    public VectorMapJoinHashMapResult createHashMapResult() {
        return new VectorMapJoinFastValueStore.HashMapResult();
    }

    @Override
    public int spillPartitionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getHashCode(BytesWritable currentKey) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.keyBinarySortableDeserializeRead.set(keyBytes, 0, keyLength);
        try {
            if (!this.keyBinarySortableDeserializeRead.readNextField()) {
                return 0L;
            }
        }
        catch (Exception e) {
            throw new HiveException("DeserializeRead details: " + this.keyBinarySortableDeserializeRead.getDetailedReadPositionString(), (Throwable)e);
        }
        long key = VectorMapJoinFastLongHashUtil.deserializeLongKey(this.keyBinarySortableDeserializeRead, this.hashTableKeyType);
        return HashCodeUtil.calculateLongHashCode((long)key);
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        this.vectorMapJoinFastLongHashMaps[(int)((long)(this.numThreads - 1) & hashCode)].putRow(hashCode, currentKey, currentValue);
    }

    @Override
    public JoinUtil.JoinResult lookup(long key, VectorMapJoinHashMapResult hashMapResult) {
        long hashCode = HashCodeUtil.calculateLongHashCode((long)key);
        return this.vectorMapJoinFastLongHashMaps[(int)((long)(this.numThreads - 1) & hashCode)].lookup(key, hashMapResult);
    }

    @Override
    public JoinUtil.JoinResult lookup(long key, VectorMapJoinHashMapResult hashMapResult, MatchTracker matchTracker) {
        long hashCode = HashCodeUtil.calculateLongHashCode((long)key);
        int partition = (int)((long)(this.numThreads - 1) & hashCode);
        MatchTracker childMatchTracker = matchTracker != null ? matchTracker.getPartition(partition) : null;
        return this.vectorMapJoinFastLongHashMaps[partition].lookup(key, hashMapResult, childMatchTracker);
    }

    @Override
    public long getEstimatedMemorySize() {
        long estimatedMemorySize = 0L;
        for (int i = 0; i < this.numThreads; ++i) {
            estimatedMemorySize += this.vectorMapJoinFastLongHashMaps[i].getEstimatedMemorySize();
        }
        return estimatedMemorySize;
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this.numThreads; ++i) {
            size += this.vectorMapJoinFastLongHashMaps[i].size();
        }
        return size;
    }

    @Override
    public MatchTracker createMatchTracker() {
        MatchTracker parentMatchTracker = MatchTracker.createPartitioned(this.numThreads);
        for (int i = 0; i < this.numThreads; ++i) {
            int childSize = this.vectorMapJoinFastLongHashMaps[i].logicalHashBucketCount;
            parentMatchTracker.addPartition(i, childSize);
        }
        return parentMatchTracker;
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        return new NonMatchedLongHashMapIterator(matchTracker, this.vectorMapJoinFastLongHashMaps, this.numThreads);
    }

    public static class NonMatchedLongHashMapIterator
    extends VectorMapJoinFastNonMatchedIterator {
        private VectorMapJoinFastLongHashMap.NonMatchedLongHashMapIterator[] hashMapIterators;
        private int index;
        private int numThreads;

        private NonMatchedLongHashMapIterator(MatchTracker matchTracker, VectorMapJoinFastLongHashMap[] vectorMapJoinFastLongHashMaps, int numThreads) {
            super(matchTracker);
            this.hashMapIterators = new VectorMapJoinFastLongHashMap.NonMatchedLongHashMapIterator[numThreads];
            for (int i = 0; i < numThreads; ++i) {
                this.hashMapIterators[i] = new VectorMapJoinFastLongHashMap.NonMatchedLongHashMapIterator(matchTracker.getPartition(i), vectorMapJoinFastLongHashMaps[i]);
            }
            this.index = 0;
            this.numThreads = numThreads;
        }

        @Override
        public void init() {
            for (int i = 0; i < this.numThreads; ++i) {
                this.hashMapIterators[i].init();
            }
            this.index = 0;
        }

        @Override
        public boolean findNextNonMatched() {
            while (this.index < this.numThreads) {
                if (this.hashMapIterators[this.index].findNextNonMatched()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean readNonMatchedLongKey() {
            return this.hashMapIterators[this.index].readNonMatchedLongKey();
        }

        @Override
        public long getNonMatchedLongKey() {
            return this.hashMapIterators[this.index].getNonMatchedLongKey();
        }

        @Override
        public VectorMapJoinHashMapResult getNonMatchedHashMapResult() {
            return this.hashMapIterators[this.index].getNonMatchedHashMapResult();
        }
    }
}

