/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.snapshotref;

import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.snapshotref.AlterTableSnapshotRefDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public abstract class AlterTableCreateSnapshotRefAnalyzer
extends AbstractAlterTableAnalyzer {
    protected AlterTableType alterTableType;

    public AlterTableCreateSnapshotRefAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        DDLUtils.validateTableIsIceberg(table);
        this.inputs.add(new ReadEntity(table));
        this.validateAlterTableType(table, this.alterTableType, false);
        String refName = command.getChild(0).getText();
        Long snapshotId = null;
        Long asOfTime = null;
        Long maxRefAgeMs = null;
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        boolean isReplace = false;
        boolean ifNotExists = false;
        String asOfTag = null;
        block9: for (int i = 1; i < command.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)command.getChild(i);
            switch (childNode.getToken().getType()) {
                case 933: {
                    snapshotId = Long.parseLong(childNode.getChild(0).getText());
                    continue block9;
                }
                case 932: {
                    ZoneId timeZone = SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
                    TimestampTZ ts = TimestampTZUtil.parse((String)AlterTableCreateSnapshotRefAnalyzer.stripQuotes(childNode.getChild(0).getText()), (ZoneId)timeZone);
                    asOfTime = ts.toEpochMilli();
                    continue block9;
                }
                case 931: {
                    asOfTag = AlterTableCreateSnapshotRefAnalyzer.unescapeIdentifier(childNode.getChild(0).getText());
                    continue block9;
                }
                case 1184: {
                    String maxRefAge = childNode.getChild(0).getText();
                    String timeUnitOfBranchRetain = childNode.getChild(1).getText();
                    maxRefAgeMs = TimeUnit.valueOf(timeUnitOfBranchRetain.toUpperCase(Locale.ENGLISH)).toMillis(Long.parseLong(maxRefAge));
                    continue block9;
                }
                case 1329: {
                    minSnapshotsToKeep = Integer.valueOf(childNode.getChild(0).getText());
                    if (childNode.getChildren().size() <= 1) continue block9;
                    String maxSnapshotAge = childNode.getChild(1).getText();
                    String timeUnitOfSnapshotsRetention = childNode.getChild(2).getText();
                    maxSnapshotAgeMs = TimeUnit.valueOf(timeUnitOfSnapshotsRetention.toUpperCase(Locale.ENGLISH)).toMillis(Long.parseLong(maxSnapshotAge));
                    continue block9;
                }
                case 297: {
                    isReplace = true;
                    continue block9;
                }
                case 1055: {
                    ifNotExists = true;
                    continue block9;
                }
                default: {
                    throw new SemanticException("Unrecognized token in ALTER " + this.alterTableType.getName() + " statement");
                }
            }
        }
        AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createSnapshotRefSpec = new AlterTableSnapshotRefSpec.CreateSnapshotRefSpec(refName, snapshotId, asOfTime, maxRefAgeMs, minSnapshotsToKeep, maxSnapshotAgeMs, asOfTag, isReplace, ifNotExists);
        AlterTableSnapshotRefSpec<AlterTableSnapshotRefSpec.CreateSnapshotRefSpec> alterTableSnapshotRefSpec = new AlterTableSnapshotRefSpec<AlterTableSnapshotRefSpec.CreateSnapshotRefSpec>(this.alterTableType, createSnapshotRefSpec);
        AlterTableSnapshotRefDesc alterTableDesc = new AlterTableSnapshotRefDesc(this.alterTableType, tableName, alterTableSnapshotRefSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTableDesc)));
    }
}

