/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.math.BigDecimal;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class DecimalUtil {
    private DecimalUtil() {
    }

    public static byte[] toReusedFixLengthBytes(int precision, int scale, BigDecimal decimal, byte[] reuseBuf) {
        Preconditions.checkArgument(decimal.scale() == scale, "Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)precision, (Object)scale, (Object)decimal);
        Preconditions.checkArgument(decimal.precision() <= precision, "Cannot write value as decimal(%s,%s), too large: %s", (Object)precision, (Object)scale, (Object)decimal);
        byte[] unscaled = decimal.unscaledValue().toByteArray();
        if (unscaled.length == reuseBuf.length) {
            return unscaled;
        }
        byte fillByte = (byte)(decimal.signum() < 0 ? 255 : 0);
        int offset = reuseBuf.length - unscaled.length;
        for (int i = 0; i < reuseBuf.length; ++i) {
            reuseBuf[i] = i < offset ? fillByte : unscaled[i - offset];
        }
        return reuseBuf;
    }
}

