package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface InternalCobApi {
    /**
    * 
    * 
        * @param partitionSize  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/internal/cob/partitions/{partitionSize}")
    Call<String> getCobPartitions(@retrofit2.http.Path("partitionSize") Integer partitionSize);

    /**
    * 
    * 
        * @param loanId  (required)
    * @return Call&lt;Void&gt;
    */
    @POST("v1/internal/cob/loan-reprocess/{loanId}")
    Call<Void> loanReprocess(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * 
    * 
        * @param loanId  (required)
        * @param body  (optional)
    * @return Call&lt;Void&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/internal/cob/fast-forward-cob-date-of-loan/{loanId}")
    Call<Void> updateLoanCobLastDate(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body String body);


        /**
        * 
        * 
            * @param loanId  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/cob/fast-forward-cob-date-of-loan/{loanId}")
    Call<Void> updateLoanCobLastDate(@retrofit2.http.Path("loanId") Long loanId);

        /**
        * 
        * 
            * @param partitionSize  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/internal/cob/partitions/{partitionSize}")
    Call<String> getCobPartitions(@retrofit2.http.Path("partitionSize") Integer partitionSize, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
        * @return Call&lt;Void&gt;
        */
    @POST("v1/internal/cob/loan-reprocess/{loanId}")
    Call<Void> loanReprocess(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/cob/fast-forward-cob-date-of-loan/{loanId}")
    Call<Void> updateLoanCobLastDate(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body String body, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param loanId  (required)
            * @param body  (optional)
        * @return Call&lt;Void&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/internal/cob/fast-forward-cob-date-of-loan/{loanId}")
    Call<Void> updateLoanCobLastDate(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);
}
