/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.template.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.template.domain.Template;
import org.apache.fineract.template.domain.TemplateEntity;
import org.apache.fineract.template.domain.TemplateType;

public final class TemplateData {
    private final List<Map<String, Object>> entities;
    private final List<Map<String, Object>> types;
    private final Template template;

    private TemplateData(Template template) {
        this.template = template;
        this.entities = this.getEntites();
        this.types = this.getTypes();
    }

    public static TemplateData template(Template template) {
        return new TemplateData(template);
    }

    public static TemplateData template() {
        return new TemplateData(null);
    }

    private List<Map<String, Object>> getEntites() {
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (TemplateEntity e : TemplateEntity.values()) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id", e.getId());
            m.put("name", e.getName());
            l.add(m);
        }
        return l;
    }

    private List<Map<String, Object>> getTypes() {
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (TemplateType e : TemplateType.values()) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id", e.getId());
            m.put("name", e.getName());
            l.add(m);
        }
        return l;
    }
}

