/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.accountdetails.data.ShareAccountSummaryData;
import org.apache.fineract.portfolio.accounts.data.AccountData;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.products.data.ProductData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountApplicationTimelineData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountChargeData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountDividendData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountStatusEnumData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountTransactionData;

public class ShareAccountData
implements Serializable,
AccountData {
    private Long id;
    private String accountNo;
    private String externalId;
    private String savingsAccountNumber;
    private Long clientId;
    private String clientName;
    private Long defaultShares;
    private Long productId;
    private String productName;
    private ShareAccountStatusEnumData status;
    ShareAccountApplicationTimelineData timeline;
    private CurrencyData currency;
    private ShareAccountSummaryData summary;
    private Collection<ShareAccountTransactionData> purchasedShares;
    private Long savingsAccountId;
    private BigDecimal currentMarketPrice;
    private Integer lockinPeriod;
    private EnumOptionData lockPeriodTypeEnum;
    private Integer minimumActivePeriod;
    private EnumOptionData minimumActivePeriodTypeEnum;
    private Boolean allowDividendCalculationForInactiveClients;
    private Collection<ShareAccountChargeData> charges;
    private Collection<ShareAccountDividendData> dividends;
    private Integer requestedShares;
    private LocalDate submittedDate;
    private Integer minimumActivePeriodFrequencyType;
    private Integer lockinPeriodFrequency;
    private Integer lockinPeriodFrequencyType;
    private LocalDate applicationDate;
    private String locale;
    private transient Integer rowIndex;
    private String dateFormat;
    private Collection<ProductData> productOptions;
    private Collection<ChargeData> chargeOptions;
    private Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions;
    private Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOptions;
    private Collection<SavingsAccountData> clientSavingsAccounts;

    public static ShareAccountData importInstance(Long clientId, Long productId, Integer requestedShares, String externalId, LocalDate submittedOnDate, Integer minimumActivePeriodDays, Integer minimumActivePeriodFrequencyType, Integer lockinPeriodFrequency, Integer lockinPeriodFrequencyType, LocalDate applicationDate, Boolean allowDividendCalculationForInactiveClients, Collection<ShareAccountChargeData> charges, Long defaultSavingsAccountId, Integer rowIndex, String locale, String dateFormat) {
        return new ShareAccountData(clientId, productId, requestedShares, externalId, submittedOnDate, minimumActivePeriodDays, minimumActivePeriodFrequencyType, lockinPeriodFrequency, lockinPeriodFrequencyType, applicationDate, allowDividendCalculationForInactiveClients, charges, defaultSavingsAccountId, rowIndex, locale, dateFormat);
    }

    private ShareAccountData(Long clientId, Long productId, Integer requestedShares, String externalId, LocalDate submittedDate, Integer minimumActivePeriod, Integer minimumActivePeriodFrequencyType, Integer lockinPeriodFrequency, Integer lockinPeriodFrequencyType, LocalDate applicationDate, Boolean allowDividendCalculationForInactiveClients, Collection<ShareAccountChargeData> charges, Long savingsAccountId, Integer rowIndex, String locale, String dateFormat) {
        this.clientId = clientId;
        this.productId = productId;
        this.requestedShares = requestedShares;
        this.externalId = externalId;
        this.submittedDate = submittedDate;
        this.minimumActivePeriod = minimumActivePeriod;
        this.minimumActivePeriodFrequencyType = minimumActivePeriodFrequencyType;
        this.lockinPeriodFrequency = lockinPeriodFrequency;
        this.lockinPeriodFrequencyType = lockinPeriodFrequencyType;
        this.applicationDate = applicationDate;
        this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
        this.dateFormat = dateFormat;
        this.locale = locale;
        this.charges = charges;
        this.savingsAccountId = savingsAccountId;
        this.rowIndex = rowIndex;
        this.clientName = null;
        this.savingsAccountNumber = null;
        this.defaultShares = null;
        this.id = null;
        this.accountNo = null;
        this.productName = null;
        this.status = null;
        this.timeline = null;
        this.currency = null;
        this.summary = null;
        this.purchasedShares = null;
        this.currentMarketPrice = null;
        this.lockinPeriod = null;
        this.lockPeriodTypeEnum = null;
        this.minimumActivePeriodTypeEnum = null;
        this.dividends = null;
        this.productOptions = null;
        this.chargeOptions = null;
        this.lockinPeriodFrequencyTypeOptions = null;
        this.minimumActivePeriodFrequencyTypeOptions = null;
        this.clientSavingsAccounts = null;
    }

    public ShareAccountData(Long id, String accountNo, String externalId, Long savingsAccountId, String savingsAccountNumber, Long clientId, String clientName, Long productId, String productName, ShareAccountStatusEnumData status, ShareAccountApplicationTimelineData timeline, CurrencyData currency, ShareAccountSummaryData summaryData, Collection<ShareAccountChargeData> charges, Collection<ShareAccountTransactionData> purchasedSharesData, Integer lockinPeriod, EnumOptionData lockPeriodTypeEnum, Integer minimumActivePeriod, EnumOptionData minimumActivePeriodTypeEnum, Boolean allowdividendsforinactiveclients) {
        this.id = id;
        this.accountNo = accountNo;
        this.externalId = externalId;
        this.savingsAccountId = savingsAccountId;
        this.savingsAccountNumber = savingsAccountNumber;
        this.clientId = clientId;
        this.clientName = clientName;
        this.productId = productId;
        this.productName = productName;
        this.status = status;
        this.timeline = timeline;
        this.currency = currency;
        this.summary = summaryData;
        this.charges = charges;
        this.purchasedShares = purchasedSharesData;
        this.lockinPeriod = lockinPeriod;
        this.lockPeriodTypeEnum = lockPeriodTypeEnum;
        this.minimumActivePeriod = minimumActivePeriod;
        this.minimumActivePeriodTypeEnum = minimumActivePeriodTypeEnum;
        this.allowDividendCalculationForInactiveClients = allowdividendsforinactiveclients;
    }

    public ShareAccountData(Long clientId, String clientName, Collection<ProductData> productOptions, Collection<ChargeData> chargeOptions) {
        this.clientId = clientId;
        this.clientName = clientName;
        this.productOptions = productOptions;
        this.chargeOptions = chargeOptions;
    }

    public ShareAccountData(Long clientId, String clientName, CurrencyData currency, Collection<ShareAccountChargeData> charges, BigDecimal currentMarketPrice, Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOptions, Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions, Collection<SavingsAccountData> clientSavingsAccounts, Long defaultShares) {
        this.clientId = clientId;
        this.clientName = clientName;
        this.charges = charges;
        this.currency = currency;
        this.currentMarketPrice = currentMarketPrice;
        this.minimumActivePeriodFrequencyTypeOptions = minimumActivePeriodFrequencyTypeOptions;
        this.lockinPeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions;
        this.clientSavingsAccounts = clientSavingsAccounts;
        this.defaultShares = defaultShares;
    }

    private ShareAccountData(Long id, String accountNo, String externalId, Long savingsAccountId, String savingsAccountNumber, Long clientId, String clientName, Long productId, String productName, ShareAccountStatusEnumData status, ShareAccountApplicationTimelineData timeline, CurrencyData currency, ShareAccountSummaryData summaryData, Collection<ShareAccountChargeData> charges, Collection<ShareAccountTransactionData> purchasedSharesData, Integer lockinPeriod, EnumOptionData lockPeriodTypeEnum, Integer minimumActivePeriod, EnumOptionData minimumActivePeriodTypeEnum, Boolean allowDividendCalculationForInactiveClients, Collection<ProductData> productOptions, Collection<ChargeData> chargeOptions, Collection<SavingsAccountData> clientSavingsAccounts, Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions, Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOption, BigDecimal currenMarketPrice) {
        this.id = id;
        this.accountNo = accountNo;
        this.externalId = externalId;
        this.savingsAccountId = savingsAccountId;
        this.savingsAccountNumber = savingsAccountNumber;
        this.clientId = clientId;
        this.clientName = clientName;
        this.productId = productId;
        this.productName = productName;
        this.status = status;
        this.timeline = timeline;
        this.currency = currency;
        this.summary = summaryData;
        this.charges = charges;
        this.purchasedShares = purchasedSharesData;
        this.lockinPeriod = lockinPeriod;
        this.lockPeriodTypeEnum = lockPeriodTypeEnum;
        this.minimumActivePeriod = minimumActivePeriod;
        this.minimumActivePeriodTypeEnum = minimumActivePeriodTypeEnum;
        this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
        this.productOptions = productOptions;
        this.chargeOptions = chargeOptions;
        this.clientSavingsAccounts = clientSavingsAccounts;
        this.lockinPeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions;
        this.minimumActivePeriodFrequencyTypeOptions = minimumActivePeriodFrequencyTypeOption;
        this.currentMarketPrice = currenMarketPrice;
    }

    public static ShareAccountData template(ShareAccountData data, Collection<ProductData> productOptions, Collection<ChargeData> chargeOptions, Collection<SavingsAccountData> clientSavingsAccounts, Collection<EnumOptionData> lockinPeriodFrequencyTypeOptions, Collection<EnumOptionData> minimumActivePeriodFrequencyTypeOptions) {
        return new ShareAccountData(data.id, data.accountNo, data.externalId, data.savingsAccountId, data.savingsAccountNumber, data.clientId, data.clientName, data.productId, data.productName, data.status, data.timeline, data.currency, data.summary, data.charges, data.purchasedShares, data.lockinPeriod, data.lockPeriodTypeEnum, data.minimumActivePeriod, data.minimumActivePeriodTypeEnum, data.allowDividendCalculationForInactiveClients, productOptions, chargeOptions, clientSavingsAccounts, lockinPeriodFrequencyTypeOptions, minimumActivePeriodFrequencyTypeOptions, data.currentMarketPrice);
    }

    public static ShareAccountData lookup(Long id, String accountNo, Long clientId, String clientName) {
        String externalId = null;
        ShareAccountSummaryData summaryData = null;
        Collection purchasedSharesData = null;
        Object suspenseAccount = null;
        Integer lockinPeriod = null;
        EnumOptionData lockPeriodTypeEnum = null;
        Integer minimumActivePeriod = null;
        EnumOptionData minimumActivePeriodTypeEnum = null;
        Collection charges = null;
        ShareAccountStatusEnumData status = null;
        ShareAccountApplicationTimelineData timeline = null;
        CurrencyData currency = null;
        Boolean allowDividendCalculationForInactiveClients = null;
        Long savingsAccountId = null;
        String savingsAccountNumber = null;
        String productName = null;
        Collection chargeOptions = null;
        Collection clientSavingsAccounts = null;
        Collection lockinPeriodFrequencyTypeOptions = null;
        Collection minimumActivePeriodFrequencyTypeOption = null;
        BigDecimal currenMarketPrice = null;
        Long productId = null;
        Collection productOptions = null;
        return new ShareAccountData(id, accountNo, externalId, savingsAccountId, savingsAccountNumber, clientId, clientName, productId, productName, status, timeline, currency, summaryData, charges, purchasedSharesData, lockinPeriod, lockPeriodTypeEnum, minimumActivePeriod, minimumActivePeriodTypeEnum, allowDividendCalculationForInactiveClients, productOptions, chargeOptions, clientSavingsAccounts, lockinPeriodFrequencyTypeOptions, minimumActivePeriodFrequencyTypeOption, currenMarketPrice);
    }

    public void setCurrentMarketPrice(BigDecimal currentMarketPrice) {
        this.currentMarketPrice = currentMarketPrice;
    }

    public void setDividends(Collection<ShareAccountDividendData> dividends) {
        this.dividends = dividends;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getAccountNo() {
        return this.accountNo;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getSavingsAccountNumber() {
        return this.savingsAccountNumber;
    }

    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public Long getDefaultShares() {
        return this.defaultShares;
    }

    @Generated
    public Long getProductId() {
        return this.productId;
    }

    @Generated
    public String getProductName() {
        return this.productName;
    }

    @Generated
    public ShareAccountStatusEnumData getStatus() {
        return this.status;
    }

    @Generated
    public ShareAccountApplicationTimelineData getTimeline() {
        return this.timeline;
    }

    @Generated
    public CurrencyData getCurrency() {
        return this.currency;
    }

    @Generated
    public ShareAccountSummaryData getSummary() {
        return this.summary;
    }

    @Generated
    public Collection<ShareAccountTransactionData> getPurchasedShares() {
        return this.purchasedShares;
    }

    @Generated
    public Long getSavingsAccountId() {
        return this.savingsAccountId;
    }

    @Generated
    public BigDecimal getCurrentMarketPrice() {
        return this.currentMarketPrice;
    }

    @Generated
    public Integer getLockinPeriod() {
        return this.lockinPeriod;
    }

    @Generated
    public EnumOptionData getLockPeriodTypeEnum() {
        return this.lockPeriodTypeEnum;
    }

    @Generated
    public Integer getMinimumActivePeriod() {
        return this.minimumActivePeriod;
    }

    @Generated
    public EnumOptionData getMinimumActivePeriodTypeEnum() {
        return this.minimumActivePeriodTypeEnum;
    }

    @Generated
    public Boolean getAllowDividendCalculationForInactiveClients() {
        return this.allowDividendCalculationForInactiveClients;
    }

    @Generated
    public Collection<ShareAccountChargeData> getCharges() {
        return this.charges;
    }

    @Generated
    public Collection<ShareAccountDividendData> getDividends() {
        return this.dividends;
    }

    @Generated
    public Integer getRequestedShares() {
        return this.requestedShares;
    }

    @Generated
    public LocalDate getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public Integer getMinimumActivePeriodFrequencyType() {
        return this.minimumActivePeriodFrequencyType;
    }

    @Generated
    public Integer getLockinPeriodFrequency() {
        return this.lockinPeriodFrequency;
    }

    @Generated
    public Integer getLockinPeriodFrequencyType() {
        return this.lockinPeriodFrequencyType;
    }

    @Generated
    public LocalDate getApplicationDate() {
        return this.applicationDate;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public Integer getRowIndex() {
        return this.rowIndex;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public Collection<ProductData> getProductOptions() {
        return this.productOptions;
    }

    @Generated
    public Collection<ChargeData> getChargeOptions() {
        return this.chargeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getLockinPeriodFrequencyTypeOptions() {
        return this.lockinPeriodFrequencyTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getMinimumActivePeriodFrequencyTypeOptions() {
        return this.minimumActivePeriodFrequencyTypeOptions;
    }

    @Generated
    public Collection<SavingsAccountData> getClientSavingsAccounts() {
        return this.clientSavingsAccounts;
    }
}

