/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.common.AccountingValidations;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingHelper;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargeOffBehaviour;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleProcessingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanproduct.domain.AdvancedPaymentAllocationsJsonParser;
import org.apache.fineract.portfolio.loanproduct.domain.AdvancedPaymentAllocationsValidator;
import org.apache.fineract.portfolio.loanproduct.domain.AmortizationMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestCalculationPeriodMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestRecalculationCompoundingMethod;
import org.apache.fineract.portfolio.loanproduct.domain.LoanPreCloseInterestCalculationStrategy;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductValueConditionType;
import org.apache.fineract.portfolio.loanproduct.domain.LoanRescheduleStrategyMethod;
import org.apache.fineract.portfolio.loanproduct.domain.LoanSupportedInterestRefundTypes;
import org.apache.fineract.portfolio.loanproduct.domain.RecalculationFrequencyType;
import org.apache.fineract.portfolio.loanproduct.exception.EqualAmortizationUnsupportedFeatureException;
import org.springframework.stereotype.Component;

@Component
public final class LoanProductDataValidator {
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String FUND_ID = "fundId";
    public static final String INCLUDE_IN_BORROWER_CYCLE = "includeInBorrowerCycle";
    public static final String CURRENCY_CODE = "currencyCode";
    public static final String DIGITS_AFTER_DECIMAL = "digitsAfterDecimal";
    public static final String IN_MULTIPLES_OF = "inMultiplesOf";
    public static final String PRINCIPAL = "principal";
    public static final String MIN_PRINCIPAL = "minPrincipal";
    public static final String MAX_PRINCIPAL = "maxPrincipal";
    public static final String NUMBER_OF_REPAYMENTS = "numberOfRepayments";
    public static final String MIN_NUMBER_OF_REPAYMENTS = "minNumberOfRepayments";
    public static final String MAX_NUMBER_OF_REPAYMENTS = "maxNumberOfRepayments";
    public static final String REPAYMENT_EVERY = "repaymentEvery";
    public static final String REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
    public static final String AMORTIZATION_TYPE = "amortizationType";
    public static final String INTEREST_TYPE = "interestType";
    public static final String INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
    public static final String IN_ARREARS_TOLERANCE = "inArrearsTolerance";
    public static final String TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
    public static final String ADVANCED_PAYMENT_ALLOCATIONS = "paymentAllocation";
    public static final String CREDIT_ALLOCATIONS = "creditAllocation";
    public static final String GRACE_ON_PRINCIPAL_PAYMENT = "graceOnPrincipalPayment";
    public static final String GRACE_ON_INTEREST_PAYMENT = "graceOnInterestPayment";
    public static final String GRACE_ON_INTEREST_CHARGED = "graceOnInterestCharged";
    public static final String IS_LINKED_TO_FLOATING_INTEREST_RATES = "isLinkedToFloatingInterestRates";
    public static final String INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
    public static final String MIN_INTEREST_RATE_PER_PERIOD = "minInterestRatePerPeriod";
    public static final String MAX_INTEREST_RATE_PER_PERIOD = "maxInterestRatePerPeriod";
    public static final String INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
    public static final String FLOATING_RATES_ID = "floatingRatesId";
    public static final String INTEREST_RATE_DIFFERENTIAL = "interestRateDifferential";
    public static final String MIN_DIFFERENTIAL_LENDING_RATE = "minDifferentialLendingRate";
    public static final String DEFAULT_DIFFERENTIAL_LENDING_RATE = "defaultDifferentialLendingRate";
    public static final String MAX_DIFFERENTIAL_LENDING_RATE = "maxDifferentialLendingRate";
    public static final String IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED = "isFloatingInterestRateCalculationAllowed";
    public static final String ACCOUNTING_RULE = "accountingRule";
    public static final String ENABLE_ACCRUAL_ACTIVITY_POSTING = "enableAccrualActivityPosting";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "name", "description", "fundId", "currencyCode", "digitsAfterDecimal", "inMultiplesOf", "principal", "minPrincipal", "maxPrincipal", "repaymentEvery", "numberOfRepayments", "minNumberOfRepayments", "maxNumberOfRepayments", "repaymentFrequencyType", "interestRatePerPeriod", "minInterestRatePerPeriod", "maxInterestRatePerPeriod", "interestRateFrequencyType", "amortizationType", "interestType", "interestCalculationPeriodType", "allowPartialPeriodInterestCalcualtion", "inArrearsTolerance", "transactionProcessingStrategyCode", "paymentAllocation", "creditAllocation", "graceOnPrincipalPayment", "recurringMoratoriumOnPrincipalPeriods", "graceOnInterestPayment", "graceOnInterestCharged", "charges", "accountingRule", "includeInBorrowerCycle", "startDate", "closeDate", "externalId", "isLinkedToFloatingInterestRates", "floatingRatesId", "interestRateDifferential", "minDifferentialLendingRate", "defaultDifferentialLendingRate", "maxDifferentialLendingRate", "isFloatingInterestRateCalculationAllowed", "syncExpectedWithDisbursementDate", AccountingConstants.LoanProductAccountingParams.FEES_RECEIVABLE.getValue(), AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_FEES.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_PENALTIES.getValue(), AccountingConstants.LoanProductAccountingParams.INTEREST_ON_LOANS.getValue(), AccountingConstants.LoanProductAccountingParams.INTEREST_RECEIVABLE.getValue(), AccountingConstants.LoanProductAccountingParams.LOAN_PORTFOLIO.getValue(), AccountingConstants.LoanProductAccountingParams.OVERPAYMENT.getValue(), AccountingConstants.LoanProductAccountingParams.TRANSFERS_SUSPENSE.getValue(), AccountingConstants.LoanProductAccountingParams.LOSSES_WRITTEN_OFF.getValue(), AccountingConstants.LoanProductAccountingParams.GOODWILL_CREDIT.getValue(), AccountingConstants.LoanProductAccountingParams.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.LoanProductAccountingParams.PAYMENT_CHANNEL_FUND_SOURCE_MAPPING.getValue(), AccountingConstants.LoanProductAccountingParams.FEE_INCOME_ACCOUNT_MAPPING.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.LoanProductAccountingParams.PENALTY_INCOME_ACCOUNT_MAPPING.getValue(), AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS.getValue(), AccountingConstants.LoanProductAccountingParams.WRITE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS.getValue(), AccountingConstants.LoanProductAccountingParams.WRITE_OFF_REASON_CODE_VALUE_ID.getValue(), AccountingConstants.LoanProductAccountingParams.EXPENSE_GL_ACCOUNT_ID.getValue(), AccountingConstants.LoanProductAccountingParams.EXPENSE_GL_ACCOUNT_ID.getValue(), AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_REASON_CODE_VALUE_ID.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CAPITALIZATION.getValue(), AccountingConstants.LoanProductAccountingParams.DEFERRED_INCOME_LIABILITY.getValue(), AccountingConstants.LoanProductAccountingParams.BUY_DOWN_EXPENSE.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_BUY_DOWN.getValue(), "useBorrowerCycle", "principalVariationsForBorrowerCycle", "interestRateVariationsForBorrowerCycle", "numberOfRepaymentVariationsForBorrowerCycle", "shortName", "multiDisburseLoan", "outstandingLoanBalance", "maxTrancheCount", "graceOnArrearsAgeing", "overdueDaysForNPA", "isInterestRecalculationEnabled", "daysInYearType", "daysInMonthType", "rescheduleStrategyMethod", "interestRecalculationCompoundingMethod", "recalculationRestFrequencyInterval", "recalculationRestFrequencyType", "recalculationCompoundingFrequencyInterval", "recalculationCompoundingFrequencyType", "isArrearsBasedOnOriginalSchedule", "minimumDaysBetweenDisbursalAndFirstRepayment", "mandatoryGuarantee", "holdGuaranteeFunds", "minimumGuaranteeFromGuarantor", "minimumGuaranteeFromOwnFunds", "principalThresholdForLastInstallment", "accountMovesOutOfNPAOnlyOnArrearsCompletion", "canDefineInstallmentAmount", "installmentAmountInMultiplesOf", "preClosureInterestCalculationStrategy", "allowAttributeOverrides", "allowVariableInstallments", "minimumGap", "maximumGap", "recalculationCompoundingFrequencyDayOfWeekType", "recalculationCompoundingFrequencyNthDayType", "recalculationCompoundingFrequencyOnDayType", "recalculationRestFrequencyDayOfWeekType", "recalculationRestFrequencyNthDayType", "recalculationRestFrequencyOnDayType", "isCompoundingToBePostedAsTransaction", "allowCompoundingOnEod", "disallowInterestCalculationOnPastDue", "canUseForTopup", "isEqualAmortization", "rates", "fixedPrincipalPercentagePerInstallment", "disallowExpectedDisbursements", "allowApprovedDisbursedAmountsOverApplied", "overAppliedCalculationType", "overAppliedNumber", "delinquencyBucketId", "dueDaysForRepaymentEvent", "overDueDaysForRepaymentEvent", "enableDownPayment", "disbursedAmountPercentageForDownPayment", "enableAutoRepaymentForDownPayment", "repaymentStartDateType", "enableInstallmentLevelDelinquency", "loanScheduleType", "loanScheduleProcessingType", "fixedLength", "enableAccrualActivityPosting", "supportedInterestRefundTypes", "chargeOffBehaviour", "interestRecognitionOnDisbursementDate", "daysInYearCustomStrategy", "enableIncomeCapitalization", "capitalizedIncomeCalculationType", "capitalizedIncomeStrategy", "capitalizedIncomeType", "enableBuyDownFee", "buyDownFeeCalculationType", "buyDownFeeStrategy", "buyDownFeeIncomeType", AccountingConstants.LoanProductAccountingParams.BUY_DOWN_EXPENSE.getValue(), AccountingConstants.LoanProductAccountingParams.INCOME_FROM_BUY_DOWN.getValue(), "merchantBuyDownFee", AccountingConstants.LoanProductAccountingParams.CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS.getValue(), AccountingConstants.LoanProductAccountingParams.BUYDOWN_FEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS.getValue()));
    private static final String[] SUPPORTED_LOAN_CONFIGURABLE_ATTRIBUTES = new String[]{"amortizationType", "interestType", "transactionProcessingStrategyCode", "interestCalculationPeriodType", "inArrearsTolerance", "repaymentEvery", "graceOnPrincipalAndInterestPayment", "graceOnArrearsAgeing"};
    public static final String LOANPRODUCT = "loanproduct";
    public static final String OVER_APPLIED_CALCULATION_TYPE = "overAppliedCalculationType";
    public static final String OPENING_SQUARE_BRACKET = "[";
    public static final String CLOSING_SQUARE_BRACKET = "]";
    public static final String DOT = ".";
    private final FromJsonHelper fromApiJsonHelper;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final AdvancedPaymentAllocationsJsonParser advancedPaymentAllocationsJsonParser;
    private final AdvancedPaymentAllocationsValidator advancedPaymentAllocationsValidator;
    private final ProductToGLAccountMappingHelper productToGLAccountMappingHelper;

    public void validateForCreate(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(LOANPRODUCT);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed(NAME, element);
        baseDataValidator.reset().parameter(NAME).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String shortName = this.fromApiJsonHelper.extractStringNamed("shortName", element);
        baseDataValidator.reset().parameter("shortName").value((Object)shortName).notBlank().notExceedingLengthOf(Integer.valueOf(4));
        String description = this.fromApiJsonHelper.extractStringNamed(DESCRIPTION, element);
        baseDataValidator.reset().parameter(DESCRIPTION).value((Object)description).notExceedingLengthOf(Integer.valueOf(500));
        if (this.fromApiJsonHelper.parameterExists(FUND_ID, element)) {
            Long fundId = this.fromApiJsonHelper.extractLongNamed(FUND_ID, element);
            baseDataValidator.reset().parameter(FUND_ID).value((Object)fundId).ignoreIfNull().integerGreaterThanZero();
        }
        boolean isEqualAmortization = false;
        if (this.fromApiJsonHelper.parameterExists("isEqualAmortization", element)) {
            isEqualAmortization = this.fromApiJsonHelper.extractBooleanNamed("isEqualAmortization", element);
            baseDataValidator.reset().parameter("isEqualAmortization").value((Object)isEqualAmortization).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("minimumDaysBetweenDisbursalAndFirstRepayment", element)) {
            Long minimumDaysBetweenDisbursalAndFirstRepayment = this.fromApiJsonHelper.extractLongNamed("minimumDaysBetweenDisbursalAndFirstRepayment", element);
            baseDataValidator.reset().parameter("minimumDaysBetweenDisbursalAndFirstRepayment").value((Object)minimumDaysBetweenDisbursalAndFirstRepayment).ignoreIfNull().integerGreaterThanZero();
        }
        Boolean includeInBorrowerCycle = this.fromApiJsonHelper.extractBooleanNamed(INCLUDE_IN_BORROWER_CYCLE, element);
        baseDataValidator.reset().parameter(INCLUDE_IN_BORROWER_CYCLE).value((Object)includeInBorrowerCycle).ignoreIfNull().validateForBooleanValue();
        String currencyCode = this.fromApiJsonHelper.extractStringNamed(CURRENCY_CODE, element);
        baseDataValidator.reset().parameter(CURRENCY_CODE).value((Object)currencyCode).notBlank().notExceedingLengthOf(Integer.valueOf(3));
        Integer digitsAfterDecimal = this.fromApiJsonHelper.extractIntegerNamed(DIGITS_AFTER_DECIMAL, element, Locale.getDefault());
        baseDataValidator.reset().parameter(DIGITS_AFTER_DECIMAL).value((Object)digitsAfterDecimal).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(6));
        Integer inMultiplesOf = this.fromApiJsonHelper.extractIntegerNamed(IN_MULTIPLES_OF, element, Locale.getDefault());
        baseDataValidator.reset().parameter(IN_MULTIPLES_OF).value((Object)inMultiplesOf).ignoreIfNull().integerZeroOrGreater();
        BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(PRINCIPAL, element);
        baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principal).positiveAmount();
        String minPrincipalParameterName = MIN_PRINCIPAL;
        BigDecimal minPrincipalAmount = null;
        if (this.fromApiJsonHelper.parameterExists(MIN_PRINCIPAL, element)) {
            minPrincipalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MIN_PRINCIPAL, element);
            baseDataValidator.reset().parameter(MIN_PRINCIPAL).value((Object)minPrincipalAmount).ignoreIfNull().positiveAmount();
        }
        String maxPrincipalParameterName = MAX_PRINCIPAL;
        BigDecimal maxPrincipalAmount = null;
        if (this.fromApiJsonHelper.parameterExists(MAX_PRINCIPAL, element)) {
            maxPrincipalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MAX_PRINCIPAL, element);
            baseDataValidator.reset().parameter(MAX_PRINCIPAL).value((Object)maxPrincipalAmount).ignoreIfNull().positiveAmount();
        }
        if (maxPrincipalAmount != null && maxPrincipalAmount.compareTo(BigDecimal.ZERO) >= 0) {
            if (minPrincipalAmount != null && minPrincipalAmount.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter(MAX_PRINCIPAL).value((Object)maxPrincipalAmount).notLessThanMin(minPrincipalAmount);
                if (minPrincipalAmount.compareTo(maxPrincipalAmount) <= 0 && principal != null) {
                    baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principal).inMinAndMaxAmountRange(minPrincipalAmount, maxPrincipalAmount);
                }
            } else if (principal != null) {
                baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principal).notGreaterThanMax(maxPrincipalAmount);
            }
        } else if (minPrincipalAmount != null && minPrincipalAmount.compareTo(BigDecimal.ZERO) >= 0 && principal != null) {
            baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principal).notLessThanMin(minPrincipalAmount);
        }
        Integer numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(NUMBER_OF_REPAYMENTS, element);
        baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).notNull().integerGreaterThanZero();
        String minNumberOfRepaymentsParameterName = MIN_NUMBER_OF_REPAYMENTS;
        Integer minNumberOfRepayments = null;
        if (this.fromApiJsonHelper.parameterExists(MIN_NUMBER_OF_REPAYMENTS, element)) {
            minNumberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(MIN_NUMBER_OF_REPAYMENTS, element);
            baseDataValidator.reset().parameter(MIN_NUMBER_OF_REPAYMENTS).value((Object)minNumberOfRepayments).ignoreIfNull().integerGreaterThanZero();
        }
        String maxNumberOfRepaymentsParameterName = MAX_NUMBER_OF_REPAYMENTS;
        Integer maxNumberOfRepayments = null;
        if (this.fromApiJsonHelper.parameterExists(MAX_NUMBER_OF_REPAYMENTS, element)) {
            maxNumberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(MAX_NUMBER_OF_REPAYMENTS, element);
            baseDataValidator.reset().parameter(MAX_NUMBER_OF_REPAYMENTS).value((Object)maxNumberOfRepayments).ignoreIfNull().integerGreaterThanZero();
        }
        if (maxNumberOfRepayments != null && maxNumberOfRepayments.compareTo(0) > 0) {
            if (minNumberOfRepayments != null && minNumberOfRepayments.compareTo(0) > 0) {
                baseDataValidator.reset().parameter(MAX_NUMBER_OF_REPAYMENTS).value((Object)maxNumberOfRepayments).notLessThanMin(minNumberOfRepayments);
                if (minNumberOfRepayments.compareTo(maxNumberOfRepayments) <= 0) {
                    baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).inMinMaxRange(minNumberOfRepayments, maxNumberOfRepayments);
                }
            } else {
                baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).notGreaterThanMax(maxNumberOfRepayments);
            }
        } else if (minNumberOfRepayments != null && minNumberOfRepayments.compareTo(0) > 0) {
            baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).notLessThanMin(minNumberOfRepayments);
        }
        Integer repaymentEvery = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(REPAYMENT_EVERY, element);
        baseDataValidator.reset().parameter(REPAYMENT_EVERY).value((Object)repaymentEvery).notNull().integerGreaterThanZero();
        Integer repaymentFrequencyType = this.fromApiJsonHelper.extractIntegerNamed(REPAYMENT_FREQUENCY_TYPE, element, Locale.getDefault());
        baseDataValidator.reset().parameter(REPAYMENT_FREQUENCY_TYPE).value((Object)repaymentFrequencyType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
        Integer amortizationType = this.fromApiJsonHelper.extractIntegerNamed(AMORTIZATION_TYPE, element, Locale.getDefault());
        baseDataValidator.reset().parameter(AMORTIZATION_TYPE).value((Object)amortizationType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
        Integer interestType = this.fromApiJsonHelper.extractIntegerNamed(INTEREST_TYPE, element, Locale.getDefault());
        baseDataValidator.reset().parameter(INTEREST_TYPE).value((Object)interestType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
        Integer interestCalculationPeriodType = this.fromApiJsonHelper.extractIntegerNamed(INTEREST_CALCULATION_PERIOD_TYPE, element, Locale.getDefault());
        baseDataValidator.reset().parameter(INTEREST_CALCULATION_PERIOD_TYPE).value((Object)interestCalculationPeriodType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
        BigDecimal inArrearsTolerance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(IN_ARREARS_TOLERANCE, element);
        baseDataValidator.reset().parameter(IN_ARREARS_TOLERANCE).value((Object)inArrearsTolerance).ignoreIfNull().zeroOrPositiveAmount();
        String transactionProcessingStrategyCode = this.fromApiJsonHelper.extractStringNamed(TRANSACTION_PROCESSING_STRATEGY_CODE, element);
        baseDataValidator.reset().parameter(TRANSACTION_PROCESSING_STRATEGY_CODE).value((Object)transactionProcessingStrategyCode).notBlank();
        this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(transactionProcessingStrategyCode);
        Long delinquencyBucketId = null;
        if (this.fromApiJsonHelper.parameterExists("delinquencyBucketId", element)) {
            delinquencyBucketId = this.fromApiJsonHelper.extractLongNamed("delinquencyBucketId", element);
            baseDataValidator.reset().parameter("delinquencyBucketId").value((Object)delinquencyBucketId).ignoreIfNull().integerGreaterThanZero();
        }
        Integer graceOnPrincipalPayment = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(GRACE_ON_PRINCIPAL_PAYMENT, element);
        baseDataValidator.reset().parameter(GRACE_ON_PRINCIPAL_PAYMENT).value((Object)graceOnPrincipalPayment).zeroOrPositiveAmount();
        Integer graceOnInterestPayment = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(GRACE_ON_INTEREST_PAYMENT, element);
        baseDataValidator.reset().parameter(GRACE_ON_INTEREST_PAYMENT).value((Object)graceOnInterestPayment).zeroOrPositiveAmount();
        Integer graceOnInterestCharged = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(GRACE_ON_INTEREST_CHARGED, element);
        baseDataValidator.reset().parameter(GRACE_ON_INTEREST_CHARGED).value((Object)graceOnInterestCharged).zeroOrPositiveAmount();
        Integer graceOnArrearsAgeing = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnArrearsAgeing", element);
        baseDataValidator.reset().parameter("graceOnArrearsAgeing").value((Object)graceOnArrearsAgeing).integerZeroOrGreater();
        Integer overdueDaysForNPA = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("overdueDaysForNPA", element);
        baseDataValidator.reset().parameter("overdueDaysForNPA").value((Object)overdueDaysForNPA).integerZeroOrGreater();
        Integer daysInYearType = this.fromApiJsonHelper.extractIntegerNamed("daysInYearType", element, Locale.getDefault());
        baseDataValidator.reset().parameter("daysInYearType").value((Object)daysInYearType).notNull().isOneOfTheseValues(new Object[]{1, 360, 364, 365});
        Integer daysInMonthType = this.fromApiJsonHelper.extractIntegerNamed("daysInMonthType", element, Locale.getDefault());
        baseDataValidator.reset().parameter("daysInMonthType").value((Object)daysInMonthType).notNull().isOneOfTheseValues(new Object[]{1, 30});
        if (this.fromApiJsonHelper.parameterExists("accountMovesOutOfNPAOnlyOnArrearsCompletion", element)) {
            Boolean npaChangeConfig = this.fromApiJsonHelper.extractBooleanNamed("accountMovesOutOfNPAOnlyOnArrearsCompletion", element);
            baseDataValidator.reset().parameter("accountMovesOutOfNPAOnlyOnArrearsCompletion").value((Object)npaChangeConfig).notNull().isOneOfTheseValues(new Object[]{true, false});
        }
        Boolean isInterestRecalculationEnabled = this.fromApiJsonHelper.extractBooleanNamed("isInterestRecalculationEnabled", element);
        baseDataValidator.reset().parameter("isInterestRecalculationEnabled").value((Object)isInterestRecalculationEnabled).notNull().isOneOfTheseValues(new Object[]{true, false});
        if (isInterestRecalculationEnabled != null && isInterestRecalculationEnabled.booleanValue()) {
            if (isEqualAmortization) {
                throw new EqualAmortizationUnsupportedFeatureException("interest.recalculation", "interest recalculation");
            }
            this.validateInterestRecalculationParams(element, baseDataValidator, null);
        }
        boolean isInterestBearing = false;
        if (this.fromApiJsonHelper.parameterExists(IS_LINKED_TO_FLOATING_INTEREST_RATES, element) && this.fromApiJsonHelper.extractBooleanNamed(IS_LINKED_TO_FLOATING_INTEREST_RATES, element).booleanValue()) {
            if (isEqualAmortization) {
                throw new EqualAmortizationUnsupportedFeatureException("floating.interest.rate", "floating interest rate");
            }
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_PER_PERIOD, element)) {
                baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.true", new Object[]{"interestRatePerPeriod param is not supported when isLinkedToFloatingInterestRates is true"});
            }
            if (this.fromApiJsonHelper.parameterExists(MIN_INTEREST_RATE_PER_PERIOD, element)) {
                baseDataValidator.reset().parameter(MIN_INTEREST_RATE_PER_PERIOD).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.true", new Object[]{"minInterestRatePerPeriod param is not supported when isLinkedToFloatingInterestRates is true"});
            }
            if (this.fromApiJsonHelper.parameterExists(MAX_INTEREST_RATE_PER_PERIOD, element)) {
                baseDataValidator.reset().parameter(MAX_INTEREST_RATE_PER_PERIOD).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.true", new Object[]{"maxInterestRatePerPeriod param is not supported when isLinkedToFloatingInterestRates is true"});
            }
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_FREQUENCY_TYPE, element)) {
                baseDataValidator.reset().parameter(INTEREST_RATE_FREQUENCY_TYPE).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.true", new Object[]{"interestRateFrequencyType param is not supported when isLinkedToFloatingInterestRates is true"});
            }
            if (interestType == null || !interestType.equals(InterestMethod.DECLINING_BALANCE.getValue()) || isInterestRecalculationEnabled == null || !isInterestRecalculationEnabled.booleanValue()) {
                baseDataValidator.reset().parameter(IS_LINKED_TO_FLOATING_INTEREST_RATES).failWithCode("supported.only.for.declining.balance.interest.recalculation.enabled", new Object[]{"Floating interest rates are supported only for declining balance and interest recalculation enabled loan products"});
            }
            Integer floatingRatesId = this.fromApiJsonHelper.extractIntegerNamed(FLOATING_RATES_ID, element, Locale.getDefault());
            baseDataValidator.reset().parameter(FLOATING_RATES_ID).value((Object)floatingRatesId).notNull();
            BigDecimal interestRateDifferential = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(INTEREST_RATE_DIFFERENTIAL, element);
            baseDataValidator.reset().parameter(INTEREST_RATE_DIFFERENTIAL).value((Object)interestRateDifferential).notNull().zeroOrPositiveAmount();
            String minDifferentialLendingRateParameterName = MIN_DIFFERENTIAL_LENDING_RATE;
            BigDecimal minDifferentialLendingRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MIN_DIFFERENTIAL_LENDING_RATE, element);
            baseDataValidator.reset().parameter(MIN_DIFFERENTIAL_LENDING_RATE).value((Object)minDifferentialLendingRate).notNull().zeroOrPositiveAmount();
            String defaultDifferentialLendingRateParameterName = DEFAULT_DIFFERENTIAL_LENDING_RATE;
            BigDecimal defaultDifferentialLendingRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(DEFAULT_DIFFERENTIAL_LENDING_RATE, element);
            baseDataValidator.reset().parameter(DEFAULT_DIFFERENTIAL_LENDING_RATE).value((Object)defaultDifferentialLendingRate).notNull().zeroOrPositiveAmount();
            String maxDifferentialLendingRateParameterName = MAX_DIFFERENTIAL_LENDING_RATE;
            BigDecimal maxDifferentialLendingRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MAX_DIFFERENTIAL_LENDING_RATE, element);
            baseDataValidator.reset().parameter(MAX_DIFFERENTIAL_LENDING_RATE).value((Object)maxDifferentialLendingRate).notNull().zeroOrPositiveAmount();
            if (defaultDifferentialLendingRate != null && defaultDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0 && minDifferentialLendingRate != null && minDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter(DEFAULT_DIFFERENTIAL_LENDING_RATE).value((Object)defaultDifferentialLendingRate).notLessThanMin(minDifferentialLendingRate);
            }
            if (maxDifferentialLendingRate != null && maxDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0 && minDifferentialLendingRate != null && minDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter(MAX_DIFFERENTIAL_LENDING_RATE).value((Object)maxDifferentialLendingRate).notLessThanMin(minDifferentialLendingRate);
            }
            if (maxDifferentialLendingRate != null && maxDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0 && defaultDifferentialLendingRate != null && defaultDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter(MAX_DIFFERENTIAL_LENDING_RATE).value((Object)maxDifferentialLendingRate).notLessThanMin(defaultDifferentialLendingRate);
            }
            Boolean isFloatingInterestRateCalculationAllowed = this.fromApiJsonHelper.extractBooleanNamed(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED, element);
            baseDataValidator.reset().parameter(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED).value((Object)isFloatingInterestRateCalculationAllowed).notNull().isOneOfTheseValues(new Object[]{true, false});
            isInterestBearing = true;
        } else {
            if (this.fromApiJsonHelper.parameterExists(FLOATING_RATES_ID, element)) {
                baseDataValidator.reset().parameter(FLOATING_RATES_ID).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"floatingRatesId param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_DIFFERENTIAL, element)) {
                baseDataValidator.reset().parameter(INTEREST_RATE_DIFFERENTIAL).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"interestRateDifferential param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(MIN_DIFFERENTIAL_LENDING_RATE, element)) {
                baseDataValidator.reset().parameter(MIN_DIFFERENTIAL_LENDING_RATE).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"minDifferentialLendingRate param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(DEFAULT_DIFFERENTIAL_LENDING_RATE, element)) {
                baseDataValidator.reset().parameter(DEFAULT_DIFFERENTIAL_LENDING_RATE).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"defaultDifferentialLendingRate param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(MAX_DIFFERENTIAL_LENDING_RATE, element)) {
                baseDataValidator.reset().parameter(MAX_DIFFERENTIAL_LENDING_RATE).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"maxDifferentialLendingRate param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED, element)) {
                baseDataValidator.reset().parameter(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"isFloatingInterestRateCalculationAllowed param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            BigDecimal interestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(INTEREST_RATE_PER_PERIOD, element);
            baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).notNull().zeroOrPositiveAmount();
            String minInterestRatePerPeriodParameterName = MIN_INTEREST_RATE_PER_PERIOD;
            BigDecimal minInterestRatePerPeriod = null;
            if (this.fromApiJsonHelper.parameterExists(MIN_INTEREST_RATE_PER_PERIOD, element)) {
                minInterestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MIN_INTEREST_RATE_PER_PERIOD, element);
                baseDataValidator.reset().parameter(MIN_INTEREST_RATE_PER_PERIOD).value((Object)minInterestRatePerPeriod).ignoreIfNull().zeroOrPositiveAmount();
            }
            String maxInterestRatePerPeriodParameterName = MAX_INTEREST_RATE_PER_PERIOD;
            BigDecimal maxInterestRatePerPeriod = null;
            if (this.fromApiJsonHelper.parameterExists(MAX_INTEREST_RATE_PER_PERIOD, element)) {
                maxInterestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MAX_INTEREST_RATE_PER_PERIOD, element);
                baseDataValidator.reset().parameter(MAX_INTEREST_RATE_PER_PERIOD).value((Object)maxInterestRatePerPeriod).ignoreIfNull().zeroOrPositiveAmount();
            }
            if (maxInterestRatePerPeriod != null && maxInterestRatePerPeriod.compareTo(BigDecimal.ZERO) >= 0) {
                if (minInterestRatePerPeriod != null && minInterestRatePerPeriod.compareTo(BigDecimal.ZERO) >= 0) {
                    baseDataValidator.reset().parameter(MAX_INTEREST_RATE_PER_PERIOD).value((Object)maxInterestRatePerPeriod).notLessThanMin(minInterestRatePerPeriod);
                    if (minInterestRatePerPeriod.compareTo(maxInterestRatePerPeriod) <= 0) {
                        baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).inMinAndMaxAmountRange(minInterestRatePerPeriod, maxInterestRatePerPeriod);
                    }
                } else {
                    baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).notGreaterThanMax(maxInterestRatePerPeriod);
                }
            } else if (minInterestRatePerPeriod != null && minInterestRatePerPeriod.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).notLessThanMin(minInterestRatePerPeriod);
            }
            Integer interestRateFrequencyType = this.fromApiJsonHelper.extractIntegerNamed(INTEREST_RATE_FREQUENCY_TYPE, element, Locale.getDefault());
            baseDataValidator.reset().parameter(INTEREST_RATE_FREQUENCY_TYPE).value((Object)interestRateFrequencyType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(4));
            isInterestBearing = MathUtil.isGreaterThanZero((BigDecimal)interestRatePerPeriod);
        }
        this.fixedLengthValidations(transactionProcessingStrategyCode, isInterestBearing, numberOfRepayments, repaymentEvery, element, baseDataValidator);
        Boolean holdGuaranteeFunds = false;
        if (this.fromApiJsonHelper.parameterExists("holdGuaranteeFunds", element)) {
            holdGuaranteeFunds = this.fromApiJsonHelper.extractBooleanNamed("holdGuaranteeFunds", element);
            baseDataValidator.reset().parameter("holdGuaranteeFunds").value((Object)holdGuaranteeFunds).notNull().isOneOfTheseValues(new Object[]{true, false});
        }
        if (holdGuaranteeFunds != null && holdGuaranteeFunds.booleanValue()) {
            this.validateGuaranteeParams(element, baseDataValidator, null);
        }
        BigDecimal principalThresholdForLastInstallment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principalThresholdForLastInstallment", element);
        baseDataValidator.reset().parameter("principalThresholdForLastInstallment").value((Object)principalThresholdForLastInstallment).notLessThanMin(BigDecimal.ZERO).notGreaterThanMax(BigDecimal.valueOf(100L));
        BigDecimal fixedPrincipalPercentagePerInstallment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedPrincipalPercentagePerInstallment", element);
        baseDataValidator.reset().parameter("fixedPrincipalPercentagePerInstallment").value((Object)fixedPrincipalPercentagePerInstallment).notLessThanMin(BigDecimal.ONE).notGreaterThanMax(BigDecimal.valueOf(100L));
        if (amortizationType != null && !amortizationType.equals(AmortizationMethod.EQUAL_PRINCIPAL.getValue()) && fixedPrincipalPercentagePerInstallment != null) {
            baseDataValidator.reset().parameter("fixedPrincipalPercentagePerInstallment").failWithCode("not.supported.principal.fixing.not.allowed.with.equal.installments", new Object[]{"Principal fixing cannot be done with equal installment amortization"});
        }
        if (this.fromApiJsonHelper.parameterExists("canDefineInstallmentAmount", element)) {
            Boolean canDefineInstallmentAmount = this.fromApiJsonHelper.extractBooleanNamed("canDefineInstallmentAmount", element);
            baseDataValidator.reset().parameter("canDefineInstallmentAmount").value((Object)canDefineInstallmentAmount).isOneOfTheseValues(new Object[]{true, false});
        }
        if (this.fromApiJsonHelper.parameterExists("installmentAmountInMultiplesOf", element)) {
            Integer installmentAmountInMultiplesOf = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("installmentAmountInMultiplesOf", element);
            baseDataValidator.reset().parameter("installmentAmountInMultiplesOf").value((Object)installmentAmountInMultiplesOf).ignoreIfNull().integerGreaterThanZero();
        }
        Integer accountingRuleType = this.fromApiJsonHelper.extractIntegerNamed(ACCOUNTING_RULE, element, Locale.getDefault());
        baseDataValidator.reset().parameter(ACCOUNTING_RULE).value((Object)accountingRuleType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
        if (AccountingValidations.isCashBasedAccounting((Integer)accountingRuleType) || AccountingValidations.isAccrualBasedAccounting((Integer)accountingRuleType)) {
            Long fundAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue()).value((Object)fundAccountId).notNull().integerGreaterThanZero();
            Long loanPortfolioAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.LOAN_PORTFOLIO.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.LOAN_PORTFOLIO.getValue()).value((Object)loanPortfolioAccountId).notNull().integerGreaterThanZero();
            Long transfersInSuspenseAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.TRANSFERS_SUSPENSE.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.TRANSFERS_SUSPENSE.getValue()).value((Object)transfersInSuspenseAccountId).notNull().integerGreaterThanZero();
            Long incomeFromInterestId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INTEREST_ON_LOANS.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INTEREST_ON_LOANS.getValue()).value((Object)incomeFromInterestId).notNull().integerGreaterThanZero();
            Long incomeFromFeeId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_FEES.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_FEES.getValue()).value((Object)incomeFromFeeId).notNull().integerGreaterThanZero();
            Long incomeFromPenaltyId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_PENALTIES.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_PENALTIES.getValue()).value((Object)incomeFromPenaltyId).notNull().integerGreaterThanZero();
            Long incomeFromRecoveryAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_RECOVERY.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_RECOVERY.getValue()).value((Object)incomeFromRecoveryAccountId).notNull().integerGreaterThanZero();
            Long writeOffAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.LOSSES_WRITTEN_OFF.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.LOSSES_WRITTEN_OFF.getValue()).value((Object)writeOffAccountId).notNull().integerGreaterThanZero();
            Long goodwillCreditAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.GOODWILL_CREDIT.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.GOODWILL_CREDIT.getValue()).value((Object)goodwillCreditAccountId).ignoreIfNull().integerGreaterThanZero();
            Long overpaymentAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.OVERPAYMENT.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.OVERPAYMENT.getValue()).value((Object)overpaymentAccountId).notNull().integerGreaterThanZero();
            Long incomeFromChargeOffInterestAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_INTEREST.getValue()).value((Object)incomeFromChargeOffInterestAccountId).ignoreIfNull().integerGreaterThanZero();
            Long incomeFromChargeOffFeesAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_FEES.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_FEES.getValue()).value((Object)incomeFromChargeOffFeesAccountId).ignoreIfNull().integerGreaterThanZero();
            Long incomeFromChargeOffPenaltyAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_PENALTY.getValue()).value((Object)incomeFromChargeOffPenaltyAccountId).ignoreIfNull().integerGreaterThanZero();
            Long incomeFromGoodwillCreditInterestAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue()).value((Object)incomeFromGoodwillCreditInterestAccountId).ignoreIfNull().integerGreaterThanZero();
            Long incomeFromGoodwillCreditFeesAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue()).value((Object)incomeFromGoodwillCreditFeesAccountId).ignoreIfNull().integerGreaterThanZero();
            Long incomeFromGoodwillCreditPenaltyAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue()).value((Object)incomeFromGoodwillCreditPenaltyAccountId).ignoreIfNull().integerGreaterThanZero();
            Long chargeOffExpenseAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_EXPENSE.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_EXPENSE.getValue()).value((Object)chargeOffExpenseAccountId).ignoreIfNull().integerGreaterThanZero();
            Long chargeOffFraudExpenseAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_FRAUD_EXPENSE.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_FRAUD_EXPENSE.getValue()).value((Object)chargeOffFraudExpenseAccountId).ignoreIfNull().integerGreaterThanZero();
            this.validatePaymentChannelFundSourceMappings(baseDataValidator, element);
            this.validateChargeToIncomeAccountMappings(baseDataValidator, element);
            this.validateChargeOffToExpenseMappings(baseDataValidator, element);
            this.validateWriteOffToExpenseMappings(baseDataValidator, element);
            this.validateClassificationToIncomeMappings(baseDataValidator, element, AccountingConstants.LoanProductAccountingParams.BUYDOWN_FEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS);
            this.validateClassificationToIncomeMappings(baseDataValidator, element, AccountingConstants.LoanProductAccountingParams.CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS);
        }
        if (AccountingValidations.isAccrualBasedAccounting((Integer)accountingRuleType)) {
            Long receivableInterestAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INTEREST_RECEIVABLE.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INTEREST_RECEIVABLE.getValue()).value((Object)receivableInterestAccountId).notNull().integerGreaterThanZero();
            Long receivableFeeAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.FEES_RECEIVABLE.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.FEES_RECEIVABLE.getValue()).value((Object)receivableFeeAccountId).notNull().integerGreaterThanZero();
            Long receivablePenaltyAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.PENALTIES_RECEIVABLE.getValue(), element);
            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.PENALTIES_RECEIVABLE.getValue()).value((Object)receivablePenaltyAccountId).notNull().integerGreaterThanZero();
        }
        if (!AccountingValidations.isAccrualBasedAccounting((Integer)accountingRuleType) && this.fromApiJsonHelper.parameterExists(ENABLE_ACCRUAL_ACTIVITY_POSTING, element)) {
            Boolean enableAccrualActivityPosting = this.fromApiJsonHelper.extractBooleanNamed(ENABLE_ACCRUAL_ACTIVITY_POSTING, element);
            baseDataValidator.reset().parameter(ENABLE_ACCRUAL_ACTIVITY_POSTING).value((Object)enableAccrualActivityPosting).ignoreIfNull().validateForBooleanValue();
            if (!AccountingValidations.isAccrualBasedAccounting((Integer)accountingRuleType)) {
                baseDataValidator.reset().parameter(ENABLE_ACCRUAL_ACTIVITY_POSTING).isOneOfTheseValues(new Object[]{Boolean.TRUE}).failWithCode("should be false for non accrual accounting", new Object[0]);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("useBorrowerCycle", element)) {
            Boolean useBorrowerCycle = this.fromApiJsonHelper.extractBooleanNamed("useBorrowerCycle", element);
            baseDataValidator.reset().parameter("useBorrowerCycle").value((Object)useBorrowerCycle).ignoreIfNull().validateForBooleanValue();
            if (useBorrowerCycle.booleanValue()) {
                this.validateBorrowerCycleVariations(element, baseDataValidator);
            }
        }
        this.validateMultiDisburseLoanData(baseDataValidator, element, null);
        this.validateLoanConfigurableAttributes(baseDataValidator, element);
        this.validateVariableInstallmentSettings(baseDataValidator, element);
        this.validatePartialPeriodSupport(interestCalculationPeriodType, baseDataValidator, element, null);
        if (this.fromApiJsonHelper.parameterExists("canUseForTopup", element)) {
            Boolean canUseForTopup = this.fromApiJsonHelper.extractBooleanNamed("canUseForTopup", element);
            baseDataValidator.reset().parameter("canUseForTopup").value((Object)canUseForTopup).validateForBooleanValue();
        }
        Integer dueDaysForRepaymentEvent = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("dueDaysForRepaymentEvent", element);
        baseDataValidator.reset().parameter("dueDaysForRepaymentEvent").value((Object)dueDaysForRepaymentEvent).integerZeroOrGreater();
        Integer overDueDaysForRepaymentEvent = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("overDueDaysForRepaymentEvent", element);
        baseDataValidator.reset().parameter("overDueDaysForRepaymentEvent").value((Object)overDueDaysForRepaymentEvent).integerZeroOrGreater();
        if (this.fromApiJsonHelper.parameterExists("enableDownPayment", element)) {
            Boolean enableDownPayment = this.fromApiJsonHelper.extractBooleanNamed("enableDownPayment", element);
            baseDataValidator.reset().parameter("enableDownPayment").value((Object)enableDownPayment).ignoreIfNull().validateForBooleanValue();
            this.validateDownPaymentPercentage(enableDownPayment, baseDataValidator, element);
            this.validateAutoRepaymentForDownPayment(enableDownPayment, baseDataValidator, element);
        }
        if (this.fromApiJsonHelper.parameterExists("repaymentStartDateType", element)) {
            Integer repaymentStartDateType = this.fromApiJsonHelper.extractIntegerNamed("repaymentStartDateType", element, Locale.getDefault());
            baseDataValidator.reset().parameter("repaymentStartDateType").value((Object)repaymentStartDateType).notNull().isOneOfTheseValues(new Object[]{1, 2});
        }
        if (this.fromApiJsonHelper.parameterExists("enableInstallmentLevelDelinquency", element)) {
            Boolean enableInstallmentLevelDelinquency = this.fromApiJsonHelper.extractBooleanNamed("enableInstallmentLevelDelinquency", element);
            baseDataValidator.reset().parameter("enableInstallmentLevelDelinquency").value((Object)enableInstallmentLevelDelinquency).ignoreIfNull().validateForBooleanValue();
            if (delinquencyBucketId == null && enableInstallmentLevelDelinquency.booleanValue()) {
                baseDataValidator.reset().parameter("enableInstallmentLevelDelinquency").failWithCode("can.be.enabled.for.loan.product.having.valid.delinquency.bucket", new Object[]{"Installment level delinquency cannot be enabled if Delinquency bucket is not configured for loan product"});
            }
        }
        if (this.fromApiJsonHelper.parameterExists("loanScheduleType", element)) {
            this.validateLoanScheduleType(transactionProcessingStrategyCode, baseDataValidator, element);
        }
        String loanScheduleProcessingType = LoanScheduleProcessingType.HORIZONTAL.name();
        if (this.fromApiJsonHelper.parameterExists("loanScheduleProcessingType", element)) {
            loanScheduleProcessingType = this.fromApiJsonHelper.extractStringNamed("loanScheduleProcessingType", element);
            baseDataValidator.reset().parameter("loanScheduleProcessingType").value((Object)loanScheduleProcessingType).isOneOfEnumValues(LoanScheduleProcessingType.class);
            if (LoanScheduleProcessingType.VERTICAL.equals((Object)LoanScheduleProcessingType.valueOf((String)loanScheduleProcessingType)) && !"advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode)) {
                baseDataValidator.reset().parameter("loanScheduleProcessingType").failWithCode("supported.only.for.progressive.loan.schedule.handling", new Object[]{"Vertical repayment schedule processing is only available with `Advanced payment allocation` strategy"});
            }
        }
        if ("advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode) && LoanScheduleProcessingType.HORIZONTAL.name().equals(loanScheduleProcessingType)) {
            this.advancedPaymentAllocationsValidator.checkGroupingOfAllocationRules(this.advancedPaymentAllocationsJsonParser.assembleLoanProductPaymentAllocationRules(command, transactionProcessingStrategyCode));
        }
        Integer recurringMoratoriumOnPrincipalPeriods = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("recurringMoratoriumOnPrincipalPeriods", element);
        this.validateRepaymentPeriodWithGraceSettings(numberOfRepayments, graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, recurringMoratoriumOnPrincipalPeriods, baseDataValidator);
        if ("advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode) && this.fromApiJsonHelper.parameterExists("supportedInterestRefundTypes", element)) {
            String[] supportedTransactionsForInterestRefund = this.fromApiJsonHelper.extractArrayNamed("supportedInterestRefundTypes", element);
            Arrays.stream(supportedTransactionsForInterestRefund).forEach(value -> baseDataValidator.reset().parameter("supportedInterestRefundTypes").value(value).isOneOfEnumValues(LoanSupportedInterestRefundTypes.class));
        } else if (this.fromApiJsonHelper.parameterExists("supportedInterestRefundTypes", element)) {
            baseDataValidator.reset().parameter("supportedInterestRefundTypes").failWithCode("supported.only.for.progressive.loan.schedule.handling", new Object[]{"Automatic interest refund functionality is only supported for Progressive loans"});
        }
        if ("advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode) && this.fromApiJsonHelper.parameterExists("chargeOffBehaviour", element)) {
            String chargeOffBehaviour = this.fromApiJsonHelper.extractStringNamed("chargeOffBehaviour", element);
            baseDataValidator.reset().parameter("chargeOffBehaviour").value((Object)chargeOffBehaviour).isOneOfEnumValues(LoanChargeOffBehaviour.class);
        } else if (this.fromApiJsonHelper.parameterExists("chargeOffBehaviour", element)) {
            baseDataValidator.reset().parameter("chargeOffBehaviour").failWithCode("supported.only.for.progressive.loan.charge.off.behaviour", new Object[]{"Charge off behaviour is only supported for Progressive loans"});
        }
        this.validateIncomeCapitalization(transactionProcessingStrategyCode, element, baseDataValidator, accountingRuleType);
        this.validateBuyDownFee(transactionProcessingStrategyCode, element, baseDataValidator, accountingRuleType);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validateAutoRepaymentForDownPayment(Boolean enableDownPayment, DataValidatorBuilder baseDataValidator, JsonElement element) {
        if (enableDownPayment.booleanValue()) {
            if (this.fromApiJsonHelper.parameterExists("enableAutoRepaymentForDownPayment", element)) {
                Boolean enableAutoRepaymentForDownPayment = this.fromApiJsonHelper.extractBooleanNamed("enableAutoRepaymentForDownPayment", element);
                baseDataValidator.reset().parameter("enableAutoRepaymentForDownPayment").value((Object)enableAutoRepaymentForDownPayment).ignoreIfNull().validateForBooleanValue();
            }
        } else if (this.fromApiJsonHelper.parameterExists("enableAutoRepaymentForDownPayment", element)) {
            baseDataValidator.reset().parameter("enableAutoRepaymentForDownPayment").failWithCode("supported.only.for.enable.down.payment.true", new Object[]{"Auto repayment for down-payment is supported only if enable down-payment is true"});
        }
    }

    private void validateDownPaymentPercentage(Boolean enableDownPayment, DataValidatorBuilder baseDataValidator, JsonElement element) {
        if (enableDownPayment.booleanValue()) {
            if (this.fromApiJsonHelper.parameterExists("disbursedAmountPercentageForDownPayment", element)) {
                BigDecimal disbursedAmountPercentageDownPayment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("disbursedAmountPercentageForDownPayment", element);
                baseDataValidator.reset().parameter("disbursedAmountPercentageForDownPayment").value((Object)disbursedAmountPercentageDownPayment).notLessThanMin(BigDecimal.ONE).notGreaterThanMax(BigDecimal.valueOf(100L)).scaleNotGreaterThan(Integer.valueOf(6));
            } else {
                baseDataValidator.reset().parameter("disbursedAmountPercentageForDownPayment").failWithCode("required.for.enable.down.payment.true", new Object[]{"Disbursed amount percentage for down-payment is required if enable down-payment is true"});
            }
        } else if (this.fromApiJsonHelper.parameterExists("disbursedAmountPercentageForDownPayment", element)) {
            baseDataValidator.reset().parameter("disbursedAmountPercentageForDownPayment").failWithCode("supported.only.for.enable.down.payment.true", new Object[]{"Disbursed amount percentage for down-payment is supported only if enable down-payment is true"});
        }
    }

    private void validateVariableInstallmentSettings(DataValidatorBuilder baseDataValidator, JsonElement element) {
        if (this.fromApiJsonHelper.parameterExists("allowVariableInstallments", element) && this.fromApiJsonHelper.extractBooleanNamed("allowVariableInstallments", element).booleanValue()) {
            boolean isEqualAmortization = false;
            if (this.fromApiJsonHelper.parameterExists("isEqualAmortization", element)) {
                isEqualAmortization = this.fromApiJsonHelper.extractBooleanNamed("isEqualAmortization", element);
            }
            if (isEqualAmortization) {
                throw new EqualAmortizationUnsupportedFeatureException("variable.installment", "variable installment");
            }
            Long minimumGapBetweenInstallments = null;
            if (this.fromApiJsonHelper.parameterExists("minimumGap", element)) {
                minimumGapBetweenInstallments = this.fromApiJsonHelper.extractLongNamed("minimumGap", element);
                baseDataValidator.reset().parameter("minimumGap").value((Object)minimumGapBetweenInstallments).notNull();
            } else {
                baseDataValidator.reset().parameter("minimumGap").failWithCode("is.mandatory.when.allowVariableInstallments.is.true", new Object[]{"minimumGap param is mandatory when allowVariableInstallments is true"});
            }
            if (this.fromApiJsonHelper.parameterExists("maximumGap", element)) {
                Long maximumGapBetweenInstallments = this.fromApiJsonHelper.extractLongNamed("maximumGap", element);
                baseDataValidator.reset().parameter("minimumGap").value((Object)maximumGapBetweenInstallments).notNull();
                baseDataValidator.reset().parameter("maximumGap").value((Object)maximumGapBetweenInstallments).notNull().longGreaterThanNumber(minimumGapBetweenInstallments);
            }
        } else {
            if (this.fromApiJsonHelper.parameterExists("minimumGap", element)) {
                baseDataValidator.reset().parameter("minimumGap").failWithCode("not.supported.when.allowVariableInstallments.is.false", new Object[]{"minimumGap param is not supported when allowVariableInstallments is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists("maximumGap", element)) {
                baseDataValidator.reset().parameter("maximumGap").failWithCode("not.supported.when.allowVariableInstallments.is.false", new Object[]{"maximumGap param is not supported when allowVariableInstallments is not supplied or false"});
            }
        }
    }

    private void validateLoanConfigurableAttributes(DataValidatorBuilder baseDataValidator, JsonElement element) {
        if (this.fromApiJsonHelper.parameterExists("allowAttributeOverrides", element)) {
            JsonObject object = element.getAsJsonObject().getAsJsonObject("allowAttributeOverrides");
            HashSet supportedConfigurableAttributes = new HashSet();
            Collections.addAll(supportedConfigurableAttributes, SUPPORTED_LOAN_CONFIGURABLE_ATTRIBUTES);
            this.fromApiJsonHelper.checkForUnsupportedNestedParameters("allowAttributeOverrides", object, supportedConfigurableAttributes);
            for (String supportedLoanConfigurableAttribute : SUPPORTED_LOAN_CONFIGURABLE_ATTRIBUTES) {
                if (!this.fromApiJsonHelper.parameterExists(supportedLoanConfigurableAttribute, (JsonElement)object)) continue;
                Boolean loanConfigurationAttributeValue = this.fromApiJsonHelper.extractBooleanNamed(supportedLoanConfigurableAttribute, (JsonElement)object);
                baseDataValidator.reset().parameter("allowAttributeOverrides").value((Object)loanConfigurationAttributeValue).notNull().validateForBooleanValue();
            }
        }
    }

    private void validateMultiDisburseLoanData(DataValidatorBuilder baseDataValidator, JsonElement element, LoanProduct loanProduct) {
        Boolean multiDisburseLoan = false;
        if (this.fromApiJsonHelper.parameterExists("multiDisburseLoan", element)) {
            multiDisburseLoan = this.fromApiJsonHelper.extractBooleanNamed("multiDisburseLoan", element);
            baseDataValidator.reset().parameter("multiDisburseLoan").value((Object)multiDisburseLoan).ignoreIfNull().validateForBooleanValue();
        }
        boolean isEqualAmortization = false;
        if (this.fromApiJsonHelper.parameterExists("isEqualAmortization", element)) {
            isEqualAmortization = this.fromApiJsonHelper.extractBooleanNamed("isEqualAmortization", element);
        }
        if (isEqualAmortization && multiDisburseLoan.booleanValue()) {
            throw new EqualAmortizationUnsupportedFeatureException("tranche.disbursal", "tranche disbursal");
        }
        if (multiDisburseLoan.booleanValue()) {
            if (this.fromApiJsonHelper.parameterExists("outstandingLoanBalance", element)) {
                BigDecimal outstandingLoanBalance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("outstandingLoanBalance", element);
                baseDataValidator.reset().parameter("outstandingLoanBalance").value((Object)outstandingLoanBalance).ignoreIfNull().zeroOrPositiveAmount();
            }
            Integer maxTrancheCount = this.fromApiJsonHelper.extractIntegerNamed("maxTrancheCount", element, Locale.getDefault());
            baseDataValidator.reset().parameter("maxTrancheCount").value((Object)maxTrancheCount).notNull().integerGreaterThanZero();
            Integer interestType = this.fromApiJsonHelper.extractIntegerNamed(INTEREST_TYPE, element, Locale.getDefault());
            boolean isProgressive = this.isProgressive(element, loanProduct);
            if (isProgressive) {
                baseDataValidator.reset().parameter(INTEREST_TYPE).value((Object)interestType).ignoreIfNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
            } else {
                baseDataValidator.reset().parameter(INTEREST_TYPE).value((Object)interestType).ignoreIfNull().integerSameAsNumber(InterestMethod.DECLINING_BALANCE.getValue());
            }
        }
        String overAppliedCalculationType = this.fromApiJsonHelper.extractStringNamed(OVER_APPLIED_CALCULATION_TYPE, element);
        baseDataValidator.reset().parameter(OVER_APPLIED_CALCULATION_TYPE).value((Object)overAppliedCalculationType).notExceedingLengthOf(Integer.valueOf(10));
    }

    private boolean isProgressive(JsonElement element, LoanProduct loanProduct) {
        String transactionProcessingStrategyCode;
        String processorCode = null;
        if (loanProduct != null) {
            processorCode = loanProduct.getTransactionProcessingStrategyCode();
        }
        if ((transactionProcessingStrategyCode = this.fromApiJsonHelper.extractStringNamed(TRANSACTION_PROCESSING_STRATEGY_CODE, element)) != null) {
            processorCode = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(transactionProcessingStrategyCode).getCode();
        }
        return "advanced-payment-allocation-strategy".equals(processorCode);
    }

    private void validateInterestRecalculationParams(JsonElement element, DataValidatorBuilder baseDataValidator, LoanProduct loanProduct) {
        LoanPreCloseInterestCalculationStrategy preCloseStrategy;
        String loanScheduleType;
        InterestRecalculationCompoundingMethod compoundingMethod = null;
        if (loanProduct == null || this.fromApiJsonHelper.parameterExists("interestRecalculationCompoundingMethod", element)) {
            Integer interestRecalculationCompoundingMethod = this.fromApiJsonHelper.extractIntegerNamed("interestRecalculationCompoundingMethod", element, Locale.getDefault());
            baseDataValidator.reset().parameter("interestRecalculationCompoundingMethod").value((Object)interestRecalculationCompoundingMethod).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            if (interestRecalculationCompoundingMethod != null) {
                compoundingMethod = InterestRecalculationCompoundingMethod.fromInt((Integer)interestRecalculationCompoundingMethod);
            }
        }
        if (compoundingMethod == null) {
            compoundingMethod = loanProduct == null ? InterestRecalculationCompoundingMethod.NONE : InterestRecalculationCompoundingMethod.fromInt((Integer)loanProduct.getProductInterestRecalculationDetails().getInterestRecalculationCompoundingMethod());
        }
        if (loanProduct == null || this.fromApiJsonHelper.parameterExists("rescheduleStrategyMethod", element)) {
            Integer rescheduleStrategyMethod = this.fromApiJsonHelper.extractIntegerNamed("rescheduleStrategyMethod", element, Locale.getDefault());
            baseDataValidator.reset().parameter("rescheduleStrategyMethod").value((Object)rescheduleStrategyMethod).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
            LoanRescheduleStrategyMethod loanRescheduleStrategyMethod = LoanRescheduleStrategyMethod.fromInt((Integer)rescheduleStrategyMethod);
            loanScheduleType = LoanScheduleType.CUMULATIVE.toString();
            if (this.fromApiJsonHelper.parameterExists("loanScheduleType", element)) {
                loanScheduleType = this.fromApiJsonHelper.extractStringNamed("loanScheduleType", element);
            }
            if (LoanScheduleType.CUMULATIVE.equals((Object)LoanScheduleType.valueOf((String)loanScheduleType)) && this.fromApiJsonHelper.parameterExists("disallowInterestCalculationOnPastDue", element)) {
                baseDataValidator.reset().parameter("disallowInterestCalculationOnPastDue").failWithCode("disallow.interest.calculation.on.past.due.not.supported.for.loan.schedule.type.cumulative", new Object[]{"Do not calculate interest on past due principal balances is only supported for Progressive loan schedule type"});
            }
            if (LoanScheduleType.CUMULATIVE.equals((Object)LoanScheduleType.valueOf((String)loanScheduleType)) && LoanRescheduleStrategyMethod.ADJUST_LAST_UNPAID_PERIOD.equals((Object)loanRescheduleStrategyMethod)) {
                baseDataValidator.reset().parameter("rescheduleStrategyMethod").failWithCode("reschedule.strategy.method.not.supported.for.loan.schedule.type.cumulative", new Object[]{"Adjust last, unpaid period is only supported for Progressive loan schedule type"});
            }
            if (LoanScheduleType.PROGRESSIVE.equals((Object)LoanScheduleType.valueOf((String)loanScheduleType)) && !LoanRescheduleStrategyMethod.ADJUST_LAST_UNPAID_PERIOD.equals((Object)loanRescheduleStrategyMethod)) {
                baseDataValidator.reset().parameter("rescheduleStrategyMethod").failWithCode("reschedule.strategy.method.not.supported.for.loan.schedule.type.progressive", new Object[]{loanRescheduleStrategyMethod.toString() + " reschedule strategy type is not supported for Progressive loan schedule type"});
            }
        }
        RecalculationFrequencyType frequencyType = null;
        if (loanProduct == null || this.fromApiJsonHelper.parameterExists("recalculationRestFrequencyType", element)) {
            Integer recalculationRestFrequencyType = this.fromApiJsonHelper.extractIntegerNamed("recalculationRestFrequencyType", element, Locale.getDefault());
            baseDataValidator.reset().parameter("recalculationRestFrequencyType").value((Object)recalculationRestFrequencyType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
            if (recalculationRestFrequencyType != null) {
                frequencyType = RecalculationFrequencyType.fromInt((Integer)recalculationRestFrequencyType);
            }
        }
        if (frequencyType == null) {
            frequencyType = loanProduct == null ? RecalculationFrequencyType.INVALID : loanProduct.getProductInterestRecalculationDetails().getRestFrequencyType();
        }
        if (!frequencyType.isSameAsRepayment()) {
            if (loanProduct == null || this.fromApiJsonHelper.parameterExists("recalculationRestFrequencyInterval", element)) {
                Integer recurrenceInterval = this.fromApiJsonHelper.extractIntegerNamed("recalculationRestFrequencyInterval", element, Locale.getDefault());
                baseDataValidator.reset().parameter("recalculationRestFrequencyInterval").value((Object)recurrenceInterval).notNull();
            }
            if (loanProduct == null || this.fromApiJsonHelper.parameterExists("recalculationRestFrequencyNthDayType", element) || this.fromApiJsonHelper.parameterExists("recalculationRestFrequencyDayOfWeekType", element)) {
                CalendarUtils.validateNthDayOfMonthFrequency((DataValidatorBuilder)baseDataValidator, (String)"recalculationRestFrequencyNthDayType", (String)"recalculationRestFrequencyDayOfWeekType", (JsonElement)element, (FromJsonHelper)this.fromApiJsonHelper);
            }
            if (loanProduct == null || this.fromApiJsonHelper.parameterExists("recalculationRestFrequencyOnDayType", element)) {
                Integer recalculationRestFrequencyOnDay = this.fromApiJsonHelper.extractIntegerNamed("recalculationRestFrequencyOnDayType", element, Locale.getDefault());
                baseDataValidator.reset().parameter("recalculationRestFrequencyOnDayType").value((Object)recalculationRestFrequencyOnDay).ignoreIfNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(28));
            }
        }
        if (compoundingMethod.isCompoundingEnabled()) {
            RecalculationFrequencyType compoundingFrequencyType = null;
            if (loanProduct == null || this.fromApiJsonHelper.parameterExists("recalculationCompoundingFrequencyType", element)) {
                Integer recalculationCompoundingFrequencyType = this.fromApiJsonHelper.extractIntegerNamed("recalculationCompoundingFrequencyType", element, Locale.getDefault());
                baseDataValidator.reset().parameter("recalculationCompoundingFrequencyType").value((Object)recalculationCompoundingFrequencyType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
                if (recalculationCompoundingFrequencyType != null && !(compoundingFrequencyType = RecalculationFrequencyType.fromInt((Integer)recalculationCompoundingFrequencyType)).isSameAsRepayment()) {
                    PeriodFrequencyType repaymentFrequencyType = null;
                    if (this.fromApiJsonHelper.parameterExists(REPAYMENT_FREQUENCY_TYPE, element)) {
                        Integer repaymentFrequencyTypeVal = this.fromApiJsonHelper.extractIntegerNamed(REPAYMENT_FREQUENCY_TYPE, element, Locale.getDefault());
                        repaymentFrequencyType = PeriodFrequencyType.fromInt((Integer)repaymentFrequencyTypeVal);
                    } else if (loanProduct != null) {
                        repaymentFrequencyType = loanProduct.getLoanProductRelatedDetail().getRepaymentPeriodFrequencyType();
                    }
                    if (!compoundingFrequencyType.isSameFrequency(repaymentFrequencyType)) {
                        baseDataValidator.reset().parameter("recalculationCompoundingFrequencyType").value((Object)recalculationCompoundingFrequencyType).failWithCode("must.be.same.as.repayment.frequency", new Object[0]);
                    }
                }
            }
            if (compoundingFrequencyType == null) {
                compoundingFrequencyType = loanProduct == null ? RecalculationFrequencyType.INVALID : loanProduct.getProductInterestRecalculationDetails().getCompoundingFrequencyType();
            }
            if (!compoundingFrequencyType.isSameAsRepayment()) {
                if (loanProduct == null || this.fromApiJsonHelper.parameterExists("recalculationCompoundingFrequencyInterval", element)) {
                    Integer recurrenceInterval = this.fromApiJsonHelper.extractIntegerNamed("recalculationCompoundingFrequencyInterval", element, Locale.getDefault());
                    Integer repaymentEvery = null;
                    repaymentEvery = loanProduct == null ? this.fromApiJsonHelper.extractIntegerWithLocaleNamed(REPAYMENT_EVERY, element) : loanProduct.getLoanProductRelatedDetail().getRepayEvery();
                    baseDataValidator.reset().parameter("recalculationCompoundingFrequencyInterval").value((Object)recurrenceInterval).notNull().integerInMultiplesOfNumber(repaymentEvery);
                }
                if (loanProduct == null || this.fromApiJsonHelper.parameterExists("recalculationCompoundingFrequencyNthDayType", element) || this.fromApiJsonHelper.parameterExists("recalculationCompoundingFrequencyDayOfWeekType", element)) {
                    CalendarUtils.validateNthDayOfMonthFrequency((DataValidatorBuilder)baseDataValidator, (String)"recalculationCompoundingFrequencyNthDayType", (String)"recalculationCompoundingFrequencyDayOfWeekType", (JsonElement)element, (FromJsonHelper)this.fromApiJsonHelper);
                }
                if (loanProduct == null || this.fromApiJsonHelper.parameterExists("recalculationCompoundingFrequencyOnDayType", element)) {
                    Integer recalculationRestFrequencyOnDay = this.fromApiJsonHelper.extractIntegerNamed("recalculationCompoundingFrequencyOnDayType", element, Locale.getDefault());
                    baseDataValidator.reset().parameter("recalculationCompoundingFrequencyOnDayType").value((Object)recalculationRestFrequencyOnDay).ignoreIfNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(28));
                }
            }
        }
        if (this.fromApiJsonHelper.parameterExists("isArrearsBasedOnOriginalSchedule", element)) {
            Boolean isArrearsBasedOnOriginalSchedule = this.fromApiJsonHelper.extractBooleanNamed("isArrearsBasedOnOriginalSchedule", element);
            baseDataValidator.reset().parameter("isArrearsBasedOnOriginalSchedule").value((Object)isArrearsBasedOnOriginalSchedule).notNull().isOneOfTheseValues(new Object[]{true, false});
        }
        if (this.fromApiJsonHelper.parameterExists("isCompoundingToBePostedAsTransaction", element)) {
            Boolean isCompoundingToBePostedAsTransactions = this.fromApiJsonHelper.extractBooleanNamed("isCompoundingToBePostedAsTransaction", element);
            baseDataValidator.reset().parameter("isCompoundingToBePostedAsTransaction").value((Object)isCompoundingToBePostedAsTransactions).notNull().isOneOfTheseValues(new Object[]{true, false});
        }
        Integer preCloseInterestCalculationStrategy = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("preClosureInterestCalculationStrategy", element);
        baseDataValidator.reset().parameter("preClosureInterestCalculationStrategy").value((Object)preCloseInterestCalculationStrategy).ignoreIfNull().inMinMaxRange(Integer.valueOf(LoanPreCloseInterestCalculationStrategy.getMinValue()), Integer.valueOf(LoanPreCloseInterestCalculationStrategy.getMaxValue()));
        loanScheduleType = LoanScheduleType.CUMULATIVE.toString();
        if (this.fromApiJsonHelper.parameterExists("loanScheduleType", element)) {
            loanScheduleType = this.fromApiJsonHelper.extractStringNamed("loanScheduleType", element);
        }
        if (LoanScheduleType.PROGRESSIVE.equals((Object)LoanScheduleType.valueOf((String)loanScheduleType)) && preCloseInterestCalculationStrategy != null && (preCloseStrategy = LoanPreCloseInterestCalculationStrategy.fromInt((Integer)preCloseInterestCalculationStrategy)).calculateTillRestFrequencyEnabled() && !frequencyType.isSameAsRepayment() && !frequencyType.isDaily()) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("when.preclose.strategy.is.till.rest.frequency.then.frequency.type.is.daily.or.same.as.repayment", new Object[]{"When the pre-close interest calculation strategy is set to `Till Rest Frequency Date` the frequency of outstanding principal calculation must be `Daily` or `Same as repayment period`."});
        }
    }

    public void validateForUpdate(JsonCommand command, LoanProduct loanProduct) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(LOANPRODUCT);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists(NAME, element)) {
            String name = this.fromApiJsonHelper.extractStringNamed(NAME, element);
            baseDataValidator.reset().parameter(NAME).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists("shortName", element)) {
            String shortName = this.fromApiJsonHelper.extractStringNamed("shortName", element);
            baseDataValidator.reset().parameter("shortName").value((Object)shortName).notBlank().notExceedingLengthOf(Integer.valueOf(4));
        }
        if (this.fromApiJsonHelper.parameterExists(DESCRIPTION, element)) {
            String description = this.fromApiJsonHelper.extractStringNamed(DESCRIPTION, element);
            baseDataValidator.reset().parameter(DESCRIPTION).value((Object)description).notExceedingLengthOf(Integer.valueOf(500));
        }
        if (this.fromApiJsonHelper.parameterExists(FUND_ID, element)) {
            Long fundId = this.fromApiJsonHelper.extractLongNamed(FUND_ID, element);
            baseDataValidator.reset().parameter(FUND_ID).value((Object)fundId).ignoreIfNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists(INCLUDE_IN_BORROWER_CYCLE, element)) {
            Boolean includeInBorrowerCycle = this.fromApiJsonHelper.extractBooleanNamed(INCLUDE_IN_BORROWER_CYCLE, element);
            baseDataValidator.reset().parameter(INCLUDE_IN_BORROWER_CYCLE).value((Object)includeInBorrowerCycle).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists(CURRENCY_CODE, element)) {
            String currencyCode = this.fromApiJsonHelper.extractStringNamed(CURRENCY_CODE, element);
            baseDataValidator.reset().parameter(CURRENCY_CODE).value((Object)currencyCode).notBlank().notExceedingLengthOf(Integer.valueOf(3));
        }
        if (this.fromApiJsonHelper.parameterExists(DIGITS_AFTER_DECIMAL, element)) {
            Integer digitsAfterDecimal = this.fromApiJsonHelper.extractIntegerNamed(DIGITS_AFTER_DECIMAL, element, Locale.getDefault());
            baseDataValidator.reset().parameter(DIGITS_AFTER_DECIMAL).value((Object)digitsAfterDecimal).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(6));
        }
        if (this.fromApiJsonHelper.parameterExists(IN_MULTIPLES_OF, element)) {
            Integer inMultiplesOf = this.fromApiJsonHelper.extractIntegerNamed(IN_MULTIPLES_OF, element, Locale.getDefault());
            baseDataValidator.reset().parameter(IN_MULTIPLES_OF).value((Object)inMultiplesOf).ignoreIfNull().integerZeroOrGreater();
        }
        String minPrincipalParameterName = MIN_PRINCIPAL;
        if (this.fromApiJsonHelper.parameterExists(MIN_PRINCIPAL, element)) {
            BigDecimal minPrincipalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MIN_PRINCIPAL, element);
            baseDataValidator.reset().parameter(MIN_PRINCIPAL).value((Object)minPrincipalAmount).ignoreIfNull().positiveAmount();
        }
        String maxPrincipalParameterName = MAX_PRINCIPAL;
        if (this.fromApiJsonHelper.parameterExists(MAX_PRINCIPAL, element)) {
            BigDecimal maxPrincipalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MAX_PRINCIPAL, element);
            baseDataValidator.reset().parameter(MAX_PRINCIPAL).value((Object)maxPrincipalAmount).ignoreIfNull().positiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists(PRINCIPAL, element)) {
            BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(PRINCIPAL, element);
            baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principal).positiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists(IN_ARREARS_TOLERANCE, element)) {
            BigDecimal inArrearsTolerance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(IN_ARREARS_TOLERANCE, element);
            baseDataValidator.reset().parameter(IN_ARREARS_TOLERANCE).value((Object)inArrearsTolerance).ignoreIfNull().zeroOrPositiveAmount();
        }
        String minNumberOfRepaymentsParameterName = MIN_NUMBER_OF_REPAYMENTS;
        if (this.fromApiJsonHelper.parameterExists(MIN_NUMBER_OF_REPAYMENTS, element)) {
            Integer minNumberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(MIN_NUMBER_OF_REPAYMENTS, element);
            baseDataValidator.reset().parameter(MIN_NUMBER_OF_REPAYMENTS).value((Object)minNumberOfRepayments).ignoreIfNull().integerGreaterThanZero();
        }
        String maxNumberOfRepaymentsParameterName = MAX_NUMBER_OF_REPAYMENTS;
        if (this.fromApiJsonHelper.parameterExists(MAX_NUMBER_OF_REPAYMENTS, element)) {
            Integer maxNumberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(MAX_NUMBER_OF_REPAYMENTS, element);
            baseDataValidator.reset().parameter(MAX_NUMBER_OF_REPAYMENTS).value((Object)maxNumberOfRepayments).ignoreIfNull().integerGreaterThanZero();
        }
        Integer numberOfRepayments = null;
        if (this.fromApiJsonHelper.parameterExists(NUMBER_OF_REPAYMENTS, element)) {
            numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(NUMBER_OF_REPAYMENTS, element);
            baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).notNull().integerGreaterThanZero();
        }
        if (numberOfRepayments == null) {
            numberOfRepayments = loanProduct.getNumberOfRepayments();
        }
        Integer repaymentEvery = loanProduct.getLoanProductRelatedDetail().getRepayEvery();
        if (this.fromApiJsonHelper.parameterExists(REPAYMENT_EVERY, element)) {
            repaymentEvery = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(REPAYMENT_EVERY, element);
            baseDataValidator.reset().parameter(REPAYMENT_EVERY).value((Object)repaymentEvery).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists(REPAYMENT_FREQUENCY_TYPE, element)) {
            Integer repaymentFrequencyType = this.fromApiJsonHelper.extractIntegerNamed(REPAYMENT_FREQUENCY_TYPE, element, Locale.getDefault());
            baseDataValidator.reset().parameter(REPAYMENT_FREQUENCY_TYPE).value((Object)repaymentFrequencyType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
        }
        String transactionProcessingStrategyCode = loanProduct.getTransactionProcessingStrategyCode();
        if (this.fromApiJsonHelper.parameterExists(TRANSACTION_PROCESSING_STRATEGY_CODE, element)) {
            transactionProcessingStrategyCode = this.fromApiJsonHelper.extractStringNamed(TRANSACTION_PROCESSING_STRATEGY_CODE, element);
            baseDataValidator.reset().parameter(TRANSACTION_PROCESSING_STRATEGY_CODE).value((Object)transactionProcessingStrategyCode).notBlank();
            this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(transactionProcessingStrategyCode);
        }
        Integer graceOnPrincipalPayment = loanProduct.getLoanProductRelatedDetail().getGraceOnPrincipalPayment();
        if (this.fromApiJsonHelper.parameterExists(GRACE_ON_PRINCIPAL_PAYMENT, element)) {
            graceOnPrincipalPayment = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(GRACE_ON_PRINCIPAL_PAYMENT, element);
            baseDataValidator.reset().parameter(GRACE_ON_PRINCIPAL_PAYMENT).value((Object)graceOnPrincipalPayment).zeroOrPositiveAmount();
        }
        Integer graceOnInterestPayment = loanProduct.getLoanProductRelatedDetail().getGraceOnInterestPayment();
        if (this.fromApiJsonHelper.parameterExists(GRACE_ON_INTEREST_PAYMENT, element)) {
            graceOnInterestPayment = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(GRACE_ON_INTEREST_PAYMENT, element);
            baseDataValidator.reset().parameter(GRACE_ON_INTEREST_PAYMENT).value((Object)graceOnInterestPayment).zeroOrPositiveAmount();
        }
        Integer graceOnInterestCharged = loanProduct.getLoanProductRelatedDetail().getGraceOnInterestCharged();
        if (this.fromApiJsonHelper.parameterExists(GRACE_ON_INTEREST_CHARGED, element)) {
            graceOnInterestCharged = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(GRACE_ON_INTEREST_CHARGED, element);
            baseDataValidator.reset().parameter(GRACE_ON_INTEREST_CHARGED).value((Object)graceOnInterestCharged).zeroOrPositiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists("graceOnArrearsAgeing", element)) {
            Integer graceOnArrearsAgeing = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnArrearsAgeing", element);
            baseDataValidator.reset().parameter("graceOnArrearsAgeing").value((Object)graceOnArrearsAgeing).integerZeroOrGreater();
        }
        if (this.fromApiJsonHelper.parameterExists("overdueDaysForNPA", element)) {
            Integer overdueDaysForNPA = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("overdueDaysForNPA", element);
            baseDataValidator.reset().parameter("overdueDaysForNPA").value((Object)overdueDaysForNPA).integerZeroOrGreater();
        }
        Long delinquencyBucketId = null;
        if (this.fromApiJsonHelper.parameterExists("delinquencyBucketId", element)) {
            delinquencyBucketId = this.fromApiJsonHelper.extractLongNamed("delinquencyBucketId", element);
            baseDataValidator.reset().parameter("delinquencyBucketId").value((Object)delinquencyBucketId).ignoreIfNull().integerGreaterThanZero();
        }
        Integer amortizationType = null;
        if (this.fromApiJsonHelper.parameterExists(AMORTIZATION_TYPE, element)) {
            amortizationType = this.fromApiJsonHelper.extractIntegerNamed(AMORTIZATION_TYPE, element, Locale.getDefault());
            baseDataValidator.reset().parameter(AMORTIZATION_TYPE).value((Object)amortizationType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
        }
        if (this.fromApiJsonHelper.parameterExists(INTEREST_TYPE, element)) {
            Integer interestType = this.fromApiJsonHelper.extractIntegerNamed(INTEREST_TYPE, element, Locale.getDefault());
            baseDataValidator.reset().parameter(INTEREST_TYPE).value((Object)interestType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
        }
        Integer interestCalculationPeriodType = loanProduct.getLoanProductRelatedDetail().getInterestCalculationPeriodMethod().getValue();
        if (this.fromApiJsonHelper.parameterExists(INTEREST_CALCULATION_PERIOD_TYPE, element)) {
            interestCalculationPeriodType = this.fromApiJsonHelper.extractIntegerNamed(INTEREST_CALCULATION_PERIOD_TYPE, element, Locale.getDefault());
            baseDataValidator.reset().parameter(INTEREST_CALCULATION_PERIOD_TYPE).value((Object)interestCalculationPeriodType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
        }
        if (this.fromApiJsonHelper.parameterExists("daysInYearType", element)) {
            Integer daysInYearType = this.fromApiJsonHelper.extractIntegerNamed("daysInYearType", element, Locale.getDefault());
            baseDataValidator.reset().parameter("daysInYearType").value((Object)daysInYearType).notNull().isOneOfTheseValues(new Object[]{1, 360, 364, 365});
        }
        if (this.fromApiJsonHelper.parameterExists("daysInMonthType", element)) {
            Integer daysInMonthType = this.fromApiJsonHelper.extractIntegerNamed("daysInMonthType", element, Locale.getDefault());
            baseDataValidator.reset().parameter("daysInMonthType").value((Object)daysInMonthType).notNull().isOneOfTheseValues(new Object[]{1, 30});
        }
        if (this.fromApiJsonHelper.parameterExists("accountMovesOutOfNPAOnlyOnArrearsCompletion", element)) {
            Boolean npaChangeConfig = this.fromApiJsonHelper.extractBooleanNamed("accountMovesOutOfNPAOnlyOnArrearsCompletion", element);
            baseDataValidator.reset().parameter("accountMovesOutOfNPAOnlyOnArrearsCompletion").value((Object)npaChangeConfig).notNull().isOneOfTheseValues(new Object[]{true, false});
        }
        boolean isEqualAmortization = loanProduct.isEqualAmortization();
        if (this.fromApiJsonHelper.parameterExists("isEqualAmortization", element)) {
            isEqualAmortization = this.fromApiJsonHelper.extractBooleanNamed("isEqualAmortization", element);
            baseDataValidator.reset().parameter("isEqualAmortization").value((Object)isEqualAmortization).ignoreIfNull().validateForBooleanValue();
        }
        Boolean isInterestRecalculationEnabled = loanProduct.isInterestRecalculationEnabled();
        if (this.fromApiJsonHelper.parameterExists("isInterestRecalculationEnabled", element)) {
            isInterestRecalculationEnabled = this.fromApiJsonHelper.extractBooleanNamed("isInterestRecalculationEnabled", element);
            baseDataValidator.reset().parameter("isInterestRecalculationEnabled").value((Object)isInterestRecalculationEnabled).notNull().isOneOfTheseValues(new Object[]{true, false});
        }
        if (isInterestRecalculationEnabled != null && isInterestRecalculationEnabled.booleanValue()) {
            if (isEqualAmortization) {
                throw new EqualAmortizationUnsupportedFeatureException("interest.recalculation", "interest recalculation");
            }
            this.validateInterestRecalculationParams(element, baseDataValidator, loanProduct);
        }
        boolean isLinkedToFloatingInterestRates = loanProduct.isLinkedToFloatingInterestRate();
        if (this.fromApiJsonHelper.parameterExists(IS_LINKED_TO_FLOATING_INTEREST_RATES, element)) {
            isLinkedToFloatingInterestRates = this.fromApiJsonHelper.extractBooleanNamed(IS_LINKED_TO_FLOATING_INTEREST_RATES, element);
        }
        boolean isInterestBearing = false;
        if (isLinkedToFloatingInterestRates) {
            Boolean isFloatingInterestRateCalculationAllowed;
            BigDecimal maxDifferentialLendingRate;
            BigDecimal defaultDifferentialLendingRate;
            BigDecimal minDifferentialLendingRate;
            BigDecimal interestRateDifferential;
            Long floatingRatesId;
            Integer interestType;
            if (isEqualAmortization) {
                throw new EqualAmortizationUnsupportedFeatureException("floating.interest.rate", "floating interest rate");
            }
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_PER_PERIOD, element)) {
                baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.true", new Object[]{"interestRatePerPeriod param is not supported when isLinkedToFloatingInterestRates is true"});
            }
            if (this.fromApiJsonHelper.parameterExists(MIN_INTEREST_RATE_PER_PERIOD, element)) {
                baseDataValidator.reset().parameter(MIN_INTEREST_RATE_PER_PERIOD).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.true", new Object[]{"minInterestRatePerPeriod param is not supported when isLinkedToFloatingInterestRates is true"});
            }
            if (this.fromApiJsonHelper.parameterExists(MAX_INTEREST_RATE_PER_PERIOD, element)) {
                baseDataValidator.reset().parameter(MAX_INTEREST_RATE_PER_PERIOD).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.true", new Object[]{"maxInterestRatePerPeriod param is not supported when isLinkedToFloatingInterestRates is true"});
            }
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_FREQUENCY_TYPE, element)) {
                baseDataValidator.reset().parameter(INTEREST_RATE_FREQUENCY_TYPE).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.true", new Object[]{"interestRateFrequencyType param is not supported when isLinkedToFloatingInterestRates is true"});
            }
            Integer n = interestType = this.fromApiJsonHelper.parameterExists(INTEREST_TYPE, element) ? this.fromApiJsonHelper.extractIntegerNamed(INTEREST_TYPE, element, Locale.getDefault()) : loanProduct.getLoanProductRelatedDetail().getInterestMethod().getValue();
            if (interestType == null || !interestType.equals(InterestMethod.DECLINING_BALANCE.getValue()) || isInterestRecalculationEnabled == null || !isInterestRecalculationEnabled.booleanValue()) {
                baseDataValidator.reset().parameter(IS_LINKED_TO_FLOATING_INTEREST_RATES).failWithCode("supported.only.for.declining.balance.interest.recalculation.enabled", new Object[]{"Floating interest rates are supported only for declining balance and interest recalculation enabled loan products"});
            }
            Long l = floatingRatesId = loanProduct.getFloatingRates() == null ? null : (Long)loanProduct.getFloatingRates().getFloatingRate().getId();
            if (this.fromApiJsonHelper.parameterExists(FLOATING_RATES_ID, element)) {
                floatingRatesId = this.fromApiJsonHelper.extractLongNamed(FLOATING_RATES_ID, element);
            }
            baseDataValidator.reset().parameter(FLOATING_RATES_ID).value((Object)floatingRatesId).notNull();
            BigDecimal bigDecimal = interestRateDifferential = loanProduct.getFloatingRates() == null ? null : loanProduct.getFloatingRates().getInterestRateDifferential();
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_DIFFERENTIAL, element)) {
                interestRateDifferential = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(INTEREST_RATE_DIFFERENTIAL, element);
            }
            baseDataValidator.reset().parameter(INTEREST_RATE_DIFFERENTIAL).value((Object)interestRateDifferential).notNull().zeroOrPositiveAmount();
            String minDifferentialLendingRateParameterName = MIN_DIFFERENTIAL_LENDING_RATE;
            BigDecimal bigDecimal2 = minDifferentialLendingRate = loanProduct.getFloatingRates() == null ? null : loanProduct.getFloatingRates().getMinDifferentialLendingRate();
            if (this.fromApiJsonHelper.parameterExists(MIN_DIFFERENTIAL_LENDING_RATE, element)) {
                minDifferentialLendingRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MIN_DIFFERENTIAL_LENDING_RATE, element);
            }
            baseDataValidator.reset().parameter(MIN_DIFFERENTIAL_LENDING_RATE).value((Object)minDifferentialLendingRate).notNull().zeroOrPositiveAmount();
            String defaultDifferentialLendingRateParameterName = DEFAULT_DIFFERENTIAL_LENDING_RATE;
            BigDecimal bigDecimal3 = defaultDifferentialLendingRate = loanProduct.getFloatingRates() == null ? null : loanProduct.getFloatingRates().getDefaultDifferentialLendingRate();
            if (this.fromApiJsonHelper.parameterExists(DEFAULT_DIFFERENTIAL_LENDING_RATE, element)) {
                defaultDifferentialLendingRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(DEFAULT_DIFFERENTIAL_LENDING_RATE, element);
            }
            baseDataValidator.reset().parameter(DEFAULT_DIFFERENTIAL_LENDING_RATE).value((Object)defaultDifferentialLendingRate).notNull().zeroOrPositiveAmount();
            String maxDifferentialLendingRateParameterName = MAX_DIFFERENTIAL_LENDING_RATE;
            BigDecimal bigDecimal4 = maxDifferentialLendingRate = loanProduct.getFloatingRates() == null ? null : loanProduct.getFloatingRates().getMaxDifferentialLendingRate();
            if (this.fromApiJsonHelper.parameterExists(MAX_DIFFERENTIAL_LENDING_RATE, element)) {
                maxDifferentialLendingRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MAX_DIFFERENTIAL_LENDING_RATE, element);
            }
            baseDataValidator.reset().parameter(MAX_DIFFERENTIAL_LENDING_RATE).value((Object)maxDifferentialLendingRate).notNull().zeroOrPositiveAmount();
            if (defaultDifferentialLendingRate != null && defaultDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0 && minDifferentialLendingRate != null && minDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter(DEFAULT_DIFFERENTIAL_LENDING_RATE).value((Object)defaultDifferentialLendingRate).notLessThanMin(minDifferentialLendingRate);
            }
            if (maxDifferentialLendingRate != null && maxDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0 && minDifferentialLendingRate != null && minDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter(MAX_DIFFERENTIAL_LENDING_RATE).value((Object)maxDifferentialLendingRate).notLessThanMin(minDifferentialLendingRate);
            }
            if (maxDifferentialLendingRate != null && maxDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0 && defaultDifferentialLendingRate != null && defaultDifferentialLendingRate.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter(MAX_DIFFERENTIAL_LENDING_RATE).value((Object)maxDifferentialLendingRate).notLessThanMin(defaultDifferentialLendingRate);
            }
            Boolean bl = isFloatingInterestRateCalculationAllowed = loanProduct.getFloatingRates() == null ? null : Boolean.valueOf(loanProduct.getFloatingRates().isFloatingInterestRateCalculationAllowed());
            if (this.fromApiJsonHelper.parameterExists(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED, element)) {
                isFloatingInterestRateCalculationAllowed = this.fromApiJsonHelper.extractBooleanNamed(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED, element);
            }
            baseDataValidator.reset().parameter(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED).value((Object)isFloatingInterestRateCalculationAllowed).notNull().isOneOfTheseValues(new Object[]{true, false});
            isInterestBearing = true;
        } else {
            if (this.fromApiJsonHelper.parameterExists(FLOATING_RATES_ID, element)) {
                baseDataValidator.reset().parameter(FLOATING_RATES_ID).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"floatingRatesId param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_DIFFERENTIAL, element)) {
                baseDataValidator.reset().parameter(INTEREST_RATE_DIFFERENTIAL).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"interestRateDifferential param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(MIN_DIFFERENTIAL_LENDING_RATE, element)) {
                baseDataValidator.reset().parameter(MIN_DIFFERENTIAL_LENDING_RATE).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"minDifferentialLendingRate param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(DEFAULT_DIFFERENTIAL_LENDING_RATE, element)) {
                baseDataValidator.reset().parameter(DEFAULT_DIFFERENTIAL_LENDING_RATE).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"defaultDifferentialLendingRate param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(MAX_DIFFERENTIAL_LENDING_RATE, element)) {
                baseDataValidator.reset().parameter(MAX_DIFFERENTIAL_LENDING_RATE).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"maxDifferentialLendingRate param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            if (this.fromApiJsonHelper.parameterExists(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED, element)) {
                baseDataValidator.reset().parameter(IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED).failWithCode("not.supported.when.isLinkedToFloatingInterestRates.is.false", new Object[]{"isFloatingInterestRateCalculationAllowed param is not supported when isLinkedToFloatingInterestRates is not supplied or false"});
            }
            String minInterestRatePerPeriodParameterName = MIN_INTEREST_RATE_PER_PERIOD;
            BigDecimal minInterestRatePerPeriod = loanProduct.getMinNominalInterestRatePerPeriod();
            if (this.fromApiJsonHelper.parameterExists(MIN_INTEREST_RATE_PER_PERIOD, element)) {
                minInterestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MIN_INTEREST_RATE_PER_PERIOD, element);
            }
            baseDataValidator.reset().parameter(MIN_INTEREST_RATE_PER_PERIOD).value((Object)minInterestRatePerPeriod).ignoreIfNull().zeroOrPositiveAmount();
            String maxInterestRatePerPeriodParameterName = MAX_INTEREST_RATE_PER_PERIOD;
            BigDecimal maxInterestRatePerPeriod = loanProduct.getMaxNominalInterestRatePerPeriod();
            if (this.fromApiJsonHelper.parameterExists(MAX_INTEREST_RATE_PER_PERIOD, element)) {
                maxInterestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MAX_INTEREST_RATE_PER_PERIOD, element);
            }
            baseDataValidator.reset().parameter(MAX_INTEREST_RATE_PER_PERIOD).value((Object)maxInterestRatePerPeriod).ignoreIfNull().zeroOrPositiveAmount();
            BigDecimal interestRatePerPeriod = loanProduct.getLoanProductRelatedDetail().getNominalInterestRatePerPeriod();
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_PER_PERIOD, element)) {
                interestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(INTEREST_RATE_PER_PERIOD, element);
            }
            baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).notNull().zeroOrPositiveAmount();
            Integer interestRateFrequencyType = loanProduct.getLoanProductRelatedDetail().getInterestPeriodFrequencyType().getValue();
            if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_FREQUENCY_TYPE, element)) {
                interestRateFrequencyType = this.fromApiJsonHelper.extractIntegerNamed(INTEREST_RATE_FREQUENCY_TYPE, element, Locale.getDefault());
            }
            baseDataValidator.reset().parameter(INTEREST_RATE_FREQUENCY_TYPE).value((Object)interestRateFrequencyType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(4));
            isInterestBearing = MathUtil.isGreaterThanZero((BigDecimal)interestRatePerPeriod);
        }
        this.fixedLengthValidations(transactionProcessingStrategyCode, isInterestBearing, numberOfRepayments, repaymentEvery, element, baseDataValidator);
        Boolean holdGuaranteeFunds = loanProduct.isHoldGuaranteeFunds();
        if (this.fromApiJsonHelper.parameterExists("holdGuaranteeFunds", element)) {
            holdGuaranteeFunds = this.fromApiJsonHelper.extractBooleanNamed("holdGuaranteeFunds", element);
            baseDataValidator.reset().parameter("holdGuaranteeFunds").value((Object)holdGuaranteeFunds).notNull().isOneOfTheseValues(new Object[]{true, false});
        }
        if (holdGuaranteeFunds != null && holdGuaranteeFunds.booleanValue()) {
            this.validateGuaranteeParams(element, baseDataValidator, null);
        }
        if (this.fromApiJsonHelper.parameterExists("principalThresholdForLastInstallment", element)) {
            BigDecimal principalThresholdForLastInstallment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principalThresholdForLastInstallment", element);
            baseDataValidator.reset().parameter("principalThresholdForLastInstallment").value((Object)principalThresholdForLastInstallment).notNull().notLessThanMin(BigDecimal.ZERO).notGreaterThanMax(BigDecimal.valueOf(100L));
        }
        BigDecimal fixedPrincipalPercentagePerInstallment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedPrincipalPercentagePerInstallment", element);
        baseDataValidator.reset().parameter("fixedPrincipalPercentagePerInstallment").value((Object)fixedPrincipalPercentagePerInstallment).notLessThanMin(BigDecimal.ONE).notGreaterThanMax(BigDecimal.valueOf(100L));
        if (!AmortizationMethod.EQUAL_PRINCIPAL.getValue().equals(amortizationType) && fixedPrincipalPercentagePerInstallment != null) {
            baseDataValidator.reset().parameter("fixedPrincipalPercentagePerInstallment").failWithCode("not.supported.principal.fixing.not.allowed.with.equal.installments", new Object[]{"Principal fixing cannot be done with equal installment amortization"});
        }
        if (this.fromApiJsonHelper.parameterExists("canDefineInstallmentAmount", element)) {
            Boolean canDefineInstallmentAmount = this.fromApiJsonHelper.extractBooleanNamed("canDefineInstallmentAmount", element);
            baseDataValidator.reset().parameter("canDefineInstallmentAmount").value((Object)canDefineInstallmentAmount).isOneOfTheseValues(new Object[]{true, false});
        }
        if (this.fromApiJsonHelper.parameterExists("installmentAmountInMultiplesOf", element)) {
            Integer installmentAmountInMultiplesOf = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("installmentAmountInMultiplesOf", element);
            baseDataValidator.reset().parameter("installmentAmountInMultiplesOf").value((Object)installmentAmountInMultiplesOf).ignoreIfNull().integerGreaterThanZero();
        }
        Integer accountingRuleType = this.fromApiJsonHelper.extractIntegerNamed(ACCOUNTING_RULE, element, Locale.getDefault());
        baseDataValidator.reset().parameter(ACCOUNTING_RULE).value((Object)accountingRuleType).ignoreIfNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
        boolean actualValue = loanProduct.getLoanProductRelatedDetail().isEnableAccrualActivityPosting();
        if (this.fromApiJsonHelper.parameterExists(ENABLE_ACCRUAL_ACTIVITY_POSTING, element)) {
            Boolean enableAccrualActivityPosting = this.fromApiJsonHelper.extractBooleanNamed(ENABLE_ACCRUAL_ACTIVITY_POSTING, element);
            baseDataValidator.reset().parameter(ENABLE_ACCRUAL_ACTIVITY_POSTING).value((Object)enableAccrualActivityPosting).ignoreIfNull().validateForBooleanValue();
            actualValue = enableAccrualActivityPosting;
        }
        if (actualValue) {
            Integer ruleType = accountingRuleType;
            if (ruleType == null && loanProduct.getAccountingRule() != null) {
                ruleType = loanProduct.getAccountingRule().getValue();
            }
            if (!AccountingValidations.isAccrualBasedAccounting((Integer)ruleType)) {
                baseDataValidator.reset().parameter(ENABLE_ACCRUAL_ACTIVITY_POSTING).failWithCode("should be false for non accrual accounting", new Object[0]);
            }
        }
        Long fundAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue()).value((Object)fundAccountId).ignoreIfNull().integerGreaterThanZero();
        Long loanPortfolioAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.LOAN_PORTFOLIO.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.LOAN_PORTFOLIO.getValue()).value((Object)loanPortfolioAccountId).ignoreIfNull().integerGreaterThanZero();
        Long transfersInSuspenseAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.TRANSFERS_SUSPENSE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.TRANSFERS_SUSPENSE.getValue()).value((Object)transfersInSuspenseAccountId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromInterestId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INTEREST_ON_LOANS.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INTEREST_ON_LOANS.getValue()).value((Object)incomeFromInterestId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromFeeId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_FEES.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_FEES.getValue()).value((Object)incomeFromFeeId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromPenaltyId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_PENALTIES.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_PENALTIES.getValue()).value((Object)incomeFromPenaltyId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromRecoveryAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_RECOVERY.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_RECOVERY.getValue()).value((Object)incomeFromRecoveryAccountId).ignoreIfNull().integerGreaterThanZero();
        Long writeOffAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.LOSSES_WRITTEN_OFF.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.LOSSES_WRITTEN_OFF.getValue()).value((Object)writeOffAccountId).ignoreIfNull().integerGreaterThanZero();
        Long goodwillCreditAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.LOSSES_WRITTEN_OFF.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.GOODWILL_CREDIT.getValue()).value((Object)goodwillCreditAccountId).ignoreIfNull().integerGreaterThanZero();
        Long overpaymentAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.OVERPAYMENT.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.OVERPAYMENT.getValue()).value((Object)overpaymentAccountId).ignoreIfNull().integerGreaterThanZero();
        Long receivableInterestAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INTEREST_RECEIVABLE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INTEREST_RECEIVABLE.getValue()).value((Object)receivableInterestAccountId).ignoreIfNull().integerGreaterThanZero();
        Long receivableFeeAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.FEES_RECEIVABLE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.FEES_RECEIVABLE.getValue()).value((Object)receivableFeeAccountId).ignoreIfNull().integerGreaterThanZero();
        Long receivablePenaltyAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.PENALTIES_RECEIVABLE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.PENALTIES_RECEIVABLE.getValue()).value((Object)receivablePenaltyAccountId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromChargeOffInterestAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_INTEREST.getValue()).value((Object)incomeFromChargeOffInterestAccountId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromChargeOffFeesAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_FEES.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_FEES.getValue()).value((Object)incomeFromChargeOffFeesAccountId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromChargeOffPenaltyAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_PENALTY.getValue()).value((Object)incomeFromChargeOffPenaltyAccountId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromGoodwillCreditInterestAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue()).value((Object)incomeFromGoodwillCreditInterestAccountId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromGoodwillCreditFeesAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue()).value((Object)incomeFromGoodwillCreditFeesAccountId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromGoodwillCreditPenaltyAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue()).value((Object)incomeFromGoodwillCreditPenaltyAccountId).ignoreIfNull().integerGreaterThanZero();
        Long chargeOffExpenseAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_EXPENSE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_EXPENSE.getValue()).value((Object)chargeOffExpenseAccountId).ignoreIfNull().integerGreaterThanZero();
        Long chargeOffFraudExpenseAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_FRAUD_EXPENSE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_FRAUD_EXPENSE.getValue()).value((Object)chargeOffFraudExpenseAccountId).ignoreIfNull().integerGreaterThanZero();
        this.validatePaymentChannelFundSourceMappings(baseDataValidator, element);
        this.validateChargeToIncomeAccountMappings(baseDataValidator, element);
        this.validateChargeOffToExpenseMappings(baseDataValidator, element);
        this.validateClassificationToIncomeMappings(baseDataValidator, element, AccountingConstants.LoanProductAccountingParams.BUYDOWN_FEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS);
        this.validateClassificationToIncomeMappings(baseDataValidator, element, AccountingConstants.LoanProductAccountingParams.CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS);
        this.validateMinMaxConstraints(element, baseDataValidator, loanProduct);
        if (this.fromApiJsonHelper.parameterExists("useBorrowerCycle", element)) {
            Boolean useBorrowerCycle = this.fromApiJsonHelper.extractBooleanNamed("useBorrowerCycle", element);
            baseDataValidator.reset().parameter("useBorrowerCycle").value((Object)useBorrowerCycle).ignoreIfNull().validateForBooleanValue();
            if (useBorrowerCycle.booleanValue()) {
                this.validateBorrowerCycleVariations(element, baseDataValidator);
            }
        }
        this.validateMultiDisburseLoanData(baseDataValidator, element, loanProduct);
        this.validateVariableInstallmentSettings(baseDataValidator, element);
        this.validatePartialPeriodSupport(interestCalculationPeriodType, baseDataValidator, element, loanProduct);
        if (this.fromApiJsonHelper.parameterExists("canUseForTopup", element)) {
            Boolean canUseForTopup = this.fromApiJsonHelper.extractBooleanNamed("canUseForTopup", element);
            baseDataValidator.reset().parameter("canUseForTopup").value((Object)canUseForTopup).validateForBooleanValue();
        }
        Integer dueDaysForRepaymentEvent = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("dueDaysForRepaymentEvent", element);
        baseDataValidator.reset().parameter("dueDaysForRepaymentEvent").value((Object)dueDaysForRepaymentEvent).integerZeroOrGreater();
        Integer overDueDaysForRepaymentEvent = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("overDueDaysForRepaymentEvent", element);
        baseDataValidator.reset().parameter("overDueDaysForRepaymentEvent").value((Object)overDueDaysForRepaymentEvent).integerZeroOrGreater();
        if (this.fromApiJsonHelper.parameterExists("enableDownPayment", element)) {
            Boolean enableDownPayment = this.fromApiJsonHelper.extractBooleanNamed("enableDownPayment", element);
            baseDataValidator.reset().parameter("enableDownPayment").value((Object)enableDownPayment).ignoreIfNull().validateForBooleanValue();
            this.validateDownPaymentPercentage(enableDownPayment, baseDataValidator, element);
            this.validateAutoRepaymentForDownPayment(enableDownPayment, baseDataValidator, element);
        }
        Integer repaymentStartDateType = loanProduct.getRepaymentStartDateType().getValue();
        if (this.fromApiJsonHelper.parameterExists("repaymentStartDateType", element)) {
            repaymentStartDateType = this.fromApiJsonHelper.extractIntegerNamed("repaymentStartDateType", element, Locale.getDefault());
        }
        baseDataValidator.reset().parameter("repaymentStartDateType").value((Object)repaymentStartDateType).notNull().isOneOfTheseValues(new Object[]{1, 2});
        if (this.fromApiJsonHelper.parameterExists("enableInstallmentLevelDelinquency", element)) {
            Boolean enableInstallmentLevelDelinquency = this.fromApiJsonHelper.extractBooleanNamed("enableInstallmentLevelDelinquency", element);
            baseDataValidator.reset().parameter("enableInstallmentLevelDelinquency").value((Object)enableInstallmentLevelDelinquency).ignoreIfNull().validateForBooleanValue();
            if (delinquencyBucketId == null && enableInstallmentLevelDelinquency.booleanValue()) {
                baseDataValidator.reset().parameter("enableInstallmentLevelDelinquency").failWithCode("can.be.enabled.for.loan.product.having.valid.delinquency.bucket", new Object[]{"Installment level delinquency cannot be enabled if Delinquency bucket is not configured for loan product"});
            }
        }
        if (this.fromApiJsonHelper.parameterExists("loanScheduleType", element)) {
            this.validateLoanScheduleType(transactionProcessingStrategyCode, baseDataValidator, element);
        }
        String loanScheduleProcessingType = loanProduct.getLoanProductRelatedDetail().getLoanScheduleProcessingType().name();
        if (this.fromApiJsonHelper.parameterExists("loanScheduleProcessingType", element)) {
            loanScheduleProcessingType = this.fromApiJsonHelper.extractStringNamed("loanScheduleProcessingType", element);
            baseDataValidator.reset().parameter("loanScheduleProcessingType").value((Object)loanScheduleProcessingType).isOneOfEnumValues(LoanScheduleProcessingType.class);
        }
        List allocationRules = loanProduct.getPaymentAllocationRules();
        if (this.fromApiJsonHelper.parameterExists(ADVANCED_PAYMENT_ALLOCATIONS, element) && LoanScheduleProcessingType.HORIZONTAL.name().equals(loanScheduleProcessingType)) {
            allocationRules = this.advancedPaymentAllocationsJsonParser.assembleLoanProductPaymentAllocationRules(command, transactionProcessingStrategyCode);
        }
        if (LoanScheduleProcessingType.HORIZONTAL.name().equals(loanScheduleProcessingType) && "advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode)) {
            this.advancedPaymentAllocationsValidator.checkGroupingOfAllocationRules(allocationRules);
        }
        if (LoanScheduleProcessingType.VERTICAL.equals((Object)LoanScheduleProcessingType.valueOf((String)loanScheduleProcessingType)) && !"advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode)) {
            baseDataValidator.reset().parameter("loanScheduleProcessingType").failWithCode("supported.only.for.progressive.loan.schedule.handling", new Object[]{"Vertical repayment schedule processing is only available with `Advanced payment allocation` strategy"});
        }
        Integer recurringMoratoriumOnPrincipalPeriods = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("recurringMoratoriumOnPrincipalPeriods", element);
        this.validateRepaymentPeriodWithGraceSettings(numberOfRepayments, graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, recurringMoratoriumOnPrincipalPeriods, baseDataValidator);
        this.validateIncomeCapitalization(transactionProcessingStrategyCode, element, baseDataValidator, accountingRuleType);
        this.validateBuyDownFee(transactionProcessingStrategyCode, element, baseDataValidator, accountingRuleType);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validatePaymentChannelFundSourceMappings(DataValidatorBuilder baseDataValidator, JsonElement element) {
        JsonArray paymentChannelMappingArray;
        if (this.fromApiJsonHelper.parameterExists(AccountingConstants.LoanProductAccountingParams.PAYMENT_CHANNEL_FUND_SOURCE_MAPPING.getValue(), element) && (paymentChannelMappingArray = this.fromApiJsonHelper.extractJsonArrayNamed(AccountingConstants.LoanProductAccountingParams.PAYMENT_CHANNEL_FUND_SOURCE_MAPPING.getValue(), element)) != null && paymentChannelMappingArray.size() > 0) {
            int i = 0;
            do {
                JsonObject jsonObject = paymentChannelMappingArray.get(i).getAsJsonObject();
                Long paymentTypeId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.PAYMENT_TYPE.getValue(), (JsonElement)jsonObject);
                Long paymentSpecificFundAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue(), (JsonElement)jsonObject);
                baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.PAYMENT_CHANNEL_FUND_SOURCE_MAPPING.getValue() + OPENING_SQUARE_BRACKET + i + "]." + AccountingConstants.LoanProductAccountingParams.PAYMENT_TYPE.getValue()).value((Object)paymentTypeId).notNull().integerGreaterThanZero();
                baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.PAYMENT_CHANNEL_FUND_SOURCE_MAPPING.getValue() + OPENING_SQUARE_BRACKET + i + "]." + AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue()).value((Object)paymentSpecificFundAccountId).notNull().integerGreaterThanZero();
            } while (++i < paymentChannelMappingArray.size());
        }
    }

    private void validateChargeToIncomeAccountMappings(DataValidatorBuilder baseDataValidator, JsonElement element) {
        this.validateChargeToIncomeAccountMappings(baseDataValidator, element, true);
        this.validateChargeToIncomeAccountMappings(baseDataValidator, element, true);
    }

    private void validateChargeToIncomeAccountMappings(DataValidatorBuilder baseDataValidator, JsonElement element, boolean isPenalty) {
        JsonArray chargeToIncomeAccountMappingArray;
        String parameterName = isPenalty ? AccountingConstants.LoanProductAccountingParams.PENALTY_INCOME_ACCOUNT_MAPPING.getValue() : AccountingConstants.LoanProductAccountingParams.FEE_INCOME_ACCOUNT_MAPPING.getValue();
        if (this.fromApiJsonHelper.parameterExists(parameterName, element) && (chargeToIncomeAccountMappingArray = this.fromApiJsonHelper.extractJsonArrayNamed(parameterName, element)) != null && chargeToIncomeAccountMappingArray.size() > 0) {
            int i = 0;
            do {
                JsonObject jsonObject = chargeToIncomeAccountMappingArray.get(i).getAsJsonObject();
                Long chargeId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.CHARGE_ID.getValue(), (JsonElement)jsonObject);
                Long incomeAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_ACCOUNT_ID.getValue(), (JsonElement)jsonObject);
                baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + "]." + AccountingConstants.LoanProductAccountingParams.CHARGE_ID.getValue()).value((Object)chargeId).notNull().integerGreaterThanZero();
                baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + "]." + AccountingConstants.LoanProductAccountingParams.INCOME_ACCOUNT_ID.getValue()).value((Object)incomeAccountId).notNull().integerGreaterThanZero();
            } while (++i < chargeToIncomeAccountMappingArray.size());
        }
    }

    private void validateChargeOffToExpenseMappings(DataValidatorBuilder baseDataValidator, JsonElement element) {
        String parameterName = AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS.getValue();
        AccountingConstants.LoanProductAccountingParams reasonCodeValueId = AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_REASON_CODE_VALUE_ID;
        String failCode = "chargeOffReason";
        this.validateAdditionalAccountMappings(baseDataValidator, element, parameterName, reasonCodeValueId, failCode, (arg_0, arg_1) -> ((ProductToGLAccountMappingHelper)this.productToGLAccountMappingHelper).validateChargeOffMappingsInDatabase(arg_0, arg_1));
    }

    private void validateWriteOffToExpenseMappings(DataValidatorBuilder baseDataValidator, JsonElement element) {
        String parameterName = AccountingConstants.LoanProductAccountingParams.WRITE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS.getValue();
        AccountingConstants.LoanProductAccountingParams reasonCodeValueId = AccountingConstants.LoanProductAccountingParams.WRITE_OFF_REASON_CODE_VALUE_ID;
        String failCode = "writeOffReason";
        this.validateAdditionalAccountMappings(baseDataValidator, element, parameterName, reasonCodeValueId, failCode, (arg_0, arg_1) -> ((ProductToGLAccountMappingHelper)this.productToGLAccountMappingHelper).validateWriteOffMappingsInDatabase(arg_0, arg_1));
    }

    private void validateAdditionalAccountMappings(DataValidatorBuilder baseDataValidator, JsonElement element, String parameterName, AccountingConstants.LoanProductAccountingParams reasonCodeValueIdParam, String failCode, BiConsumer<List<ApiParameterError>, List<JsonObject>> additionalMappingValidator) {
        JsonArray reasonToExpenseMappingArray;
        if (this.fromApiJsonHelper.parameterExists(parameterName, element) && (reasonToExpenseMappingArray = this.fromApiJsonHelper.extractJsonArrayNamed(parameterName, element)) != null && !reasonToExpenseMappingArray.isEmpty()) {
            HashMap reasonToAccounts = new HashMap();
            ArrayList<JsonObject> processedMappings = new ArrayList<JsonObject>();
            int i = 0;
            do {
                JsonObject jsonObject = reasonToExpenseMappingArray.get(i).getAsJsonObject();
                String expenseGlAccountIdString = this.fromApiJsonHelper.extractStringNamed(AccountingConstants.LoanProductAccountingParams.EXPENSE_GL_ACCOUNT_ID.getValue(), (JsonElement)jsonObject);
                String reasonCodeValueIdString = this.fromApiJsonHelper.extractStringNamed(reasonCodeValueIdParam.getValue(), (JsonElement)jsonObject);
                baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + "]." + AccountingConstants.LoanProductAccountingParams.EXPENSE_GL_ACCOUNT_ID.getValue()).value((Object)expenseGlAccountIdString).notNull().longGreaterThanZero();
                baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + "]." + reasonCodeValueIdParam.getValue()).value((Object)reasonCodeValueIdString).notNull().longGreaterThanZero();
                Long reasonCodeValueId = Long.valueOf(reasonCodeValueIdString);
                Long expenseGlAccountId = Long.valueOf(expenseGlAccountIdString);
                reasonToAccounts.putIfAbsent(reasonCodeValueId, new HashSet());
                Set associatedAccounts = (Set)reasonToAccounts.get(reasonCodeValueId);
                if (associatedAccounts.contains(expenseGlAccountId)) {
                    baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + CLOSING_SQUARE_BRACKET).failWithCode("duplicate." + failCode + ".and.glAccount", new Object[0]);
                }
                associatedAccounts.add(expenseGlAccountId);
                if (associatedAccounts.size() > 1) {
                    baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + CLOSING_SQUARE_BRACKET).failWithCode("multiple.glAccounts.for." + failCode, new Object[0]);
                }
                processedMappings.add(jsonObject);
            } while (++i < reasonToExpenseMappingArray.size());
            ArrayList validationErrors = new ArrayList();
            this.productToGLAccountMappingHelper.validateGLAccountInDatabase(validationErrors, processedMappings);
            if (additionalMappingValidator != null) {
                additionalMappingValidator.accept(validationErrors, processedMappings);
            }
            if (!validationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(validationErrors);
            }
        }
    }

    private void validateClassificationToIncomeMappings(DataValidatorBuilder baseDataValidator, JsonElement element, AccountingConstants.LoanProductAccountingParams classificationParameter) {
        JsonArray classificationToIncomeMappingArray;
        String parameterName = classificationParameter.getValue();
        if (this.fromApiJsonHelper.parameterExists(parameterName, element) && (classificationToIncomeMappingArray = this.fromApiJsonHelper.extractJsonArrayNamed(parameterName, element)) != null && classificationToIncomeMappingArray.size() > 0) {
            HashMap classificationToAccounts = new HashMap();
            ArrayList<JsonObject> processedMappings = new ArrayList<JsonObject>();
            int i = 0;
            do {
                JsonObject jsonObject = classificationToIncomeMappingArray.get(i).getAsJsonObject();
                Long incomeGlAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_ACCOUNT_ID.getValue(), (JsonElement)jsonObject);
                Long classificationCodeValueId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.CLASSIFICATION_CODE_VALUE_ID.getValue(), (JsonElement)jsonObject);
                baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + "]." + AccountingConstants.LoanProductAccountingParams.INCOME_ACCOUNT_ID.getValue()).value((Object)incomeGlAccountId).notNull().integerGreaterThanZero();
                baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + "]." + AccountingConstants.LoanProductAccountingParams.CLASSIFICATION_CODE_VALUE_ID.getValue()).value((Object)classificationCodeValueId).notNull().integerGreaterThanZero();
                classificationToAccounts.putIfAbsent(classificationCodeValueId, new HashSet());
                Set associatedAccounts = (Set)classificationToAccounts.get(classificationCodeValueId);
                if (associatedAccounts.contains(incomeGlAccountId)) {
                    baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + CLOSING_SQUARE_BRACKET).failWithCode("duplicate.classification.and.glAccount", new Object[0]);
                }
                associatedAccounts.add(incomeGlAccountId);
                if (associatedAccounts.size() > 1) {
                    baseDataValidator.reset().parameter(parameterName + OPENING_SQUARE_BRACKET + i + CLOSING_SQUARE_BRACKET).failWithCode("multiple.glAccounts.for.classification", new Object[0]);
                }
                processedMappings.add(jsonObject);
            } while (++i < classificationToIncomeMappingArray.size());
            String dataCodeName = classificationParameter.equals((Object)AccountingConstants.LoanProductAccountingParams.CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS) ? "capitalized_income_transaction_classification" : "buydown_fee_transaction_classification";
            this.productToGLAccountMappingHelper.validateClassificationMappingsInDatabase(processedMappings, dataCodeName);
        }
    }

    public void validateMinMaxConstraints(JsonElement element, DataValidatorBuilder baseDataValidator, LoanProduct loanProduct) {
        this.validatePrincipalMinMaxConstraint(element, loanProduct, baseDataValidator);
        this.validateNumberOfRepaymentsMinMaxConstraint(element, loanProduct, baseDataValidator);
        this.validateNominalInterestRatePerPeriodMinMaxConstraint(element, loanProduct, baseDataValidator);
    }

    public void validateMinMaxConstraints(JsonElement element, DataValidatorBuilder baseDataValidator, LoanProduct loanProduct, Integer cycleNumber) {
        Map minmaxValues = loanProduct.fetchBorrowerCycleVariationsForCycleNumber(cycleNumber);
        String principalParameterName = PRINCIPAL;
        BigDecimal principalAmount = null;
        BigDecimal minPrincipalAmount = null;
        BigDecimal maxPrincipalAmount = null;
        if (this.fromApiJsonHelper.parameterExists(PRINCIPAL, element)) {
            principalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(PRINCIPAL, element);
            minPrincipalAmount = (BigDecimal)minmaxValues.get(MIN_PRINCIPAL);
            maxPrincipalAmount = (BigDecimal)minmaxValues.get("maxPrincipalValue");
        }
        if (minPrincipalAmount != null && minPrincipalAmount.compareTo(BigDecimal.ZERO) > 0 && maxPrincipalAmount != null && maxPrincipalAmount.compareTo(BigDecimal.ZERO) > 0) {
            baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principalAmount).inMinAndMaxAmountRange(minPrincipalAmount, maxPrincipalAmount);
        } else if (minPrincipalAmount != null && minPrincipalAmount.compareTo(BigDecimal.ZERO) > 0) {
            baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principalAmount).notLessThanMin(minPrincipalAmount);
        } else if (maxPrincipalAmount != null && maxPrincipalAmount.compareTo(BigDecimal.ZERO) > 0) {
            baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principalAmount).notGreaterThanMax(maxPrincipalAmount);
        }
        String numberOfRepaymentsParameterName = NUMBER_OF_REPAYMENTS;
        Integer maxNumberOfRepayments = null;
        Integer minNumberOfRepayments = null;
        Integer numberOfRepayments = null;
        if (this.fromApiJsonHelper.parameterExists(NUMBER_OF_REPAYMENTS, element)) {
            numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(NUMBER_OF_REPAYMENTS, element);
            if (minmaxValues.get(MIN_NUMBER_OF_REPAYMENTS) != null) {
                minNumberOfRepayments = ((BigDecimal)minmaxValues.get(MIN_NUMBER_OF_REPAYMENTS)).intValueExact();
            }
            if (minmaxValues.get(MAX_NUMBER_OF_REPAYMENTS) != null) {
                maxNumberOfRepayments = ((BigDecimal)minmaxValues.get(MAX_NUMBER_OF_REPAYMENTS)).intValueExact();
            }
        }
        if (maxNumberOfRepayments != null && maxNumberOfRepayments.compareTo(0) > 0) {
            if (minNumberOfRepayments != null && minNumberOfRepayments.compareTo(0) > 0) {
                baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).inMinMaxRange(minNumberOfRepayments, maxNumberOfRepayments);
            } else {
                baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).notGreaterThanMax(maxNumberOfRepayments);
            }
        } else if (minNumberOfRepayments != null && minNumberOfRepayments.compareTo(0) > 0) {
            baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).notLessThanMin(minNumberOfRepayments);
        }
        String interestRatePerPeriodParameterName = INTEREST_RATE_PER_PERIOD;
        BigDecimal interestRatePerPeriod = null;
        BigDecimal minInterestRatePerPeriod = null;
        BigDecimal maxInterestRatePerPeriod = null;
        if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_PER_PERIOD, element)) {
            interestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(INTEREST_RATE_PER_PERIOD, element);
            minInterestRatePerPeriod = (BigDecimal)minmaxValues.get(MIN_INTEREST_RATE_PER_PERIOD);
            maxInterestRatePerPeriod = (BigDecimal)minmaxValues.get(MAX_INTEREST_RATE_PER_PERIOD);
        }
        if (maxInterestRatePerPeriod != null) {
            if (minInterestRatePerPeriod != null) {
                baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).inMinAndMaxAmountRange(minInterestRatePerPeriod, maxInterestRatePerPeriod);
            } else {
                baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).notGreaterThanMax(maxInterestRatePerPeriod);
            }
        } else if (minInterestRatePerPeriod != null) {
            baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).notLessThanMin(minInterestRatePerPeriod);
        }
    }

    private void validatePrincipalMinMaxConstraint(JsonElement element, LoanProduct loanProduct, DataValidatorBuilder baseDataValidator) {
        BigDecimal maxPrincipalAmount;
        BigDecimal minPrincipalAmount;
        BigDecimal principalAmount;
        boolean principalUpdated = false;
        boolean minPrincipalUpdated = false;
        boolean maxPrincipalUpdated = false;
        String principalParameterName = PRINCIPAL;
        if (this.fromApiJsonHelper.parameterExists(PRINCIPAL, element)) {
            principalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(PRINCIPAL, element);
            principalUpdated = true;
        } else {
            principalAmount = loanProduct.getPrincipalAmount().getAmount();
        }
        String minPrincipalParameterName = MIN_PRINCIPAL;
        if (this.fromApiJsonHelper.parameterExists(MIN_PRINCIPAL, element)) {
            minPrincipalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MIN_PRINCIPAL, element);
            minPrincipalUpdated = true;
        } else {
            minPrincipalAmount = loanProduct.getMinPrincipalAmount().getAmount();
        }
        String maxPrincipalParameterName = MAX_PRINCIPAL;
        if (this.fromApiJsonHelper.parameterExists(MAX_PRINCIPAL, element)) {
            maxPrincipalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MAX_PRINCIPAL, element);
            maxPrincipalUpdated = true;
        } else {
            maxPrincipalAmount = loanProduct.getMaxPrincipalAmount().getAmount();
        }
        if (minPrincipalUpdated) {
            baseDataValidator.reset().parameter(MIN_PRINCIPAL).value((Object)minPrincipalAmount).notGreaterThanMax(maxPrincipalAmount);
        }
        if (maxPrincipalUpdated) {
            baseDataValidator.reset().parameter(MAX_PRINCIPAL).value((Object)maxPrincipalAmount).notLessThanMin(minPrincipalAmount);
        }
        if (principalUpdated || minPrincipalUpdated || maxPrincipalUpdated) {
            if (minPrincipalAmount != null && minPrincipalAmount.compareTo(BigDecimal.ZERO) > 0 && maxPrincipalAmount != null && maxPrincipalAmount.compareTo(BigDecimal.ZERO) > 0) {
                baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principalAmount).inMinAndMaxAmountRange(minPrincipalAmount, maxPrincipalAmount);
            } else if (minPrincipalAmount != null && minPrincipalAmount.compareTo(BigDecimal.ZERO) > 0) {
                baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principalAmount).notLessThanMin(minPrincipalAmount);
            } else if (maxPrincipalAmount != null && maxPrincipalAmount.compareTo(BigDecimal.ZERO) > 0) {
                baseDataValidator.reset().parameter(PRINCIPAL).value((Object)principalAmount).notGreaterThanMax(maxPrincipalAmount);
            }
        }
    }

    private void validateNumberOfRepaymentsMinMaxConstraint(JsonElement element, LoanProduct loanProduct, DataValidatorBuilder baseDataValidator) {
        Integer maxNumberOfRepayments;
        Integer numberOfRepayments;
        boolean numberOfRepaymentsUpdated = false;
        boolean minNumberOfRepaymentsUpdated = false;
        boolean maxNumberOfRepaymentsUpdated = false;
        String numberOfRepaymentsParameterName = NUMBER_OF_REPAYMENTS;
        if (this.fromApiJsonHelper.parameterExists(NUMBER_OF_REPAYMENTS, element)) {
            numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(NUMBER_OF_REPAYMENTS, element);
            numberOfRepaymentsUpdated = true;
        } else {
            numberOfRepayments = loanProduct.getNumberOfRepayments();
        }
        String minNumberOfRepaymentsParameterName = MIN_NUMBER_OF_REPAYMENTS;
        Integer minNumberOfRepayments = null;
        if (this.fromApiJsonHelper.parameterExists(MIN_NUMBER_OF_REPAYMENTS, element)) {
            minNumberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(MIN_NUMBER_OF_REPAYMENTS, element);
            minNumberOfRepaymentsUpdated = true;
        } else {
            minNumberOfRepayments = loanProduct.getMinNumberOfRepayments();
        }
        String maxNumberOfRepaymentsParameterName = MAX_NUMBER_OF_REPAYMENTS;
        if (this.fromApiJsonHelper.parameterExists(MAX_NUMBER_OF_REPAYMENTS, element)) {
            maxNumberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed(MAX_NUMBER_OF_REPAYMENTS, element);
            maxNumberOfRepaymentsUpdated = true;
        } else {
            maxNumberOfRepayments = loanProduct.getMaxNumberOfRepayments();
        }
        if (minNumberOfRepaymentsUpdated) {
            baseDataValidator.reset().parameter(MIN_NUMBER_OF_REPAYMENTS).value((Object)minNumberOfRepayments).ignoreIfNull().notGreaterThanMax(maxNumberOfRepayments);
        }
        if (maxNumberOfRepaymentsUpdated) {
            baseDataValidator.reset().parameter(MAX_NUMBER_OF_REPAYMENTS).value((Object)maxNumberOfRepayments).notLessThanMin(minNumberOfRepayments);
        }
        if (numberOfRepaymentsUpdated || minNumberOfRepaymentsUpdated || maxNumberOfRepaymentsUpdated) {
            if (maxNumberOfRepayments != null && maxNumberOfRepayments.compareTo(0) > 0) {
                if (minNumberOfRepayments != null && minNumberOfRepayments.compareTo(0) > 0) {
                    baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).inMinMaxRange(minNumberOfRepayments, maxNumberOfRepayments);
                } else {
                    baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).notGreaterThanMax(maxNumberOfRepayments);
                }
            } else if (minNumberOfRepayments != null && minNumberOfRepayments.compareTo(0) > 0) {
                baseDataValidator.reset().parameter(NUMBER_OF_REPAYMENTS).value((Object)numberOfRepayments).notLessThanMin(minNumberOfRepayments);
            }
        }
    }

    private void validateNominalInterestRatePerPeriodMinMaxConstraint(JsonElement element, LoanProduct loanProduct, DataValidatorBuilder baseDataValidator) {
        BigDecimal maxInterestRatePerPeriod;
        BigDecimal interestRatePerPeriod;
        if (this.fromApiJsonHelper.parameterExists(IS_LINKED_TO_FLOATING_INTEREST_RATES, element) && this.fromApiJsonHelper.extractBooleanNamed(IS_LINKED_TO_FLOATING_INTEREST_RATES, element).booleanValue() || loanProduct.isLinkedToFloatingInterestRate()) {
            return;
        }
        boolean iRPUpdated = false;
        boolean minIRPUpdated = false;
        boolean maxIRPUpdated = false;
        String interestRatePerPeriodParameterName = INTEREST_RATE_PER_PERIOD;
        if (this.fromApiJsonHelper.parameterExists(INTEREST_RATE_PER_PERIOD, element)) {
            interestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(INTEREST_RATE_PER_PERIOD, element);
            iRPUpdated = true;
        } else {
            interestRatePerPeriod = loanProduct.getNominalInterestRatePerPeriod();
        }
        String minInterestRatePerPeriodParameterName = MIN_INTEREST_RATE_PER_PERIOD;
        BigDecimal minInterestRatePerPeriod = null;
        if (this.fromApiJsonHelper.parameterExists(MIN_INTEREST_RATE_PER_PERIOD, element)) {
            minInterestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MIN_INTEREST_RATE_PER_PERIOD, element);
            minIRPUpdated = true;
        } else {
            minInterestRatePerPeriod = loanProduct.getMinNominalInterestRatePerPeriod();
        }
        String maxInterestRatePerPeriodParameterName = MAX_INTEREST_RATE_PER_PERIOD;
        if (this.fromApiJsonHelper.parameterExists(MAX_INTEREST_RATE_PER_PERIOD, element)) {
            maxInterestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(MAX_INTEREST_RATE_PER_PERIOD, element);
            maxIRPUpdated = true;
        } else {
            maxInterestRatePerPeriod = loanProduct.getMaxNominalInterestRatePerPeriod();
        }
        if (minIRPUpdated) {
            baseDataValidator.reset().parameter(MIN_INTEREST_RATE_PER_PERIOD).value((Object)minInterestRatePerPeriod).ignoreIfNull().notGreaterThanMax(maxInterestRatePerPeriod);
        }
        if (maxIRPUpdated) {
            baseDataValidator.reset().parameter(MAX_INTEREST_RATE_PER_PERIOD).value((Object)maxInterestRatePerPeriod).ignoreIfNull().notLessThanMin(minInterestRatePerPeriod);
        }
        if (iRPUpdated || minIRPUpdated || maxIRPUpdated) {
            if (maxInterestRatePerPeriod != null) {
                if (minInterestRatePerPeriod != null) {
                    baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).inMinAndMaxAmountRange(minInterestRatePerPeriod, maxInterestRatePerPeriod);
                } else {
                    baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).notGreaterThanMax(maxInterestRatePerPeriod);
                }
            } else if (minInterestRatePerPeriod != null) {
                baseDataValidator.reset().parameter(INTEREST_RATE_PER_PERIOD).value((Object)interestRatePerPeriod).notLessThanMin(minInterestRatePerPeriod);
            }
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    private void validateBorrowerCycleVariations(JsonElement element, DataValidatorBuilder baseDataValidator) {
        this.validateBorrowerCyclePrincipalVariations(element, baseDataValidator);
        this.validateBorrowerCycleRepaymentVariations(element, baseDataValidator);
        this.validateBorrowerCycleInterestVariations(element, baseDataValidator);
    }

    private void validateBorrowerCyclePrincipalVariations(JsonElement element, DataValidatorBuilder baseDataValidator) {
        this.validateBorrowerCycleVariations(element, baseDataValidator, "principalVariationsForBorrowerCycle", "principalPerCycle", "minPrincipalPerCycle", "minPrincipalPerCycle", "principalValueUsageCondition", "principalCycleNumbers");
    }

    private void validateBorrowerCycleRepaymentVariations(JsonElement element, DataValidatorBuilder baseDataValidator) {
        this.validateBorrowerCycleVariations(element, baseDataValidator, "numberOfRepaymentVariationsForBorrowerCycle", "numberOfRepaymentsPerCycle", "minNumberOfRepaymentsPerCycle", "maxNumberOfRepaymentsPerCycle", "repaymentValueUsageCondition", "repaymentCycleNumber");
    }

    private void validateBorrowerCycleInterestVariations(JsonElement element, DataValidatorBuilder baseDataValidator) {
        this.validateBorrowerCycleVariations(element, baseDataValidator, "interestRateVariationsForBorrowerCycle", "interestRatePerPeriodPerCycle", "minInterestRatePerPeriodPerCycle", "maxInterestRatePerPeriodPerCycle", "interestRateValueUsageCondition", "interestRateValueUsageCondition");
    }

    private void validateBorrowerCycleVariations(JsonElement element, DataValidatorBuilder baseDataValidator, String variationParameterName, String defaultParameterName, String minParameterName, String maxParameterName, String valueUsageConditionParamName, String cycleNumbersParamName) {
        JsonArray variationArray;
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        int lastCycleNumber = 0;
        LoanProductValueConditionType lastConditionType = LoanProductValueConditionType.EQUAL;
        if (this.fromApiJsonHelper.parameterExists(variationParameterName, element) && (variationArray = this.fromApiJsonHelper.extractJsonArrayNamed(variationParameterName, element)) != null && variationArray.size() > 0) {
            int i = 0;
            do {
                JsonObject jsonObject = variationArray.get(i).getAsJsonObject();
                BigDecimal defaultValue = this.fromApiJsonHelper.extractBigDecimalNamed("defaultValue", (JsonElement)jsonObject, locale);
                BigDecimal minValue = this.fromApiJsonHelper.extractBigDecimalNamed("minValue", (JsonElement)jsonObject, locale);
                BigDecimal maxValue = this.fromApiJsonHelper.extractBigDecimalNamed("maxValue", (JsonElement)jsonObject, locale);
                Integer cycleNumber = this.fromApiJsonHelper.extractIntegerNamed("borrowerCycleNumber", (JsonElement)jsonObject, locale);
                Integer valueUsageCondition = this.fromApiJsonHelper.extractIntegerNamed("valueConditionType", (JsonElement)jsonObject, locale);
                baseDataValidator.reset().parameter(defaultParameterName).value((Object)defaultValue).notBlank();
                if (minValue != null) {
                    baseDataValidator.reset().parameter(minParameterName).value((Object)minValue).notGreaterThanMax(maxValue);
                }
                if (maxValue != null) {
                    baseDataValidator.reset().parameter(maxParameterName).value((Object)maxValue).notLessThanMin(minValue);
                }
                if (minValue != null && minValue.compareTo(BigDecimal.ZERO) > 0 && maxValue != null && maxValue.compareTo(BigDecimal.ZERO) > 0) {
                    baseDataValidator.reset().parameter(defaultParameterName).value((Object)defaultValue).inMinAndMaxAmountRange(minValue, maxValue);
                } else if (minValue != null && minValue.compareTo(BigDecimal.ZERO) > 0) {
                    baseDataValidator.reset().parameter(defaultParameterName).value((Object)defaultValue).notLessThanMin(minValue);
                } else if (maxValue != null && maxValue.compareTo(BigDecimal.ZERO) > 0) {
                    baseDataValidator.reset().parameter(defaultParameterName).value((Object)defaultValue).notGreaterThanMax(maxValue);
                }
                LoanProductValueConditionType conditionType = LoanProductValueConditionType.INVALID;
                if (valueUsageCondition != null) {
                    conditionType = LoanProductValueConditionType.fromInt((Integer)valueUsageCondition);
                }
                baseDataValidator.reset().parameter(valueUsageConditionParamName).value((Object)valueUsageCondition).notNull().inMinMaxRange(LoanProductValueConditionType.EQUAL.getValue(), LoanProductValueConditionType.GREATERTHAN.getValue());
                if (lastConditionType.equals((Object)LoanProductValueConditionType.EQUAL) && conditionType.equals((Object)LoanProductValueConditionType.GREATERTHAN)) {
                    if (lastCycleNumber == 0) {
                        baseDataValidator.reset().parameter(cycleNumbersParamName).failWithCode("condition.type.must.start.with.equal", new Object[0]);
                        lastCycleNumber = 1;
                    }
                    baseDataValidator.reset().parameter(cycleNumbersParamName).value((Object)cycleNumber).notNull().integerSameAsNumber(Integer.valueOf(lastCycleNumber));
                } else if (lastConditionType.equals((Object)LoanProductValueConditionType.EQUAL)) {
                    baseDataValidator.reset().parameter(cycleNumbersParamName).value((Object)cycleNumber).notNull().integerSameAsNumber(Integer.valueOf(lastCycleNumber + 1));
                } else if (lastConditionType.equals((Object)LoanProductValueConditionType.GREATERTHAN)) {
                    baseDataValidator.reset().parameter(cycleNumbersParamName).value((Object)cycleNumber).notNull().integerGreaterThanNumber(Integer.valueOf(lastCycleNumber));
                }
                if (conditionType != null) {
                    lastConditionType = conditionType;
                }
                if (cycleNumber == null) continue;
                lastCycleNumber = cycleNumber;
            } while (++i < variationArray.size());
            if (!lastConditionType.equals((Object)LoanProductValueConditionType.GREATERTHAN)) {
                baseDataValidator.reset().parameter(cycleNumbersParamName).failWithCode("condition.type.must.end.with.greater.than", new Object[0]);
            }
        }
    }

    private void validateGuaranteeParams(JsonElement element, DataValidatorBuilder baseDataValidator, LoanProduct loanProduct) {
        BigDecimal mandatoryGuarantee = BigDecimal.ZERO;
        BigDecimal minimumGuaranteeFromOwnFunds = BigDecimal.ZERO;
        BigDecimal minimumGuaranteeFromGuarantor = BigDecimal.ZERO;
        if (loanProduct != null) {
            mandatoryGuarantee = loanProduct.getLoanProductGuaranteeDetails().getMandatoryGuarantee();
            minimumGuaranteeFromOwnFunds = loanProduct.getLoanProductGuaranteeDetails().getMinimumGuaranteeFromOwnFunds();
            minimumGuaranteeFromGuarantor = loanProduct.getLoanProductGuaranteeDetails().getMinimumGuaranteeFromGuarantor();
        }
        if (loanProduct == null || this.fromApiJsonHelper.parameterExists("mandatoryGuarantee", element)) {
            mandatoryGuarantee = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("mandatoryGuarantee", element);
            baseDataValidator.reset().parameter("mandatoryGuarantee").value((Object)mandatoryGuarantee).notNull();
            if (mandatoryGuarantee == null) {
                mandatoryGuarantee = BigDecimal.ZERO;
            }
        }
        if ((loanProduct == null || this.fromApiJsonHelper.parameterExists("minimumGuaranteeFromGuarantor", element)) && (minimumGuaranteeFromGuarantor = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minimumGuaranteeFromGuarantor", element)) == null) {
            minimumGuaranteeFromGuarantor = BigDecimal.ZERO;
        }
        if ((loanProduct == null || this.fromApiJsonHelper.parameterExists("minimumGuaranteeFromOwnFunds", element)) && (minimumGuaranteeFromOwnFunds = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minimumGuaranteeFromOwnFunds", element)) == null) {
            minimumGuaranteeFromOwnFunds = BigDecimal.ZERO;
        }
        if (mandatoryGuarantee.compareTo(minimumGuaranteeFromOwnFunds.add(minimumGuaranteeFromGuarantor)) < 0) {
            baseDataValidator.parameter("mandatoryGuarantee").failWithCode("must.be.greater.than.sum.of.min.funds", new Object[0]);
        }
    }

    private void validatePartialPeriodSupport(Integer interestCalculationPeriodType, DataValidatorBuilder baseDataValidator, JsonElement element, LoanProduct loanProduct) {
        if (interestCalculationPeriodType != null) {
            InterestCalculationPeriodMethod interestCalculationPeriodMethod = InterestCalculationPeriodMethod.fromInt((Integer)interestCalculationPeriodType);
            boolean considerPartialPeriodUpdates = interestCalculationPeriodMethod.isDaily();
            if (this.fromApiJsonHelper.parameterExists("allowPartialPeriodInterestCalcualtion", element)) {
                boolean considerPartialPeriods;
                Boolean considerPartialInterestEnabled = this.fromApiJsonHelper.extractBooleanNamed("allowPartialPeriodInterestCalcualtion", element);
                baseDataValidator.reset().parameter("allowPartialPeriodInterestCalcualtion").value((Object)considerPartialInterestEnabled).notNull().isOneOfTheseValues(new Object[]{true, false});
                boolean bl = considerPartialPeriods = considerPartialInterestEnabled != null && considerPartialInterestEnabled != false;
                if (interestCalculationPeriodMethod.isDaily()) {
                    if (considerPartialPeriods) {
                        baseDataValidator.reset().parameter("allowPartialPeriodInterestCalcualtion").failWithCode("not.supported.for.daily.calculations", new Object[0]);
                    }
                } else {
                    considerPartialPeriodUpdates = considerPartialPeriods;
                }
            } else if (loanProduct != null && !interestCalculationPeriodMethod.isDaily()) {
                considerPartialPeriodUpdates = loanProduct.getLoanProductRelatedDetail().isAllowPartialPeriodInterestCalculation();
            }
            if (!considerPartialPeriodUpdates) {
                Boolean isInterestRecalculationEnabled = null;
                if (this.fromApiJsonHelper.parameterExists("isInterestRecalculationEnabled", element)) {
                    isInterestRecalculationEnabled = this.fromApiJsonHelper.extractBooleanNamed("isInterestRecalculationEnabled", element);
                } else if (loanProduct != null) {
                    isInterestRecalculationEnabled = loanProduct.isInterestRecalculationEnabled();
                }
                if (isInterestRecalculationEnabled != null && isInterestRecalculationEnabled.booleanValue()) {
                    baseDataValidator.reset().parameter("isInterestRecalculationEnabled").failWithCode("not.supported.for.selected.interest.calculation.type", new Object[0]);
                }
                Boolean multiDisburseLoan = null;
                if (this.fromApiJsonHelper.parameterExists("multiDisburseLoan", element)) {
                    multiDisburseLoan = this.fromApiJsonHelper.extractBooleanNamed("multiDisburseLoan", element);
                } else if (loanProduct != null) {
                    multiDisburseLoan = loanProduct.isMultiDisburseLoan();
                }
                if (multiDisburseLoan != null && multiDisburseLoan.booleanValue() && !this.isProgressive(element, loanProduct)) {
                    baseDataValidator.reset().parameter("multiDisburseLoan").failWithCode("not.supported.for.selected.interest.calculation.type", new Object[0]);
                }
                Boolean variableInstallments = null;
                if (this.fromApiJsonHelper.parameterExists("allowVariableInstallments", element)) {
                    variableInstallments = this.fromApiJsonHelper.extractBooleanNamed("allowVariableInstallments", element);
                } else if (loanProduct != null) {
                    variableInstallments = loanProduct.isAllowVariabeInstallments();
                }
                if (variableInstallments != null && variableInstallments.booleanValue()) {
                    baseDataValidator.reset().parameter("allowVariableInstallments").failWithCode("not.supported.for.selected.interest.calculation.type", new Object[0]);
                }
                Boolean floatingInterestRates = null;
                if (this.fromApiJsonHelper.parameterExists(IS_LINKED_TO_FLOATING_INTEREST_RATES, element)) {
                    floatingInterestRates = this.fromApiJsonHelper.extractBooleanNamed(IS_LINKED_TO_FLOATING_INTEREST_RATES, element);
                } else if (loanProduct != null) {
                    floatingInterestRates = loanProduct.isLinkedToFloatingInterestRate();
                }
                if (floatingInterestRates != null && floatingInterestRates.booleanValue()) {
                    baseDataValidator.reset().parameter(IS_LINKED_TO_FLOATING_INTEREST_RATES).failWithCode("not.supported.for.selected.interest.calculation.type", new Object[0]);
                }
            }
        }
    }

    public void fixedLengthValidations(String transactionProcessingStrategyCode, boolean thereIsInterest, Integer numberOfRepayments, Integer repayEvery, JsonElement element, DataValidatorBuilder baseDataValidator) {
        if (this.fromApiJsonHelper.parameterExists("fixedLength", element)) {
            JsonObject topLevelJsonElement = element.getAsJsonObject();
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
            Integer fixedLength = this.fromApiJsonHelper.extractIntegerNamed("fixedLength", element, locale);
            baseDataValidator.reset().parameter("fixedLength").value((Object)fixedLength).ignoreIfNull().integerGreaterThanZero();
            if (fixedLength != null) {
                if (!"advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode)) {
                    String errorMsg = "Fixed Length configuration is only allowed with advanced-payment-allocation-strategy strategy";
                    throw new GeneralPlatformDomainRuleException("error.msg.fixed.length.only.supported.for.advanced.payment.allocation", "Fixed Length configuration is only allowed with advanced-payment-allocation-strategy strategy", new Object[]{"advanced-payment-allocation-strategy"});
                }
                if (thereIsInterest) {
                    String errorMsg = "Fixed Length configuration is only allowed for zero interest products";
                    throw new GeneralPlatformDomainRuleException("error.msg.fixed.length.only.supported.for.zero.interest", "Fixed Length configuration is only allowed for zero interest products", new Object[0]);
                }
                Integer valueToCompare = (numberOfRepayments - 1) * repayEvery + 1;
                if (fixedLength.compareTo(valueToCompare) < 0) {
                    String errorMsg = "Wrong configuration between Number Of Repayments: " + numberOfRepayments + " * " + repayEvery + " and Fixed Length: " + fixedLength + " values";
                    throw new GeneralPlatformDomainRuleException("error.msg.number.repayments.and.fixed.length.configuration.not.valid", errorMsg, new Object[]{numberOfRepayments, repayEvery, valueToCompare, fixedLength});
                }
            }
        }
    }

    private void validateLoanScheduleType(String transactionProcessingStrategyCode, DataValidatorBuilder baseDataValidator, JsonElement element) {
        String loanScheduleType = this.fromApiJsonHelper.extractStringNamed("loanScheduleType", element);
        baseDataValidator.reset().parameter("loanScheduleType").value((Object)loanScheduleType).isOneOfEnumValues(LoanScheduleType.class);
        if (!LoanScheduleType.PROGRESSIVE.equals((Object)LoanScheduleType.valueOf((String)loanScheduleType)) && "advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode)) {
            baseDataValidator.reset().parameter("loanScheduleProcessingType").failWithCode("supported.only.for.progressive.loan.schedule.type", new Object[]{"Progressive repayment schedule processing is only available with `Advanced payment allocation` strategy"});
        }
        if (LoanScheduleType.PROGRESSIVE.equals((Object)LoanScheduleType.valueOf((String)loanScheduleType)) && !"advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode)) {
            baseDataValidator.reset().parameter("loanScheduleType").failWithCode("supported.only.with.advanced.payment.allocation.strategy", new Object[]{loanScheduleType + " loan schedule type is not available with " + transactionProcessingStrategyCode + " strategy"});
        }
    }

    public void validateRepaymentPeriodWithGraceSettings(Integer numberOfRepayments, Integer graceOnPrincipalPayment, Integer graceOnInterestPayment, Integer graceOnInterestCharged, Integer recurringMoratoriumOnPrincipalPeriods, DataValidatorBuilder baseDataValidator) {
        if (numberOfRepayments != null) {
            if (numberOfRepayments <= this.defaultToZeroIfNull(graceOnPrincipalPayment)) {
                baseDataValidator.reset().parameter(GRACE_ON_PRINCIPAL_PAYMENT).value((Object)graceOnPrincipalPayment).failWithCode("mustBeLessThan.numberOfRepayments", new Object[0]);
            }
            if (numberOfRepayments <= this.defaultToZeroIfNull(graceOnInterestPayment)) {
                baseDataValidator.reset().parameter(GRACE_ON_INTEREST_PAYMENT).value((Object)graceOnInterestPayment).failWithCode("mustBeLessThan.numberOfRepayments", new Object[0]);
            }
            if (numberOfRepayments < this.defaultToZeroIfNull(graceOnInterestCharged)) {
                baseDataValidator.reset().parameter(GRACE_ON_INTEREST_CHARGED).value((Object)graceOnInterestCharged).failWithCode("mustBeLessThan.numberOfRepayments", new Object[0]);
            }
            int graceOnPrincipal = 0;
            if (graceOnPrincipalPayment != null) {
                graceOnPrincipal = graceOnPrincipalPayment;
            }
            int recurMoratoriumOnPrincipal = 0;
            if (recurringMoratoriumOnPrincipalPeriods != null) {
                recurMoratoriumOnPrincipal = recurringMoratoriumOnPrincipalPeriods;
            }
            if (recurMoratoriumOnPrincipal > 0 && (numberOfRepayments - graceOnPrincipal) % (recurMoratoriumOnPrincipal + 1) != 1) {
                baseDataValidator.reset().parameter("graceOnPrincipalPayments.and.recurringMoratoriumOnPrincipalPeriods").value((Object)graceOnPrincipal).value((Object)recurMoratoriumOnPrincipal).failWithCode("causes.principal.moratorium.for.last.installment", new Object[0]);
            }
        }
    }

    private void validateIncomeCapitalization(String transactionProcessingStrategyCode, JsonElement element, DataValidatorBuilder baseDataValidator, Integer accountingRuleType) {
        Boolean enableIncomeCapitalization;
        if (this.fromApiJsonHelper.parameterExists("capitalizedIncomeCalculationType", element)) {
            String capitalizedIncomeCalculationType = this.fromApiJsonHelper.extractStringNamed("capitalizedIncomeCalculationType", element);
            baseDataValidator.reset().parameter("capitalizedIncomeCalculationType").value((Object)capitalizedIncomeCalculationType).isOneOfEnumValues(LoanCapitalizedIncomeCalculationType.class);
        }
        if (this.fromApiJsonHelper.parameterExists("capitalizedIncomeStrategy", element)) {
            String capitalizedIncomeStrategy = this.fromApiJsonHelper.extractStringNamed("capitalizedIncomeStrategy", element);
            baseDataValidator.reset().parameter("capitalizedIncomeStrategy").value((Object)capitalizedIncomeStrategy).isOneOfEnumValues(LoanCapitalizedIncomeStrategy.class);
        }
        if (this.fromApiJsonHelper.parameterExists("capitalizedIncomeType", element)) {
            String capitalizedIncomeType = this.fromApiJsonHelper.extractStringNamed("capitalizedIncomeType", element);
            baseDataValidator.reset().parameter("capitalizedIncomeType").value((Object)capitalizedIncomeType).isOneOfEnumValues(LoanCapitalizedIncomeType.class);
        }
        if ("advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode) && this.fromApiJsonHelper.parameterExists("enableIncomeCapitalization", element)) {
            enableIncomeCapitalization = this.fromApiJsonHelper.extractBooleanNamed("enableIncomeCapitalization", element);
            baseDataValidator.reset().parameter("enableIncomeCapitalization").value((Object)enableIncomeCapitalization).ignoreIfNull().validateForBooleanValue();
            if (enableIncomeCapitalization.booleanValue()) {
                String capitalizedIncomeCalculationType = this.fromApiJsonHelper.extractStringNamed("capitalizedIncomeCalculationType", element);
                baseDataValidator.reset().parameter("capitalizedIncomeCalculationType").value((Object)capitalizedIncomeCalculationType).isOneOfEnumValues(LoanCapitalizedIncomeCalculationType.class).cantBeBlankWhenParameterProvidedIs("enableIncomeCapitalization", (Object)true);
                String capitalizedIncomeStrategy = this.fromApiJsonHelper.extractStringNamed("capitalizedIncomeStrategy", element);
                baseDataValidator.reset().parameter("capitalizedIncomeStrategy").value((Object)capitalizedIncomeStrategy).isOneOfEnumValues(LoanCapitalizedIncomeStrategy.class).cantBeBlankWhenParameterProvidedIs("enableIncomeCapitalization", (Object)true);
                String capitalizedIncomeType = this.fromApiJsonHelper.extractStringNamed("capitalizedIncomeType", element);
                baseDataValidator.reset().parameter("capitalizedIncomeType").value((Object)capitalizedIncomeType).isOneOfEnumValues(LoanCapitalizedIncomeType.class).cantBeBlankWhenParameterProvidedIs("enableIncomeCapitalization", (Object)true);
                if (AccountingValidations.isAccrualBasedAccounting((Integer)accountingRuleType)) {
                    Long deferredIncomeLiabilityAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.DEFERRED_INCOME_LIABILITY.getValue(), element);
                    baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.DEFERRED_INCOME_LIABILITY.getValue()).value((Object)deferredIncomeLiabilityAccountId).notNull().cantBeBlankWhenParameterProvidedIs("enableIncomeCapitalization", (Object)true).integerGreaterThanZero();
                    Long incomeFromDeferredIncomeAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CAPITALIZATION.getValue(), element);
                    baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CAPITALIZATION.getValue()).value((Object)incomeFromDeferredIncomeAccountId).notNull().cantBeBlankWhenParameterProvidedIs("enableIncomeCapitalization", (Object)true).integerGreaterThanZero();
                }
            }
        } else if (this.fromApiJsonHelper.parameterExists("enableIncomeCapitalization", element) && Boolean.TRUE.equals(enableIncomeCapitalization = this.fromApiJsonHelper.extractBooleanNamed("enableIncomeCapitalization", element))) {
            baseDataValidator.reset().parameter("enableIncomeCapitalization").failWithCode("supported.only.for.progressive.loan.income.capitalization", new Object[]{"Income capitalization is only supported for Progressive loans"});
        }
    }

    private void validateBuyDownFee(String transactionProcessingStrategyCode, JsonElement element, DataValidatorBuilder baseDataValidator, Integer accountingRuleType) {
        Boolean enableBuyDownFee;
        if (this.fromApiJsonHelper.parameterExists("buyDownFeeCalculationType", element)) {
            String buyDownFeeCalculationType = this.fromApiJsonHelper.extractStringNamed("buyDownFeeCalculationType", element);
            baseDataValidator.reset().parameter("buyDownFeeCalculationType").value((Object)buyDownFeeCalculationType).isOneOfEnumValues(LoanBuyDownFeeCalculationType.class);
        }
        if (this.fromApiJsonHelper.parameterExists("buyDownFeeStrategy", element)) {
            String buyDownFeeStrategy = this.fromApiJsonHelper.extractStringNamed("buyDownFeeStrategy", element);
            baseDataValidator.reset().parameter("buyDownFeeStrategy").value((Object)buyDownFeeStrategy).isOneOfEnumValues(LoanBuyDownFeeStrategy.class);
        }
        if (this.fromApiJsonHelper.parameterExists("buyDownFeeIncomeType", element)) {
            String buyDownFeeIncomeType = this.fromApiJsonHelper.extractStringNamed("buyDownFeeIncomeType", element);
            baseDataValidator.reset().parameter("buyDownFeeIncomeType").value((Object)buyDownFeeIncomeType).isOneOfEnumValues(LoanBuyDownFeeIncomeType.class);
        }
        if ("advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode) && this.fromApiJsonHelper.parameterExists("enableBuyDownFee", element)) {
            enableBuyDownFee = this.fromApiJsonHelper.extractBooleanNamed("enableBuyDownFee", element);
            baseDataValidator.reset().parameter("enableBuyDownFee").value((Object)enableBuyDownFee).ignoreIfNull().validateForBooleanValue();
            if (enableBuyDownFee.booleanValue()) {
                String buyDownFeeCalculationType = this.fromApiJsonHelper.extractStringNamed("buyDownFeeCalculationType", element);
                baseDataValidator.reset().parameter("buyDownFeeCalculationType").value((Object)buyDownFeeCalculationType).isOneOfEnumValues(LoanBuyDownFeeCalculationType.class).cantBeBlankWhenParameterProvidedIs("enableBuyDownFee", (Object)true);
                String buyDownFeeStrategy = this.fromApiJsonHelper.extractStringNamed("buyDownFeeStrategy", element);
                baseDataValidator.reset().parameter("buyDownFeeStrategy").value((Object)buyDownFeeStrategy).isOneOfEnumValues(LoanBuyDownFeeStrategy.class).cantBeBlankWhenParameterProvidedIs("enableBuyDownFee", (Object)true);
                String buyDownFeeIncomeType = this.fromApiJsonHelper.extractStringNamed("buyDownFeeIncomeType", element);
                baseDataValidator.reset().parameter("buyDownFeeIncomeType").value((Object)buyDownFeeIncomeType).isOneOfEnumValues(LoanBuyDownFeeIncomeType.class).cantBeBlankWhenParameterProvidedIs("enableBuyDownFee", (Object)true);
                if (AccountingValidations.isAccrualBasedAccounting((Integer)accountingRuleType)) {
                    if (this.fromApiJsonHelper.parameterExists("merchantBuyDownFee", element)) {
                        Boolean merchantBuyDownFee = this.fromApiJsonHelper.extractBooleanNamed("merchantBuyDownFee", element);
                        baseDataValidator.reset().parameter("merchantBuyDownFee").value((Object)merchantBuyDownFee).ignoreIfNull().validateForBooleanValue();
                        if (Boolean.TRUE.equals(merchantBuyDownFee)) {
                            Long deferredIncomeLiabilityAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.BUY_DOWN_EXPENSE.getValue(), element);
                            baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.BUY_DOWN_EXPENSE.getValue()).value((Object)deferredIncomeLiabilityAccountId).notNull().cantBeBlankWhenParameterProvidedIs("enableBuyDownFee", (Object)true).integerGreaterThanZero();
                        }
                    }
                    Long incomeFromDeferredIncomeAccountId = this.fromApiJsonHelper.extractLongNamed(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_BUY_DOWN.getValue(), element);
                    baseDataValidator.reset().parameter(AccountingConstants.LoanProductAccountingParams.INCOME_FROM_BUY_DOWN.getValue()).value((Object)incomeFromDeferredIncomeAccountId).notNull().cantBeBlankWhenParameterProvidedIs("enableBuyDownFee", (Object)true).integerGreaterThanZero();
                }
            }
        } else if (this.fromApiJsonHelper.parameterExists("enableBuyDownFee", element) && Boolean.TRUE.equals(enableBuyDownFee = this.fromApiJsonHelper.extractBooleanNamed("enableBuyDownFee", element))) {
            baseDataValidator.reset().parameter("enableBuyDownFee").failWithCode("supported.only.for.progressive.loan.buyDownFee", new Object[]{"Buy down fee is only supported for Progressive loans"});
        }
    }

    private Integer defaultToZeroIfNull(Integer value) {
        return value != null ? value : 0;
    }

    @Generated
    public LoanProductDataValidator(FromJsonHelper fromApiJsonHelper, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, AdvancedPaymentAllocationsJsonParser advancedPaymentAllocationsJsonParser, AdvancedPaymentAllocationsValidator advancedPaymentAllocationsValidator, ProductToGLAccountMappingHelper productToGLAccountMappingHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.advancedPaymentAllocationsJsonParser = advancedPaymentAllocationsJsonParser;
        this.advancedPaymentAllocationsValidator = advancedPaymentAllocationsValidator;
        this.productToGLAccountMappingHelper = productToGLAccountMappingHelper;
    }
}

