/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.configuration.service.TemporaryConfigurationServiceContainer;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.JsonParserHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargePaidBy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTrancheCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTrancheDisbursementCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanDisbursementValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoanDisbursementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanDisbursementService.class);
    private final LoanChargeValidator loanChargeValidator;
    private final LoanDisbursementValidator loanDisbursementValidator;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final LoanChargeService loanChargeService;
    private final LoanBalanceService loanBalanceService;
    private final LoanJournalEntryPoster loanJournalEntryPoster;
    private final LoanTransactionRepository loanTransactionRepository;

    public void updateDisbursementDetails(Loan loan, JsonCommand jsonCommand, Map<String, Object> actualChanges) {
        JsonArray disbursementDataArray;
        boolean removeAllCharges;
        List disbursementList = loan.fetchDisbursementIds();
        List loanChargeIds = loan.fetchLoanTrancheChargeIds();
        int chargeIdLength = loanChargeIds.size();
        boolean bl = removeAllCharges = jsonCommand.parameterExists("charges") && jsonCommand.arrayOfParameterNamed("charges").isEmpty();
        if (jsonCommand.parameterExists("disbursementData") && (disbursementDataArray = jsonCommand.arrayOfParameterNamed("disbursementData")) != null && !disbursementDataArray.isEmpty()) {
            Locale locale = null;
            Map dateAndLocale = this.getDateFormatAndLocale(jsonCommand);
            String dateFormat = (String)dateAndLocale.get("dateFormat");
            if (dateAndLocale.containsKey("locale")) {
                locale = JsonParserHelper.localeFromString((String)((String)dateAndLocale.get("locale")));
            }
            for (JsonElement jsonElement : disbursementDataArray) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Map parsedDisbursementData = this.parseDisbursementDetails(jsonObject, dateFormat, locale);
                LocalDate expectedDisbursementDate = (LocalDate)parsedDisbursementData.get("expectedDisbursementDate");
                BigDecimal principal = (BigDecimal)parsedDisbursementData.get("principal");
                Long disbursementID = (Long)parsedDisbursementData.get("id");
                String chargeIds = (String)parsedDisbursementData.get("loanChargeId");
                if (chargeIds != null) {
                    if (chargeIds.contains(",")) {
                        Iterable chargeId = Splitter.on((char)',').split((CharSequence)chargeIds);
                        for (String loanChargeId : chargeId) {
                            loanChargeIds.remove(Long.parseLong(loanChargeId));
                        }
                    } else {
                        loanChargeIds.remove(Long.parseLong(chargeIds));
                    }
                }
                this.createOrUpdateDisbursementDetails(loan, disbursementID, actualChanges, expectedDisbursementDate, principal, disbursementList);
            }
            this.removeDisbursementAndAssociatedCharges(loan, actualChanges, disbursementList, loanChargeIds, chargeIdLength, removeAllCharges);
        }
    }

    public Money adjustDisburseAmount(Loan loan, @NonNull JsonCommand command, @NonNull LocalDate actualDisbursementDate) {
        Collection details;
        Money disburseAmount = loan.getLoanRepaymentScheduleDetail().getPrincipal().zero();
        BigDecimal principalDisbursed = command.bigDecimalValueOfParameterNamed("transactionAmount");
        if (loan.getActualDisbursementDate() == null || DateUtils.isBefore((LocalDate)actualDisbursementDate, (LocalDate)loan.getActualDisbursementDate())) {
            loan.setActualDisbursementDate(actualDisbursementDate);
        }
        BigDecimal diff = BigDecimal.ZERO;
        Collection rawDetails = loan.fetchUndisbursedDetail();
        Collection collection = details = LoanDisbursementService.hasMultipleTranchesOnSameDateWithSameExpectedDate((Collection)rawDetails, (LocalDate)actualDisbursementDate) ? LoanDisbursementService.sortDisbursementDetailsByBusinessRules((Collection)rawDetails) : rawDetails;
        if (principalDisbursed == null) {
            disburseAmount = loan.getLoanRepaymentScheduleDetail().getPrincipal();
            if (!details.isEmpty()) {
                disburseAmount = disburseAmount.zero();
                for (LoanDisbursementDetails disbursementDetails : details) {
                    disbursementDetails.updateActualDisbursementDate(actualDisbursementDate);
                    disburseAmount = disburseAmount.plus(disbursementDetails.principal());
                }
            }
        } else {
            disburseAmount = loan.getLoanProduct().isMultiDisburseLoan() ? Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)principalDisbursed) : disburseAmount.plus(principalDisbursed);
            if (details.isEmpty()) {
                diff = loan.getLoanRepaymentScheduleDetail().getPrincipal().minus(principalDisbursed).getAmount();
            } else {
                boolean isTrancheBasedLoan = this.hasMultipleOrPreDefinedDisbursementDetails(loan, details);
                if (isTrancheBasedLoan && details.size() >= 1) {
                    LoanDisbursementDetails selectedTranche = null;
                    for (LoanDisbursementDetails disbursementDetails : details) {
                        if (disbursementDetails.actualDisbursementDate() != null || disbursementDetails.principal().compareTo(principalDisbursed) != 0) continue;
                        selectedTranche = disbursementDetails;
                        break;
                    }
                    if (selectedTranche == null) {
                        for (LoanDisbursementDetails disbursementDetails : details) {
                            if (disbursementDetails.actualDisbursementDate() != null) continue;
                            selectedTranche = disbursementDetails;
                            break;
                        }
                    }
                    if (selectedTranche != null) {
                        selectedTranche.updateActualDisbursementDate(actualDisbursementDate);
                        selectedTranche.updatePrincipal(principalDisbursed);
                    }
                } else {
                    for (LoanDisbursementDetails disbursementDetails : details) {
                        disbursementDetails.updateActualDisbursementDate(actualDisbursementDate);
                        disbursementDetails.updatePrincipal(principalDisbursed);
                    }
                }
            }
            BigDecimal totalAmount = BigDecimal.ZERO;
            if (loan.loanProduct().isMultiDisburseLoan()) {
                List loanDisburseDetails = loan.getDisbursementDetails();
                BigDecimal setPrincipalAmount = BigDecimal.ZERO;
                for (LoanDisbursementDetails disbursementDetails : loanDisburseDetails) {
                    if (disbursementDetails.actualDisbursementDate() != null) {
                        setPrincipalAmount = setPrincipalAmount.add(disbursementDetails.principal());
                    }
                    totalAmount = totalAmount.add(disbursementDetails.principal());
                }
                loan.getLoanRepaymentScheduleDetail().setPrincipal(setPrincipalAmount);
            } else {
                loan.getLoanRepaymentScheduleDetail().setPrincipal(loan.getLoanRepaymentScheduleDetail().getPrincipal().minus(diff).getAmount());
                totalAmount = loan.getLoanRepaymentScheduleDetail().getPrincipal().getAmount();
            }
            this.loanDisbursementValidator.compareDisbursedToApprovedOrProposedPrincipal(loan, disburseAmount.getAmount(), totalAmount);
        }
        return disburseAmount;
    }

    public void handleDisbursementTransaction(Loan loan, LocalDate disbursedOn, PaymentDetail paymentDetail) {
        Money totalFeeChargesDueAtDisbursement = loan.getSummary().getTotalFeeChargesDueAtDisbursement(loan.getCurrency());
        Money disbursentMoney = Money.zero((MonetaryCurrency)loan.getCurrency());
        LoanTransaction chargesPayment = LoanTransaction.repaymentAtDisbursement((Office)loan.getOffice(), (Money)disbursentMoney, (PaymentDetail)paymentDetail, (LocalDate)disbursedOn, null);
        Integer installmentNumber = null;
        for (LoanCharge charge : loan.getActiveCharges()) {
            LoanTransaction applyLoanChargeTransaction;
            boolean isTrancheDisbursementCharge;
            LocalDate actualDisbursementDate = loan.getActualDisbursementDate(charge);
            boolean isDisbursementCharge = charge.getCharge().getChargeTimeType().equals(ChargeTimeType.DISBURSEMENT.getValue()) && disbursedOn.equals(actualDisbursementDate) && !charge.isWaived() && !charge.isFullyPaid();
            boolean bl = isTrancheDisbursementCharge = charge.getCharge().getChargeTimeType().equals(ChargeTimeType.TRANCHE_DISBURSEMENT.getValue()) && disbursedOn.equals(actualDisbursementDate) && !charge.isWaived() && !charge.isFullyPaid();
            if (isDisbursementCharge || isTrancheDisbursementCharge) {
                if (!totalFeeChargesDueAtDisbursement.isGreaterThanZero() || charge.getChargePaymentMode().isPaymentModeAccountTransfer()) continue;
                charge.markAsFullyPaid();
                LoanChargePaidBy loanChargePaidBy = new LoanChargePaidBy(chargesPayment, charge, charge.amount(), installmentNumber);
                chargesPayment.getLoanChargesPaid().add(loanChargePaidBy);
                disbursentMoney = disbursentMoney.plus(charge.amount());
                continue;
            }
            if (!disbursedOn.equals(loan.getActualDisbursementDate()) || !loan.isNoneOrCashOrUpfrontAccrualAccountingEnabledOnLoanProduct().booleanValue() || (applyLoanChargeTransaction = this.loanChargeService.handleChargeAppliedTransaction(loan, charge, disbursedOn)) == null) continue;
            this.loanTransactionRepository.saveAndFlush((Object)applyLoanChargeTransaction);
            this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(applyLoanChargeTransaction, false, false);
        }
        if (disbursentMoney.isGreaterThanZero()) {
            Money zero = Money.zero((MonetaryCurrency)loan.getCurrency());
            chargesPayment.updateComponentsAndTotal(zero, zero, disbursentMoney, zero);
            chargesPayment.updateLoan(loan);
            loan.addLoanTransaction(chargesPayment);
            this.loanTransactionRepository.saveAndFlush((Object)chargesPayment);
            this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(chargesPayment, false, false);
            this.loanBalanceService.updateLoanOutstandingBalances(loan);
        }
        LocalDate expectedDate = loan.getExpectedFirstRepaymentOnDate();
        this.loanDisbursementValidator.validateDisburseDate(loan, disbursedOn, expectedDate);
    }

    private void createOrUpdateDisbursementDetails(Loan loan, Long disbursementID, Map<String, Object> actualChanges, LocalDate expectedDisbursementDate, BigDecimal principal, List<Long> existingDisbursementList) {
        if (disbursementID != null) {
            LoanDisbursementDetails loanDisbursementDetail = loan.fetchLoanDisbursementsById(disbursementID);
            existingDisbursementList.remove(disbursementID);
            if (loanDisbursementDetail.actualDisbursementDate() == null) {
                LocalDate actualDisbursementDate = null;
                LoanDisbursementDetails disbursementDetails = new LoanDisbursementDetails(expectedDisbursementDate, actualDisbursementDate, principal, loan.getNetDisbursalAmount(), false);
                disbursementDetails.updateLoan(loan);
                if (!loanDisbursementDetail.equals((Object)disbursementDetails)) {
                    loanDisbursementDetail.copy(disbursementDetails);
                    actualChanges.put("disbursementDetailId", disbursementID);
                    actualChanges.put("recalculateLoanSchedule", true);
                }
            }
        } else {
            LoanDisbursementDetails disbursementDetails = loan.addLoanDisbursementDetails(expectedDisbursementDate, principal);
            for (LoanTrancheCharge trancheCharge : loan.getTrancheCharges()) {
                Charge chargeDefinition = trancheCharge.getCharge();
                ExternalId externalId = ExternalId.empty();
                if (TemporaryConfigurationServiceContainer.isExternalIdAutoGenerationEnabled()) {
                    externalId = ExternalId.generate();
                }
                LoanCharge loanCharge = this.loanChargeService.create(loan, chargeDefinition, principal, null, null, null, expectedDisbursementDate, null, null, BigDecimal.ZERO, externalId);
                LoanTrancheDisbursementCharge loanTrancheDisbursementCharge = new LoanTrancheDisbursementCharge(loanCharge, disbursementDetails);
                loanCharge.updateLoanTrancheDisbursementCharge(loanTrancheDisbursementCharge);
                this.loanChargeValidator.validateChargeAdditionForDisbursedLoan(loan, loanCharge);
                this.loanChargeValidator.validateChargeHasValidSpecifiedDateIfApplicable(loan, loanCharge, loan.getDisbursementDate());
                this.loanChargeService.addLoanCharge(loan, loanCharge);
            }
            actualChanges.put("disbursementData", String.valueOf(expectedDisbursementDate) + "-" + String.valueOf(principal));
            actualChanges.put("recalculateLoanSchedule", true);
        }
    }

    private void removeDisbursementAndAssociatedCharges(Loan loan, Map<String, Object> actualChanges, List<Long> disbursementList, List<Long> loanChargeIds, int chargeIdLength, boolean removeAllCharges) {
        if (removeAllCharges) {
            LoanCharge[] tempCharges = new LoanCharge[loan.getCharges().size()];
            loan.getCharges().toArray(tempCharges);
            for (LoanCharge loanCharge : tempCharges) {
                this.loanChargeValidator.validateLoanIsNotClosed(loan, loanCharge);
                this.loanChargeValidator.validateLoanChargeIsNotWaived(loan, loanCharge);
                this.reprocessLoanTransactionsService.removeLoanCharge(loan, loanCharge);
            }
            loan.getTrancheCharges().clear();
        } else if (!loanChargeIds.isEmpty() && loanChargeIds.size() != chargeIdLength) {
            for (Long chargeId : loanChargeIds) {
                LoanCharge deleteCharge = this.loanChargeService.fetchLoanChargesById(loan, chargeId);
                if (!loan.getCharges().contains(deleteCharge)) continue;
                this.loanChargeValidator.validateLoanIsNotClosed(loan, deleteCharge);
                this.loanChargeValidator.validateLoanChargeIsNotWaived(loan, deleteCharge);
                this.reprocessLoanTransactionsService.removeLoanCharge(loan, deleteCharge);
            }
        }
        for (Long id : disbursementList) {
            this.removeChargesByDisbursementID(loan, id);
            loan.removeDisbursementDetails(id.longValue());
            actualChanges.put("recalculateLoanSchedule", true);
        }
    }

    private void removeChargesByDisbursementID(Loan loan, Long id) {
        loan.getCharges().stream().filter(charge -> {
            LoanTrancheDisbursementCharge transCharge = charge.getTrancheDisbursementCharge();
            if (transCharge == null || !Objects.equals(id, transCharge.getloanDisbursementDetails().getId())) {
                return false;
            }
            this.loanChargeValidator.validateLoanIsNotClosed(loan, charge);
            this.loanChargeValidator.validateLoanChargeIsNotWaived(loan, charge);
            return true;
        }).forEach(loanCharge -> this.reprocessLoanTransactionsService.removeLoanCharge(loan, loanCharge));
    }

    private Map<String, String> getDateFormatAndLocale(JsonCommand jsonCommand) {
        HashMap<String, String> returnObject = new HashMap<String, String>();
        JsonElement jsonElement = jsonCommand.parsedJson();
        if (jsonElement.isJsonObject()) {
            JsonPrimitive primitive;
            JsonObject topLevel = jsonElement.getAsJsonObject();
            if (topLevel.has("dateFormat") && topLevel.get("dateFormat").isJsonPrimitive()) {
                primitive = topLevel.get("dateFormat").getAsJsonPrimitive();
                returnObject.put("dateFormat", primitive.getAsString());
            }
            if (topLevel.has("locale") && topLevel.get("locale").isJsonPrimitive()) {
                primitive = topLevel.get("locale").getAsJsonPrimitive();
                String localeString = primitive.getAsString();
                returnObject.put("locale", localeString);
            }
        }
        return returnObject;
    }

    private Map<String, Object> parseDisbursementDetails(JsonObject jsonObject, String dateFormat, Locale locale) {
        LocalDate date;
        JsonPrimitive primitive;
        String valueAsString;
        HashMap<String, Object> returnObject = new HashMap<String, Object>();
        if (jsonObject.get("expectedDisbursementDate") != null && jsonObject.get("expectedDisbursementDate").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)(valueAsString = (primitive = jsonObject.get("expectedDisbursementDate").getAsJsonPrimitive()).getAsString())) && (date = JsonParserHelper.convertFrom((String)valueAsString, (String)"expectedDisbursementDate", (String)dateFormat, (Locale)locale)) != null) {
            returnObject.put("expectedDisbursementDate", date);
        }
        if (jsonObject.get("principal").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("principal").getAsString())) {
            BigDecimal principal = jsonObject.getAsJsonPrimitive("principal").getAsBigDecimal();
            returnObject.put("principal", principal);
        }
        if (jsonObject.has("id") && jsonObject.get("id").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("id").getAsString())) {
            Long id = jsonObject.getAsJsonPrimitive("id").getAsLong();
            returnObject.put("id", id);
        }
        if (jsonObject.has("loanChargeId") && jsonObject.get("loanChargeId").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("loanChargeId").getAsString())) {
            returnObject.put("loanChargeId", jsonObject.getAsJsonPrimitive("loanChargeId").getAsString());
        }
        return returnObject;
    }

    private boolean hasMultipleOrPreDefinedDisbursementDetails(Loan loan, Collection<LoanDisbursementDetails> undisbursedDetails) {
        List allDisbursementDetails = loan.getDisbursementDetails();
        if (undisbursedDetails.size() > 1) {
            return true;
        }
        if (allDisbursementDetails.size() > 1 && !undisbursedDetails.isEmpty()) {
            return true;
        }
        if (undisbursedDetails.size() == 1) {
            LoanDisbursementDetails singleDetail = undisbursedDetails.iterator().next();
            BigDecimal loanPrincipal = loan.getLoanRepaymentScheduleDetail().getPrincipal().getAmount();
            if (singleDetail.principal().compareTo(loanPrincipal) == 0) {
                return false;
            }
        }
        return true;
    }

    public static List<LoanDisbursementDetails> sortDisbursementDetailsByBusinessRules(Collection<LoanDisbursementDetails> disbursementDetails) {
        if (disbursementDetails == null || disbursementDetails.isEmpty()) {
            return List.of();
        }
        return disbursementDetails.stream().sorted(Comparator.comparing(LoanDisbursementDetails::expectedDisbursementDate).thenComparing((d1, d2) -> d2.principal().compareTo(d1.principal())).thenComparing(AbstractPersistableCustom::getId)).collect(Collectors.toList());
    }

    public static boolean hasMultipleTranchesOnSameDate(Collection<LoanDisbursementDetails> disbursementDetails) {
        if (disbursementDetails == null || disbursementDetails.size() <= 1) {
            return false;
        }
        return disbursementDetails.stream().collect(Collectors.groupingBy(LoanDisbursementDetails::expectedDisbursementDate, Collectors.counting())).values().stream().anyMatch(count -> count > 1L);
    }

    public static boolean hasMultipleTranchesOnSameDateWithSameExpectedDate(Collection<LoanDisbursementDetails> disbursementDetails, LocalDate actualDisbursementDate) {
        if (disbursementDetails == null || disbursementDetails.size() <= 1 || actualDisbursementDate == null) {
            return false;
        }
        long tranchesForActualDate = disbursementDetails.stream().filter(detail -> actualDisbursementDate.equals(detail.expectedDisbursementDate())).count();
        return tranchesForActualDate > 1L;
    }

    @Generated
    public LoanDisbursementService(LoanChargeValidator loanChargeValidator, LoanDisbursementValidator loanDisbursementValidator, ReprocessLoanTransactionsService reprocessLoanTransactionsService, LoanChargeService loanChargeService, LoanBalanceService loanBalanceService, LoanJournalEntryPoster loanJournalEntryPoster, LoanTransactionRepository loanTransactionRepository) {
        this.loanChargeValidator = loanChargeValidator;
        this.loanDisbursementValidator = loanDisbursementValidator;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.loanChargeService = loanChargeService;
        this.loanBalanceService = loanBalanceService;
        this.loanJournalEntryPoster = loanJournalEntryPoster;
        this.loanTransactionRepository = loanTransactionRepository;
    }
}

