/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.serialization;

import java.time.LocalDate;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.exception.LoanForeclosureException;
import org.springframework.stereotype.Component;

@Component
public final class LoanForeclosureValidator {
    public void validateForForeclosure(Loan loan, LocalDate transactionDate) {
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            String defaultUserMessage = "The loan with interest recalculation enabled cannot be foreclosed.";
            throw new LoanForeclosureException("loan.with.interest.recalculation.enabled.cannot.be.foreclosured", "The loan with interest recalculation enabled cannot be foreclosed.", new Object[]{loan.getId()});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)transactionDate)) {
            String defaultUserMessage = "The transactionDate cannot be in the future.";
            throw new LoanForeclosureException("loan.foreclosure.transaction.date.is.in.future", "The transactionDate cannot be in the future.", new Object[]{transactionDate});
        }
        if (DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getLastUserTransactionDate())) {
            String defaultUserMessage = "The transactionDate cannot be earlier than the last transaction date.";
            throw new LoanForeclosureException("loan.foreclosure.transaction.date.cannot.before.the.last.transaction.date", "The transactionDate cannot be earlier than the last transaction date.", new Object[]{transactionDate});
        }
    }
}

