/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.portfolio.collateralmanagement.data.LoanCollateralResponseData;
import org.apache.fineract.portfolio.collateralmanagement.service.LoanCollateralManagementReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loan-collateral-management")
@Component
@Tag(name="Loan Collateral Management", description="Loan Collateral Management is for managing collateral operations")
public class LoanCollateralManagementApiResource {
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final LoanCollateralManagementReadPlatformService loanCollateralManagementReadPlatformService;

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(description="Delete Loan Collateral", summary="Delete Loan Collateral")
    public CommandProcessingResult deleteLoanCollateral(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="id") @Parameter(description="loan collateral id") Long id) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().deleteLoanCollateral(loanId, id).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @GET
    @Path(value="{collateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(description="Get Loan Collateral Details", summary="Get Loan Collateral Details")
    public LoanCollateralResponseData getLoanCollateral(@PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId) {
        return this.loanCollateralManagementReadPlatformService.getLoanCollateralResponseData(collateralId);
    }

    @Generated
    public LoanCollateralManagementApiResource(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, LoanCollateralManagementReadPlatformService loanCollateralManagementReadPlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.loanCollateralManagementReadPlatformService = loanCollateralManagementReadPlatformService;
    }
}

