/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.charge.service;

import jakarta.persistence.PersistenceException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.glaccount.domain.GLAccountRepositoryWrapper;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityAccessType;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessUtil;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeRepository;
import org.apache.fineract.portfolio.charge.exception.ChargeCannotBeDeletedException;
import org.apache.fineract.portfolio.charge.exception.ChargeCannotBeUpdatedException;
import org.apache.fineract.portfolio.charge.exception.ChargeNotFoundException;
import org.apache.fineract.portfolio.charge.serialization.ChargeDefinitionCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.charge.service.ChargeWritePlatformService;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.paymenttype.domain.PaymentType;
import org.apache.fineract.portfolio.paymenttype.domain.PaymentTypeRepositoryWrapper;
import org.apache.fineract.portfolio.tax.domain.TaxGroup;
import org.apache.fineract.portfolio.tax.domain.TaxGroupRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class ChargeWritePlatformServiceJpaRepositoryImpl
implements ChargeWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChargeWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final ChargeDefinitionCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final ChargeRepository chargeRepository;
    private final LoanProductRepository loanProductRepository;
    private final JdbcTemplate jdbcTemplate;
    private final FineractEntityAccessUtil fineractEntityAccessUtil;
    private final GLAccountRepositoryWrapper glAccountRepository;
    private final TaxGroupRepositoryWrapper taxGroupRepository;
    private final PaymentTypeRepositoryWrapper paymentTyperepositoryWrapper;

    @Transactional
    @CacheEvict(value={"charges"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('ch')")
    public CommandProcessingResult createCharge(JsonCommand command) {
        try {
            Long paymentTypeId;
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            Long glAccountId = command.longValueOfParameterNamed("incomeAccountId");
            GLAccount glAccount = null;
            if (glAccountId != null) {
                glAccount = this.glAccountRepository.findOneWithNotFoundDetection(glAccountId);
            }
            Long taxGroupId = command.longValueOfParameterNamed("taxGroupId");
            TaxGroup taxGroup = null;
            if (taxGroupId != null) {
                taxGroup = this.taxGroupRepository.findOneWithNotFoundDetection(taxGroupId);
            }
            boolean enablePaymentType = command.booleanPrimitiveValueOfParameterNamed("enablePaymentType");
            PaymentType paymentType = null;
            if (enablePaymentType && (paymentTypeId = command.longValueOfParameterNamed("paymentTypeId")) != null) {
                paymentType = this.paymentTyperepositoryWrapper.findOneWithNotFoundDetection(paymentTypeId);
            }
            Charge charge = Charge.fromJson((JsonCommand)command, (GLAccount)glAccount, (TaxGroup)taxGroup, paymentType);
            this.chargeRepository.saveAndFlush((Object)charge);
            this.fineractEntityAccessUtil.checkConfigurationAndAddProductResrictionsForUserOffice(FineractEntityAccessType.OFFICE_ACCESS_TO_CHARGES, (Long)charge.getId());
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)charge.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    @CacheEvict(value={"charges"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('ch')")
    public CommandProcessingResult updateCharge(Long chargeId, JsonCommand command) {
        try {
            Boolean isChargeExistWithLoans;
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            Charge chargeForUpdate = (Charge)this.chargeRepository.findById((Object)chargeId).orElseThrow(() -> new ChargeNotFoundException(chargeId));
            Map changes = chargeForUpdate.update(command);
            this.fromApiJsonDeserializer.validateChargeTimeNCalculationType(chargeForUpdate.getChargeTimeType(), chargeForUpdate.getChargeCalculation());
            if (changes.containsKey("active")) {
                if (!chargeForUpdate.isActive()) {
                    isChargeExistWithLoans = this.isAnyLoanProductsAssociateWithThisCharge(chargeId);
                    Boolean isChargeExistWithSavings = this.isAnySavingsProductsAssociateWithThisCharge(chargeId);
                    if (isChargeExistWithLoans.booleanValue() || isChargeExistWithSavings.booleanValue()) {
                        throw new ChargeCannotBeUpdatedException("error.msg.charge.cannot.be.updated.it.is.used.in.loan", "This charge cannot be updated, it is used in loan", new Object[0]);
                    }
                }
            } else if ((changes.containsKey("feeFrequency") || changes.containsKey("feeInterval")) && chargeForUpdate.isLoanCharge() && (isChargeExistWithLoans = Boolean.valueOf(this.isAnyLoanProductsAssociateWithThisCharge(chargeId))).booleanValue()) {
                throw new ChargeCannotBeUpdatedException("error.msg.charge.frequency.cannot.be.updated.it.is.used.in.loan", "This charge frequency cannot be updated, it is used in loan", new Object[0]);
            }
            if (changes.containsKey("incomeAccountId")) {
                Long newValue = command.longValueOfParameterNamed("incomeAccountId");
                GLAccount newIncomeAccount = null;
                if (newValue != null) {
                    newIncomeAccount = this.glAccountRepository.findOneWithNotFoundDetection(newValue);
                }
                chargeForUpdate.setAccount(newIncomeAccount);
            }
            String paymentTypeIdParamName = "paymentTypeId";
            if (changes.containsKey("paymentTypeId")) {
                Long paymentTypeIdNewValue = command.longValueOfParameterNamed("paymentTypeId");
                PaymentType paymentType = null;
                if (paymentTypeIdNewValue != null) {
                    Long paymentTypeId = (long)paymentTypeIdNewValue;
                    paymentType = this.paymentTyperepositoryWrapper.findOneWithNotFoundDetection(paymentTypeId);
                    chargeForUpdate.setPaymentType(paymentType);
                }
            }
            if (changes.containsKey("taxGroupId")) {
                Long newValue = command.longValueOfParameterNamed("taxGroupId");
                TaxGroup taxGroup = null;
                if (newValue != null) {
                    taxGroup = this.taxGroupRepository.findOneWithNotFoundDetection(newValue);
                }
                chargeForUpdate.setTaxGroup(taxGroup);
            }
            if (!changes.isEmpty()) {
                this.chargeRepository.save((Object)chargeForUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(chargeId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    @CacheEvict(value={"charges"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('ch')")
    public CommandProcessingResult deleteCharge(Long chargeId) {
        Charge chargeForDelete = (Charge)this.chargeRepository.findById((Object)chargeId).orElseThrow(() -> new ChargeNotFoundException(chargeId));
        if (chargeForDelete.isDeleted()) {
            throw new ChargeNotFoundException(chargeId);
        }
        List loanProducts = this.loanProductRepository.retrieveLoanProductsByChargeId(chargeId);
        Boolean isChargeExistWithLoans = this.isAnyLoansAssociateWithThisCharge(chargeId);
        Boolean isChargeExistWithSavings = this.isAnySavingsAssociateWithThisCharge(chargeId);
        if (!loanProducts.isEmpty() || isChargeExistWithLoans.booleanValue() || isChargeExistWithSavings.booleanValue()) {
            throw new ChargeCannotBeDeletedException("error.msg.charge.cannot.be.deleted.it.is.already.used.in.loan", "This charge cannot be deleted, it is already used in loan", new Object[0]);
        }
        chargeForDelete.delete();
        this.chargeRepository.save((Object)chargeForDelete);
        return new CommandProcessingResultBuilder().withEntityId((Long)chargeForDelete.getId()).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.charge.duplicate.name", "Charge with name `" + name + "` already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.charge.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    private boolean isAnyLoansAssociateWithThisCharge(Long chargeId) {
        String sql = "select (CASE WHEN exists (select 1 from m_loan_charge lc where lc.charge_id = ? and lc.is_active = true) THEN 'true' ELSE 'false' END)";
        String isLoansUsingCharge = (String)this.jdbcTemplate.queryForObject("select (CASE WHEN exists (select 1 from m_loan_charge lc where lc.charge_id = ? and lc.is_active = true) THEN 'true' ELSE 'false' END)", String.class, new Object[]{chargeId});
        return Boolean.valueOf(isLoansUsingCharge);
    }

    private boolean isAnySavingsAssociateWithThisCharge(Long chargeId) {
        String sql = "select (CASE WHEN exists (select 1 from m_savings_account_charge sc where sc.charge_id = ? and sc.is_active = true) THEN 'true' ELSE 'false' END)";
        String isSavingsUsingCharge = (String)this.jdbcTemplate.queryForObject("select (CASE WHEN exists (select 1 from m_savings_account_charge sc where sc.charge_id = ? and sc.is_active = true) THEN 'true' ELSE 'false' END)", String.class, new Object[]{chargeId});
        return Boolean.valueOf(isSavingsUsingCharge);
    }

    private boolean isAnyLoanProductsAssociateWithThisCharge(Long chargeId) {
        String sql = "select (CASE WHEN exists (select 1 from m_product_loan_charge lc where lc.charge_id = ?) THEN 'true' ELSE 'false' END)";
        String isLoansUsingCharge = (String)this.jdbcTemplate.queryForObject("select (CASE WHEN exists (select 1 from m_product_loan_charge lc where lc.charge_id = ?) THEN 'true' ELSE 'false' END)", String.class, new Object[]{chargeId});
        return Boolean.valueOf(isLoansUsingCharge);
    }

    private boolean isAnySavingsProductsAssociateWithThisCharge(Long chargeId) {
        String sql = "select (CASE WHEN (exists (select 1 from m_savings_product_charge sc where sc.charge_id = ?)) = 1 THEN 'true' ELSE 'false' END)";
        String isSavingsUsingCharge = (String)this.jdbcTemplate.queryForObject("select (CASE WHEN (exists (select 1 from m_savings_product_charge sc where sc.charge_id = ?)) = 1 THEN 'true' ELSE 'false' END)", String.class, new Object[]{chargeId});
        return Boolean.valueOf(isSavingsUsingCharge);
    }

    @Generated
    public ChargeWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, ChargeDefinitionCommandFromApiJsonDeserializer fromApiJsonDeserializer, ChargeRepository chargeRepository, LoanProductRepository loanProductRepository, JdbcTemplate jdbcTemplate, FineractEntityAccessUtil fineractEntityAccessUtil, GLAccountRepositoryWrapper glAccountRepository, TaxGroupRepositoryWrapper taxGroupRepository, PaymentTypeRepositoryWrapper paymentTyperepositoryWrapper) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.chargeRepository = chargeRepository;
        this.loanProductRepository = loanProductRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.fineractEntityAccessUtil = fineractEntityAccessUtil;
        this.glAccountRepository = glAccountRepository;
        this.taxGroupRepository = taxGroupRepository;
        this.paymentTyperepositoryWrapper = paymentTyperepositoryWrapper;
    }
}

