/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.provisioning.constants.ProvisioningCriteriaConstants;
import org.apache.fineract.organisation.provisioning.exception.ProvisioningCriteriaCannotBeCreatedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProvisioningCriteriaDefinitionJsonDeserializer
implements ProvisioningCriteriaConstants {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> supportedParametersForCreate = new HashSet<String>(Arrays.asList("locale", "criteriaName", "loanProducts", "definitions"));
    private static final Set<String> supportedParametersForUpdate = new HashSet<String>(Arrays.asList("criteriaId", "locale", "criteriaName", "loanProducts", "definitions"));
    private static final Set<String> loanProductSupportedParams = new HashSet<String>(Arrays.asList("id", "name", "includeInBorrowerCycle"));
    private static final Set<String> provisioningcriteriaSupportedParams = new HashSet<String>(Arrays.asList("categoryId", "categoryName", "minAge", "maxAge", "minAge", "provisioningPercentage", "expenseAccount", "liabilityAccount"));

    @Autowired
    public ProvisioningCriteriaDefinitionJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        int i;
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new ProvisioningCriteriaCannotBeCreatedException("error.msg.provisioningcriteria.cannot.be.created", "criterianame, loanproducts[], provisioningcriteria[] params are missing in the request", new Object[0]);
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParametersForCreate);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("provisioningcriteria");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
        String name = this.fromApiJsonHelper.extractStringNamed("criteriaName", element);
        baseDataValidator.reset().parameter("criteriaName").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(200));
        if (this.fromApiJsonHelper.parameterExists("loanProducts", element)) {
            JsonArray jsonloanProducts = this.fromApiJsonHelper.extractJsonArrayNamed("loanProducts", element);
            baseDataValidator.reset().parameter("loanProducts").value((Object)jsonloanProducts).jsonArrayNotEmpty();
            i = 0;
            for (JsonElement obj : jsonloanProducts) {
                this.fromApiJsonHelper.checkForUnsupportedParameters(obj.getAsJsonObject(), (Collection)loanProductSupportedParams);
                Long productId = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)obj.getAsJsonObject());
                baseDataValidator.reset().parameter("loanProducts").parameterAtIndexArray("id", Integer.valueOf(i + 1)).value((Object)productId).notNull().longGreaterThanZero();
                ++i;
            }
        }
        if (this.fromApiJsonHelper.parameterExists("definitions", element)) {
            JsonArray jsonProvisioningCriteria = this.fromApiJsonHelper.extractJsonArrayNamed("definitions", element);
            baseDataValidator.reset().parameter("definitions").value((Object)jsonProvisioningCriteria).jsonArrayNotEmpty();
            for (i = 0; i < jsonProvisioningCriteria.size(); ++i) {
                JsonObject jsonObject = jsonProvisioningCriteria.get(i).getAsJsonObject();
                this.fromApiJsonHelper.checkForUnsupportedParameters(jsonObject, (Collection)provisioningcriteriaSupportedParams);
                Long categoryId = this.fromApiJsonHelper.extractLongNamed("categoryId", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("definitions").parameterAtIndexArray("categoryId", Integer.valueOf(i + 1)).value((Object)categoryId).notNull().longGreaterThanZero();
                Long minimumAge = this.fromApiJsonHelper.extractLongNamed("minAge", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("minAge").parameterAtIndexArray("minAge", Integer.valueOf(i + 1)).value((Object)minimumAge).notNull().longZeroOrGreater();
                Long maximumAge = this.fromApiJsonHelper.extractLongNamed("maxAge", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("maxAge").parameterAtIndexArray("maxAge", Integer.valueOf(i + 1)).value((Object)maximumAge).notNull().longGreaterThanNumber("minAge", minimumAge, i + 1);
                BigDecimal provisioningpercentage = this.fromApiJsonHelper.extractBigDecimalNamed("provisioningPercentage", (JsonElement)jsonObject, locale);
                baseDataValidator.reset().parameter("provisioningPercentage").parameterAtIndexArray("provisioningPercentage", Integer.valueOf(i + 1)).value((Object)provisioningpercentage).notNull().zeroOrPositiveAmount();
                Long liabilityAccountId = this.fromApiJsonHelper.extractLongNamed("liabilityAccount", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("liabilityAccount").parameterAtIndexArray("liabilityAccount", Integer.valueOf(i + 1)).value((Object)liabilityAccountId).notNull().longGreaterThanZero();
                Long expenseAccountId = this.fromApiJsonHelper.extractLongNamed("expenseAccount", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("expenseAccount").parameterAtIndexArray("expenseAccount", Integer.valueOf(i + 1)).value((Object)expenseAccountId).notNull().longGreaterThanZero();
            }
        } else {
            baseDataValidator.reset().parameter("definitions").jsonArrayNotEmpty();
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForUpdate(String json) {
        int i;
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new ProvisioningCriteriaCannotBeCreatedException("error.msg.provisioningcriteria.cannot.be.updated", "update params are missing in the request", new Object[0]);
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParametersForUpdate);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("provisioningcriteria");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
        if (this.fromApiJsonHelper.parameterExists("criteriaName", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("criteriaName", element);
            baseDataValidator.reset().parameter("criteriaName").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(200));
        }
        if (this.fromApiJsonHelper.parameterExists("loanProducts", element)) {
            JsonArray jsonloanProducts = this.fromApiJsonHelper.extractJsonArrayNamed("loanProducts", element);
            baseDataValidator.reset().parameter("loanProducts").value((Object)jsonloanProducts).jsonArrayNotEmpty();
            i = 0;
            for (JsonElement obj : jsonloanProducts) {
                Long productId = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)obj.getAsJsonObject());
                baseDataValidator.reset().parameter("loanProducts").parameterAtIndexArray("id", Integer.valueOf(i + 1)).value((Object)productId).notNull().longGreaterThanZero();
                ++i;
            }
        }
        if (this.fromApiJsonHelper.parameterExists("definitions", element)) {
            JsonArray jsonProvisioningCriteria = this.fromApiJsonHelper.extractJsonArrayNamed("definitions", element);
            baseDataValidator.reset().parameter("definitions").value((Object)jsonProvisioningCriteria).jsonArrayNotEmpty();
            for (i = 0; i < jsonProvisioningCriteria.size(); ++i) {
                JsonObject jsonObject = jsonProvisioningCriteria.get(i).getAsJsonObject();
                Long categoryId = this.fromApiJsonHelper.extractLongNamed("categoryId", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("definitions").parameterAtIndexArray("categoryId", Integer.valueOf(i + 1)).value((Object)categoryId).notNull().longGreaterThanZero();
                Long minimumAge = this.fromApiJsonHelper.extractLongNamed("minAge", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("definitions").parameterAtIndexArray("minAge", Integer.valueOf(i + 1)).value((Object)minimumAge).notNull().longZeroOrGreater();
                Long maximumAge = this.fromApiJsonHelper.extractLongNamed("maxAge", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("maxAge").parameterAtIndexArray("maxAge", Integer.valueOf(i + 1)).value((Object)maximumAge).notNull().longGreaterThanNumber("minAge", minimumAge, i + 1);
                BigDecimal provisioningpercentage = this.fromApiJsonHelper.extractBigDecimalNamed("provisioningPercentage", (JsonElement)jsonObject, locale);
                baseDataValidator.reset().parameter("definitions").parameterAtIndexArray("provisioningPercentage", Integer.valueOf(i + 1)).value((Object)provisioningpercentage).notNull().zeroOrPositiveAmount();
                Long liabilityAccountId = this.fromApiJsonHelper.extractLongNamed("liabilityAccount", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("definitions").parameterAtIndexArray("liabilityAccount", Integer.valueOf(i + 1)).value((Object)liabilityAccountId).notNull().longGreaterThanZero();
                Long expenseAccountId = this.fromApiJsonHelper.extractLongNamed("expenseAccount", (JsonElement)jsonObject);
                baseDataValidator.reset().parameter("definitions").parameterAtIndexArray("expenseAccount", Integer.valueOf(i + 1)).value((Object)expenseAccountId).notNull().longGreaterThanZero();
            }
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

