/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.monetary.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.organisation.monetary.data.CurrencyUpdateRequest;
import org.apache.fineract.organisation.monetary.data.CurrencyUpdateResponse;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrency;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrencyRepository;
import org.apache.fineract.organisation.monetary.exception.CurrencyInUseException;
import org.apache.fineract.organisation.monetary.service.CurrencyWritePlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.springframework.transaction.annotation.Transactional;

public class CurrencyWritePlatformServiceJpaRepositoryImpl
implements CurrencyWritePlatformService {
    private final ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository;
    private final OrganisationCurrencyRepository organisationCurrencyRepository;
    private final LoanProductReadPlatformService loanProductService;
    private final SavingsProductReadPlatformService savingsProductService;
    private final ChargeReadPlatformService chargeService;

    @Transactional
    public CurrencyUpdateResponse updateAllowedCurrencies(CurrencyUpdateRequest request) {
        List currencies = request.getCurrencies();
        ArrayList<String> allowedCurrencyCodes = new ArrayList<String>();
        HashSet<OrganisationCurrency> allowedCurrencies = new HashSet<OrganisationCurrency>();
        for (String currencyCode : currencies) {
            ApplicationCurrency currency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currencyCode);
            OrganisationCurrency allowedCurrency = currency.toOrganisationCurrency();
            allowedCurrencyCodes.add(currencyCode);
            allowedCurrencies.add(allowedCurrency);
        }
        for (OrganisationCurrency priorCurrency : this.organisationCurrencyRepository.findAll()) {
            if (allowedCurrencyCodes.contains(priorCurrency.getCode()) || this.loanProductService.retrieveAllLoanProductsForCurrency(priorCurrency.getCode()).isEmpty() && this.savingsProductService.retrieveAllForCurrency(priorCurrency.getCode()).isEmpty() && this.chargeService.retrieveAllChargesForCurrency(priorCurrency.getCode()).isEmpty()) continue;
            throw new CurrencyInUseException(priorCurrency.getCode());
        }
        this.organisationCurrencyRepository.deleteAll();
        this.organisationCurrencyRepository.saveAll(allowedCurrencies);
        return CurrencyUpdateResponse.builder().currencies(allowedCurrencyCodes).build();
    }

    @Generated
    public CurrencyWritePlatformServiceJpaRepositoryImpl(ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository, OrganisationCurrencyRepository organisationCurrencyRepository, LoanProductReadPlatformService loanProductService, SavingsProductReadPlatformService savingsProductService, ChargeReadPlatformService chargeService) {
        this.applicationCurrencyRepository = applicationCurrencyRepository;
        this.organisationCurrencyRepository = organisationCurrencyRepository;
        this.loanProductService = loanProductService;
        this.savingsProductService = savingsProductService;
        this.chargeService = chargeService;
    }
}

