/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobEmailAttachmentFileFormat;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_report_mailing_job", uniqueConstraints={@UniqueConstraint(columnNames={"name"}, name="unique_name")})
public class ReportMailingJob
extends AbstractAuditableCustom
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -2197602941230009227L;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="description", nullable=true)
    private String description;
    @Column(name="start_datetime", nullable=false)
    private LocalDateTime startDateTime;
    @Column(name="recurrence", nullable=true)
    private String recurrence;
    @Column(name="email_recipients", nullable=false)
    private String emailRecipients;
    @Column(name="email_subject", nullable=false)
    private String emailSubject;
    @Column(name="email_message", nullable=false)
    private String emailMessage;
    @Column(name="email_attachment_file_format", nullable=false)
    private String emailAttachmentFileFormat;
    @ManyToOne
    @JoinColumn(name="stretchy_report_id", nullable=false)
    private Report stretchyReport;
    @Column(name="stretchy_report_param_map", nullable=true)
    private String stretchyReportParamMap;
    @Column(name="previous_run_datetime", nullable=true)
    private LocalDateTime previousRunDateTime;
    @Column(name="next_run_datetime", nullable=true)
    private LocalDateTime nextRunDateTime;
    @Column(name="previous_run_status", nullable=true)
    private String previousRunStatus;
    @Column(name="previous_run_error_log", nullable=true)
    private String previousRunErrorLog;
    @Column(name="previous_run_error_message", nullable=true)
    private String previousRunErrorMessage;
    @Column(name="number_of_runs", nullable=false)
    private Integer numberOfRuns;
    @Column(name="is_active", nullable=false)
    private boolean isActive;
    @Column(name="is_deleted", nullable=false)
    private boolean isDeleted;
    @ManyToOne(optional=false)
    @JoinColumn(name="run_as_userid", nullable=false)
    private AppUser runAsUser;

    public static ReportMailingJob newInstance(String name, String description, LocalDateTime startDateTime, String recurrence, String emailRecipients, String emailSubject, String emailMessage, ReportMailingJobEmailAttachmentFileFormat emailAttachmentFileFormat, Report stretchyReport, String stretchyReportParamMap, boolean isActive, AppUser runAsUser) {
        return new ReportMailingJob().setName(name).setDescription(description).setStartDateTime(startDateTime).setRecurrence(recurrence).setEmailRecipients(emailRecipients).setEmailSubject(emailSubject).setEmailMessage(emailMessage).setEmailAttachmentFileFormat(emailAttachmentFileFormat.getValue()).setStretchyReport(stretchyReport).setStretchyReportParamMap(stretchyReportParamMap).setActive(isActive).setDeleted(false).setRunAsUser(runAsUser);
    }

    public static ReportMailingJob newInstance(JsonCommand jsonCommand, Report stretchyReport, AppUser runAsUser) {
        String startDateTimeString;
        String name = jsonCommand.stringValueOfParameterNamed("name");
        String description = jsonCommand.stringValueOfParameterNamed("description");
        String recurrence = jsonCommand.stringValueOfParameterNamed("recurrence");
        boolean isActive = jsonCommand.booleanPrimitiveValueOfParameterNamed("isActive");
        String emailRecipients = jsonCommand.stringValueOfParameterNamed("emailRecipients");
        String emailSubject = jsonCommand.stringValueOfParameterNamed("emailSubject");
        String emailMessage = jsonCommand.stringValueOfParameterNamed("emailMessage");
        String stretchyReportParamMap = jsonCommand.stringValueOfParameterNamed("stretchyReportParamMap");
        Integer emailAttachmentFileFormatId = jsonCommand.integerValueOfParameterNamed("emailAttachmentFileFormatId");
        ReportMailingJobEmailAttachmentFileFormat emailAttachmentFileFormat = ReportMailingJobEmailAttachmentFileFormat.newInstance((Integer)emailAttachmentFileFormatId);
        LocalDateTime startDateTime = LocalDateTime.now(DateUtils.getDateTimeZoneOfTenant());
        if (jsonCommand.hasParameter("startDateTime") && (startDateTimeString = jsonCommand.stringValueOfParameterNamed("startDateTime")) != null) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(jsonCommand.dateFormat()).withLocale(jsonCommand.extractLocale());
            startDateTime = LocalDateTime.parse(startDateTimeString, dateTimeFormatter);
        }
        return new ReportMailingJob().setName(name).setDescription(description).setStartDateTime(startDateTime).setRecurrence(recurrence).setEmailRecipients(emailRecipients).setEmailSubject(emailSubject).setEmailMessage(emailMessage).setEmailAttachmentFileFormat(emailAttachmentFileFormat.getValue()).setStretchyReport(stretchyReport).setStretchyReportParamMap(stretchyReportParamMap).setNextRunDateTime(startDateTime).setActive(isActive).setDeleted(false).setRunAsUser(runAsUser);
    }

    public Map<String, Object> update(JsonCommand jsonCommand) {
        String newStartDateTimeString;
        ReportMailingJobEmailAttachmentFileFormat emailAttachmentFileFormat;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>();
        if (jsonCommand.isChangeInStringParameterNamed("name", this._persistence_get_name())) {
            String name = jsonCommand.stringValueOfParameterNamed("name");
            actualChanges.put("name", name);
            this._persistence_set_name(name);
        }
        if (jsonCommand.isChangeInStringParameterNamed("description", this._persistence_get_description())) {
            String description = jsonCommand.stringValueOfParameterNamed("description");
            actualChanges.put("description", description);
            this._persistence_set_description(description);
        }
        if (jsonCommand.isChangeInStringParameterNamed("recurrence", this._persistence_get_recurrence())) {
            String recurrence = jsonCommand.stringValueOfParameterNamed("recurrence");
            actualChanges.put("recurrence", recurrence);
            this._persistence_set_recurrence(recurrence);
        }
        if (jsonCommand.isChangeInBooleanParameterNamed("isActive", Boolean.valueOf(this._persistence_get_isActive()))) {
            boolean isActive = jsonCommand.booleanPrimitiveValueOfParameterNamed("isActive");
            actualChanges.put("isActive", isActive);
            this._persistence_set_isActive(isActive);
        }
        if (jsonCommand.isChangeInStringParameterNamed("emailRecipients", this._persistence_get_emailRecipients())) {
            String emailRecipients = jsonCommand.stringValueOfParameterNamed("emailRecipients");
            actualChanges.put("emailRecipients", emailRecipients);
            this._persistence_set_emailRecipients(emailRecipients);
        }
        if (jsonCommand.isChangeInStringParameterNamed("emailSubject", this._persistence_get_emailSubject())) {
            String emailSubject = jsonCommand.stringValueOfParameterNamed("emailSubject");
            actualChanges.put("emailSubject", emailSubject);
            this._persistence_set_emailSubject(emailSubject);
        }
        if (jsonCommand.isChangeInStringParameterNamed("emailMessage", this._persistence_get_emailMessage())) {
            String emailMessage = jsonCommand.stringValueOfParameterNamed("emailMessage");
            actualChanges.put("emailMessage", emailMessage);
            this._persistence_set_emailMessage(emailMessage);
        }
        if (jsonCommand.isChangeInStringParameterNamed("stretchyReportParamMap", this._persistence_get_stretchyReportParamMap())) {
            String stretchyReportParamMap = jsonCommand.stringValueOfParameterNamed("stretchyReportParamMap");
            actualChanges.put("stretchyReportParamMap", stretchyReportParamMap);
            this._persistence_set_stretchyReportParamMap(stretchyReportParamMap);
        }
        if (jsonCommand.isChangeInIntegerParameterNamed("emailAttachmentFileFormatId", (emailAttachmentFileFormat = ReportMailingJobEmailAttachmentFileFormat.newInstance((String)this._persistence_get_emailAttachmentFileFormat())).getId())) {
            Integer emailAttachmentFileFormatId = jsonCommand.integerValueOfParameterNamed("emailAttachmentFileFormatId");
            actualChanges.put("emailAttachmentFileFormatId", emailAttachmentFileFormatId);
            ReportMailingJobEmailAttachmentFileFormat newEmailAttachmentFileFormat = ReportMailingJobEmailAttachmentFileFormat.newInstance((Integer)emailAttachmentFileFormatId);
            this._persistence_set_emailAttachmentFileFormat(newEmailAttachmentFileFormat.getValue());
        }
        if (!StringUtils.isEmpty((CharSequence)(newStartDateTimeString = jsonCommand.stringValueOfParameterNamed("startDateTime")))) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(jsonCommand.dateFormat()).withLocale(jsonCommand.extractLocale());
            LocalDateTime newStartDateTime = LocalDateTime.parse(newStartDateTimeString, dateTimeFormatter);
            LocalDateTime oldStartDateTime = this._persistence_get_startDateTime();
            if (oldStartDateTime != null && !newStartDateTime.equals(oldStartDateTime)) {
                actualChanges.put("startDateTime", newStartDateTimeString);
                this._persistence_set_startDateTime(newStartDateTime);
            }
        }
        Long currentStretchyReportId = null;
        if (this._persistence_get_stretchyReport() != null) {
            currentStretchyReportId = (Long)this._persistence_get_stretchyReport().getId();
        }
        if (jsonCommand.isChangeInLongParameterNamed("stretchyReportId", currentStretchyReportId)) {
            Long updatedStretchyReportId = jsonCommand.longValueOfParameterNamed("stretchyReportId");
            actualChanges.put("stretchyReportId", updatedStretchyReportId);
        }
        return actualChanges;
    }

    public void delete() {
        this._persistence_set_isDeleted(true);
        this._persistence_set_isActive(false);
        this._persistence_set_name(this._persistence_get_name() + "_deleted_" + String.valueOf(this.getId()));
    }

    public void increaseNumberOfRunsByOne() {
        Integer n = this._persistence_get_numberOfRuns();
        this._persistence_set_numberOfRuns(Integer.valueOf(this._persistence_get_numberOfRuns() + 1));
    }

    @Generated
    public String getName() {
        return this._persistence_get_name();
    }

    @Generated
    public String getDescription() {
        return this._persistence_get_description();
    }

    @Generated
    public LocalDateTime getStartDateTime() {
        return this._persistence_get_startDateTime();
    }

    @Generated
    public String getRecurrence() {
        return this._persistence_get_recurrence();
    }

    @Generated
    public String getEmailRecipients() {
        return this._persistence_get_emailRecipients();
    }

    @Generated
    public String getEmailSubject() {
        return this._persistence_get_emailSubject();
    }

    @Generated
    public String getEmailMessage() {
        return this._persistence_get_emailMessage();
    }

    @Generated
    public String getEmailAttachmentFileFormat() {
        return this._persistence_get_emailAttachmentFileFormat();
    }

    @Generated
    public Report getStretchyReport() {
        return this._persistence_get_stretchyReport();
    }

    @Generated
    public String getStretchyReportParamMap() {
        return this._persistence_get_stretchyReportParamMap();
    }

    @Generated
    public LocalDateTime getPreviousRunDateTime() {
        return this._persistence_get_previousRunDateTime();
    }

    @Generated
    public LocalDateTime getNextRunDateTime() {
        return this._persistence_get_nextRunDateTime();
    }

    @Generated
    public String getPreviousRunStatus() {
        return this._persistence_get_previousRunStatus();
    }

    @Generated
    public String getPreviousRunErrorLog() {
        return this._persistence_get_previousRunErrorLog();
    }

    @Generated
    public String getPreviousRunErrorMessage() {
        return this._persistence_get_previousRunErrorMessage();
    }

    @Generated
    public Integer getNumberOfRuns() {
        return this._persistence_get_numberOfRuns();
    }

    @Generated
    public boolean isActive() {
        return this._persistence_get_isActive();
    }

    @Generated
    public boolean isDeleted() {
        return this._persistence_get_isDeleted();
    }

    @Generated
    public AppUser getRunAsUser() {
        return this._persistence_get_runAsUser();
    }

    @Generated
    public ReportMailingJob setName(String name) {
        this._persistence_set_name(name);
        return this;
    }

    @Generated
    public ReportMailingJob setDescription(String description) {
        this._persistence_set_description(description);
        return this;
    }

    @Generated
    public ReportMailingJob setStartDateTime(LocalDateTime startDateTime) {
        this._persistence_set_startDateTime(startDateTime);
        return this;
    }

    @Generated
    public ReportMailingJob setRecurrence(String recurrence) {
        this._persistence_set_recurrence(recurrence);
        return this;
    }

    @Generated
    public ReportMailingJob setEmailRecipients(String emailRecipients) {
        this._persistence_set_emailRecipients(emailRecipients);
        return this;
    }

    @Generated
    public ReportMailingJob setEmailSubject(String emailSubject) {
        this._persistence_set_emailSubject(emailSubject);
        return this;
    }

    @Generated
    public ReportMailingJob setEmailMessage(String emailMessage) {
        this._persistence_set_emailMessage(emailMessage);
        return this;
    }

    @Generated
    public ReportMailingJob setEmailAttachmentFileFormat(String emailAttachmentFileFormat) {
        this._persistence_set_emailAttachmentFileFormat(emailAttachmentFileFormat);
        return this;
    }

    @Generated
    public ReportMailingJob setStretchyReport(Report stretchyReport) {
        this._persistence_set_stretchyReport(stretchyReport);
        return this;
    }

    @Generated
    public ReportMailingJob setStretchyReportParamMap(String stretchyReportParamMap) {
        this._persistence_set_stretchyReportParamMap(stretchyReportParamMap);
        return this;
    }

    @Generated
    public ReportMailingJob setPreviousRunDateTime(LocalDateTime previousRunDateTime) {
        this._persistence_set_previousRunDateTime(previousRunDateTime);
        return this;
    }

    @Generated
    public ReportMailingJob setNextRunDateTime(LocalDateTime nextRunDateTime) {
        this._persistence_set_nextRunDateTime(nextRunDateTime);
        return this;
    }

    @Generated
    public ReportMailingJob setPreviousRunStatus(String previousRunStatus) {
        this._persistence_set_previousRunStatus(previousRunStatus);
        return this;
    }

    @Generated
    public ReportMailingJob setPreviousRunErrorLog(String previousRunErrorLog) {
        this._persistence_set_previousRunErrorLog(previousRunErrorLog);
        return this;
    }

    @Generated
    public ReportMailingJob setPreviousRunErrorMessage(String previousRunErrorMessage) {
        this._persistence_set_previousRunErrorMessage(previousRunErrorMessage);
        return this;
    }

    @Generated
    public ReportMailingJob setNumberOfRuns(Integer numberOfRuns) {
        this._persistence_set_numberOfRuns(numberOfRuns);
        return this;
    }

    @Generated
    public ReportMailingJob setActive(boolean isActive) {
        this._persistence_set_isActive(isActive);
        return this;
    }

    @Generated
    public ReportMailingJob setDeleted(boolean isDeleted) {
        this._persistence_set_isDeleted(isDeleted);
        return this;
    }

    @Generated
    public ReportMailingJob setRunAsUser(AppUser runAsUser) {
        this._persistence_set_runAsUser(runAsUser);
        return this;
    }

    @Generated
    public ReportMailingJob() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ReportMailingJob();
    }

    public Object _persistence_get(String string) {
        if (string == "previousRunErrorMessage") {
            return this.previousRunErrorMessage;
        }
        if (string == "previousRunDateTime") {
            return this.previousRunDateTime;
        }
        if (string == "stretchyReportParamMap") {
            return this.stretchyReportParamMap;
        }
        if (string == "previousRunStatus") {
            return this.previousRunStatus;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "emailRecipients") {
            return this.emailRecipients;
        }
        if (string == "numberOfRuns") {
            return this.numberOfRuns;
        }
        if (string == "isActive") {
            return this.isActive;
        }
        if (string == "emailSubject") {
            return this.emailSubject;
        }
        if (string == "recurrence") {
            return this.recurrence;
        }
        if (string == "runAsUser") {
            return this.runAsUser;
        }
        if (string == "nextRunDateTime") {
            return this.nextRunDateTime;
        }
        if (string == "startDateTime") {
            return this.startDateTime;
        }
        if (string == "isDeleted") {
            return this.isDeleted;
        }
        if (string == "emailMessage") {
            return this.emailMessage;
        }
        if (string == "previousRunErrorLog") {
            return this.previousRunErrorLog;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "stretchyReport") {
            return this.stretchyReport;
        }
        if (string == "emailAttachmentFileFormat") {
            return this.emailAttachmentFileFormat;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "previousRunErrorMessage") {
            this.previousRunErrorMessage = (String)object;
            return;
        }
        if (string == "previousRunDateTime") {
            this.previousRunDateTime = (LocalDateTime)object;
            return;
        }
        if (string == "stretchyReportParamMap") {
            this.stretchyReportParamMap = (String)object;
            return;
        }
        if (string == "previousRunStatus") {
            this.previousRunStatus = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "emailRecipients") {
            this.emailRecipients = (String)object;
            return;
        }
        if (string == "numberOfRuns") {
            this.numberOfRuns = (Integer)object;
            return;
        }
        if (string == "isActive") {
            this.isActive = (Boolean)object;
            return;
        }
        if (string == "emailSubject") {
            this.emailSubject = (String)object;
            return;
        }
        if (string == "recurrence") {
            this.recurrence = (String)object;
            return;
        }
        if (string == "runAsUser") {
            this.runAsUser = (AppUser)object;
            return;
        }
        if (string == "nextRunDateTime") {
            this.nextRunDateTime = (LocalDateTime)object;
            return;
        }
        if (string == "startDateTime") {
            this.startDateTime = (LocalDateTime)object;
            return;
        }
        if (string == "isDeleted") {
            this.isDeleted = (Boolean)object;
            return;
        }
        if (string == "emailMessage") {
            this.emailMessage = (String)object;
            return;
        }
        if (string == "previousRunErrorLog") {
            this.previousRunErrorLog = (String)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "stretchyReport") {
            this.stretchyReport = (Report)object;
            return;
        }
        if (string == "emailAttachmentFileFormat") {
            this.emailAttachmentFileFormat = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_previousRunErrorMessage() {
        this._persistence_checkFetched("previousRunErrorMessage");
        return this.previousRunErrorMessage;
    }

    public void _persistence_set_previousRunErrorMessage(String string) {
        this._persistence_checkFetchedForSet("previousRunErrorMessage");
        this._persistence_propertyChange("previousRunErrorMessage", (Object)this.previousRunErrorMessage, (Object)string);
        this.previousRunErrorMessage = string;
    }

    public LocalDateTime _persistence_get_previousRunDateTime() {
        this._persistence_checkFetched("previousRunDateTime");
        return this.previousRunDateTime;
    }

    public void _persistence_set_previousRunDateTime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("previousRunDateTime");
        this._persistence_propertyChange("previousRunDateTime", (Object)this.previousRunDateTime, (Object)localDateTime);
        this.previousRunDateTime = localDateTime;
    }

    public String _persistence_get_stretchyReportParamMap() {
        this._persistence_checkFetched("stretchyReportParamMap");
        return this.stretchyReportParamMap;
    }

    public void _persistence_set_stretchyReportParamMap(String string) {
        this._persistence_checkFetchedForSet("stretchyReportParamMap");
        this._persistence_propertyChange("stretchyReportParamMap", (Object)this.stretchyReportParamMap, (Object)string);
        this.stretchyReportParamMap = string;
    }

    public String _persistence_get_previousRunStatus() {
        this._persistence_checkFetched("previousRunStatus");
        return this.previousRunStatus;
    }

    public void _persistence_set_previousRunStatus(String string) {
        this._persistence_checkFetchedForSet("previousRunStatus");
        this._persistence_propertyChange("previousRunStatus", (Object)this.previousRunStatus, (Object)string);
        this.previousRunStatus = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", (Object)this.description, (Object)string);
        this.description = string;
    }

    public String _persistence_get_emailRecipients() {
        this._persistence_checkFetched("emailRecipients");
        return this.emailRecipients;
    }

    public void _persistence_set_emailRecipients(String string) {
        this._persistence_checkFetchedForSet("emailRecipients");
        this._persistence_propertyChange("emailRecipients", (Object)this.emailRecipients, (Object)string);
        this.emailRecipients = string;
    }

    public Integer _persistence_get_numberOfRuns() {
        this._persistence_checkFetched("numberOfRuns");
        return this.numberOfRuns;
    }

    public void _persistence_set_numberOfRuns(Integer n) {
        this._persistence_checkFetchedForSet("numberOfRuns");
        this._persistence_propertyChange("numberOfRuns", (Object)this.numberOfRuns, (Object)n);
        this.numberOfRuns = n;
    }

    public boolean _persistence_get_isActive() {
        this._persistence_checkFetched("isActive");
        return this.isActive;
    }

    public void _persistence_set_isActive(boolean bl) {
        this._persistence_checkFetchedForSet("isActive");
        this._persistence_propertyChange("isActive", (Object)new Boolean(this.isActive), (Object)new Boolean(bl));
        this.isActive = bl;
    }

    public String _persistence_get_emailSubject() {
        this._persistence_checkFetched("emailSubject");
        return this.emailSubject;
    }

    public void _persistence_set_emailSubject(String string) {
        this._persistence_checkFetchedForSet("emailSubject");
        this._persistence_propertyChange("emailSubject", (Object)this.emailSubject, (Object)string);
        this.emailSubject = string;
    }

    public String _persistence_get_recurrence() {
        this._persistence_checkFetched("recurrence");
        return this.recurrence;
    }

    public void _persistence_set_recurrence(String string) {
        this._persistence_checkFetchedForSet("recurrence");
        this._persistence_propertyChange("recurrence", (Object)this.recurrence, (Object)string);
        this.recurrence = string;
    }

    public AppUser _persistence_get_runAsUser() {
        this._persistence_checkFetched("runAsUser");
        return this.runAsUser;
    }

    public void _persistence_set_runAsUser(AppUser appUser) {
        this._persistence_checkFetchedForSet("runAsUser");
        this._persistence_propertyChange("runAsUser", (Object)this.runAsUser, (Object)appUser);
        this.runAsUser = appUser;
    }

    public LocalDateTime _persistence_get_nextRunDateTime() {
        this._persistence_checkFetched("nextRunDateTime");
        return this.nextRunDateTime;
    }

    public void _persistence_set_nextRunDateTime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("nextRunDateTime");
        this._persistence_propertyChange("nextRunDateTime", (Object)this.nextRunDateTime, (Object)localDateTime);
        this.nextRunDateTime = localDateTime;
    }

    public LocalDateTime _persistence_get_startDateTime() {
        this._persistence_checkFetched("startDateTime");
        return this.startDateTime;
    }

    public void _persistence_set_startDateTime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("startDateTime");
        this._persistence_propertyChange("startDateTime", (Object)this.startDateTime, (Object)localDateTime);
        this.startDateTime = localDateTime;
    }

    public boolean _persistence_get_isDeleted() {
        this._persistence_checkFetched("isDeleted");
        return this.isDeleted;
    }

    public void _persistence_set_isDeleted(boolean bl) {
        this._persistence_checkFetchedForSet("isDeleted");
        this._persistence_propertyChange("isDeleted", (Object)new Boolean(this.isDeleted), (Object)new Boolean(bl));
        this.isDeleted = bl;
    }

    public String _persistence_get_emailMessage() {
        this._persistence_checkFetched("emailMessage");
        return this.emailMessage;
    }

    public void _persistence_set_emailMessage(String string) {
        this._persistence_checkFetchedForSet("emailMessage");
        this._persistence_propertyChange("emailMessage", (Object)this.emailMessage, (Object)string);
        this.emailMessage = string;
    }

    public String _persistence_get_previousRunErrorLog() {
        this._persistence_checkFetched("previousRunErrorLog");
        return this.previousRunErrorLog;
    }

    public void _persistence_set_previousRunErrorLog(String string) {
        this._persistence_checkFetchedForSet("previousRunErrorLog");
        this._persistence_propertyChange("previousRunErrorLog", (Object)this.previousRunErrorLog, (Object)string);
        this.previousRunErrorLog = string;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", (Object)this.name, (Object)string);
        this.name = string;
    }

    public Report _persistence_get_stretchyReport() {
        this._persistence_checkFetched("stretchyReport");
        return this.stretchyReport;
    }

    public void _persistence_set_stretchyReport(Report report) {
        this._persistence_checkFetchedForSet("stretchyReport");
        this._persistence_propertyChange("stretchyReport", (Object)this.stretchyReport, (Object)report);
        this.stretchyReport = report;
    }

    public String _persistence_get_emailAttachmentFileFormat() {
        this._persistence_checkFetched("emailAttachmentFileFormat");
        return this.emailAttachmentFileFormat;
    }

    public void _persistence_set_emailAttachmentFileFormat(String string) {
        this._persistence_checkFetchedForSet("emailAttachmentFileFormat");
        this._persistence_propertyChange("emailAttachmentFileFormat", (Object)this.emailAttachmentFileFormat, (Object)string);
        this.emailAttachmentFileFormat = string;
    }
}

