/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobDetailDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> JOB_UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("displayName", "active", "cronExpression"));

    @Autowired
    public JobDetailDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        boolean atLeastOneParameterPassedForUpdate = false;
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)JOB_UPDATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("schedulerjob");
        if (this.fromApiJsonHelper.parameterExists("displayName", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String displayName = this.fromApiJsonHelper.extractStringNamed("displayName", element);
            baseDataValidator.reset().parameter("displayName").value((Object)displayName).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists("cronExpression", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String cronExpression = this.fromApiJsonHelper.extractStringNamed("cronExpression", element);
            baseDataValidator.reset().parameter("cronExpression").value((Object)cronExpression).notBlank().validateCronExpression();
        }
        if (this.fromApiJsonHelper.parameterExists("active", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String status = this.fromApiJsonHelper.extractStringNamed("active", element);
            baseDataValidator.reset().parameter("active").value((Object)status).notBlank().validateForBooleanValue();
        }
        if (!atLeastOneParameterPassedForUpdate) {
            Object forceError = null;
            baseDataValidator.reset().anyOfNotNull(new Object[]{forceError});
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

