/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.hooks.domain.Hook;
import org.apache.fineract.infrastructure.hooks.domain.HookConfiguration;
import org.apache.fineract.infrastructure.hooks.domain.HookConfigurationRepository;
import org.apache.fineract.infrastructure.hooks.processor.HookProcessor;
import org.apache.fineract.infrastructure.hooks.processor.ProcessorHelper;
import org.apache.fineract.infrastructure.hooks.processor.WebHookService;
import org.apache.fineract.infrastructure.hooks.processor.data.SmsProviderData;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.template.service.TemplateMergeService;
import org.springframework.stereotype.Service;
import retrofit2.Callback;

@Service
public class TwilioHookProcessor
implements HookProcessor {
    private final HookConfigurationRepository hookConfigurationRepository;
    private final TemplateMergeService templateMergeService;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final ProcessorHelper processorHelper;

    public void process(Hook hook, String payload, String entityName, String actionName, FineractContext context) throws IOException {
        SmsProviderData smsProviderData = new SmsProviderData(hook.getConfig());
        this.sendRequest(smsProviderData, payload, entityName, actionName, hook, context);
    }

    private void sendRequest(SmsProviderData smsProviderData, String payload, String entityName, String actionName, Hook hook, FineractContext context) throws IOException {
        WebHookService service = this.processorHelper.createWebHookService(smsProviderData.getUrl());
        Callback callback = this.processorHelper.createCallback(smsProviderData.getUrl());
        String apiKey = this.hookConfigurationRepository.findOneByHookIdAndFieldName((Long)hook.getId(), "Api Key");
        if (apiKey == null) {
            smsProviderData.setUrl(null);
            smsProviderData.setEndpoint(System.getProperty("baseUrl"));
            smsProviderData.setTenantId(context.getTenantContext().getTenantIdentifier());
            smsProviderData.setMifosToken(context.getAuthTokenContext());
            apiKey = (String)service.sendSmsBridgeConfigRequest(smsProviderData).execute().body();
            HookConfiguration apiKeyEntry = HookConfiguration.createNew((Hook)hook, (String)"string", (String)"Api Key", (String)apiKey);
            this.hookConfigurationRepository.save((Object)apiKeyEntry);
        }
        if (apiKey != null && !apiKey.equals("")) {
            JsonObject json;
            if (hook.getUgdTemplate() != null) {
                entityName = "sms";
                actionName = "send";
                json = this.processUgdTemplate(payload, hook);
                if (json == null) {
                    return;
                }
            } else {
                json = JsonParser.parseString((String)payload).getAsJsonObject();
            }
            service.sendSmsBridgeRequest(entityName, actionName, context.getTenantContext().getTenantIdentifier(), apiKey, json).enqueue(callback);
        }
    }

    private JsonObject processUgdTemplate(String payload, Hook hook) throws IOException {
        Long clientId;
        Client client;
        String mobileNo;
        JsonObject json = null;
        HashMap map = (HashMap)new ObjectMapper().readValue(payload, HashMap.class);
        map.put("BASE_URI", System.getProperty("baseUrl"));
        if (map.containsKey("clientId") && (mobileNo = (client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId = Long.valueOf(Integer.toString((Integer)map.get("clientId"))))).mobileNo()) != null && !mobileNo.isEmpty()) {
            String compiledMessage = this.templateMergeService.compile(hook.getUgdTemplate(), (Map)map).replace("<p>", "").replace("</p>", "");
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            jsonMap.put("mobileNo", mobileNo);
            jsonMap.put("message", compiledMessage);
            String jsonString = new Gson().toJson(jsonMap);
            json = JsonParser.parseString((String)jsonString).getAsJsonObject();
        }
        return json;
    }

    @Generated
    public TwilioHookProcessor(HookConfigurationRepository hookConfigurationRepository, TemplateMergeService templateMergeService, ClientRepositoryWrapper clientRepositoryWrapper, ProcessorHelper processorHelper) {
        this.hookConfigurationRepository = hookConfigurationRepository;
        this.templateMergeService = templateMergeService;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.processorHelper = processorHelper;
    }
}

