/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.dataqueries.api.EntityDatatableChecksApiResourceSwagger;
import org.apache.fineract.infrastructure.dataqueries.data.EntityDataTableChecksTemplateData;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.springframework.stereotype.Component;

@Path(value="/v1/entityDatatableChecks")
@Component
@Tag(name="Entity Data Table", description="This defines Entity-Datatable Check.")
public class EntityDatatableChecksApiResource {
    private final EntityDatatableChecksReadService readEntityDatatableChecksService;
    private final ToApiJsonSerializer<GenericResultsetData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Entity-Datatable Checks", description="The list capability of Entity-Datatable Checks can support pagination.\n\nOPTIONAL ARGUMENTS\noffset Integer optional, defaults to 0 Indicates the result from which pagination startslimit Integer optional, defaults to 200 Restricts the size of results returned. To override the default and return all entries you must explicitly pass a non-positive integer value for limit e.g. limit=0, or limit=-1\nExample Request:\n\nentityDatatableChecks?offset=0&limit=15")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EntityDatatableChecksApiResourceSwagger.GetEntityDatatableChecksResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="status") @Parameter(description="status") Integer status, @QueryParam(value="entity") @Parameter(description="entity") String entity, @QueryParam(value="productId") @Parameter(description="productId") Long productId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit) {
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).build();
        Page result = this.readEntityDatatableChecksService.retrieveAll(searchParameters, status, entity, productId);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Entity-Datatable Checks Template", description="This is a convenience resource useful for building maintenance user interface screens for Entity-Datatable Checks applications. The template data returned consists of:\n\nAllowed description Lists\nExample Request:\n\nentityDatatableChecks/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EntityDatatableChecksApiResourceSwagger.GetEntityDatatableChecksTemplateResponse.class))})})
    public String getTemplate(@Context UriInfo uriInfo) {
        EntityDataTableChecksTemplateData result = this.readEntityDatatableChecksService.retrieveTemplate();
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create Entity-Datatable Checks", description="Mandatory Fields : \nentity, status, datatableName\n\nNon-Mandatory Fields : \nproductId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=EntityDatatableChecksApiResourceSwagger.PostEntityDatatableChecksTemplateRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EntityDatatableChecksApiResourceSwagger.PostEntityDatatableChecksTemplateResponse.class))})})
    public String createEntityDatatableCheck(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createEntityDatatableChecks(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{entityDatatableCheckId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete Entity-Datatable Checks", description="Deletes an existing Entity-Datatable Check")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EntityDatatableChecksApiResourceSwagger.DeleteEntityDatatableChecksTemplateResponse.class))})})
    public String deleteDatatable(@PathParam(value="entityDatatableCheckId") @Parameter(description="entityDatatableCheckId") long entityDatatableCheckId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteEntityDatatableChecks(entityDatatableCheckId, apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public EntityDatatableChecksApiResource(EntityDatatableChecksReadService readEntityDatatableChecksService, ToApiJsonSerializer<GenericResultsetData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.readEntityDatatableChecksService = readEntityDatatableChecksService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

