/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.codes.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.codes.api.CodesApiResourceSwagger;
import org.apache.fineract.infrastructure.codes.data.CodeData;
import org.apache.fineract.infrastructure.codes.service.CodeReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/codes")
@Component
@Tag(name="Codes", description="Code and code values: Codes represent a specific category of data, their code values are a specific instance of that category.\n\nCodes are mostly system defined which means the code itself comes out of the box and cannot be modified however its code values can be. e.g. 'Customer Identifier', it defaults to a code value of 'Passport' but could be 'Drivers License, National Id' etc")
public class CodesApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "name", "systemDefined"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "CODE";
    private final PlatformSecurityContext context;
    private final CodeReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<CodeData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Codes", description="Returns the list of codes.\n\nExample Requests:\n\ncodes")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CodesApiResourceSwagger.GetCodesResponse.class)))})})
    public String retrieveCodes(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection codes = this.readPlatformService.retrieveAllCodes();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, codes, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Code", description="Creates a code. Codes created through api are always 'user defined' and so system defined is marked as false.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CodesApiResourceSwagger.PostCodesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodesApiResourceSwagger.PostCodesResponse.class))})})
    public String createCode(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCode().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{codeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Code", description="Returns the details of a Code.\n\nExample Requests:\n\ncodes/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodesApiResourceSwagger.GetCodesResponse.class))})})
    public String retrieveCode(@PathParam(value="codeId") @Parameter(description="codeId") Long codeId, @Context UriInfo uriInfo) {
        CodeData code = this.readPlatformService.retrieveCode(codeId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)code, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="name/{codeName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Code", description="Returns the details of a Code.\n\nExample Requests:\n\ncodes/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodesApiResourceSwagger.GetCodesResponse.class))})})
    public String retrieveCodeByName(@PathParam(value="codeName") @Parameter(description="codeName") String codeName, @Context UriInfo uriInfo) {
        CodeData code = this.readPlatformService.retriveCode(codeName);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)code, RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="{codeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Code", description="Updates the details of a code if it is not system defined.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CodesApiResourceSwagger.PutCodesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodesApiResourceSwagger.PutCodesResponse.class))})})
    public String updateCode(@PathParam(value="codeId") @Parameter(description="codeId") Long codeId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCode(codeId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{codeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Code", description="Deletes a code if it is not system defined.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodesApiResourceSwagger.DeleteCodesResponse.class))})})
    public String deleteCode(@PathParam(value="codeId") @Parameter(description="codeId") Long codeId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCode(codeId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public CodesApiResource(PlatformSecurityContext context, CodeReadPlatformService readPlatformService, DefaultToApiJsonSerializer<CodeData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

