/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.office;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class OfficeWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final List<OfficeData> offices;

    public OfficeWorkbookPopulator(List<OfficeData> offices) {
        this.offices = offices;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet officeSheet = workbook.createSheet("Offices");
        this.setLayout(officeSheet);
        this.setLookupTable(officeSheet);
        this.setRules(officeSheet, dateFormat);
        this.setDefaults(officeSheet);
    }

    private void setLookupTable(Sheet officeSheet) {
        int rowIndex = 1;
        for (OfficeData office : this.offices) {
            Row row = officeSheet.createRow(rowIndex);
            this.writeString(7, row, office.getName());
            this.writeLong(8, row, office.getId().longValue());
            ++rowIndex;
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 4000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        this.writeString(0, rowHeader, "Office Name*");
        this.writeString(1, rowHeader, "Parent Office*");
        this.writeString(2, rowHeader, "Parent OfficeId*");
        this.writeString(3, rowHeader, "Opened On Date*");
        this.writeString(4, rowHeader, "External Id*");
        this.writeString(7, rowHeader, "Lookup Offices");
        this.writeString(8, rowHeader, "Lookup OfficeId*");
    }

    private void setRules(Sheet workSheet, String dateFormat) {
        CellRangeAddressList parentOfficeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList OpenedOndateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)workSheet);
        this.setNames(workSheet);
        DataValidationConstraint parentOfficeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint openDateConstraint = validationHelper.createDateConstraint(7, "=TODAY()", null, dateFormat);
        DataValidation parentOfficeValidation = validationHelper.createValidation(parentOfficeNameConstraint, parentOfficeNameRange);
        DataValidation openDateValidation = validationHelper.createValidation(openDateConstraint, OpenedOndateRange);
        workSheet.addValidationData(parentOfficeValidation);
        workSheet.addValidationData(openDateValidation);
    }

    private void setNames(Sheet workSheet) {
        Workbook officeWorkbook = workSheet.getWorkbook();
        Name parentOffice = officeWorkbook.createName();
        parentOffice.setNameName("Office");
        parentOffice.setRefersToFormula("Offices!$H$2:$H$" + (this.offices.size() + 1));
    }

    private void setDefaults(Sheet worksheet) {
        Integer rowNo = 1;
        while (rowNo < 3000) {
            Row row = worksheet.getRow(rowNo.intValue());
            if (row == null) {
                row = worksheet.createRow(rowNo.intValue());
            }
            this.writeFormula(2, row, "IF(ISERROR(VLOOKUP($B" + (rowNo + 1) + ",$H$2:$I$" + (this.offices.size() + 1) + ",2,FALSE)),\"\",(VLOOKUP($B" + (rowNo + 1) + ",$H$2:$I$" + (this.offices.size() + 1) + ",2,FALSE)))");
            Integer n = rowNo;
            rowNo = rowNo + 1;
        }
    }
}

