/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import net.spy.memcached.ops.ConfigurationType;
import net.spy.memcached.ops.GetConfigOperation;
import net.spy.memcached.protocol.binary.OperationImpl;

class GetConfigOperationImpl
extends OperationImpl
implements GetConfigOperation {
    protected final ConfigurationType type;
    static final byte CONFIG_GET_CMD = 96;
    static final int EXTRA_HDR_LEN = 4;

    public GetConfigOperationImpl(ConfigurationType type, GetConfigOperation.Callback cb) {
        super((byte)96, GetConfigOperationImpl.generateOpaque(), cb);
        this.type = type;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.type.getValue(), 0L, EMPTY_BYTES, new Object[0]);
    }

    @Override
    protected void decodePayload(byte[] pl) {
        int flags = GetConfigOperationImpl.decodeInt(pl, 0);
        byte[] data = new byte[pl.length - 4];
        System.arraycopy(pl, 4, data, 0, pl.length - 4);
        GetConfigOperation.Callback gcb = (GetConfigOperation.Callback)this.getCallback();
        gcb.gotData(this.type, flags, data);
        this.getCallback().receivedStatus(STATUS_OK);
    }

    @Override
    public ConfigurationType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return super.toString() + " Type: " + this.type.getValue();
    }
}

