/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.exec.ProcessingBuffersSet;
import org.apache.druid.utils.CloseableUtils;

public class PeonProcessingBuffersProvider
implements ProcessingBuffersProvider {
    private final AtomicBoolean acquired = new AtomicBoolean(false);
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final int bufferCount;

    public PeonProcessingBuffersProvider(NonBlockingPool<ByteBuffer> bufferPool, int bufferCount) {
        this.bufferPool = bufferPool;
        this.bufferCount = bufferCount;
    }

    @Override
    public ResourceHolder<ProcessingBuffersSet> acquire(int poolSize, long timeoutMillis) {
        if (poolSize == 0) {
            return new ReferenceCountingResourceHolder((Object)ProcessingBuffersSet.EMPTY, () -> {});
        }
        if (!this.acquired.compareAndSet(false, true)) {
            throw DruidException.defensive((String)"Expected a single call to acquire() for[%s]", (Object[])new Object[]{this.getClass().getName()});
        }
        Closer closer = Closer.create();
        try {
            int i;
            ArrayList bufferPools = new ArrayList();
            for (i = 0; i < poolSize; ++i) {
                bufferPools.add(new ArrayList(this.bufferCount));
            }
            for (i = 0; i < this.bufferCount; ++i) {
                ResourceHolder bufferHolder = (ResourceHolder)closer.register((Closeable)this.bufferPool.take());
                ByteBuffer buffer = ((ByteBuffer)bufferHolder.get()).duplicate();
                int sliceSize = buffer.capacity() / poolSize;
                for (int j = 0; j < poolSize; ++j) {
                    buffer.position(sliceSize * j).limit(sliceSize * (j + 1));
                    ((List)bufferPools.get(j)).add(buffer.slice());
                }
            }
            return new ReferenceCountingResourceHolder((Object)ProcessingBuffersSet.fromCollection(bufferPools), (Closeable)closer);
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch((Throwable)e, (Closeable)closer);
        }
    }
}

