/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.msq.counters.CpuCounter;
import org.apache.druid.msq.counters.CpuTimeAccumulatingFrameProcessor;

public class CpuTimeAccumulatingProcessorManager<T, R>
implements ProcessorManager<T, R> {
    private final ProcessorManager<T, R> delegate;
    private final CpuCounter counter;

    public CpuTimeAccumulatingProcessorManager(ProcessorManager<T, R> delegate, CpuCounter counter) {
        this.delegate = delegate;
        this.counter = counter;
    }

    public ListenableFuture<Optional<ProcessorAndCallback<T>>> next() {
        ListenableFuture delegateNext = this.counter.run(() -> this.delegate.next());
        return FutureUtils.transform((ListenableFuture)delegateNext, opt -> opt.map(pac -> new ProcessorAndCallback(new CpuTimeAccumulatingFrameProcessor(pac.processor(), this.counter), t -> this.counter.run(() -> pac.onComplete(t)))));
    }

    public R result() {
        return (R)this.counter.run(() -> this.delegate.result());
    }

    public void close() {
        this.counter.run(() -> this.delegate.close());
    }
}

