/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Optional;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.ISE;

public class SurrogateAction<ReturnType, ActionType extends TaskAction<ReturnType>>
implements TaskAction<ReturnType> {
    private final String surrogateId;
    private final ActionType taskAction;

    @JsonCreator
    public SurrogateAction(@JsonProperty(value="surrogateId") String surrogateId, @JsonProperty(value="taskAction") ActionType taskAction) {
        this.surrogateId = surrogateId;
        this.taskAction = taskAction;
    }

    @JsonProperty
    public String getSurrogateId() {
        return this.surrogateId;
    }

    @JsonProperty
    public ActionType getTaskAction() {
        return this.taskAction;
    }

    @Override
    public TypeReference<ReturnType> getReturnTypeReference() {
        return this.taskAction.getReturnTypeReference();
    }

    @Override
    public ReturnType perform(Task task, TaskActionToolbox toolbox) {
        Optional<Task> maybeSurrogateTask = toolbox.getTaskStorage().getTask(this.surrogateId);
        if (maybeSurrogateTask.isPresent()) {
            return (ReturnType)this.taskAction.perform((Task)maybeSurrogateTask.get(), toolbox);
        }
        throw new ISE("Can't find surrogate task[%s]", new Object[]{this.surrogateId});
    }

    @Override
    public String toString() {
        return "SurrogateAction{surrogateId='" + this.surrogateId + "', taskAction=" + String.valueOf(this.taskAction) + "}";
    }
}

