/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public final class FixedIndexedIntWriter
implements Serializer {
    private static final int PAGE_SIZE = 4096;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final ByteBuffer scratch;
    private int numWritten;
    @Nullable
    private WriteOutBytes valuesOut = null;
    private final boolean isSorted;

    public FixedIndexedIntWriter(SegmentWriteOutMedium segmentWriteOutMedium, boolean sorted) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.isSorted = sorted;
        this.scratch = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
    }

    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public long getSerializedSize() {
        return 6L + this.valuesOut.size();
    }

    public void write(int objectToWrite) throws IOException {
        this.scratch.clear();
        this.scratch.putInt(objectToWrite);
        this.scratch.flip();
        Channels.writeFully(this.valuesOut, this.scratch);
        ++this.numWritten;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.scratch.clear();
        this.scratch.put((byte)0);
        byte flags = 0;
        if (this.isSorted) {
            flags = (byte)(flags | 2);
        }
        this.scratch.put(flags);
        this.scratch.flip();
        Channels.writeFully(channel, this.scratch);
        this.scratch.clear();
        this.scratch.putInt(this.numWritten);
        this.scratch.flip();
        Channels.writeFully(channel, this.scratch);
        this.valuesOut.writeTo(channel);
    }

    public IntIterator getIterator() {
        final ByteBuffer iteratorBuffer = ByteBuffer.allocate(16384).order(ByteOrder.nativeOrder());
        return new IntIterator(){
            int pos = 0;

            public int nextInt() {
                if (this.pos == 0 || iteratorBuffer.position() >= iteratorBuffer.limit()) {
                    this.readPage();
                }
                int value = iteratorBuffer.getInt();
                ++this.pos;
                return value;
            }

            public boolean hasNext() {
                return this.pos < FixedIndexedIntWriter.this.numWritten;
            }

            private void readPage() {
                iteratorBuffer.clear();
                try {
                    if (FixedIndexedIntWriter.this.numWritten - this.pos < 4096) {
                        int size = (FixedIndexedIntWriter.this.numWritten - this.pos) * 4;
                        iteratorBuffer.limit(size);
                        FixedIndexedIntWriter.this.valuesOut.readFully((long)this.pos * 4L, iteratorBuffer);
                    } else {
                        FixedIndexedIntWriter.this.valuesOut.readFully((long)this.pos * 4L, iteratorBuffer);
                    }
                    iteratorBuffer.flip();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

