/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;
import org.apache.druid.segment.nested.ValueDictionary;

public class AutoTypeColumnIndexer
implements DimensionIndexer<StructuredData, StructuredData, StructuredData> {
    protected volatile boolean hasNulls = false;
    protected volatile boolean hasNestedData = false;
    protected volatile boolean isConstant = true;
    @Nullable
    protected volatile Object constantValue = null;
    private volatile boolean firstRow = true;
    protected SortedMap<String, FieldIndexer> fieldIndexers = new TreeMap<String, FieldIndexer>();
    protected final ValueDictionary globalDictionary = new ValueDictionary();
    protected int estimatedFieldKeySize = 0;
    private final String columnName;
    @Nullable
    protected final ColumnType castToType;
    @Nullable
    protected final ExpressionType castToExpressionType;
    protected final StructuredDataProcessor indexerProcessor = new StructuredDataProcessor(){

        @Override
        public StructuredDataProcessor.ProcessedValue<?> processField(ArrayList<NestedPathPart> fieldPath, @Nullable Object fieldValue) {
            if (fieldValue != null) {
                String fieldName = NestedPathFinder.toNormalizedJsonPath(fieldPath);
                ExprEval eval = ExprEval.bestEffortOf(fieldValue);
                FieldIndexer fieldIndexer = (FieldIndexer)AutoTypeColumnIndexer.this.fieldIndexers.get(fieldName);
                if (fieldIndexer == null) {
                    AutoTypeColumnIndexer.this.estimatedFieldKeySize += StructuredDataProcessor.estimateStringSize(fieldName);
                    fieldIndexer = new FieldIndexer(AutoTypeColumnIndexer.this.globalDictionary);
                    AutoTypeColumnIndexer.this.fieldIndexers.put(fieldName, fieldIndexer);
                }
                return fieldIndexer.processValue(eval);
            }
            return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
        }

        @Override
        @Nullable
        public StructuredDataProcessor.ProcessedValue<?> processArrayField(ArrayList<NestedPathPart> fieldPath, @Nullable List<?> array) {
            ExprEval eval = ExprEval.bestEffortArray(array);
            if (eval.type().isPrimitiveArray()) {
                String fieldName = NestedPathFinder.toNormalizedJsonPath(fieldPath);
                FieldIndexer fieldIndexer = (FieldIndexer)AutoTypeColumnIndexer.this.fieldIndexers.get(fieldName);
                if (fieldIndexer == null) {
                    AutoTypeColumnIndexer.this.estimatedFieldKeySize += StructuredDataProcessor.estimateStringSize(fieldName);
                    fieldIndexer = new FieldIndexer(AutoTypeColumnIndexer.this.globalDictionary);
                    AutoTypeColumnIndexer.this.fieldIndexers.put(fieldName, fieldIndexer);
                }
                return fieldIndexer.processValue(eval);
            }
            return null;
        }
    };

    public AutoTypeColumnIndexer(String name, @Nullable ColumnType castToType) {
        this.columnName = name;
        if (castToType != null && (castToType.isPrimitive() || castToType.isPrimitiveArray())) {
            this.castToType = castToType;
            this.castToExpressionType = ExpressionType.fromColumnTypeStrict(castToType);
        } else {
            this.castToType = null;
            this.castToExpressionType = null;
        }
    }

    @Override
    public EncodedKeyComponent<StructuredData> processRowValsToUnsortedEncodedKeyComponent(@Nullable Object dimValues, boolean reportParseExceptions) {
        if (this.firstRow) {
            this.constantValue = dimValues;
            this.firstRow = false;
        } else if (this.isConstant) {
            this.isConstant = Objects.equals(dimValues, this.constantValue);
        }
        if (this.castToExpressionType != null) {
            return this.processCast(dimValues);
        }
        return this.processAuto(dimValues);
    }

    private EncodedKeyComponent<StructuredData> processCast(@Nullable Object dimValues) {
        long oldDictSizeInBytes = this.globalDictionary.sizeInBytes();
        int oldFieldKeySize = this.estimatedFieldKeySize;
        ExprEval eval = ExprEval.bestEffortOf(dimValues);
        try {
            eval = eval.castTo(this.castToExpressionType);
        }
        catch (IAE invalidCast) {
            throw new ParseException(eval.asString(), (Throwable)invalidCast, "Cannot coerce column [%s] input to requested type [%s]", this.columnName, this.castToType);
        }
        FieldIndexer fieldIndexer = (FieldIndexer)this.fieldIndexers.get("$");
        if (fieldIndexer == null) {
            this.estimatedFieldKeySize += StructuredDataProcessor.estimateStringSize("$");
            fieldIndexer = new FieldIndexer(this.globalDictionary);
            this.fieldIndexers.put("$", fieldIndexer);
        }
        StructuredDataProcessor.ProcessedValue<?> rootValue = fieldIndexer.processValue(eval);
        long effectiveSizeBytes = rootValue.getSize();
        effectiveSizeBytes += this.globalDictionary.sizeInBytes() - oldDictSizeInBytes;
        return new EncodedKeyComponent<StructuredData>(StructuredData.wrap(eval.value()), effectiveSizeBytes += (long)(this.estimatedFieldKeySize - oldFieldKeySize));
    }

    private EncodedKeyComponent<StructuredData> processAuto(@Nullable Object dimValues) {
        StructuredData data;
        long oldDictSizeInBytes = this.globalDictionary.sizeInBytes();
        int oldFieldKeySize = this.estimatedFieldKeySize;
        if (dimValues == null) {
            this.hasNulls = true;
            data = null;
        } else {
            data = dimValues instanceof StructuredData ? (StructuredData)dimValues : new StructuredData(dimValues);
        }
        StructuredDataProcessor.ProcessResults info = this.indexerProcessor.processFields(data == null ? null : data.getValue());
        if (info.hasObjects()) {
            this.hasNestedData = true;
        }
        long effectiveSizeBytes = info.getEstimatedSize();
        effectiveSizeBytes += this.globalDictionary.sizeInBytes() - oldDictSizeInBytes;
        return new EncodedKeyComponent<StructuredData>(data, effectiveSizeBytes += (long)(this.estimatedFieldKeySize - oldFieldKeySize));
    }

    @Override
    public void setSparseIndexed() {
        this.hasNulls = true;
        if (this.firstRow) {
            this.firstRow = false;
        } else if (this.constantValue != null) {
            this.constantValue = null;
            this.isConstant = false;
        }
    }

    @Override
    public StructuredData getUnsortedEncodedValueFromSorted(StructuredData sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public CloseableIndexed<StructuredData> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Not supported");
    }

    public SortedValueDictionary getSortedValueLookups() {
        return this.globalDictionary.getSortedCollector();
    }

    public SortedMap<String, FieldTypeInfo.MutableTypeSet> getFieldTypeInfo() {
        TreeMap<String, FieldTypeInfo.MutableTypeSet> fields = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
        for (Map.Entry<String, FieldIndexer> entry : this.fieldIndexers.entrySet()) {
            if (entry.getValue().getTypes().isEmpty() && !entry.getValue().getTypes().hasUntypedArray()) continue;
            fields.put(entry.getKey(), entry.getValue().getTypes());
        }
        return fields;
    }

    @Override
    public StructuredData getMinValue() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public StructuredData getMaxValue() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public DimensionSelector makeDimensionSelector(final DimensionSpec spec, IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        int dimIndex = desc.getIndex();
        if (this.fieldIndexers.size() == 0 && this.isConstant && !this.hasNestedData) {
            return DimensionSelector.constant(null, spec.getExtractionFn());
        }
        final ColumnValueSelector<?> rootLiteralSelector = this.getRootLiteralValueSelector(currEntry, dimIndex);
        if (rootLiteralSelector != null) {
            ColumnType rootType;
            FieldIndexer root = (FieldIndexer)this.fieldIndexers.get("$");
            ColumnType columnType = rootType = root.isSingleType() ? root.getTypes().getSingleType() : this.getLogicalType();
            if (rootType.isArray()) {
                throw new UOE("makeDimensionSelector is not supported, column [%s] is [%s] typed and should only use makeColumnValueSelector", spec.getOutputName(), rootType);
            }
            if (spec.getExtractionFn() == null) {
                return new BaseSingleValueDimensionSelector(){

                    @Override
                    @Nullable
                    protected String getValue() {
                        return Evals.asString(rootLiteralSelector.getObject());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }
                };
            }
            return new BaseSingleValueDimensionSelector(){

                @Override
                @Nullable
                protected String getValue() {
                    String s = Evals.asString(rootLiteralSelector.getObject());
                    return spec.getExtractionFn().apply(s);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }
        throw new UOE("makeDimensionSelector is not supported, column [%s] is [%s] typed and should only use makeColumnValueSelector", spec.getOutputName(), ColumnType.NESTED_DATA);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        ColumnValueSelector<?> rootLiteralSelector = this.getRootLiteralValueSelector(currEntry, dimIndex);
        if (rootLiteralSelector != null) {
            return rootLiteralSelector;
        }
        return new ColumnValueSelector<Object>(){

            @Override
            public double getDouble() {
                Object o = StructuredData.unwrap(this.getObject());
                return Numbers.tryParseDouble(o, 0.0);
            }

            @Override
            public float getFloat() {
                Object o = StructuredData.unwrap(this.getObject());
                return Numbers.tryParseFloat(o, 0.0f);
            }

            @Override
            public long getLong() {
                Object o = StructuredData.unwrap(this.getObject());
                return Numbers.tryParseLong(o, 0L);
            }

            @Override
            public boolean isNull() {
                Object o = StructuredData.unwrap(this.getObject());
                if (o instanceof Number) {
                    return false;
                }
                if (o instanceof String) {
                    return GuavaUtils.tryParseLong((String)o) == null && Doubles.tryParse((String)((String)o)) == null;
                }
                return true;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            @Nullable
            public StructuredData getObject() {
                Object[] dims = currEntry.get().getDims();
                if (0 <= dimIndex && dimIndex < dims.length) {
                    return (StructuredData)dims[dimIndex];
                }
                return null;
            }

            @Override
            public Class<StructuredData> classOfObject() {
                return StructuredData.class;
            }
        };
    }

    @Override
    public ColumnCapabilities getColumnCapabilities() {
        return ColumnCapabilitiesImpl.createDefault().setType(this.getLogicalType()).setHasNulls(this.hasNulls);
    }

    public ColumnType getLogicalType() {
        if (this.castToType != null) {
            return this.castToType;
        }
        if (this.hasNestedData) {
            return ColumnType.NESTED_DATA;
        }
        if (this.isConstant && this.constantValue == null) {
            return ColumnType.STRING;
        }
        if (this.fieldIndexers.size() == 1 && this.fieldIndexers.containsKey("$")) {
            FieldIndexer rootField = (FieldIndexer)this.fieldIndexers.get("$");
            ColumnType logicalType = ColumnType.leastRestrictiveType(FieldTypeInfo.convertToSet(rootField.getTypes().getByteValue()));
            if (logicalType != null) {
                if (!rootField.getTypes().hasUntypedArray() || logicalType.isArray()) {
                    return logicalType;
                }
                return ColumnTypeFactory.getInstance().ofArray(logicalType);
            }
            if (rootField.getTypes().hasUntypedArray()) {
                return ColumnType.LONG_ARRAY;
            }
        }
        return ColumnType.NESTED_DATA;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    @Nullable
    public Object getConstantValue() {
        return this.constantValue;
    }

    @Override
    public ColumnFormat getFormat() {
        return new Format(this.getLogicalType(), this.hasNulls, this.castToType != null);
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable StructuredData lhs, @Nullable StructuredData rhs) {
        return StructuredData.COMPARATOR.compare(lhs, rhs);
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable StructuredData lhs, @Nullable StructuredData rhs) {
        return Objects.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable StructuredData key) {
        return Objects.hash(key);
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualList(StructuredData key) {
        return key;
    }

    @Override
    public ColumnValueSelector convertUnsortedValuesToSorted(final ColumnValueSelector selectorWithUnsortedValues) {
        FieldIndexer rootIndexer = (FieldIndexer)this.fieldIndexers.get("$");
        if (this.fieldIndexers.size() == 1 && rootIndexer != null && rootIndexer.isSingleType()) {
            return new ColumnValueSelector<StructuredData>(){

                @Override
                public boolean isNull() {
                    return selectorWithUnsortedValues.isNull();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    selectorWithUnsortedValues.inspectRuntimeShape(inspector);
                }

                @Override
                @Nullable
                public StructuredData getObject() {
                    return StructuredData.wrap(selectorWithUnsortedValues.getObject());
                }

                @Override
                public float getFloat() {
                    return selectorWithUnsortedValues.getFloat();
                }

                @Override
                public double getDouble() {
                    return selectorWithUnsortedValues.getDouble();
                }

                @Override
                public long getLong() {
                    return selectorWithUnsortedValues.getLong();
                }

                @Override
                public Class<StructuredData> classOfObject() {
                    return StructuredData.class;
                }
            };
        }
        return selectorWithUnsortedValues;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(StructuredData key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Nullable
    private ColumnValueSelector<?> getRootLiteralValueSelector(final IncrementalIndexRowHolder currEntry, final int dimIndex) {
        if (this.fieldIndexers.size() > 1 || this.hasNestedData) {
            return null;
        }
        FieldIndexer root = (FieldIndexer)this.fieldIndexers.get("$");
        if (root == null) {
            return null;
        }
        return new ColumnValueSelector<Object>(){

            @Override
            public boolean isNull() {
                Object o = this.getObject();
                return this.computeNumber(o) == null;
            }

            @Override
            public float getFloat() {
                Number value = this.computeNumber(this.getObject());
                if (value == null) {
                    return 0.0f;
                }
                return value.floatValue();
            }

            @Override
            public double getDouble() {
                Number value = this.computeNumber(this.getObject());
                if (value == null) {
                    return 0.0;
                }
                return value.doubleValue();
            }

            @Override
            public long getLong() {
                Number value = this.computeNumber(this.getObject());
                if (value == null) {
                    return 0L;
                }
                return value.longValue();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            @Nullable
            public Object getObject() {
                StructuredData data;
                Object[] dims = currEntry.get().getDims();
                if (0 <= dimIndex && dimIndex < dims.length && (data = (StructuredData)dims[dimIndex]) != null) {
                    Object o = ExprEval.bestEffortOf(data.getValue()).valueOrDefault();
                    return o;
                }
                return null;
            }

            @Nullable
            private Number computeNumber(@Nullable Object o) {
                if (o instanceof Number) {
                    return (Number)o;
                }
                if (o instanceof String) {
                    Long l = GuavaUtils.tryParseLong((String)o);
                    if (l != null) {
                        return l;
                    }
                    return Doubles.tryParse((String)((String)o));
                }
                return null;
            }

            @Override
            public Class<?> classOfObject() {
                return Object.class;
            }
        };
    }

    @Nullable
    private static Object getDefaultValueForType(@Nullable ColumnType columnType) {
        return null;
    }

    static class FieldIndexer {
        private final ValueDictionary valueDictionary;
        private final FieldTypeInfo.MutableTypeSet typeSet;

        FieldIndexer(ValueDictionary valueDictionary) {
            this.valueDictionary = valueDictionary;
            this.typeSet = new FieldTypeInfo.MutableTypeSet();
        }

        private StructuredDataProcessor.ProcessedValue<?> processValue(ExprEval<?> eval) {
            ExpressionType columnType = eval.type();
            switch ((ExprType)columnType.getType()) {
                case LONG: {
                    this.typeSet.add(ColumnType.LONG);
                    int sizeEstimate = this.valueDictionary.addLongValue(eval.asLong());
                    return new StructuredDataProcessor.ProcessedValue<Long>(eval.asLong(), sizeEstimate);
                }
                case DOUBLE: {
                    this.typeSet.add(ColumnType.DOUBLE);
                    int sizeEstimate = this.valueDictionary.addDoubleValue(eval.asDouble());
                    return new StructuredDataProcessor.ProcessedValue<Double>(eval.asDouble(), sizeEstimate);
                }
                case ARRAY: {
                    if (columnType.getElementType() == null) {
                        throw new IAE("Array type [%s] missing element type, how did this possibly happen?", eval.type());
                    }
                    Object[] theArray = eval.asArray();
                    if (theArray == null) {
                        this.typeSet.addUntypedArray();
                    } else {
                        switch ((ExprType)columnType.getElementType().getType()) {
                            case LONG: {
                                this.typeSet.add(ColumnType.LONG_ARRAY);
                                int sizeEstimate = this.valueDictionary.addLongArray(theArray);
                                return new StructuredDataProcessor.ProcessedValue<Object[]>(theArray, sizeEstimate);
                            }
                            case DOUBLE: {
                                this.typeSet.add(ColumnType.DOUBLE_ARRAY);
                                int sizeEstimate = this.valueDictionary.addDoubleArray(theArray);
                                return new StructuredDataProcessor.ProcessedValue<Object[]>(theArray, sizeEstimate);
                            }
                            case STRING: {
                                if (theArray.length == 0 || Arrays.stream(theArray).allMatch(Objects::isNull)) {
                                    this.typeSet.addUntypedArray();
                                } else {
                                    this.typeSet.add(ColumnType.STRING_ARRAY);
                                }
                                int sizeEstimate = this.valueDictionary.addStringArray(theArray);
                                return new StructuredDataProcessor.ProcessedValue<Object[]>(theArray, sizeEstimate);
                            }
                        }
                        throw new IAE("Unhandled type: %s", columnType);
                    }
                }
                case STRING: {
                    this.typeSet.add(ColumnType.STRING);
                    String asString = eval.asString();
                    int sizeEstimate = this.valueDictionary.addStringValue(asString);
                    return new StructuredDataProcessor.ProcessedValue<String>(asString, sizeEstimate);
                }
            }
            throw new IAE("Unhandled type: %s", columnType);
        }

        public FieldTypeInfo.MutableTypeSet getTypes() {
            return this.typeSet;
        }

        public boolean isSingleType() {
            return this.typeSet.getSingleType() != null;
        }
    }

    static class Format
    implements ColumnFormat {
        private final ColumnType logicalType;
        private final boolean hasNulls;
        private final boolean enforceLogicalType;

        Format(ColumnType logicalType, boolean hasNulls, boolean enforceLogicalType) {
            this.logicalType = logicalType;
            this.hasNulls = hasNulls;
            this.enforceLogicalType = enforceLogicalType;
        }

        @Override
        public ColumnType getLogicalType() {
            return this.logicalType;
        }

        @Override
        public DimensionHandler getColumnHandler(String columnName) {
            return new NestedCommonFormatColumnHandler(columnName, this.enforceLogicalType ? this.logicalType : null);
        }

        @Override
        public DimensionSchema getColumnSchema(String columnName) {
            return new AutoTypeColumnSchema(columnName, this.enforceLogicalType ? this.logicalType : null);
        }

        @Override
        public ColumnFormat merge(@Nullable ColumnFormat otherFormat) {
            if (otherFormat == null) {
                return this;
            }
            if (otherFormat instanceof Format) {
                Format other = (Format)otherFormat;
                if (!this.getLogicalType().equals(other.getLogicalType())) {
                    return new Format(ColumnType.NESTED_DATA, this.hasNulls || other.hasNulls, false);
                }
                return new Format(this.logicalType, this.hasNulls || other.hasNulls, this.enforceLogicalType || other.enforceLogicalType);
            }
            throw new ISE("Cannot merge columns of type[%s] and format[%s] and with [%s] and [%s]", this.logicalType, this.getClass().getName(), otherFormat.getLogicalType(), otherFormat.getClass().getName());
        }

        @Override
        public ColumnCapabilities toColumnCapabilities() {
            return ColumnCapabilitiesImpl.createDefault().setType(this.logicalType).setHasNulls(this.hasNulls);
        }
    }
}

