/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.DefaultFramedOnHeapAggregatable;
import org.apache.druid.query.rowsandcols.semantic.FramedOnHeapAggregatable;

public class WindowFramedAggregateProcessor
implements Processor {
    private final WindowFrame frame;
    private final AggregatorFactory[] aggregations;

    @Nullable
    private static <T> T[] emptyToNull(T[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        return arr;
    }

    @Override
    public List<String> getOutputColumnNames() {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (AggregatorFactory aggregation : this.aggregations) {
            outputColumnNames.add(aggregation.getName());
        }
        return outputColumnNames;
    }

    @JsonCreator
    public WindowFramedAggregateProcessor(@JsonProperty(value="frame") WindowFrame frame, @JsonProperty(value="aggregations") AggregatorFactory[] aggregations) {
        this.frame = frame;
        this.aggregations = WindowFramedAggregateProcessor.emptyToNull(aggregations);
    }

    @JsonProperty(value="frame")
    public WindowFrame getFrame() {
        return this.frame;
    }

    @JsonProperty(value="aggregations")
    public AggregatorFactory[] getAggregations() {
        return this.aggregations;
    }

    @Override
    public RowsAndColumns process(RowsAndColumns inputPartition) {
        FramedOnHeapAggregatable agger = inputPartition.as(FramedOnHeapAggregatable.class);
        if (agger == null) {
            agger = new DefaultFramedOnHeapAggregatable(RowsAndColumns.expectAppendable(inputPartition));
        }
        return agger.aggregateAll(this.frame, this.aggregations);
    }

    @Override
    public boolean validateEquivalent(Processor otherProcessor) {
        if (otherProcessor instanceof WindowFramedAggregateProcessor) {
            WindowFramedAggregateProcessor other = (WindowFramedAggregateProcessor)otherProcessor;
            return this.frame.equals(other.frame) && Arrays.equals(this.aggregations, other.aggregations);
        }
        return false;
    }

    public String toString() {
        return "WindowFramedAggregateProcessor{frame=" + String.valueOf(this.frame) + ", aggregations=" + Arrays.toString(this.aggregations) + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.aggregations);
        result = 31 * result + Objects.hash(this.frame);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowFramedAggregateProcessor other = (WindowFramedAggregateProcessor)obj;
        return Arrays.equals(this.aggregations, other.aggregations) && Objects.equals(this.frame, other.frame);
    }
}

