/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.RowsAndColumnsDecorator;
import org.joda.time.Interval;

public class LimitTimeIntervalOperator
implements Operator {
    private final Operator segmentOperator;
    private Interval interval;

    public LimitTimeIntervalOperator(Operator segmentOperator, Interval interval) {
        this.segmentOperator = segmentOperator;
        this.interval = interval;
    }

    @Override
    @Nullable
    public Closeable goOrContinue(Closeable continuationObject, final Operator.Receiver receiver) {
        return this.segmentOperator.goOrContinue(continuationObject, new Operator.Receiver(){

            @Override
            public Operator.Signal push(RowsAndColumns rac) {
                if (Intervals.isEternity(LimitTimeIntervalOperator.this.interval)) {
                    return receiver.push(rac);
                }
                RowsAndColumnsDecorator decor = RowsAndColumnsDecorator.fromRAC(rac);
                decor.limitTimeRange(LimitTimeIntervalOperator.this.interval);
                return receiver.push(decor.toRowsAndColumns());
            }

            @Override
            public void completed() {
                receiver.completed();
            }
        });
    }
}

