/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;

public class ReportTimelineMissingSegmentQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger LOG = new Logger(ReportTimelineMissingSegmentQueryRunner.class);
    private final List<SegmentDescriptor> descriptors;

    public ReportTimelineMissingSegmentQueryRunner(SegmentDescriptor descriptor) {
        this((List<SegmentDescriptor>)ImmutableList.of((Object)descriptor));
    }

    public ReportTimelineMissingSegmentQueryRunner(List<SegmentDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        LOG.debug("Reporting a missing segments[%s] for query[%s]", this.descriptors, queryPlus.getQuery().getId());
        responseContext.addMissingSegments(this.descriptors);
        return Sequences.empty();
    }
}

