/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionValidationException;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.FallbackVectorProcessor;
import org.apache.druid.segment.column.Types;

class FunctionExpr
implements Expr {
    final Function function;
    final ImmutableList<Expr> args;
    private final String name;

    FunctionExpr(Function function, String name, List<Expr> args) {
        this.function = function;
        this.name = name;
        this.args = ImmutableList.copyOf(args);
        function.validateArguments(args);
    }

    @Override
    public Expr asSingleThreaded(Expr.InputBindingInspector inspector) {
        return new FunctionExpr(this.function.asSingleThreaded((List<Expr>)this.args, inspector), this.name, (List<Expr>)this.args);
    }

    public String toString() {
        return StringUtils.format("(%s %s)", this.name, this.args);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        try {
            return this.function.apply((List<Expr>)this.args, bindings);
        }
        catch (ExpressionValidationException e) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build(e, e.getMessage(), new Object[0]);
        }
        catch (Types.InvalidCastBooleanException | Types.InvalidCastException e) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build(e, "Function[%s] encountered exception: %s", this.name, e.getMessage());
        }
        catch (DruidException e) {
            throw e;
        }
        catch (Exception e) {
            throw DruidException.defensive().build(e, "Function[%s] encountered unknown exception.", this.name);
        }
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return this.function.canVectorize(inspector, (List<Expr>)this.args) || this.canFallbackVectorize(inspector, (List<Expr>)this.args);
    }

    public ExprVectorProcessor<?> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        if (this.function.canVectorize(inspector, (List<Expr>)this.args)) {
            return this.function.asVectorProcessor(inspector, (List<Expr>)this.args);
        }
        return FallbackVectorProcessor.create(this.function, this.args, inspector);
    }

    @Override
    public String stringify() {
        return StringUtils.format("%s(%s)", this.name, ARG_JOINER.join(this.args.stream().map(Expr::stringify).iterator()));
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        return shuttle.visit(new FunctionExpr(this.function, this.name, shuttle.visitAll((List<Expr>)this.args)));
    }

    @Override
    public Expr.BindingAnalysis analyzeInputs() {
        return Expr.BindingAnalysis.collectExprs(this.args).withScalarArguments(this.function.getScalarInputs((List<Expr>)this.args)).withArrayArguments(this.function.getArrayInputs((List<Expr>)this.args)).withArrayInputs(this.function.hasArrayInputs()).withArrayOutput(this.function.hasArrayOutput());
    }

    @Override
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return this.function.getOutputType(inspector, (List<Expr>)this.args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionExpr that = (FunctionExpr)o;
        return this.args.equals(that.args) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.name);
    }
}

