/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;

final class FixedBucketsHistogramBufferAggregatorHelper {
    private final double lowerLimit;
    private final double upperLimit;
    private final int numBuckets;
    private final FixedBucketsHistogram.OutlierHandlingMode outlierHandlingMode;

    public FixedBucketsHistogramBufferAggregatorHelper(double lowerLimit, double upperLimit, int numBuckets, FixedBucketsHistogram.OutlierHandlingMode outlierHandlingMode) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.numBuckets = numBuckets;
        this.outlierHandlingMode = outlierHandlingMode;
    }

    public void init(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        FixedBucketsHistogram histogram = new FixedBucketsHistogram(this.lowerLimit, this.upperLimit, this.numBuckets, this.outlierHandlingMode);
        mutationBuffer.put(histogram.toBytesFull(false));
    }

    public void aggregate(ByteBuffer buf, int position, @Nullable Object val) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        FixedBucketsHistogram h0 = FixedBucketsHistogram.fromByteBufferFullNoSerdeHeader(mutationBuffer);
        h0.combine(val);
        mutationBuffer.position(position);
        mutationBuffer.put(h0.toBytesFull(false));
    }

    public FixedBucketsHistogram get(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        return FixedBucketsHistogram.fromByteBufferFullNoSerdeHeader(mutationBuffer);
    }

    public void put(ByteBuffer buf, int position, FixedBucketsHistogram histogram) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.put(histogram.toBytesFull(false));
    }
}

