/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.storage.hdfs.HdfsDataSegmentPuller;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class HdfsFileTimestampVersionFinder
extends HdfsDataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    @Inject
    public HdfsFileTimestampVersionFinder(@Hdfs Configuration config) {
        super(config);
    }

    private URI mostRecentInDir(Path dir, final Pattern pattern) throws IOException {
        PathFilter filter = new PathFilter(){

            public boolean accept(Path path) {
                return pattern == null || pattern.matcher(path.getName()).matches();
            }
        };
        long modifiedTime = Long.MIN_VALUE;
        URI mostRecentURI = null;
        try (FileSystem fs = dir.getFileSystem(this.config);){
            for (FileStatus status : fs.listStatus(dir, filter)) {
                long thisModifiedTime;
                if (!status.isFile() || (thisModifiedTime = status.getModificationTime()) < modifiedTime) continue;
                modifiedTime = thisModifiedTime;
                mostRecentURI = status.getPath().toUri();
            }
        }
        return mostRecentURI;
    }

    public URI getLatestVersion(URI uri, @Nullable Pattern pattern) {
        Path path = new Path(uri);
        try {
            return (URI)RetryUtils.retry(() -> {
                FileSystem fs = path.getFileSystem(this.config);
                if (!fs.exists(path)) {
                    return null;
                }
                return this.mostRecentInDir(fs.isDirectory(path) ? path : path.getParent(), pattern);
            }, this.shouldRetryPredicate(), (int)3);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

