/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public abstract class SimpleSqlAggregator
implements SqlAggregator {
    public static DruidException badTypeException(String columnName, String agg, ColumnType type) {
        return InvalidSqlInput.exception((String)"Aggregation [%s] does not support type [%s], column [%s]", (Object[])new Object[]{agg, type, columnName});
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        if (aggregateCall.isDistinct()) {
            return null;
        }
        List<DruidExpression> arguments = Aggregations.getArgumentsForSimpleAggregator(plannerContext, aggregateCall, inputAccessor);
        if (arguments == null) {
            return null;
        }
        DruidExpression arg = (DruidExpression)Iterables.getOnlyElement(arguments);
        ExprMacroTable macroTable = plannerContext.getPlannerToolbox().exprMacroTable();
        String fieldName = arg.isDirectColumnAccess() ? arg.getDirectColumn() : virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, aggregateCall.getType());
        return this.getAggregation(name, aggregateCall, macroTable, fieldName);
    }

    abstract Aggregation getAggregation(String var1, AggregateCall var2, ExprMacroTable var3, String var4);
}

