/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import org.apache.datasketches.memory.BaseState;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.MapHandle;
import org.apache.datasketches.memory.Utf8CodingException;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.Prim;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.datasketches.memory.internal.Util;

public interface Memory
extends BaseState {
    public static Memory wrap(ByteBuffer byteBuffer) {
        return Memory.wrap(byteBuffer, byteBuffer.order());
    }

    public static Memory wrap(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        Objects.requireNonNull(byteBuffer, "byteBuffer must not be null");
        Objects.requireNonNull(byteOrder, "byteOrder must not be null");
        Util.negativeCheck(byteBuffer.capacity(), "byteBuffer");
        return BaseWritableMemoryImpl.wrapByteBuffer(byteBuffer, true, byteOrder, null);
    }

    public static MapHandle map(File file) {
        return Memory.map(file, 0L, file.length(), ByteOrder.nativeOrder());
    }

    public static MapHandle map(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder) {
        Objects.requireNonNull(file, "file must be non-null.");
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null.");
        if (!file.canRead()) {
            throw new IllegalArgumentException("file must be readable.");
        }
        Util.negativeCheck(fileOffsetBytes, "fileOffsetBytes");
        Util.negativeCheck(capacityBytes, "capacityBytes");
        return (MapHandle)((Object)BaseWritableMemoryImpl.wrapMap(file, fileOffsetBytes, capacityBytes, true, byteOrder));
    }

    default public Memory region(long offsetBytes, long capacityBytes) {
        return this.region(offsetBytes, capacityBytes, ByteOrder.nativeOrder());
    }

    public Memory region(long var1, long var3, ByteOrder var5);

    default public Buffer asBuffer() {
        return this.asBuffer(ByteOrder.nativeOrder());
    }

    public Buffer asBuffer(ByteOrder var1);

    public static Memory wrap(byte[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        return Memory.wrap(array, 0, array.length, ByteOrder.nativeOrder());
    }

    public static Memory wrap(byte[] array, ByteOrder byteOrder) {
        return Memory.wrap(array, 0, array.length, byteOrder);
    }

    public static Memory wrap(byte[] array, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        Objects.requireNonNull(array, "array must be non-null");
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null");
        Util.negativeCheck(offsetBytes, "offsetBytes");
        Util.negativeCheck(lengthBytes, "lengthBytes");
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, array.length);
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, true, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(boolean[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.BOOLEAN.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, true, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(char[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.CHAR.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, true, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(short[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.SHORT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, true, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(int[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.INT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, true, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(long[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.LONG.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, true, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(float[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.FLOAT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, true, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(double[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.DOUBLE.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, true, ByteOrder.nativeOrder(), null);
    }

    public boolean getBoolean(long var1);

    public void getBooleanArray(long var1, boolean[] var3, int var4, int var5);

    public byte getByte(long var1);

    public void getByteArray(long var1, byte[] var3, int var4, int var5);

    public char getChar(long var1);

    public void getCharArray(long var1, char[] var3, int var4, int var5);

    public int getCharsFromUtf8(long var1, int var3, Appendable var4) throws IOException, Utf8CodingException;

    public int getCharsFromUtf8(long var1, int var3, StringBuilder var4) throws Utf8CodingException;

    public double getDouble(long var1);

    public void getDoubleArray(long var1, double[] var3, int var4, int var5);

    public float getFloat(long var1);

    public void getFloatArray(long var1, float[] var3, int var4, int var5);

    public int getInt(long var1);

    public void getIntArray(long var1, int[] var3, int var4, int var5);

    public long getLong(long var1);

    public void getLongArray(long var1, long[] var3, int var4, int var5);

    public short getShort(long var1);

    public void getShortArray(long var1, short[] var3, int var4, int var5);

    public int compareTo(long var1, long var3, Memory var5, long var6, long var8);

    public void copyTo(long var1, WritableMemory var3, long var4, long var6);

    public void writeTo(long var1, long var3, WritableByteChannel var5) throws IOException;
}

