/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import org.apache.harmony.jndi.internal.nls.Messages;

public class NameClassPair
implements Serializable {
    private static final long serialVersionUID = 5620776610160863339L;
    private String name;
    private String className;
    private String fullName;
    private boolean isRel;

    public NameClassPair(String name, String className) {
        this(name, className, true);
    }

    public NameClassPair(String name, String className, boolean relative) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.getString("jndi.00"));
        }
        this.name = name;
        this.className = className;
        this.isRel = relative;
        this.fullName = null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRelative() {
        return this.isRel;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.getString("jndi.00"));
        }
        this.name = name;
    }

    public void setRelative(boolean relative) {
        this.isRel = relative;
    }

    public String getNameInNamespace() {
        if (this.fullName == null) {
            throw new UnsupportedOperationException(Messages.getString("jndi.01"));
        }
        return this.fullName;
    }

    public void setNameInNamespace(String fullName) {
        this.fullName = fullName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (!this.isRel) {
            buf.append("(not relative)");
        }
        buf.append(this.getName());
        buf.append(": ");
        buf.append(this.getClassName());
        return buf.toString();
    }
}

