/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.trie;

import org.apache.commons.collections4.Trie;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.commons.collections4.trie.UnmodifiableTrie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableTrieTest<V>
extends AbstractSortedMapTest<String, V> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Trie<String, V> makeFullMap() {
        PatriciaTrie m = new PatriciaTrie();
        this.addSampleMappings(m);
        return UnmodifiableTrie.unmodifiableTrie((Trie)m);
    }

    @Override
    public Trie<String, V> makeObject() {
        return UnmodifiableTrie.unmodifiableTrie((Trie)new PatriciaTrie());
    }

    @Test
    public void testDecorateFactory() {
        Trie<String, V> trie = this.makeFullMap();
        Assertions.assertSame(trie, (Object)UnmodifiableTrie.unmodifiableTrie(trie));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableTrie.unmodifiableTrie(null));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }
}

