/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;

public final class ArrayHasher
implements Hasher {
    private final int[] values;

    public ArrayHasher(int ... values) {
        this.values = values;
    }

    public IndexExtractor indices(Shape shape) {
        Objects.requireNonNull(shape, "shape");
        return new Extractor(shape);
    }

    private final class Extractor
    implements IndexExtractor {
        Shape shape;

        Extractor(Shape shape) {
            this.shape = shape;
        }

        public boolean processIndices(IntPredicate consumer) {
            Objects.requireNonNull(consumer, "consumer");
            int pos = 0;
            for (int i = 0; i < this.shape.getNumberOfHashFunctions(); ++i) {
                int result = ArrayHasher.this.values[pos++] % this.shape.getNumberOfBits();
                pos %= ArrayHasher.this.values.length;
                if (consumer.test(result)) continue;
                return false;
            }
            return true;
        }
    }
}

