/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.HashMap;
import org.apache.commons.collections4.bloomfilter.AbstractBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.CellExtractor;
import org.apache.commons.collections4.bloomfilter.CountingBloomFilter;
import org.apache.commons.collections4.bloomfilter.DefaultBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCountingBloomFilterTest<T extends CountingBloomFilter>
extends AbstractBloomFilterTest<T> {
    private static final int[] from1Counts = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0};
    private static final int[] bigHashCounts = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0};
    private static final long bigHashValue = 0xFFFFFFEL;

    private static void assertCounts(CountingBloomFilter bf, int[] expected) {
        HashMap m = new HashMap();
        bf.processCells((i, c) -> {
            m.put(i, c);
            return true;
        });
        int zeros = 0;
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (m.get(i2) == null) {
                Assertions.assertEquals((int)expected[i2], (int)0, (String)("Wrong value for " + i2));
                ++zeros;
                continue;
            }
            Assertions.assertEquals((int)expected[i2], (int)((Integer)m.get(i2)), (String)("Wrong value for " + i2));
        }
        Assertions.assertEquals((int)(expected.length - zeros), (int)bf.cardinality());
    }

    private void assertCell3(CountingBloomFilter bf, int value) {
        bf.processCells((k, v) -> {
            if (k == 3) {
                Assertions.assertEquals((int)value, (int)v, (String)"Mismatch at position 3");
            } else {
                Assertions.assertEquals((int)0, (int)v, (String)("Mismatch at position " + k));
            }
            return true;
        });
    }

    protected final CellExtractor getMaximumValueExtractor(int maxValue) {
        return consumer -> {
            for (int i = 1; i < 18; ++i) {
                if (consumer.test(i, maxValue)) continue;
                return false;
            }
            return true;
        };
    }

    @Test
    public void mergeIncrementsAllCellsTest() {
        CountingBloomFilter f1 = (CountingBloomFilter)this.createEmptyFilter(Shape.fromKM((int)1, (int)10));
        CountingBloomFilter f2 = (CountingBloomFilter)f1.copy();
        CountingBloomFilter f3 = (CountingBloomFilter)f1.copy();
        IndexExtractor ip = p -> {
            p.test(3);
            p.test(3);
            return true;
        };
        f1.merge(ip);
        this.assertCell3(f1, 1);
        f2.add(CellExtractor.from((IndexExtractor)ip));
        this.assertCell3(f2, 2);
    }

    @Test
    public void removeDecrementsAllCellsTest() {
        CountingBloomFilter f1 = (CountingBloomFilter)this.createEmptyFilter(Shape.fromKM((int)1, (int)10));
        CellExtractor cp = p -> {
            p.test(3, 3);
            return true;
        };
        f1.add(cp);
        CountingBloomFilter f2 = (CountingBloomFilter)f1.copy();
        CountingBloomFilter f3 = (CountingBloomFilter)f1.copy();
        IndexExtractor ip = p -> {
            p.test(3);
            p.test(3);
            return true;
        };
        f1.remove(ip);
        this.assertCell3(f1, 2);
        f2.subtract(CellExtractor.from((IndexExtractor)ip));
        this.assertCell3(f2, 1);
        f3.remove(IndexExtractor.fromIndexArray((int[])ip.asIndexArray()));
        this.assertCell3(f3, 2);
    }

    @Test
    public void testAdd() {
        CountingBloomFilter bf1 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        Assertions.assertTrue((boolean)bf1.add((CellExtractor)this.createFilter(this.getTestShape(), TestingHashers.FROM11)), (String)"Add should work");
        Assertions.assertTrue((boolean)bf1.contains(TestingHashers.FROM1), (String)"Should contain");
        Assertions.assertTrue((boolean)bf1.contains(TestingHashers.FROM11), (String)"Should contain");
        AbstractCountingBloomFilterTest.assertCounts(bf1, bigHashCounts);
        CountingBloomFilter bf2 = (CountingBloomFilter)this.createEmptyFilter(this.getTestShape());
        Assertions.assertTrue((boolean)bf2.add(this.getMaximumValueExtractor(bf2.getMaxCell())), (String)"Should add to empty");
        Assertions.assertTrue((boolean)bf2.isValid(), (String)"Should be valid");
        Assertions.assertFalse((boolean)bf2.add((CellExtractor)this.createFilter(this.getTestShape(), TestingHashers.FROM1)), (String)"Should not add");
        Assertions.assertFalse((boolean)bf2.isValid(), (String)"Should not be valid");
    }

    @Test
    public final void testCountingBloomFilterSpecificContains() {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.getTestShape());
        bf.merge(TestingHashers.FROM1);
        CountingBloomFilter bf2 = TestingHashers.populateFromHashersFrom1AndFrom11((CountingBloomFilter)this.createEmptyFilter(this.getTestShape()));
        Assertions.assertTrue((boolean)bf.contains((BloomFilter)bf), (String)"BF Should contain itself");
        Assertions.assertTrue((boolean)bf2.contains((BloomFilter)bf2), (String)"BF2 Should contain itself");
        Assertions.assertFalse((boolean)bf.contains((BloomFilter)bf2), (String)"BF should not contain BF2");
        Assertions.assertTrue((boolean)bf2.contains((BloomFilter)bf), (String)"BF2 should contain BF");
        CountingBloomFilter extractor = bf2;
        Assertions.assertTrue((boolean)bf2.contains((BitMapExtractor)extractor), (String)"BF2 should contain BF bitMapExtractor");
    }

    @Test
    public final void testCountingSpecificConstructor() {
        CountingBloomFilter bf = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        bf.add(CellExtractor.from((IndexExtractor)TestingHashers.FROM11.indices(this.getTestShape())));
        long[] lb = bf.asBitMapArray();
        Assertions.assertEquals((int)2, (int)lb.length);
        Assertions.assertEquals((long)0xFFFFFFEL, (long)lb[0]);
        AbstractCountingBloomFilterTest.assertCounts(bf, bigHashCounts);
    }

    @Test
    public final void testCountingSpecificMerge() {
        Object bf1 = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        SimpleBloomFilter bf2 = new SimpleBloomFilter(this.getTestShape());
        bf2.merge(TestingHashers.FROM11);
        BloomFilter bf3 = bf1.copy();
        bf3.merge((BloomFilter)bf2);
        Assertions.assertTrue((boolean)bf3.contains(bf1), (String)"Should contain");
        Assertions.assertTrue((boolean)bf3.contains((BloomFilter)bf2), (String)"Should contain");
        BloomFilter bf4 = bf2.copy();
        bf4.merge(bf1);
        Assertions.assertTrue((boolean)bf4.contains(bf1), (String)"Should contain");
        Assertions.assertTrue((boolean)bf4.contains((BloomFilter)bf2), (String)"Should contain");
        Assertions.assertTrue((boolean)bf4.contains(bf3), (String)"Should contain");
        Assertions.assertTrue((boolean)bf3.contains(bf4), (String)"Should contain");
        CountingBloomFilter bf5 = (CountingBloomFilter)this.createEmptyFilter(this.getTestShape());
        Assertions.assertTrue((boolean)bf5.add(this.getMaximumValueExtractor(bf5.getMaxCell())), (String)"Should add to empty");
        Assertions.assertTrue((boolean)bf5.isValid(), (String)"Should be valid");
        CountingBloomFilter bf6 = (CountingBloomFilter)bf5.copy();
        SimpleBloomFilter bf7 = new SimpleBloomFilter(this.getTestShape());
        bf7.merge(TestingHashers.FROM1);
        bf6.merge((BloomFilter)bf7);
        Assertions.assertFalse((boolean)bf6.isValid(), (String)"Should not be valid");
    }

    @Test
    public void testExcludesDuplicates() {
        Shape shape = Shape.fromKM((int)12, (int)72);
        IncrementingHasher hasher = new IncrementingHasher(5L, 12L);
        CountingBloomFilter bf1 = (CountingBloomFilter)this.createFilter(shape, hasher);
        Assertions.assertEquals((int)6, (int)bf1.cardinality());
        bf1.processCells((x, y) -> {
            Assertions.assertEquals((int)1, (int)y, (String)"Hasher in constructor results in value not equal to 1");
            return true;
        });
        bf1 = (CountingBloomFilter)this.createEmptyFilter(shape);
        bf1.merge((Hasher)hasher);
        Assertions.assertEquals((int)6, (int)bf1.cardinality());
        bf1.processCells((x, y) -> {
            Assertions.assertEquals((int)1, (int)y, (String)"Hasher in merge results in value not equal to 1");
            return true;
        });
        bf1 = (CountingBloomFilter)this.createEmptyFilter(shape);
        bf1.merge((Hasher)hasher);
        bf1.remove((Hasher)hasher);
        Assertions.assertEquals((int)0, (int)bf1.cardinality());
        Assertions.assertTrue((boolean)bf1.processCells((x, y) -> false), (String)"Hasher in removes results in value not equal to 0");
    }

    @Test
    public void testGetMaxInsert() {
        CountingBloomFilter bf = (CountingBloomFilter)this.createEmptyFilter(this.getTestShape());
        this.verifyMaxInsert(bf, 0, 0);
        bf.merge(TestingHashers.FROM1);
        this.verifyMaxInsert(bf, 1, 0);
        bf.merge(TestingHashers.FROM1);
        this.verifyMaxInsert(bf, 2, 0);
        bf.merge(TestingHashers.FROM11);
        this.verifyMaxInsert(bf, 2, 1);
        bf.remove(TestingHashers.FROM1);
        this.verifyMaxInsert(bf, 1, 1);
        Assertions.assertEquals((int)1, (int)bf.getMaxInsert((Hasher)new IncrementingHasher(5L, 1L)));
        bf.remove((Hasher)new IncrementingHasher(5L, 1L));
        this.verifyMaxInsert(bf, 0, 0);
        Assertions.assertEquals((int)0, (int)bf.getMaxInsert((Hasher)new IncrementingHasher(5L, 1L)));
    }

    @Test
    public final void testRemove() {
        SimpleBloomFilter simple = new SimpleBloomFilter(this.getTestShape());
        simple.merge(TestingHashers.FROM11);
        CountingBloomFilter bf1 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        bf1.add(CellExtractor.from((IndexExtractor)TestingHashers.FROM11.indices(this.getTestShape())));
        Assertions.assertTrue((boolean)bf1.remove((BloomFilter)simple), (String)"Remove should work");
        Assertions.assertFalse((boolean)bf1.contains(TestingHashers.FROM11), (String)"Should not contain");
        Assertions.assertTrue((boolean)bf1.contains(TestingHashers.FROM1), (String)"Should contain");
        AbstractCountingBloomFilterTest.assertCounts(bf1, from1Counts);
        CountingBloomFilter bf2 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        bf2.add(CellExtractor.from((IndexExtractor)TestingHashers.FROM11.indices(this.getTestShape())));
        Assertions.assertTrue((boolean)bf2.remove(TestingHashers.FROM11), (String)"Remove should work");
        Assertions.assertFalse((boolean)bf2.contains(TestingHashers.FROM11), (String)"Should not contain");
        Assertions.assertTrue((boolean)bf2.contains(TestingHashers.FROM1), (String)"Should contain");
        AbstractCountingBloomFilterTest.assertCounts(bf2, from1Counts);
        CountingBloomFilter bf3 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        Assertions.assertFalse((boolean)bf3.remove((BloomFilter)simple), (String)"Subtract should not work");
        Assertions.assertFalse((boolean)bf3.isValid(), (String)"isValid should return false");
        Assertions.assertFalse((boolean)bf3.contains(TestingHashers.FROM1), (String)"Should not contain");
        Assertions.assertFalse((boolean)bf3.contains((BloomFilter)simple), (String)"Should not contain");
        AbstractCountingBloomFilterTest.assertCounts(bf3, new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
        IndexExtractor ip = TestingHashers.FROM11.indices(this.getTestShape());
        CountingBloomFilter bf4 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        bf4.add(CellExtractor.from((IndexExtractor)TestingHashers.FROM11.indices(this.getTestShape())));
        Assertions.assertTrue((boolean)bf4.remove(ip), (String)"Remove should work");
        Assertions.assertFalse((boolean)bf4.contains(TestingHashers.FROM11), (String)"Should not contain");
        Assertions.assertTrue((boolean)bf4.contains(TestingHashers.FROM1), (String)"Should contain");
        AbstractCountingBloomFilterTest.assertCounts(bf4, from1Counts);
        BitMapExtractor bmp = BitMapExtractor.fromIndexExtractor((IndexExtractor)ip, (int)this.getTestShape().getNumberOfBits());
        CountingBloomFilter bf5 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        bf5.add(CellExtractor.from((IndexExtractor)TestingHashers.FROM11.indices(this.getTestShape())));
        Assertions.assertTrue((boolean)bf5.remove(bmp), (String)"Remove should work");
        Assertions.assertFalse((boolean)bf5.contains(TestingHashers.FROM11), (String)"Should not contain");
        Assertions.assertTrue((boolean)bf5.contains(TestingHashers.FROM1), (String)"Should contain");
        AbstractCountingBloomFilterTest.assertCounts(bf5, from1Counts);
        IndexExtractor ip2 = IndexExtractor.fromIndexArray((int[])new int[]{1, 2, this.getTestShape().getNumberOfBits()});
        CountingBloomFilter bf6 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf6.remove(ip2));
        CountingBloomFilter bf7 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        BitMapExtractor bmp2 = BitMapExtractor.fromIndexExtractor((IndexExtractor)ip2, (int)this.getTestShape().getNumberOfBits());
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf7.remove(bmp2));
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf7.remove((Hasher)new AbstractBloomFilterTest.BadHasher(-1)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf7.remove((Hasher)new AbstractBloomFilterTest.BadHasher(this.getTestShape().getNumberOfBits())));
    }

    @Test
    public final void testSubtract() {
        CountingBloomFilter bf1 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        bf1.add(CellExtractor.from((IndexExtractor)TestingHashers.FROM11.indices(this.getTestShape())));
        CountingBloomFilter bf2 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM11);
        Assertions.assertTrue((boolean)bf1.subtract((CellExtractor)bf2), (String)"Subtract should work");
        Assertions.assertFalse((boolean)bf1.contains((BloomFilter)TestingHashers.populateFromHashersFrom1AndFrom11(new SimpleBloomFilter(this.getTestShape()))), (String)"Should not contain bitHasher");
        Assertions.assertTrue((boolean)bf1.contains(TestingHashers.FROM1), (String)"Should contain TestingHashers.from1");
        AbstractCountingBloomFilterTest.assertCounts(bf1, from1Counts);
        CountingBloomFilter bf3 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        CountingBloomFilter bf4 = (CountingBloomFilter)this.createFilter(this.getTestShape(), TestingHashers.FROM11);
        Assertions.assertFalse((boolean)bf3.subtract((CellExtractor)bf4), (String)"Subtract should not work");
        Assertions.assertFalse((boolean)bf3.isValid(), (String)"isValid should return false");
        Assertions.assertFalse((boolean)bf3.contains(TestingHashers.FROM1), (String)"Should not contain");
        Assertions.assertFalse((boolean)bf3.contains((BloomFilter)bf4), (String)"Should not contain");
        AbstractCountingBloomFilterTest.assertCounts(bf3, new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0});
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf3.remove((Hasher)new AbstractBloomFilterTest.BadHasher(-1)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf3.remove((Hasher)new AbstractBloomFilterTest.BadHasher(this.getTestShape().getNumberOfBits())));
    }

    private void verifyMaxInsert(CountingBloomFilter bf, int from1, int from11) {
        DefaultBloomFilterTest.SparseDefaultBloomFilter bfFrom0 = new DefaultBloomFilterTest.SparseDefaultBloomFilter(this.getTestShape());
        bfFrom0.merge(new IncrementingHasher(0L, 1L));
        DefaultBloomFilterTest.SparseDefaultBloomFilter bfFrom1 = new DefaultBloomFilterTest.SparseDefaultBloomFilter(this.getTestShape());
        bfFrom1.merge(TestingHashers.FROM1);
        DefaultBloomFilterTest.SparseDefaultBloomFilter bfFrom11 = new DefaultBloomFilterTest.SparseDefaultBloomFilter(this.getTestShape());
        bfFrom11.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)0, (int)bf.getMaxInsert((Hasher)new IncrementingHasher(0L, 1L)));
        Assertions.assertEquals((int)0, (int)bf.getMaxInsert((BloomFilter)bfFrom0));
        Assertions.assertEquals((int)0, (int)bf.getMaxInsert((BitMapExtractor)bfFrom0));
        Assertions.assertEquals((int)0, (int)bf.getMaxInsert((IndexExtractor)bfFrom0));
        Assertions.assertEquals((int)from1, (int)bf.getMaxInsert(TestingHashers.FROM1));
        Assertions.assertEquals((int)from1, (int)bf.getMaxInsert((BloomFilter)bfFrom1));
        Assertions.assertEquals((int)from1, (int)bf.getMaxInsert((BitMapExtractor)bfFrom1));
        Assertions.assertEquals((int)from1, (int)bf.getMaxInsert((IndexExtractor)bfFrom1));
        Assertions.assertEquals((int)from11, (int)bf.getMaxInsert(TestingHashers.FROM11));
        Assertions.assertEquals((int)from11, (int)bf.getMaxInsert((BloomFilter)bfFrom11));
        Assertions.assertEquals((int)from11, (int)bf.getMaxInsert((BitMapExtractor)bfFrom11));
        Assertions.assertEquals((int)from11, (int)bf.getMaxInsert((IndexExtractor)bfFrom11));
    }
}

