/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.NettyOptions;
import com.google.common.util.concurrent.SidecarRateLimiter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.adapters.base.CassandraFactory;
import org.apache.cassandra.sidecar.adapters.cassandra41.Cassandra41Factory;
import org.apache.cassandra.sidecar.cluster.CQLSessionProviderImpl;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.InstancesMetadataImpl;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadataImpl;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.ICassandraFactory;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.utils.ByteUtils;
import org.apache.cassandra.sidecar.common.server.utils.DriverUtils;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.SidecarVersionProvider;
import org.apache.cassandra.sidecar.config.CassandraInputValidationConfiguration;
import org.apache.cassandra.sidecar.config.InstanceConfiguration;
import org.apache.cassandra.sidecar.config.JmxConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.yaml.SidecarConfigurationImpl;
import org.apache.cassandra.sidecar.db.schema.TableSchemaFetcher;
import org.apache.cassandra.sidecar.metrics.MetricRegistryFactory;
import org.apache.cassandra.sidecar.metrics.instance.InstanceHealthMetrics;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.utils.CassandraVersionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationModule.class);
    protected final Path confPath;

    public ConfigurationModule() {
        this.confPath = null;
    }

    public ConfigurationModule(Path confPath) {
        this.confPath = confPath;
    }

    @Provides
    @Singleton
    SidecarConfiguration sidecarConfiguration() throws IOException {
        if (this.confPath == null) {
            throw new NullPointerException("the YAML configuration path for Sidecar has not been defined.");
        }
        return SidecarConfigurationImpl.readYamlConfiguration(this.confPath);
    }

    @Provides
    @Singleton
    ServiceConfiguration serviceConfiguration(SidecarConfiguration sidecarConfiguration) {
        return sidecarConfiguration.serviceConfiguration();
    }

    @Provides
    @Singleton
    CassandraInputValidationConfiguration validationConfiguration(SidecarConfiguration configuration) {
        return configuration.cassandraInputValidationConfiguration();
    }

    @Provides
    @Singleton
    CQLSessionProvider cqlSessionProvider(Vertx vertx, SidecarConfiguration sidecarConfiguration, DriverUtils driverUtils) {
        CQLSessionProviderImpl cqlSessionProvider = new CQLSessionProviderImpl(sidecarConfiguration, NettyOptions.DEFAULT_INSTANCE, driverUtils);
        vertx.eventBus().localConsumer(SidecarServerEvents.ON_SERVER_STOP.address(), message -> cqlSessionProvider.close());
        return cqlSessionProvider;
    }

    @Provides
    @Singleton
    CassandraVersionProvider cassandraVersionProvider(DnsResolver dnsResolver, DriverUtils driverUtils, TableSchemaFetcher tableSchemaFetcher) {
        return new CassandraVersionProvider.Builder().add((ICassandraFactory)new CassandraFactory(dnsResolver, driverUtils, tableSchemaFetcher)).add((ICassandraFactory)new Cassandra41Factory(dnsResolver, driverUtils, tableSchemaFetcher)).build();
    }

    @Provides
    @Singleton
    @Named(value="StreamRequestRateLimiter")
    SidecarRateLimiter streamRequestRateLimiter(ServiceConfiguration config) {
        long permitsPerSecond = config.throttleConfiguration().rateLimitStreamRequestsPerSecond();
        LOGGER.info("Configuring streamRequestRateLimiter. rateLimitStreamRequestsPerSecond={}", (Object)permitsPerSecond);
        return SidecarRateLimiter.create(permitsPerSecond);
    }

    @Provides
    @Singleton
    @Named(value="IngressFileRateLimiter")
    SidecarRateLimiter ingressFileRateLimiter(ServiceConfiguration config) {
        long bytesPerSecond = config.trafficShapingConfiguration().inboundGlobalFileBandwidthBytesPerSecond();
        LOGGER.info("Configuring ingressFileRateLimiter. inboundGlobalFileBandwidth={}/s rawInboundGlobalFileBandwidth={} B/s", (Object)ByteUtils.bytesToHumanReadableBinaryPrefix((long)bytesPerSecond), (Object)bytesPerSecond);
        return SidecarRateLimiter.create(bytesPerSecond);
    }

    @Provides
    @Singleton
    InstancesMetadata instancesMetadata(Vertx vertx, SidecarConfiguration configuration, CassandraVersionProvider cassandraVersionProvider, SidecarVersionProvider sidecarVersionProvider, DnsResolver dnsResolver, CQLSessionProvider cqlSessionProvider, DriverUtils driverUtils, MetricRegistryFactory registryProvider) {
        List<InstanceMetadata> instanceMetadataList = configuration.cassandraInstances().stream().map(cassandraInstance -> {
            JmxConfiguration jmxConfiguration = configuration.serviceConfiguration().jmxConfiguration();
            return ConfigurationModule.buildInstanceMetadata(vertx, cassandraInstance, cassandraVersionProvider, sidecarVersionProvider.sidecarVersion(), jmxConfiguration, cqlSessionProvider, driverUtils, registryProvider, dnsResolver);
        }).collect(Collectors.toList());
        return new InstancesMetadataImpl(instanceMetadataList, dnsResolver);
    }

    private static InstanceMetadata buildInstanceMetadata(Vertx vertx, InstanceConfiguration cassandraInstance, CassandraVersionProvider versionProvider, String sidecarVersion, JmxConfiguration jmxConfiguration, CQLSessionProvider session, DriverUtils driverUtils, MetricRegistryFactory registryFactory, DnsResolver dnsResolver) {
        String host = cassandraInstance.host();
        int port = cassandraInstance.port();
        JmxClient jmxClient = JmxClient.builder().host(cassandraInstance.jmxHost()).port(cassandraInstance.jmxPort()).role(cassandraInstance.jmxRole()).password(cassandraInstance.jmxRolePassword()).enableSsl(cassandraInstance.jmxSslEnabled()).connectionMaxRetries(jmxConfiguration.maxRetries()).connectionRetryDelay((DurationSpec)jmxConfiguration.retryDelay()).build();
        MetricRegistry instanceSpecificRegistry = registryFactory.getOrCreate(cassandraInstance.id());
        CassandraAdapterDelegate delegate = new CassandraAdapterDelegate(vertx, cassandraInstance.id(), versionProvider, session, jmxClient, driverUtils, sidecarVersion, host, port, new InstanceHealthMetrics(instanceSpecificRegistry));
        return InstanceMetadataImpl.builder().id(cassandraInstance.id()).host(host, dnsResolver).port(port).storageDir(cassandraInstance.storageDir()).dataDirs(cassandraInstance.dataDirs()).stagingDir(cassandraInstance.stagingDir()).cdcDir(cassandraInstance.cdcDir()).commitlogDir(cassandraInstance.commitlogDir()).hintsDir(cassandraInstance.hintsDir()).savedCachesDir(cassandraInstance.savedCachesDir()).localSystemDataFileDir(cassandraInstance.localSystemDataFileDir()).delegate(delegate).metricRegistry(instanceSpecificRegistry).build();
    }
}

