/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	camelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	scheme "github.com/apache/camel-k/v2/pkg/client/camel/clientset/versioned/scheme"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PipesGetter has a method to return a PipeInterface.
// A group's client should implement this interface.
type PipesGetter interface {
	Pipes(namespace string) PipeInterface
}

// PipeInterface has methods to work with Pipe resources.
type PipeInterface interface {
	Create(ctx context.Context, pipe *v1.Pipe, opts metav1.CreateOptions) (*v1.Pipe, error)
	Update(ctx context.Context, pipe *v1.Pipe, opts metav1.UpdateOptions) (*v1.Pipe, error)
	UpdateStatus(ctx context.Context, pipe *v1.Pipe, opts metav1.UpdateOptions) (*v1.Pipe, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Pipe, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.PipeList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Pipe, err error)
	Apply(ctx context.Context, pipe *camelv1.PipeApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Pipe, err error)
	ApplyStatus(ctx context.Context, pipe *camelv1.PipeApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Pipe, err error)
	GetScale(ctx context.Context, pipeName string, options metav1.GetOptions) (*autoscalingv1.Scale, error)
	UpdateScale(ctx context.Context, pipeName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (*autoscalingv1.Scale, error)

	PipeExpansion
}

// pipes implements PipeInterface
type pipes struct {
	client rest.Interface
	ns     string
}

// newPipes returns a Pipes
func newPipes(c *CamelV1Client, namespace string) *pipes {
	return &pipes{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the pipe, and returns the corresponding pipe object, and an error if there is any.
func (c *pipes) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Pipe, err error) {
	result = &v1.Pipe{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("pipes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Pipes that match those selectors.
func (c *pipes) List(ctx context.Context, opts metav1.ListOptions) (result *v1.PipeList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.PipeList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("pipes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested pipes.
func (c *pipes) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("pipes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a pipe and creates it.  Returns the server's representation of the pipe, and an error, if there is any.
func (c *pipes) Create(ctx context.Context, pipe *v1.Pipe, opts metav1.CreateOptions) (result *v1.Pipe, err error) {
	result = &v1.Pipe{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("pipes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(pipe).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a pipe and updates it. Returns the server's representation of the pipe, and an error, if there is any.
func (c *pipes) Update(ctx context.Context, pipe *v1.Pipe, opts metav1.UpdateOptions) (result *v1.Pipe, err error) {
	result = &v1.Pipe{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("pipes").
		Name(pipe.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(pipe).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *pipes) UpdateStatus(ctx context.Context, pipe *v1.Pipe, opts metav1.UpdateOptions) (result *v1.Pipe, err error) {
	result = &v1.Pipe{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("pipes").
		Name(pipe.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(pipe).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the pipe and deletes it. Returns an error if one occurs.
func (c *pipes) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("pipes").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *pipes) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("pipes").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched pipe.
func (c *pipes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Pipe, err error) {
	result = &v1.Pipe{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("pipes").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied pipe.
func (c *pipes) Apply(ctx context.Context, pipe *camelv1.PipeApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Pipe, err error) {
	if pipe == nil {
		return nil, fmt.Errorf("pipe provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(pipe)
	if err != nil {
		return nil, err
	}
	name := pipe.Name
	if name == nil {
		return nil, fmt.Errorf("pipe.Name must be provided to Apply")
	}
	result = &v1.Pipe{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("pipes").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *pipes) ApplyStatus(ctx context.Context, pipe *camelv1.PipeApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Pipe, err error) {
	if pipe == nil {
		return nil, fmt.Errorf("pipe provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(pipe)
	if err != nil {
		return nil, err
	}

	name := pipe.Name
	if name == nil {
		return nil, fmt.Errorf("pipe.Name must be provided to Apply")
	}

	result = &v1.Pipe{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("pipes").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// GetScale takes name of the pipe, and returns the corresponding autoscalingv1.Scale object, and an error if there is any.
func (c *pipes) GetScale(ctx context.Context, pipeName string, options metav1.GetOptions) (result *autoscalingv1.Scale, err error) {
	result = &autoscalingv1.Scale{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("pipes").
		Name(pipeName).
		SubResource("scale").
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// UpdateScale takes the top resource name and the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *pipes) UpdateScale(ctx context.Context, pipeName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	result = &autoscalingv1.Scale{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("pipes").
		Name(pipeName).
		SubResource("scale").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(scale).
		Do(ctx).
		Into(result)
	return
}
