#!/usr/bin/perl

package eBay::API::XML::Call::GetItemShipping::GetItemShippingResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetItemShippingResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetItemShipping::GetItemShippingResponseType

=head1 DESCRIPTION

Contains the data returned by the call. The shipping details for the specified
item are returned in a ShippingDetails object.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetItemShipping::GetItemShippingResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::ShippingDetailsType;


my @gaProperties = ( [ 'ShippingDetails', 'ns:ShippingDetailsType', ''
	     ,'eBay::API::XML::DataType::ShippingDetailsType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setShippingDetails()

Shipping-related details for the specified item. Any error about shipping services
(returned by a vendor of eBay's who calculates shipping costs) is returned in
ShippingRateErrorMessage. Errors from a shipping service are likely to be related to
issues with shipping specifications, such as package size and the selected shipping
method not supported by a particular shipping service.<br>
<br>It is possible for a seller to offer a shipping service which turns out
to be a mismatch in some way with the item(s) being shipped. For example, if a
buyer purchases more than one of an item, the weight might be too great for First
Class mail. In such a case, GetItemShipping will omit that shipping service from
the response.

#    Argument: 'ns:ShippingDetailsType'

=cut

sub setShippingDetails {
  my $self = shift;
  $self->{'ShippingDetails'} = shift
}

=head2 getShippingDetails()

  Returned: Always
#    Returns: 'ns:ShippingDetailsType'

=cut

sub getShippingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingDetails'
		,'eBay::API::XML::DataType::ShippingDetailsType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
