package App::USBKeyCopyCon::Chrome;


use constant ROW_TOP    =>  67;
use constant ROW_BOTTOM => 126;

my $rendered_icons;

my @usb_blank = (
    '39 100 34 1',
    ' 	c None',
    '.	c #4B6165',
    '+	c #696B68',
    '@	c #74699F',
    '#	c #7B6D9E',
    '$	c #66787D',
    '%	c #8071A2',
    '&	c #8178A8',
    '*	c #897DA8',
    '=	c #8E82AD',
    '-	c #8885A1',
    ';	c #868F91',
    '>	c #8E8AB3',
    ',	c #918CB6',
    'a	c #8E8FA4',
    ')	c #978FB3',
    '~	c #9692AF',
    '{	c #9B93B8',
    ']	c #9D9ABE',
    '^	c #96A2AF',
    '/	c #A29EBC',
    '(	c #A9A4C2',
    '_	c #9BABB8',
    ':	c #9EAEB4',
    '<	c #B1ACC9',
    '[	c #AFAFC7',
    '}	c #A3B4C0',
    'O	c #B1B3AF',
    '1	c #ADBDC4',
    '2	c #B6C6CD',
    '3	c #C2D2D7',
    '4	c #D5E2E4',
    'G	c #15CA00',
    'R	c #FF0000',
    '       3;;;;;;;;;;;;;;;;;;;;;;;:       ',
    '      43;;;;;;;;;;;;;;;;;;;;;;;:3      ',
    '      4444444444444333333333333332     ',
    '     44444444444333333333333332222     ',
    '     44444443333333333333322222222     ',
    '     44443333333333333322222222222     ',
    '     44433333333333322222222222111     ',
    '     343333:;;;:2222222:;;;^111111     ',
    '     34333......$22222$.....$11111     ',
    '     34331.......12221$.$$$$$^}}}}     ',
    '     34321......$11111$$$$$$$^}}}}     ',
    '     24321$$$$$$$11111$$$$$$$_}}}}     ',
    '     24222;$$$$$^11111:$$$$$;}}___     ',
    '     2421111::::1}}}}}}___________     ',
    '     14211111}11}}}}}}}}}_________     ',
    '     142111}}}}}}}}}}}_________^^^     ',
    '     }41}}}}}}}}}}_________^^_^^^^     ',
    '     }41}}}}}}___________^^^^^^^^^     ',
    '     }4}}}}_________^^^^^^^^^^^^^^     ',
    '     }4}_________^^^^^^^^^^^^^^^^^     ',
    '    ~^4}_______^^^^^^^^^^^^^^^^^^^-    ',
    ' /---a2___^^^^^^^^^^^^^^^^^^^^^^^a---) ',
    ' -----a^^^^^^^^^^^^^^^^^^^^^^^^^a----- ',
    '[[-------aaaaaaaaaaaaaaaaaaaaaa------))',
    '[[[[////////~~~~~~~~~~~~~~~~~~~~-))))))',
    '[[[[[[[[[<<<<((((((/////]]]{{{{{{)))),)',
    '[[[[[[[[[<<<<((((((///]]]{{]{{{{{))),))',
    '[[[[[[[[<<<<((((((///]/]]]]{{{{{))))),>',
    '[[[[[[[<<<<(((((((////]]]]{{{{{{))),,,>',
    '[[[[[[[[<<<((((((////]]]]]{{{{{))))),>>',
    '[[[[[[[<<<((((((////]]]]]{{{{{{))),,>>>',
    '[[[[[[<<<<(((+++++++++++++[{{{))))),>>>',
    '[[[[[[<<<((((+OOOOOOOOOOOO[{{{))),,>>>=',
    '[[[[[<<<<((((+OOOOOOOOOOOO[{{)))),,>>=>',
    '[[[[[[<<(((((+OOOOOOOOOOOO[{{))))))>=>=',
    '[[[[<<<<(((((+OOOOOOOOOOOO[{))))),>>>>>',
    '[[[[[<<((((((+OOOOOOOOOOOO[{))))))>>>==',
    '[[<<<<(((((((+OOOOOOOOOOOO[))))),>>>=>>',
    '[[[<<<(((((((+OOOOOOOOOOOO[))),,,>>====',
    '[[[<<<((((((/+OOOOOOOOOOOO[)))),>>>>===',
    '[<<<<((((((//+OOOOOOOOOOOO[)),,>>>=====',
    '[<<<<((((((//+OOOOOOOOOOOO[))))>>>>====',
    '<<<<((((((///+OOOOOOOOOOOO[),,>>>======',
    '<<<<((((((///+OOOOOOOOOOOO[)),>>>>>====',
    '<<<((((((////+OOOOOOOOOOOO[))>>>>======',
    '<<<((((((////+OOOOOOOOOOOO[),>>>>>=====',
    '<<((((((/////+OOOOOOOOOOOO[,>>>>======*',
    '<(((((((////]+OOOOOOOOOOOO[,>>>=>=====*',
    '<(((((((////]+OOOOOOOOOOOO[)>>=======**',
    '<((((((///]]]+OOOOOOOOOOOO[>>>>=====***',
    '((((((/////]]+OOOOOOOOOOOO[>===>====***',
    '((((((///]]]]+OOOOOOOOOOOO[>>>=====****',
    '(((((/////]]{+OOOOOOOOOOOO<===>====****',
    '(((((////]]]]+OOOOOOOOOOOO<>>>=====****',
    '((((/////]]]{+OOOOOOOOOOOO<=======****&',
    '((((///]]]]{]+OOOOOOOOOOOO<>>=====****&',
    '(((///]/]]]]{+OOOOOOOOOOOO<======***&&&',
    '(((////]]]{{]+OOOOOOOOOOOO<>=====***&&&',
    '(((////]]{]{{+OOOOOOOOOOOO<=====****&&&',
    '((///]]]]]{{{+OOOOOOOOOOOO<>===****&&&&',
    '(////]]]]]{{{+OOOOOOOOOOOO<====****&&&%',
    '////]]]]]{{{{+OOOOOOOOOOOO<===****&&&&&',
    '////]]]]]{{{{+OOOOOOOOOOOO<===****&&&%&',
    '///]]]]]]{{{{+OOOOOOOOOOOO<===***&&&&&&',
    '////]]]{{{{{{+OOOOOOOOOOOO<==****&&&&%%',
    '//]]]]{]{{{{{+OOOOOOOOOOOO<=****&&&&%&%',
    '/]/]]]]{{{{{)+OOOOOOOOOOOO<=***&&&&&&%%',
    '//]]]{{{{{{))+OOOOOOOOOOOO<****&&&&%%%%',
    '/]]]]]{{{{{))+OOOOOOOOOOOO<****&&&&&&%%',
    '/]]]]{{{{{{))+OOOOOOOOOOOO<***&&&&&%%%%',
    ']]]]]{{{{{)))+OOOOOOOOOOOO<***&&&&&&%%%',
    ']]]]{{{{{{)))+OOOOOOOOOOOO<**&&&&&%%%%%',
    ']]]]{{{{{))))+OOOOOOOOOOOO<**&&&&&&%%%%',
    ']{]]{{{{{))))+OOOOOOOOOOOO<*&&&%&&%%%%%',
    ']]{{{{{{)))),+OOOOOOOOOOOO(*&&&&%%%%%%%',
    '{{]{{{{{))),)+OOOOOOOOOOOO(&&&%%&%%%%%%',
    ']]{{{{{))))),+OOOOOOOOOOOO(&&&&&%%%%%%#',
    '{{{{{{)))),,)+OOOOOOOOOOOO(&&%%%%%%%%%#',
    ']{{{{{))))),>+OOOOOOOOOOOO(&&&&&%%%%%##',
    '{{{{{{))),,>>+OOOOOOOOOOOO(&&%%%%%%%##@',
    ']{{{{))))),>>+OOOOOOOOOOOO(&&&&%%%%%###',
    '{{{{)))),,>>>+OOOOOOOOOOOO(&%%%%%%%##@@',
    '{{{{))))),>>>+OOOOOOOOOOOO(&&&%%%%%#@#@',
    '{{{{))))))>>>+OOOOOOOOOOOO(&%%%%%%%##@@',
    '{{{))))),>>>>+OOOOOOOOOOOO(%&%%%%%##@@@',
    '{{{))))))>>>=+OOOOOOOOOOOO(%%%%%%%##@@@',
    '{{))))),>>>=>+OOOOOOOOOOOO(&%%%%%##@@@@',
    '{))))),)>>>>=+OOOOOOOOOOOO(%%%%%%##@@@@',
    '{))))))>>>>==+OOOOOOOOOOOO(%%%%%###@@@@',
    ')))),,>>>====+OOOOOOOOOOOO(%%%%###@@@@@',
    '))))))>>>>===+OOOOOOOOOOOO/%%%%###@@@@@',
    '))),,>>>=====+OOOOOOOOOOOO/%%%###@@@@@@',
    ')))))>>>>====+{{{{))))),)=/%%%###@@@@@@',
    '))),>>>>=======****&&&&&&%%%%###@@@@@@@',
    '))),>>>>>=====****&&&&&&%%%%%##@@@@@@@@',
    ')),>>>>======****&&&&&%%%%%%###@@@@@@@@',
    ',,,>>>=>=====***&&&&&%&%%%%%##@@@@@@@@@',
    '),>>>>>=====****&&&&&&%%%%%###@@@@@@@@@',
    ' >>>>>=>===****&&&&&&%%%%%%###@@@@@@@@ ',
    '  >==>>====****&&&%%%%%%%%###@@@@@@@@  ',
);

my @usb_ignored = (
    '39 100 27 1',
    ' 	c None',
    '.	c #8B8B8B',
    '+	c #979797',
    '@	c #9C9C9C',
    '#	c #AAAAAA',
    '$	c #ADADAD',
    '%	c #AFAFAF',
    '&	c #B2B2B2',
    '*	c #B3B3B3',
    '=	c #B4B4B4',
    '-	c #B7B7B7',
    ';	c #B8B8B8',
    '>	c #BCBCBC',
    ',	c #BDBDBD',
    'a	c #BEBEBE',
    ')	c #C1C1C1',
    '!	c #C3C3C3',
    '~	c #C5C5C5',
    '{	c #C6C6C6',
    ']	c #C9C9C9',
    '^	c #CACACA',
    '/	c #CECECE',
    '(	c #CFCFCF',
    '_	c #D0D0D0',
    ':	c #D4D4D4',
    '<	c #DCDCDC',
    '[	c #E7E7E7',
    '       ]%%%%%%%%%%%%%%%%%%%%%%%!       ',
    '      [<%%%%%%%%%%%%%%%%%%%%%%%!<      ',
    '      [[[[[[[[[[[[[<<<<<<<<<<<<<<:     ',
    '     [[[[[[[[[[[<<<<<<<<<<<<<<::::     ',
    '     [[[[[[[<<<<<<<<<<<<<<::::::::     ',
    '     [[[[<<<<<<<<<<<<<<:::::::::::     ',
    '     [[[<<<<<<<<<<<<:::::::::::///     ',
    '     <[<<<<!%%%!:::::::!%%%a//////     ',
    '     <[<<<......@:::::@.....@/////     ',
    '     <[<</......./:::/@.@@@@@a]]]]     ',
    '     <[<:/......@/////@@@@@@@a]]]]     ',
    '     :[<:/@@@@@@@/////@@@@@@@!]]]]     ',
    '     :[:::%@@@@@a/////!@@@@@%]]!!!     ',
    '     :[:////!!!!/]]]]]]!!!!!!!!!!!     ',
    '     /[://///]//]]]]]]]]]!!!!!!!!!     ',
    '     /[:///]]]]]]]]]]]!!!!!!!!!aaa     ',
    '     ][/]]]]]]]]]]!!!!!!!!!aa!aaaa     ',
    '     ][/]]]]]]!!!!!!!!!!!aaaaaaaaa     ',
    '     ][]]]]!!!!!!!!!aaaaaaaaaaaaaa     ',
    '     ][]!!!!!!!!!aaaaaaaaaaaaaaaaa     ',
    '    ,a[]!!!!!!!aaaaaaaaaaaaaaaaaaa=    ',
    ' {===;:!!!aaaaaaaaaaaaaaaaaaaaaaa;===a ',
    ' =====;aaaaaaaaaaaaaaaaaaaaaaaaa;===== ',
    '__=======;;;;;;;;;;;;;;;;;;;;;;======aa',
    '____{{{{{{{{,,,,,,,,,,,,,,,,,,,,=aaaaaa',
    '_________((((^^^^^^{{{{{~~~))))))aaaaaa',
    '_________((((^^^^^^{{{~~~))~)))))aaaaaa',
    '________((((^^^^^^{{{~{~~~~)))))aaaaaa>',
    '_______((((^^^^^^^{{{{~~~~))))))aaaaaa>',
    '________(((^^^^^^{{{{~~~~~)))))aaaaaa>>',
    '_______(((^^^+++++++++++++_))))aaaaa>>>',
    '______((((^^^+]]]]]]]]]]]]_)))aaaaaa>>>',
    '______(((^^^^+]]]]]]]]]]]]_)))aaaaa>>>-',
    '_____((((^^^^+]]]]]]]]]]]]_))aaaaaa>>->',
    '______((^^^^^+]]]]]]]]]]]]_))aaaaaa>->-',
    '____((((^^^^^+]]]]]]]]]]]]_)aaaaaa>>>>>',
    '_____((^^^^^^+]]]]]]]]]]]]_)aaaaaa>>>--',
    '__((((^^^^^^^+]]]]]]]]]]]]_aaaaaa>>>->>',
    '___(((^^^^^^^+]]]]]]]]]]]]_aaaaaa>>----',
    '___(((^^^^^^{+]]]]]]]]]]]]_aaaaa>>>>---',
    '_((((^^^^^^{{+]]]]]]]]]]]]_aaaa>>>-----',
    '_((((^^^^^^{{+]]]]]]]]]]]]_aaaa>>>>----',
    '((((^^^^^^{{{+]]]]]]]]]]]]_aaa>>>------',
    '((((^^^^^^{{{+]]]]]]]]]]]]_aaa>>>>>----',
    '(((^^^^^^{{{{+]]]]]]]]]]]]_aa>>>>------',
    '(((^^^^^^{{{{+]]]]]]]]]]]]_aa>>>>>-----',
    '((^^^^^^{{{{{+]]]]]]]]]]]]_a>>>>------*',
    '(^^^^^^^{{{{~+]]]]]]]]]]]]_a>>>->-----*',
    '(^^^^^^^{{{{~+]]]]]]]]]]]]_a>>-------**',
    '(^^^^^^{{{~~~+]]]]]]]]]]]]_>>>>-----***',
    '^^^^^^{{{{{~~+]]]]]]]]]]]]_>--->----***',
    '^^^^^^{{{~~~~+]]]]]]]]]]]]_>>>-----****',
    '^^^^^{{{{{~~)+]]]]]]]]]]]](--->----****',
    '^^^^^{{{{~~~~+]]]]]]]]]]]](>>>-----****',
    '^^^^{{{{{~~~)+]]]]]]]]]]]](-------****&',
    '^^^^{{{~~~~)~+]]]]]]]]]]]](>>-----****&',
    '^^^{{{~{~~~~)+]]]]]]]]]]]](------***&&&',
    '^^^{{{{~~~))~+]]]]]]]]]]]](>-----***&&&',
    '^^^{{{{~~)~))+]]]]]]]]]]]](-----****&&&',
    '^^{{{~~~~~)))+]]]]]]]]]]]](>---****&&&&',
    '^{{{{~~~~~)))+]]]]]]]]]]]](----****&&&$',
    '{{{{~~~~~))))+]]]]]]]]]]]](---****&&&&&',
    '{{{{~~~~~))))+]]]]]]]]]]]](---****&&&$&',
    '{{{~~~~~~))))+]]]]]]]]]]]](---***&&&&&&',
    '{{{{~~~))))))+]]]]]]]]]]]](--****&&&&$$',
    '{{~~~~)~)))))+]]]]]]]]]]]](-****&&&&$&$',
    '{~{~~~~)))))a+]]]]]]]]]]]](-***&&&&&&$$',
    '{{~~~))))))aa+]]]]]]]]]]]](****&&&&$$$$',
    '{~~~~~)))))aa+]]]]]]]]]]]](****&&&&&&$$',
    '{~~~~))))))aa+]]]]]]]]]]]](***&&&&&$$$$',
    '~~~~~)))))aaa+]]]]]]]]]]]](***&&&&&&$$$',
    '~~~~))))))aaa+]]]]]]]]]]]](**&&&&&$$$$$',
    '~~~~)))))aaaa+]]]]]]]]]]]](**&&&&&&$$$$',
    '~)~~)))))aaaa+]]]]]]]]]]]](*&&&$&&$$$$$',
    '~~))))))aaaaa+]]]]]]]]]]]]^*&&&&$$$$$$$',
    '))~)))))aaaaa+]]]]]]]]]]]]^&&&$$&$$$$$$',
    '~~)))))aaaaaa+]]]]]]]]]]]]^&&&&&$$$$$$#',
    '))))))aaaaaaa+]]]]]]]]]]]]^&&$$$$$$$$$#',
    '~)))))aaaaaa>+]]]]]]]]]]]]^&&&&&$$$$$##',
    '))))))aaaaa>>+]]]]]]]]]]]]^&&$$$$$$$###',
    '~))))aaaaaa>>+]]]]]]]]]]]]^&&&&$$$$$###',
    '))))aaaaaa>>>+]]]]]]]]]]]]^&$$$$$$$####',
    '))))aaaaaa>>>+]]]]]]]]]]]]^&&&$$$$$####',
    '))))aaaaaa>>>+]]]]]]]]]]]]^&$$$$$$$####',
    ')))aaaaaa>>>>+]]]]]]]]]]]]^$&$$$$$#####',
    ')))aaaaaa>>>-+]]]]]]]]]]]]^$$$$$$$#####',
    '))aaaaaa>>>->+]]]]]]]]]]]]^&$$$$$######',
    ')aaaaaaa>>>>-+]]]]]]]]]]]]^$$$$$$######',
    ')aaaaaa>>>>--+]]]]]]]]]]]]^$$$$$#######',
    'aaaaaa>>>----+]]]]]]]]]]]]^$$$$########',
    'aaaaaa>>>>---+]]]]]]]]]]]]{$$$$########',
    'aaaaa>>>-----+]]]]]]]]]]]]{$$$#########',
    'aaaaa>>>>----+]]]]]]]]]]]]{$$$#########',
    'aaaa>>>>-----+))))aaaaaaa-&$$##########',
    'aaaa>>>>>-----****&&&&&&$$$$$##########',
    'aaa>>>>------****&&&&&$$$$$$###########',
    'aaa>>>->-----***&&&&&$&$$$$$###########',
    'aa>>>>>-----****&&&&&&$$$$$############',
    ' >>>>>->---****&&&&&&$$$$$$########### ',
    '  >-->>----****&&&$$$$$$$$###########  ',
);

sub usb_icon {
    my($value) = @_;

    _generate_usb_icons() unless $rendered_icons;
    $value = 'fail' unless exists $rendered_icons->{$value};
    return $rendered_icons->{$value};
}


sub _generate_usb_icons {
    my $span = ROW_BOTTOM - ROW_TOP + 1;
    my @xpm_data;
    foreach my $i (0..10) {
        @xpm_data = @usb_blank;
        if($i > 0) {
            my $top = ROW_BOTTOM - int($span * $i / 10 ) + 1;
            foreach my $r ($top .. ROW_BOTTOM) {
                $xpm_data[$r] =~ s/O/G/g;
            }
        }
        $rendered_icons->{$i} = Gtk2::Gdk::Pixbuf->new_from_xpm_data(@xpm_data);
    }

    @xpm_data = @usb_blank;
    foreach my $r (ROW_TOP .. ROW_BOTTOM) {
        $xpm_data[$r] =~ s/O/R/g;
    }
    $rendered_icons->{fail} = Gtk2::Gdk::Pixbuf->new_from_xpm_data(@xpm_data);

    $rendered_icons->{ignored} = Gtk2::Gdk::Pixbuf->new_from_xpm_data(@usb_ignored);
}


1;

__END__


=head1 NAME

App::USBKeyCopyCon::Chrome - images required by App::USBKeyCopyCon

=head1 DESCRIPTION

This module provides some custom images used by the USBKeyCopyCon GUI app.

=head1 FUNCTIONS

=head2 usb_icon ( status_value )

Returns a Gtk2::Gdk::Pixbuf object representing a USB flash drive.  The image
incorporates a progress bar element which will be rendered according to the
C<status_value> supplied.  Recognised values are:

  0-10   proportion complete (0 = none, 10 = all complete)
  -1     failure (progress bar will turn red)
  -2     disabled (the whole icon will be 'greyed out')

=head1 COPYRIGHT

Copyright 2006 Grant McLean E<lt>grantm@cpan.orgE<gt>

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself. 

=cut

