/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.math.BigDecimal;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public abstract class Converter {
    public static final StringConverter.IdentityConverter IDENTITY_CONVERTER = new StringConverter.IdentityConverter();
    public static final ToUntypedAtomicConverter TO_UNTYPED_ATOMIC = new ToUntypedAtomicConverter();
    public static final ToStringConverter TO_STRING = new ToStringConverter();
    public static final NumericToFloat NUMERIC_TO_FLOAT = new NumericToFloat();
    public static final BooleanToFloat BOOLEAN_TO_FLOAT = new BooleanToFloat();
    public static final NumericToDouble NUMERIC_TO_DOUBLE = new NumericToDouble();
    public static final BooleanToDouble BOOLEAN_TO_DOUBLE = new BooleanToDouble();
    public static final DoubleToDecimal DOUBLE_TO_DECIMAL = new DoubleToDecimal();
    public static final FloatToDecimal FLOAT_TO_DECIMAL = new FloatToDecimal();
    public static final IntegerToDecimal INTEGER_TO_DECIMAL = new IntegerToDecimal();
    public static final NumericToDecimal NUMERIC_TO_DECIMAL = new NumericToDecimal();
    public static final BooleanToDecimal BOOLEAN_TO_DECIMAL = new BooleanToDecimal();
    public static final DoubleToInteger DOUBLE_TO_INTEGER = new DoubleToInteger();
    public static final FloatToInteger FLOAT_TO_INTEGER = new FloatToInteger();
    public static final DecimalToInteger DECIMAL_TO_INTEGER = new DecimalToInteger();
    public static final NumericToInteger NUMERIC_TO_INTEGER = new NumericToInteger();
    public static final BooleanToInteger BOOLEAN_TO_INTEGER = new BooleanToInteger();
    public static final DurationToDayTimeDuration DURATION_TO_DAY_TIME_DURATION = new DurationToDayTimeDuration();
    public static final DurationToYearMonthDuration DURATION_TO_YEAR_MONTH_DURATION = new DurationToYearMonthDuration();
    public static final DateToDateTime DATE_TO_DATE_TIME = new DateToDateTime();
    public static final DateTimeToDate DATE_TIME_TO_DATE = new DateTimeToDate();
    public static final DateTimeToGMonth DATE_TIME_TO_G_MONTH = new DateTimeToGMonth();
    public static final DateTimeToGYearMonth DATE_TIME_TO_G_YEAR_MONTH = new DateTimeToGYearMonth();
    public static final DateTimeToGYear DATE_TIME_TO_G_YEAR = new DateTimeToGYear();
    public static final DateTimeToGMonthDay DATE_TIME_TO_G_MONTH_DAY = new DateTimeToGMonthDay();
    public static final DateTimeToGDay DATE_TIME_TO_G_DAY = new DateTimeToGDay();
    public static final DateTimeToTime DATE_TIME_TO_TIME = new DateTimeToTime();
    public static final NumericToBoolean NUMERIC_TO_BOOLEAN = new NumericToBoolean();
    public static final Base64BinaryToHexBinary BASE64_BINARY_TO_HEX_BINARY = new Base64BinaryToHexBinary();
    public static final HexBinaryToBase64Binary HEX_BINARY_TO_BASE64_BINARY = new HexBinaryToBase64Binary();
    public static final NotationToQName NOTATION_TO_QNAME = new NotationToQName();
    public static final QNameToNotation QNAME_TO_NOTATION = new QNameToNotation();
    private ConversionRules conversionRules;

    public static AtomicValue convert(AtomicValue value, AtomicType targetType, ConversionRules rules) throws ValidationException {
        Converter converter = rules.getConverter(value.getPrimitiveType(), targetType);
        if (converter == null) {
            ValidationFailure ve = new ValidationFailure("Cannot convert value from " + value.getPrimitiveType() + " to " + targetType);
            ve.setErrorCode("FORG0001");
            throw ve.makeException();
        }
        return converter.convert(value).asAtomic();
    }

    protected Converter() {
    }

    protected Converter(ConversionRules rules) {
        this.setConversionRules(rules);
    }

    public abstract ConversionResult convert(AtomicValue var1);

    public final void setConversionRules(ConversionRules rules) {
        this.conversionRules = rules;
    }

    public final ConversionRules getConversionRules() {
        return this.conversionRules;
    }

    public boolean isAlwaysSuccessful() {
        return false;
    }

    public Converter setNamespaceResolver(NamespaceResolver resolver) {
        return this;
    }

    public NamespaceResolver getNamespaceResolver() {
        return null;
    }

    public static class PromoterToFloat
    extends Converter {
        private StringConverter stringToFloat = null;

        public ConversionResult convert(AtomicValue input) {
            if (input instanceof FloatValue) {
                return input;
            }
            if (input instanceof DoubleValue) {
                ValidationFailure err = new ValidationFailure("Cannot promote from xs:double to xs:float");
                err.setErrorCode("XPTY0004");
                return err;
            }
            if (input instanceof NumericValue) {
                return new FloatValue((float)((NumericValue)input).getDoubleValue());
            }
            if (input instanceof UntypedAtomicValue) {
                if (this.stringToFloat == null) {
                    this.stringToFloat = BuiltInAtomicType.FLOAT.getStringConverter(this.getConversionRules());
                }
                return this.stringToFloat.convert(input);
            }
            ValidationFailure err = new ValidationFailure("Cannot promote non-numeric value to xs:double");
            err.setErrorCode("XPTY0004");
            return err;
        }
    }

    public static class PromoterToDouble
    extends Converter {
        private StringConverter stringToDouble = null;

        public ConversionResult convert(AtomicValue input) {
            if (input instanceof DoubleValue) {
                return input;
            }
            if (input instanceof NumericValue) {
                return new DoubleValue(((NumericValue)input).getDoubleValue());
            }
            if (input instanceof UntypedAtomicValue) {
                if (this.stringToDouble == null) {
                    this.stringToDouble = BuiltInAtomicType.DOUBLE.getStringConverter(this.getConversionRules());
                }
                return this.stringToDouble.convert(input);
            }
            ValidationFailure err = new ValidationFailure("Cannot promote non-numeric value to xs:double");
            err.setErrorCode("XPTY0004");
            return err;
        }
    }

    public static class QNameToNotation
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new NotationValue(((QNameValue)input).getStructuredQName(), BuiltInAtomicType.NOTATION);
        }
    }

    public static class NotationToQName
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new QNameValue(((NotationValue)input).getStructuredQName(), BuiltInAtomicType.QNAME);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class HexBinaryToBase64Binary
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new Base64BinaryValue(((HexBinaryValue)input).getBinaryValue());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToBase64BinaryConverter
    extends StringConverter {
        public ConversionResult convert(AtomicValue input) {
            return this.convertString(input.getStringValueCS());
        }

        public ConversionResult convertString(CharSequence input) {
            try {
                return new Base64BinaryValue(input);
            }
            catch (XPathException e) {
                return ValidationFailure.fromException(e);
            }
        }
    }

    public static class Base64BinaryToHexBinary
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new HexBinaryValue(((Base64BinaryValue)input).getBinaryValue());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToBoolean
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                return BooleanValue.get(input.effectiveBooleanValue());
            }
            catch (XPathException err) {
                throw new AssertionError((Object)err);
            }
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToTime
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new TimeValue(dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMicrosecond(), dt.getTimezoneInMinutes());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGDay
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GDayValue(dt.getDay(), dt.getTimezoneInMinutes());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGMonthDay
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GMonthDayValue(dt.getMonth(), dt.getDay(), dt.getTimezoneInMinutes());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGYear
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GYearValue(dt.getYear(), dt.getTimezoneInMinutes(), dt.isXsd10Rules());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGYearMonth
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GYearMonthValue(dt.getYear(), dt.getMonth(), dt.getTimezoneInMinutes(), dt.isXsd10Rules());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToGMonth
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new GMonthValue(dt.getMonth(), dt.getTimezoneInMinutes());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateTimeToDate
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DateTimeValue dt = (DateTimeValue)input;
            return new DateValue(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getTimezoneInMinutes(), dt.isXsd10Rules());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DateToDateTime
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return ((DateValue)input).toDateTime();
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class DurationToYearMonthDuration
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DurationValue d = (DurationValue)input;
            return YearMonthDurationValue.fromMonths(d.getTotalMonths());
        }
    }

    public static class DurationToDayTimeDuration
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            DurationValue d = (DurationValue)input;
            return new DayTimeDurationValue(d.signum(), d.getDays(), d.getHours(), d.getMinutes(), d.getSeconds(), d.getMicroseconds());
        }
    }

    public static class BooleanToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return ((BooleanValue)input).getBooleanValue() ? Int64Value.PLUS_ONE : Int64Value.ZERO;
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                if (input instanceof IntegerValue) {
                    return input;
                }
                if (input instanceof DoubleValue) {
                    return IntegerValue.makeIntegerValue((DoubleValue)input);
                }
                if (input instanceof FloatValue) {
                    return IntegerValue.makeIntegerValue(new DoubleValue(((FloatValue)input).getDoubleValue()));
                }
                return BigIntegerValue.makeIntegerValue(((NumericValue)input).getDecimalValue().toBigInteger());
            }
            catch (ValidationException e) {
                return e.getValidationFailure();
            }
        }
    }

    public static class DecimalToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            if (input instanceof IntegerValue) {
                return input;
            }
            return BigIntegerValue.makeIntegerValue(((BigDecimalValue)input).getDecimalValue().toBigInteger());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class FloatToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return IntegerValue.makeIntegerValue(new DoubleValue(((FloatValue)input).getDoubleValue()));
        }
    }

    public static class DoubleToInteger
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return IntegerValue.makeIntegerValue((DoubleValue)input);
        }
    }

    public static class BooleanToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return ((BooleanValue)input).getBooleanValue() ? BigDecimalValue.ONE : BigDecimalValue.ZERO;
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                BigDecimal decimal = ((NumericValue)input).getDecimalValue();
                return new BigDecimalValue(decimal);
            }
            catch (ValidationException e) {
                return e.getValidationFailure();
            }
        }
    }

    public static class IntegerToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            if (input instanceof Int64Value) {
                return new BigDecimalValue(((Int64Value)input).longValue());
            }
            return new BigDecimalValue(((BigIntegerValue)input).asDecimal());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class FloatToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                return new BigDecimalValue(((FloatValue)input).getFloatValue());
            }
            catch (ValidationException e) {
                return e.getValidationFailure();
            }
        }
    }

    public static class DoubleToDecimal
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            try {
                return new BigDecimalValue(((DoubleValue)input).getDoubleValue());
            }
            catch (ValidationException e) {
                return e.getValidationFailure();
            }
        }
    }

    public static class BooleanToDouble
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new DoubleValue(((BooleanValue)input).getBooleanValue() ? 1.0 : 0.0);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToDouble
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            if (input instanceof DoubleValue) {
                return input;
            }
            return new DoubleValue(((NumericValue)input).getDoubleValue());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class BooleanToFloat
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new FloatValue(((BooleanValue)input).getBooleanValue() ? 1.0f : 0.0f);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class NumericToFloat
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new FloatValue(((NumericValue)input).getFloatValue());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class ToStringConverter
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new StringValue(input.getStringValueCS());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class ToUntypedAtomicConverter
    extends Converter {
        public ConversionResult convert(AtomicValue input) {
            return new UntypedAtomicValue(input.getStringValueCS());
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class TwoPhaseConverter
    extends StringConverter {
        private Converter phaseOne;
        private Converter phaseTwo;

        public TwoPhaseConverter(Converter phaseOne, Converter phaseTwo) {
            this.phaseOne = phaseOne;
            this.phaseTwo = phaseTwo;
        }

        public static TwoPhaseConverter makeTwoPhaseConverter(AtomicType inputType, AtomicType viaType, AtomicType outputType, ConversionRules rules) {
            return new TwoPhaseConverter(rules.getConverter(inputType, viaType), rules.getConverter(viaType, outputType));
        }

        public Converter setNamespaceResolver(NamespaceResolver resolver) {
            return new TwoPhaseConverter(this.phaseOne.setNamespaceResolver(resolver), this.phaseTwo.setNamespaceResolver(resolver));
        }

        public ConversionResult convert(AtomicValue input) {
            ConversionResult temp = this.phaseOne.convert(input);
            if (temp instanceof ValidationFailure) {
                return temp;
            }
            AtomicValue aTemp = (AtomicValue)temp;
            if (this.phaseTwo instanceof DownCastingConverter) {
                return ((DownCastingConverter)this.phaseTwo).convert(aTemp, aTemp.getCanonicalLexicalRepresentation());
            }
            return this.phaseTwo.convert(aTemp);
        }

        public ConversionResult convertString(CharSequence input) {
            ConversionResult temp = ((StringConverter)this.phaseOne).convertString(input);
            if (temp instanceof ValidationFailure) {
                return temp;
            }
            return ((DownCastingConverter)this.phaseTwo).convert((AtomicValue)temp, input);
        }
    }

    public static class DownCastingConverter
    extends Converter {
        private AtomicType newType;

        public DownCastingConverter(AtomicType annotation, ConversionRules rules) {
            this.newType = annotation;
            this.setConversionRules(rules);
        }

        public AtomicType getTargetType() {
            return this.newType;
        }

        public ConversionResult convert(AtomicValue input) {
            return this.convert(input, input.getCanonicalLexicalRepresentation());
        }

        public ConversionResult convert(AtomicValue input, CharSequence lexicalForm) {
            ValidationFailure f = this.newType.validate(input, lexicalForm, this.getConversionRules());
            if (f == null) {
                return input.copyAsSubType(this.newType);
            }
            return f;
        }

        public ValidationFailure validate(AtomicValue input, CharSequence lexicalForm) {
            return this.newType.validate(input, lexicalForm, this.getConversionRules());
        }
    }

    public static class UpCastingConverter
    extends Converter {
        private AtomicType newTypeAnnotation;

        public UpCastingConverter(AtomicType annotation) {
            this.newTypeAnnotation = annotation;
        }

        public ConversionResult convert(AtomicValue input) {
            return input.copyAsSubType(this.newTypeAnnotation);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }
}

