object Prima::Application( Prima::Widget)
{
	Bool      autoClose;
	ColorSet  colors;
	Handle    hintTimer;
	Handle    hintWidget;
	Handle    icon;
	Bool      textDirection;
	double    uiScaling;

	property  Bool   autoClose;
	property  Bool   buffered;
	property  Bool   clipChildren;
	property  Bool   clipOwner;
	property  Color  colorIndex( int index);
	property  Bool   enabled;
	property  Bool   focused;
	property  Handle icon;
	property  Bool   insertMode;
	property  int    growMode;
	property  int    hintPause;
	property  Bool   layered;
	property  Bool   modalHorizon;
	property  SV  *  palette;
	property  Bool   pointerVisible;
	property  Point  origin;
	property  Handle owner;
	property  Bool   ownerBackColor;
	property  Bool   ownerColor;
	property  Bool   ownerFont;
	property  Bool   ownerShowHint;
	property  Bool   ownerSkin;
	property  Bool   ownerPalette;
	property  Bool   selectable;
	property  Handle shape;
	property  Bool   showHint;
	property  Point  size;
	property  SV*    skin;
	property  Bool   syncPaint;
	property  int    tabOrder;
	property  Bool   tabStop;
	property  Bool   transparent;
	property  Bool   textDirection;
	property  double uiScaling;
	property  Bool   visible;
	property  Bool   wantUnicodeInput;

	method Bool   begin_paint();
	method Bool   begin_paint_info();
	method void   bring_to_front();
	method void   cleanup();
	method Bool   close();
	method void   done();
	method void   detach( Handle objectHandle, Bool kill);
	method void   end_paint();
	method void   end_paint_info();
	method SV*    fonts( char * name = "", char * encoding = "");
	method SV*    font_encodings();
	static SV*    font_mapper_action( char * dummy, HV * profile);
	method Handle get_active_window();
	static Font   get_caption_font( char * dummy = "");
	static int    get_default_cursor_width( char * dummy = "");
	static Font   get_default_font( char * dummy = "");
	static Point  get_default_scrollbar_metrics( char * dummy = "");
	static Point  get_default_window_borders( char * dummy = "", int borderStyle = bsSizeable);
	method Handle get_dnd_clipboard() => apc_dnd_get_clipboard;
	method Handle get_focused_widget();
	method Handle get_widget_from_handle( SV * handle);
	method Handle get_hint_widget();
	method Rect   get_indents() => apc_application_get_indents;
	static Font   get_message_font( char * dummy = "");
	method SV *   get_monitor_rects();
	method Handle get_modal_window( int modalFlag = mtExclusive, Bool topMost = true);
	method Point  get_scroll_rate();
	static SV *   get_system_info( char * dummy = "");
	static int    get_system_value( char * dummy = "", int sysValue = 0);
	method Bool   go( void)   => apc_application_go;
	c_only void   handle_event ( PEvent event);
	method void   hide();
	method void   init( HV * profile);
	method int    load_font(char * fontPath) => apc_font_load;
	method Bool   lock()                        => apc_application_lock;
	method void   insert_behind( Handle widget);
	method Handle next();
	import SV *   notification_types();
	method Handle prev();
	method void   send_to_back();
	import void   setup();
	method void   set_hint_action( Handle widget, Bool show, Bool mouseEvent, Rect around);
	method void   show();
	method Bool   stop( void)   => apc_application_stop;
	static void   sync( char *dummy = "");
	static SV*    sys_action( char * dymmy = "", char * params = "");
	method Bool   unlock()                      => apc_application_unlock;
	c_only void   update_sys_handle( HV * profile);
	c_only Bool   validate_owner( Handle * newOwner, HV * profile);
	static Bool   yield( char *dummy = "", Bool wait_for_event = false);

	method Bool   get_capture();
	method Font   get_hint_font();
	method Handle get_image( int x, int y, int xLen, int yLen);
	method Handle get_parent();
	method SV   * get_text();
	method Handle get_widget_from_point( Point p) => apc_application_get_widget_from_point;

	method void   set( HV * profile);
	method Bool   set_capture( Bool capture, Handle confineTo);
	method void   set_centered( Bool x, Bool y);
	method void   set_font( Font font);
	method void   set_hint_font( Font hintFont);
	method void   set_text( SV * text);

	int     hintActive;
	Bool    hintVisible;
	Handle  hintUnder;
	Rect    hintAround;
	Handle  topExclModal;
	Handle  exclModal;
	Handle  topSharedModal;
	Handle  sharedModal;
	List    modalHorizons;
	Bool    wantUnicodeInput;

	c_only  Handle map_focus( Handle from);
	c_only  Handle top_frame( Handle from);
	c_only  Handle popup_modal();
}
