/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.util.Map;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.KeySpec;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.VBucketInfo;
import org.couchbase.mock.memcached.VBucketStore;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.BinaryStatResponse;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class StatCommandExecutor
implements CommandExecutor {
    private void keyStats(BinaryCommand cmd, String key, MemcachedServer server, MemcachedConnection client) {
        String[] kstatReq = key.split(" ");
        if (kstatReq.length != 3) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.EINVAL));
        }
        key = kstatReq[1];
        short vbid = Short.parseShort(kstatReq[2]);
        VBucketInfo vbInfo = server.getStorage().getVBucketInfo(vbid);
        VBucketStore cache = server.getStorage().getCache(vbid);
        if (!vbInfo.hasAccess(server)) {
            throw new IllegalArgumentException("Wrong vBucket");
        }
        KeySpec ks = new KeySpec(key, vbid);
        Item item = cache.get(ks);
        Item diskItem = server.getStorage().getPersisted(ks);
        if (item == null) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
            return;
        }
        String stateStr = server == vbInfo.getOwner() ? "active" : "replica";
        client.sendResponse(new BinaryStatResponse(cmd, "key_vb_state", stateStr));
        client.sendResponse(new BinaryStatResponse(cmd, "key_flags", "" + item.getFlags()));
        client.sendResponse(new BinaryStatResponse(cmd, "key_cas", "" + item.getCas()));
        client.sendResponse(new BinaryStatResponse(cmd, "key_exptime", "" + item.getExpiryTime()));
        boolean isDirty = false;
        if (diskItem == null || diskItem.getCas() != item.getCas()) {
            isDirty = true;
        }
        client.sendResponse(new BinaryStatResponse(cmd, "key_is_dirty", isDirty ? "1" : "0"));
        client.sendResponse(new BinaryResponse(cmd, ErrorCode.SUCCESS));
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        String key = cmd.getKey();
        if (key != null && key.startsWith("key ")) {
            try {
                this.keyStats(cmd, key, server, client);
            }
            catch (IllegalArgumentException ex) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.EINVAL));
            }
            return;
        }
        if ("uuid".equals(key)) {
            client.sendResponse(new BinaryStatResponse(cmd, "uuid", server.getBucket().getUUID()));
        } else {
            Map<String, String> myStats = server.getStats(key);
            if (myStats == null) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
                return;
            }
            for (Map.Entry<String, String> stat : myStats.entrySet()) {
                client.sendResponse(new BinaryStatResponse(cmd, stat.getKey(), stat.getValue()));
            }
        }
        client.sendResponse(new BinaryResponse(cmd, ErrorCode.SUCCESS));
    }
}

