package Locale::CLDR::Transformations::Any::Jpan::Latn;
# This file auto generated from Data\common\transforms\Japn-Latn.xml
#	on Thu 29 Feb  5:43:51 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Hira),
					to => q(Latin),
				},
				{
					from => q(Kana),
					to => q(Latin),
				},
				{
					from => q(Han),
					to => q(Spacedhan),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(｡),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(。),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(、),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(､),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(《),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(》),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(〈),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(〉),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(「),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(」),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(『),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(』),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(・),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(･),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(々),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(〜),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呀妸屙氬鈳]),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唉誒譆]),
					result  => q(aa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擭),
					result  => q(aageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朙),
					result  => q(aakari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([挖暴訐]),
					result  => q(abaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([肋膘]),
					result  => q(abara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(浴),
					result  => q(abiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([虻蝱]),
					result  => q(abu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([油脂膏膩臊]),
					result  => q(abura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚜蜚]),
					result  => q(aburamushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蕓薹]),
					result  => q(aburana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輠),
					result  => q(aburatsubo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([炕炘炙炮烊烤焙煬熹膋]),
					result  => q(aburu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仇冦宼]),
					result  => q(ada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(寇),
					result  => q(adasuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姢娞娟]),
					result  => q(adeyaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啴喘嘽]),
					result  => q(aegu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(虀),
					result  => q(aeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(敢),
					result  => q(aete),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(溢),
					result  => q(afureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跑),
					result  => q(agaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([購贖]),
					result  => q(aganau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僜昂昜昻翥隺驤]),
					result  => q(agaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丱卝]),
					result  => q(agemaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([举偁异扛抍抖拄挙揚揵撬擧擻炸舉颺𦦙]),
					result  => q(ageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(論),
					result  => q(agetsurau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喁噞]),
					result  => q(agitou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圅腮頜頥頦頷顋顎]),
					result  => q(ago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髵),
					result  => q(agohige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鶩),
					result  => q(ahiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廅),
					result  => q(ahu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泆湓]),
					result  => q(ahureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叆嬡昹洼璦相胥藍靉靛]),
					result  => q(ai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(間),
					result  => q(aida),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(婭),
					result  => q(aimuko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妯娌]),
					result  => q(aiyome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([味鯵鰺鲹]),
					result  => q(aji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(簣),
					result  => q(ajika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丹圿垕垢朱淦絳緋赤赥赩赬赮黕]),
					result  => q(aka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齇),
					result  => q(akabana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蚶),
					result  => q(akagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銅),
					result  => q(akagane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(緹),
					result  => q(akaginu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([胼腁]),
					result  => q(akagire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(孲),
					result  => q(akago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([彤焃爀絀赫頳]),
					result  => q(akai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(猩),
					result  => q(akairo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(驊),
					result  => q(akakurige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茜蒐蒨蔳]),
					result  => q(akane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(韎),
					result  => q(akanezomenokawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(赧),
					result  => q(akarameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(酡),
					result  => q(akaramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兤明熺]),
					result  => q(akarui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([証證驗]),
					result  => q(akashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(赭),
					result  => q(akatsuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([暁曉]),
					result  => q(akatsuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(騂),
					result  => q(akauma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茟莱萊藜]),
					result  => q(akaza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(翊),
					result  => q(ake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蓪),
					result  => q(akebi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(曙),
					result  => q(akebono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(晎),
					result  => q(akekakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秋穐龝]),
					result  => q(aki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(壖),
					result  => q(akichi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鋍),
					result  => q(akikoboreru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([估商販賈]),
					result  => q(akinau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(檴),
					result  => q(akinire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亮份冏叡哲囧壡奛奣嫢彬斦旿昈昉昍昑昞昣昭昱昿晀晃-晅晑晙晟晠晢晤晪晫晰晳晶暛暤暭暸暻曂曔曠杲涣渙炯炳烉烱焕焞焯煥燉燦爽瑩皥睟睿瞭瞮苪遧郁顕顯髛]),
					result  => q(akiraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(曃),
					result  => q(akirakadenaisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諒),
					result  => q(akirakanisu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(寲),
					result  => q(akirakanisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(惘),
					result  => q(akireru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厭猒飫飽]),
					result  => q(akiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賋),
					result  => q(akiruka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(歉),
					result  => q(akitarinai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(旻),
					result  => q(akizora),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(憧),
					result  => q(akogareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([衵袙]),
					result  => q(akome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榕),
					result  => q(akou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喔饇饜鹸鹼]),
					result  => q(aku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齷),
					result  => q(akusekusuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔡),
					result  => q(akuta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(圷),
					result  => q(akutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([塰尼蜑]),
					result  => q(ama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柜霤]),
					result  => q(amadare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(雩),
					result  => q(amagoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(甘),
					result  => q(amai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(旬),
					result  => q(amaneku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佈徧普暜浹溥遍]),
					result  => q(amaneshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仂贏]),
					result  => q(amari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([余剩剰餘]),
					result  => q(amaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(醴),
					result  => q(amazake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([天糖雨霣飴餃餦餳餹]),
					result  => q(ame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰀),
					result  => q(amenouo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([畢網网罔罜罝罟罠罦罨羅]),
					result  => q(ami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(紭),
					result  => q(aminotsuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弶),
					result  => q(amioharu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([編辮]),
					result  => q(amu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堷峖氨銨餡鮟]),
					result  => q(an),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坅坎坑埂埯壙壢壧孔屇嵌穴穵窞竅竇竉膸軹阬阱]),
					result  => q(ana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侮奡媸嫚怇怭敡]),
					result  => q(anadoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(窖),
					result  => q(anagura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(矞),
					result  => q(anaoakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姉姊姐姒娰媭嬃]),
					result  => q(ane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兄昆豈]),
					result  => q(ani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嫂),
					result  => q(anyome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(杏),
					result  => q(anzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蒼襖靑青]),
					result  => q(ao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(藋),
					result  => q(aoakagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梧),
					result  => q(aogiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仰佒僸厃郤]),
					result  => q(aogu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(黝),
					result  => q(aoguro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([黤黭]),
					result  => q(aoguroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葵),
					result  => q(aoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔬),
					result  => q(aomono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鼿),
					result  => q(aomukibana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(煽),
					result  => q(aoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魭黿]),
					result  => q(aoumigame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(遖),
					result  => q(appare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鷙),
					result  => q(aradori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([砿磺礦釙鉱鎀鏷鑛]),
					result  => q(aragane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([獷笨粗翨觕誙麁]),
					result  => q(arai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([忬豫]),
					result  => q(arakajime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襏),
					result  => q(aranuno),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(霰),
					result  => q(arare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嵐),
					result  => q(arashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(盬),
					result  => q(arashio),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誩),
					result  => q(arasoiiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([争爭訟]),
					result  => q(arasou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([畬畭畲]),
					result  => q(arata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(璞),
					result  => q(aratama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([悛改]),
					result  => q(aratameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礪),
					result  => q(arato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([摡沐洒洗洮浣湔滌澡澣濯盪]),
					result  => q(arau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(駻),
					result  => q(arauma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([炅現皛]),
					result  => q(arawareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(著),
					result  => q(arawasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([菑葘]),
					result  => q(arechi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(艽),
					result  => q(areno),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([荒蕢蕪薉]),
					result  => q(areru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([螘蟻]),
					result  => q(ari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垤墥]),
					result  => q(arizuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([在或有]),
					result  => q(aru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([步歩]),
					result  => q(aruku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(汏),
					result  => q(aruu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([旴昕晁朝絜蔴麻]),
					result  => q(asa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([緗菨]),
					result  => q(asagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([旭暾]),
					result  => q(asahi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俴浅淺謭譾]),
					result  => q(asai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縝),
					result  => q(asaito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蜊鯏]),
					result  => q(asari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蒖),
					result  => q(asaza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(汗),
					result  => q(ase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疿),
					result  => q(asemo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([疋脚芦葦葭蘆足趺趾踋]),
					result  => q(ashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([禸踑迒]),
					result  => q(ashiato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笳),
					result  => q(ashibue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([騅驄]),
					result  => q(ashige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桎釱鋜]),
					result  => q(ashikase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跀),
					result  => q(ashikiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(剕),
					result  => q(ashikiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蛼),
					result  => q(ashimatsui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尢尩尬尮蹇]),
					result  => q(ashinae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(茢),
					result  => q(ashinoho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跗),
					result  => q(ashinokou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([跖蹠蹯]),
					result  => q(ashinoura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跫),
					result  => q(ashioto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([旦晨曟]),
					result  => q(ashita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蠨),
					result  => q(ashitakagumo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(娼),
					result  => q(asobime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([敖逰遊遨]),
					result  => q(asobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([与予賙]),
					result  => q(ataeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(畀),
					result  => q(ataerumono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([価價]),
					result  => q(atai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宛恰]),
					result  => q(atakamo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([頭髗鸕]),
					result  => q(atama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幋),
					result  => q(atamanokazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頍),
					result  => q(atamawoageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([新鱻]),
					result  => q(atarashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([边辺邉邊]),
					result  => q(atari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仵当應扺抗抵毄當芇]),
					result  => q(ataru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([昫温溫炆煊煗]),
					result  => q(atataka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([暄暖朐燠]),
					result  => q(atatakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([煖煦燙燸]),
					result  => q(atatameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(能),
					result  => q(atau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椹),
					result  => q(ategi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(充),
					result  => q(ateru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(婧),
					result  => q(ateyakanasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圴址墟痕跡踪蹟蹤迹阯]),
					result  => q(ato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誏),
					result  => q(atoomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匓嗗]),
					result  => q(atsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鋇),
					result  => q(atsugane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亶倎偆厚惇惲懞敦暏暑淳渥湻瀀烔煆煋熇熱窀篤腆襛]),
					result  => q(atsui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姡),
					result  => q(atsukamashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扱),
					result  => q(atsukau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亼僔卙夠攅攢滀潀潨稡聚萃軿輧輳鄼酇集鬷]),
					result  => q(atsumaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儧儹勼寯揪撅繤纂蕹輯逑]),
					result  => q(atsumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([羮羹膮臛]),
					result  => q(atsumono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(暍),
					result  => q(atsusaatari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([会佸匌吁合嗚嗟噫圫姤於會猗翕脗覯覿逅逢遇遘遭邂郃]),
					result  => q(au),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([沫泡粟粱]),
					result  => q(awa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚫鮑鰒]),
					result  => q(awabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([淡澹]),
					result  => q(awai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(哀),
					result  => q(aware),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嗕嘳愍憐憫矜閔]),
					result  => q(awaremu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([袷裌]),
					result  => q(awase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祔),
					result  => q(awasematsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佮併倂勠并幷]),
					result  => q(awaseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(醂),
					result  => q(awasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(汒),
					result  => q(awatadashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(俇),
					result  => q(awatadashiisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劻慌]),
					result  => q(awateru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彸),
					result  => q(awateteyukusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([彣彧彪彰斐斕章紋絢綞綺綾繝黻黼]),
					result  => q(aya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([綦綵]),
					result  => q(ayaginu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傒噊]),
					result  => q(ayahui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(卼),
					result  => q(ayai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([悂悞愆詿誤謝謬]),
					result  => q(ayamaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([怪恠]),
					result  => q(ayashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(操),
					result  => q(ayatsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冄危圾殆臲隉]),
					result  => q(ayaui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮎),
					result  => q(ayu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(字),
					result  => q(aza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嘲),
					result  => q(azakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芺薊]),
					result  => q(azami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倛欺紿詑詒諆謾]),
					result  => q(azamuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妕妺姃姈姲婅婈媜嫆]),
					result  => q(azana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([糺糾]),
					result  => q(azanau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(她),
					result  => q(azaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([玼璱紑緂鮮]),
					result  => q(azayaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([塍畔畛畻阡]),
					result  => q(aze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(預),
					result  => q(azukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(荅),
					result  => q(azuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(亭),
					result  => q(azumaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梓),
					result  => q(azusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哶嗎嘜場塲壇嬤嬷懡瑪羋芈藦螞駡]),
					result  => q(ba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姏婆]),
					result  => q(baba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枹桴]),
					result  => q(bachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凂呅嘪玫禖]),
					result  => q(bai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梖),
					result  => q(baitara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鬽),
					result  => q(bakemono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(化),
					result  => q(bakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([幙洦獏眽貘鄚鏌]),
					result  => q(baku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([悗梚礬鎫鑁鷭]),
					result  => q(ban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(飧),
					result  => q(banmeshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(皌),
					result  => q(batsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(勐),
					result  => q(bau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([榠猽麛]),
					result  => q(bei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鼏),
					result  => q(beki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喕婂沔臱閩閺]),
					result  => q(ben),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(紅),
					result  => q(beni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瞥篾衊覕]),
					result  => q(betsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俻咩嬍嵋渼琵蘼郿醿]),
					result  => q(bi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埕壜姄岷崏湣玟珉缾罎髩鬂鬢]),
					result  => q(bin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([梹檳]),
					result  => q(binroushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉍),
					result  => q(bisumasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峚蔤]),
					result  => q(bitsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墲峔]),
					result  => q(bo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奌点點]),
					result  => q(bochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噗坶濹狇苜霂]),
					result  => q(boku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([樠穈]),
					result  => q(bon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮱鯔]),
					result  => q(bora),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([褸襤]),
					result  => q(boro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釦),
					result  => q(botan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([孛渤]),
					result  => q(botsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呣哤壾娏戼樴檬泖瑁瞀緢蛑蛧蝥邙鄮駹魍麰𦒷]),
					result  => q(bou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([虷蜎]),
					result  => q(bouhura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(脬),
					result  => q(boukou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帽),
					result  => q(boushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(僧),
					result  => q(bouzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侢倵婺珷碔郶錻鵡]),
					result  => q(bu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(萄),
					result  => q(budou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([汶莬雯馼]),
					result  => q(bun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桕橅]),
					result  => q(buna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(規),
					result  => q(bunmawashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉑),
					result  => q(burachina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魳鰤]),
					result  => q(buri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([彘豘豚]),
					result  => q(buta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟇),
					result  => q(buto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岉芴]),
					result  => q(butsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(咕),
					result  => q(butsubutsuiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(碰),
					result  => q(butsukaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜹),
					result  => q(buyo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([荓鋲鶓]),
					result  => q(byou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茗茶]),
					result  => q(cha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([千垁堃墬廌滍离荎莉蚳血衁赿踟郗]),
					result  => q(chi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乳奶父爺]),
					result  => q(chichi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([酥酪]),
					result  => q(chichizake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鵆),
					result  => q(chidori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(智),
					result  => q(chie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(違),
					result  => q(chigau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([契期]),
					result  => q(chigiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(寀),
					result  => q(chigyousho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襅),
					result  => q(chihaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偳),
					result  => q(chihisai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佌小幺琑瑣]),
					result  => q(chiisai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朘),
					result  => q(chijimaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縐),
					result  => q(chijimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([緊縬縮]),
					result  => q(chijimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傶近迩邇]),
					result  => q(chikai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(力),
					result  => q(chikara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(劤),
					result  => q(chikari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([盟誓]),
					result  => q(chikau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([昵暱]),
					result  => q(chikazuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鄐),
					result  => q(chiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粡粽糉]),
					result  => q(chimaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垙壛巷衖閻]),
					result  => q(chimata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([棽狆猧疢紖趂郴鴆]),
					result  => q(chin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跛),
					result  => q(chinba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([孩孺]),
					result  => q(chinomigo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([衅釁]),
					result  => q(chinuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坋坌坱埃埲塕塵塺塻]),
					result  => q(chiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鏤),
					result  => q(chiribameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(坺),
					result  => q(chirinosama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笭),
					result  => q(chiriyoke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([散趲]),
					result  => q(chiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芑),
					result  => q(chisa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(栬),
					result  => q(chisanakui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鈦鐟]),
					result  => q(chitanyuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([祑腟膣袠豑]),
					result  => q(chitsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嬦嵀]),
					result  => q(chiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(滎),
					result  => q(chiyorochiyoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坾滁蕏]),
					result  => q(cho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(栻),
					result  => q(choku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伄屌庱旐朓瀓琱瑒祧耴萇蛁鼚]),
					result  => q(chou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蝶),
					result  => q(chouchou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(簿),
					result  => q(choumen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐇),
					result  => q(chouna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱘),
					result  => q(chouzame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([牏邾]),
					result  => q(chu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宒杶瑃輴迍]),
					result  => q(chun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泏窋]),
					result  => q(chutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侴椆蛺輈鍮鵃]),
					result  => q(chuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咑哪垛墯]),
					result  => q(da),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([孻棜榭爿鍖鮾]),
					result  => q(dai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橙),
					result  => q(daidai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([菔葖蔔]),
					result  => q(daikon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([默黙]),
					result  => q(damaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瞞),
					result  => q(damasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壝湳腩]),
					result  => q(dan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(糰),
					result  => q(dango),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蜱螕蟎]),
					result  => q(dani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誰),
					result  => q(dare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(妲),
					result  => q(datsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嶩),
					result  => q(dau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([迕遌]),
					result  => q(deau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嚀屔沵濔胒]),
					result  => q(dei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓧),
					result  => q(dekaguramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(籵),
					result  => q(dekameetoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竍),
					result  => q(dekaritto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疕),
					result  => q(dekimono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(叵),
					result  => q(dekinai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(尀),
					result  => q(dekinu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([塐塑]),
					result  => q(deku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姩娮]),
					result  => q(den),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蝓),
					result  => q(dendenmushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([㞮凸出岀]),
					result  => q(deru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儱),
					result  => q(desaagaranai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓰),
					result  => q(deshiguramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竕),
					result  => q(deshiritto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伖鴑]),
					result  => q(do),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蚌),
					result  => q(dobuga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蜯蠙]),
					result  => q(dobugai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(醅),
					result  => q(doburoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(圯),
					result  => q(doburu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坧墌]),
					result  => q(dodai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鯲鰌鰍鱃]),
					result  => q(dojou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榒),
					result  => q(doku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕺),
					result  => q(dokudami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吃吶呐咹唫訥謇]),
					result  => q(domoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丼),
					result  => q(donburi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(緞),
					result  => q(donsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([錚鐃鑼]),
					result  => q(dora),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坭泥浧淤]),
					result  => q(doro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(駰),
					result  => q(doroashige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弗淖]),
					result  => q(doru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囔峱巎潼瑙硇胴蕽]),
					result  => q(dou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柄柯橿江籚絵荏]),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛯蝦螧魵鰕]),
					result  => q(ebi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([箙籣]),
					result  => q(ebira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峝狄羌羗蛮蠻貊]),
					result  => q(ebisu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([朳杁]),
					result  => q(eburi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([朵朶杈条枝條]),
					result  => q(eda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(徭),
					result  => q(edachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(岐),
					result  => q(edamichi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(描),
					result  => q(egaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刔刳剔抉]),
					result  => q(eguru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([媖嬴朠柡渶潁煐珱瑛璟瓔瞖禜蠑郢鉠鍈韺鰩]),
					result  => q(ei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(噚),
					result  => q(eibiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伇垼弈醳]),
					result  => q(eki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(靨),
					result  => q(ekubo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厴啘噮媕媴嫣嬿崦晼棪櫞洹涴琬琰瑗篶綖菸蜒蝘袁豌郾鄢醃鴛鵷龑]),
					result  => q(en),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([胞褜]),
					result  => q(ena),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(冋),
					result  => q(enagamae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(苕),
					result  => q(endou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(婚),
					result  => q(engumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(槐),
					result  => q(enju),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痤),
					result  => q(enogo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榎),
					result  => q(enoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰓),
					result  => q(era),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([択拴掄掏揀撨撰擇攞柬選]),
					result  => q(erabu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偉),
					result  => q(erai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([滬衽衿襟襮魞]),
					result  => q(eri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([帬帴]),
					result  => q(eriate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([得獲]),
					result  => q(eru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(揖),
					result  => q(eshaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱛),
					result  => q(eso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泧焆蠮鮆]),
					result  => q(etsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([么宎岆]),
					result  => q(eu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([疫瘟癘]),
					result  => q(eyami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弴),
					result  => q(eyumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呎),
					result  => q(fiito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仅呋堸嬔峊滏玞盙簠缻莆莩蚨蚹蜅蜉郙鄜颫]),
					result  => q(fu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(史),
					result  => q(fubito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俸淵渊渕潭潯禄緣縁]),
					result  => q(fuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(衻),
					result  => q(fuchidoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(紕),
					result  => q(fuchikazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([札槧牋牌牒牘票箋簡]),
					result  => q(fuda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([筆聿]),
					result  => q(fude),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([笙笛簘簫籟籥龠]),
					result  => q(fue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(殖),
					result  => q(fueru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(畚),
					result  => q(fugo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魨鮐鮭鯸鯺]),
					result  => q(fugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(韛),
					result  => q(fuigau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(藤),
					result  => q(fuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蘭),
					result  => q(fujibaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕳),
					result  => q(fujibakama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蘽),
					result  => q(fujikazura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(藊),
					result  => q(fujimame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮝鯗]),
					result  => q(fuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泓浤深]),
					result  => q(fukai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湗),
					result  => q(fukaidoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([耽酖]),
					result  => q(fukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苳蕗]),
					result  => q(fuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(巾),
					result  => q(fukin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吩吹嘘噓噴洑澓畐茯葺虙飂飅龡]),
					result  => q(fuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓢),
					result  => q(fukube),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([含哺]),
					result  => q(fukumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(膨),
					result  => q(fukuramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(脹),
					result  => q(fukureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嚢囊帒櫜袋]),
					result  => q(fukuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([梟鴞]),
					result  => q(fukurou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袱),
					result  => q(fukusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帙),
					result  => q(fumaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冊册文泐籍]),
					result  => q(fumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(轥),
					result  => q(fuminijiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([梺麓]),
					result  => q(fumoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([趞跆跈跊跋跕践踄踏踐踖踶蹂蹈躅躔躙躡躢躪]),
					result  => q(fumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妢弅捴獖豶轒鈖鱝]),
					result  => q(fun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮒鯽]),
					result  => q(funa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(舷),
					result  => q(funabata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鵐鹀]),
					result  => q(funashiuzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鶕),
					result  => q(funashiuzura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([檥艤]),
					result  => q(funayosooi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([裈褌]),
					result  => q(fundoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([舟舩舸船艆艇艘艚艧]),
					result  => q(fune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栙欆]),
					result  => q(funenoho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(檄),
					result  => q(furebumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嬰牴觝触觸]),
					result  => q(fureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鼗),
					result  => q(furitsuzumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(振),
					result  => q(furu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(籭),
					result  => q(furubi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(顫),
					result  => q(furueru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([古旧篩簛]),
					result  => q(furui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奮掉揮震]),
					result  => q(furuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(醔),
					result  => q(furuzake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([房総縂總]),
					result  => q(fusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咉沌阨阸]),
					result  => q(fusagaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堙塞塡填壅怫窒錮閼]),
					result  => q(fusagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(篝),
					result  => q(fusego),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([扞捍禦防]),
					result  => q(fusegu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伏俛俯偃]),
					result  => q(fuseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([樶節莭]),
					result  => q(fushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栫罧]),
					result  => q(fushizuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(臥),
					result  => q(fusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([熏燻]),
					result  => q(fusuberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([衾麩麬麸]),
					result  => q(fusuma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(雙),
					result  => q(futa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(盒),
					result  => q(futamono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(再),
					result  => q(futatabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([両两二兩双弍弐貮貳]),
					result  => q(futatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(太),
					result  => q(futoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冹坲氟甶]),
					result  => q(futsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偑剻妚梵涪渢灃蛗酆靊]),
					result  => q(fuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(冬),
					result  => q(fuyu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(櫖),
					result  => q(fuza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([珴蛾鵝鵞齖]),
					result  => q(ga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(劽),
					result  => q(gaaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(肎),
					result  => q(gaenjiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芄),
					result  => q(gagaimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哎氦陔]),
					result  => q(gai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厂厓垳崕崖崿]),
					result  => q(gake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峉鸑]),
					result  => q(gaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蒲蟆]),
					result  => q(gama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蒾),
					result  => q(gamazumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([园奿嵓曮玵癌虤]),
					result  => q(gan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(厈),
					result  => q(gandare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呏嗧]),
					result  => q(garon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鎵),
					result  => q(garyuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仴嶭]),
					result  => q(gatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(熯),
					result  => q(gawaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟳),
					result  => q(gazami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([猊秇羿蓺貎鑈齯]),
					result  => q(gei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鶃鷁鷊鹢]),
					result  => q(geki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厡嫄孍狺謜阮騵齞]),
					result  => q(gen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈤),
					result  => q(gerumanyuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嵲玥糵鈅]),
					result  => q(getsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垚),
					result  => q(geu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帤),
					result  => q(geyo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峗萓]),
					result  => q(gi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱨),
					result  => q(gigi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喗圁犾誾鄞]),
					result  => q(gin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(圪),
					result  => q(gitsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唔棊棋檎檱浯珸碁粔茣蜈]),
					result  => q(go),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鶄),
					result  => q(goisagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(埖),
					result  => q(gomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峎闦]),
					result  => q(gon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(訁),
					result  => q(gonben),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮴),
					result  => q(gori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(如),
					result  => q(gotoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屼杌阢]),
					result  => q(gotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嗸岋廒耦齵]),
					result  => q(gou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(娨),
					result  => q(gouman),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(厶),
					result  => q(gozaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噳堣戵鄅髃]),
					result  => q(gu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(茱),
					result  => q(gumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([罱齳]),
					result  => q(gun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(寏),
					result  => q(gururitomegurashitakaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鷠),
					result  => q(gyo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嶪獟蟯鄴]),
					result  => q(gyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刃刄嘙垪嶓帊歯爸玻琶皤碆箥羽耙葉蔢豝鄱齒羽]),
					result  => q(ha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([幅掵]),
					result  => q(haba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(憚),
					result  => q(habakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鈨鎺]),
					result  => q(habaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([沮阻]),
					result  => q(habamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(翽),
					result  => q(habataki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(奞),
					result  => q(habataku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偤婑]),
					result  => q(haberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([愌滔芼衍]),
					result  => q(habikoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壎柈椀樏盂盆盎盔缽范蜂蠭鉢魩]),
					result  => q(hachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帩),
					result  => q(hachimaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([肌膚]),
					result  => q(hada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([袢裯褙襦襯]),
					result  => q(hadagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倮臝裎裸]),
					result  => q(hadaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襢),
					result  => q(hadanugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(裼),
					result  => q(hadanugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([跣踱]),
					result  => q(hadashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(軔),
					result  => q(hadome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([皅蝿蠅鲉]),
					result  => q(hae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([映暎生]),
					result  => q(haeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鉅鋼鑌]),
					result  => q(hagane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(黵),
					result  => q(hagareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([禿秃]),
					result  => q(hage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([励勵]),
					result  => q(hagemu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鬜),
					result  => q(hageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劇懁激烈]),
					result  => q(hageshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([萩蘒骭骹蘒]),
					result  => q(hagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([剝剥剺矤訠]),
					result  => q(hagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([腭齗齦齶]),
					result  => q(haguki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(莠),
					result  => q(hagusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妳姁媓媽嬭母]),
					result  => q(haha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鴜),
					result  => q(hahadori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(莔),
					result  => q(hahaguri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柞),
					result  => q(hahaso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴝鸜]),
					result  => q(hahatsuchou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伂伓俖喏姵庍捭灰牬狽猅肺蓜衃邶郥霈]),
					result  => q(hai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僇謑]),
					result  => q(haji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([椒薑]),
					result  => q(hajikami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(抨),
					result  => q(hajiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([初埱甫肁肈]),
					result  => q(hajime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乨兘刱剏始戧肇]),
					result  => q(hajimeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僯媿忸怍恥恧愧慙慚耻聭覥]),
					result  => q(hajiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坆塋塸墓墳]),
					result  => q(haka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薧),
					result  => q(hakaba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(捗),
					result  => q(hakadoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([袴褰]),
					result  => q(hakama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(埏),
					result  => q(hakamichi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秤衡銓]),
					result  => q(hakari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仞仭咨図圖圗寸彠忖挍掂揆揣敠敪料斠測猷称稱蒦訂計評詢諏諮謀謨議邡量]),
					result  => q(hakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屐),
					result  => q(hakimono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(庬),
					result  => q(hakkirishinai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匚匣-匥匧匪匭匲櫝笥筥箪箱篋篚簏簞]),
					result  => q(hako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔜),
					result  => q(hakobi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(運),
					result  => q(hakobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亳吐吢呁咯哊哯唋喀嗀嚗埽履掃欧歍歐涒珀瓟蒪餺]),
					result  => q(haku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嗀),
					result  => q(hakusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([浜濱濵]),
					result  => q(hama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蒺),
					result  => q(hamabishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛤鮚]),
					result  => q(hamaguri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([莎薠]),
					result  => q(hamasuge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扖),
					result  => q(hameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱧),
					result  => q(hamo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僠嬎嬏岅柉橎沜畈盼籓舨螌轓鞶]),
					result  => q(han),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芭花芲荂華葩蕐鼻]),
					result  => q(hana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓣),
					result  => q(hanabira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偀英]),
					result  => q(hanabusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縹),
					result  => q(hanadairo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(甚),
					result  => q(hanahada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嚊),
					result  => q(hanaiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([衂衄𧗗]),
					result  => q(hanaji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泗洟]),
					result  => q(hanajiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([荇莕]),
					result  => q(hanajunsai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(劓),
					result  => q(hanakiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([贐餞]),
					result  => q(hanamuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齄),
					result  => q(hananowaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擤),
					result  => q(hanaokamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([離麄麤]),
					result  => q(hanareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噺譚]),
					result  => q(hanashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([撝放話]),
					result  => q(hanasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芪蕁]),
					result  => q(hanasuge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頞),
					result  => q(hanasuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勶夰彂発發]),
					result  => q(hanatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(萏),
					result  => q(hanayaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齆),
					result  => q(hanazumari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([翈翎]),
					result  => q(hane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(褕),
					result  => q(hanekazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(翮),
					result  => q(hanenomoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(獧),
					result  => q(haneodoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([撥跳]),
					result  => q(haneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(唰),
					result  => q(hanetsukurohu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(桔),
					result  => q(hanetsurube),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(埴),
					result  => q(hani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榿),
					result  => q(hannoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(靃),
					result  => q(haoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([原肚腹]),
					result  => q(hara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(匐),
					result  => q(harabau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮞鯤]),
					result  => q(harago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰚),
					result  => q(haraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痢),
					result  => q(harakudari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疜),
					result  => q(harakudashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妊姙娠媰孕肧胎胚]),
					result  => q(haramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛔蜖]),
					result  => q(haranomushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([払拂摒攘祓祛禳菷釩]),
					result  => q(harau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([胕腑腸膓臓臟鯝]),
					result  => q(harawata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袨),
					result  => q(haregi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瘩瘭癕癮癰臃]),
					result  => q(haremono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夝晴晵暒瘇肛腫膖霽晴]),
					result  => q(hareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栿箴針銉鍼]),
					result  => q(hari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鎍),
					result  => q(harigane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([彙彚猬蝟]),
					result  => q(harinezumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(桀),
					result  => q(haritsuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偧奓張彍搪旾春萅貼]),
					result  => q(haru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夐敻杳藐迢迥逈遙遥遼]),
					result  => q(haruka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([螯鉸銸]),
					result  => q(hasami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈔),
					result  => q(hasamitoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夾拑挟挾搢擷敧箝篏]),
					result  => q(hasamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([馳駛騁騖驟]),
					result  => q(haseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([梁槗樑橋端筯筷箸耑]),
					result  => q(hashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榛),
					result  => q(hashibami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梯),
					result  => q(hashigo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疹),
					result  => q(hashika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([艀躉]),
					result  => q(hashike),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柱棖楹橕欂牚]),
					result  => q(hashira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閞),
					result  => q(hashiranomasugata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僬勷奔犇虡走赱趨趹运迸逛逩逬逸颿駧駾騳驋逸]),
					result  => q(hashiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(畸),
					result  => q(hashita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鷂),
					result  => q(hashitaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妮婢]),
					result  => q(hashitame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芙蓮]),
					result  => q(hasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(藕),
					result  => q(hasunone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([帾幡幢旂旃旆旌旗旙旛旟機畑畠簱籏]),
					result  => q(hata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([斿旈旒縿]),
					result  => q(hataashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刹剎]),
					result  => q(hatabashira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([纛翿]),
					result  => q(hataboko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([灞覇霸]),
					result  => q(hatagashira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鰰鱩]),
					result  => q(hatahata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紝絍]),
					result  => q(hataito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(綮),
					result  => q(hatajirushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(旄),
					result  => q(hatakazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圃圑]),
					result  => q(hatake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(霹),
					result  => q(hatameku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榺),
					result  => q(hatanokeishiwomotsugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(赳),
					result  => q(hataraki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([働拮]),
					result  => q(hataraku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(果),
					result  => q(hatasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礑),
					result  => q(hatato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(楻),
					result  => q(hatazao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垓漄畡]),
					result  => q(hate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(澖),
					result  => q(hateganai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鳩鴿]),
					result  => q(hato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芉),
					result  => q(hatomugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仈叐叭墢犮玐秡胈菝軷]),
					result  => q(hatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鼷),
					result  => q(hatsukanezumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(漶),
					result  => q(hatsukirishinai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乓匍嘐塝蚑蠉這]),
					result  => q(hau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塴),
					result  => q(haumuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垗),
					result  => q(hauridokoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮋鮠鯈鰦鰷]),
					result  => q(haya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([隼鶻鸇]),
					result  => q(hayabusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僤儵嘌慓戫早淢稙翛迅适速]),
					result  => q(hayai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(傱),
					result  => q(hayaisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(譶),
					result  => q(hayakuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扚),
					result  => q(hayakuutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湍),
					result  => q(hayase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囃林]),
					result  => q(hayashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(颰),
					result  => q(hayate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(馹),
					result  => q(hayauma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峡峽硲]),
					result  => q(hazama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枦櫨鯊鯋]),
					result  => q(haze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(粶),
					result  => q(hazekome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(楾),
					result  => q(hazou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(怩),
					result  => q(hazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([詬辱]),
					result  => q(hazukashime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侳嫸]),
					result  => q(hazukashimeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屁),
					result  => q(he),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([它虵蛇]),
					result  => q(hebi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(隔),
					result  => q(hedateru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(桫),
					result  => q(hego),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乒偋呯崥幈幤栟棅狴獘磇蛃邴]),
					result  => q(hei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓸),
					result  => q(hekutogura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(粨),
					result  => q(hekutomeetoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竡),
					result  => q(hekutoritto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([办囨媥惼楩汳汴猵艑蝙覍骿]),
					result  => q(hen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([箆篦]),
					result  => q(hera),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(謙),
					result  => q(herikudaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(劗),
					result  => q(herisu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([减歴減経經耗脧]),
					result  => q(heru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([舮艫]),
					result  => q(hesaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(毘),
					result  => q(heso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蒂蔕]),
					result  => q(heta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咇暼鷩]),
					result  => q(hetsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(傋),
					result  => q(hetsurahanu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唲憟諂諛諞]),
					result  => q(hetsurau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彯),
					result  => q(heu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壸壼]),
					result  => q(heyanotsuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伙厞呸啤妼屄岯日暃曦杼梭樋沘淝淠渄濞火灯烺煚痱砒絥肹腗芘芾苤萆蓖豼貔邳郫阦阳陽髬魮]),
					result  => q(hi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鷚鸙]),
					result  => q(hibari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([皴皸皹罅]),
					result  => q(hibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(响),
					result  => q(hibiiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([轔轞韵韻]),
					result  => q(hibiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(響),
					result  => q(hibiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(觱),
					result  => q(hichiriki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([摺襀襞襵]),
					result  => q(hida),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屮左]),
					result  => q(hidari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(孒),
					result  => q(hidarinoudeganai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([旱魃]),
					result  => q(hideri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([稗穇薭]),
					result  => q(hie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(冷),
					result  => q(hieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(晛),
					result  => q(higaarawareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰉),
					result  => q(higai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(僻),
					result  => q(higamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([熠熲]),
					result  => q(higari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(褦),
					result  => q(higasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(東),
					result  => q(higashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([須頾髭髯鬚]),
					result  => q(hige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(羆),
					result  => q(higuma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(狒),
					result  => q(hihi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(秀),
					result  => q(hiideru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枸柊]),
					result  => q(hiiragi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([肘肱臂]),
					result  => q(hiji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垩聖]),
					result  => q(hijiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([灮炗]),
					result  => q(hikaaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(控),
					result  => q(hikaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([腘膕]),
					result  => q(hikagami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(旲),
					result  => q(hikage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([曜煇煕熒熙爓耿韑]),
					result  => q(hikari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([光晧曎炫烑熈玓皓]),
					result  => q(hikaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟾),
					result  => q(hikigaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卛将將帥率]),
					result  => q(hikiiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(絅),
					result  => q(hikishimeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輘),
					result  => q(hikitsubusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瘛瘲癇]),
					result  => q(hikitsuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嬋),
					result  => q(hikitsunaga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痙),
					result  => q(hikitsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([靷鞁]),
					result  => q(hikizuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([彥彦]),
					result  => q(hiko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([櫱蘖蘶]),
					result  => q(hikobae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哰引弯彎惹扯扳扽拏拕拖拽拿挐挽掎掣揁揄搆摟攣曳曵曼牽綗輓]),
					result  => q(hiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([低卑庳矮輊]),
					result  => q(hikui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(仾),
					result  => q(hikumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(暇),
					result  => q(hima),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姫姬媛嬪]),
					result  => q(hime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堄堞陴隦]),
					result  => q(himegaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([祕秘]),
					result  => q(himeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紃紐紞紱綬繸鋬]),
					result  => q(himo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(惄),
					result  => q(himojii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱶),
					result  => q(himono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([胙脤膰]),
					result  => q(himorogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(繙),
					result  => q(himotoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姘獱玭繽臏豩豳邠髕]),
					result  => q(hin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鄙雛鶵鷇]),
					result  => q(hina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乴捻撚]),
					result  => q(hineru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(暘),
					result  => q(hinode),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(晘),
					result  => q(hinoderusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丙),
					result  => q(hinoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(暚),
					result  => q(hinohikari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桧椈檜]),
					result  => q(hinoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閘),
					result  => q(hinokuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丁),
					result  => q(hinoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枚),
					result  => q(hira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(豁),
					result  => q(hirakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(攁),
					result  => q(hirakiugokasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儙厇启呿啓啟墾披抷拆拓挓挨擺攤開闓闙闡闢]),
					result  => q(hiraku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮃),
					result  => q(hirame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閃),
					result  => q(hirameku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扁),
					result  => q(hiratai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蘑),
					result  => q(hiratake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帟),
					result  => q(hiratobari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([帍裱鰭]),
					result  => q(hire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([拡擴氾肸]),
					result  => q(hirogaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(挄),
					result  => q(hirogeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僘博宏宱宺寛寬広廣弘恢愽懬汪沆浩淼渺滂滉漭澔濶瀚竑闊]),
					result  => q(hiroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(巸),
					result  => q(hiroiago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([拾捃掇摭摳攈攟筑]),
					result  => q(hirou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佀昼晝簸蒜蛭蜞]),
					result  => q(hiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([翩翻飜]),
					result  => q(hirugaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([舜葍]),
					result  => q(hirugao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(匜),
					result  => q(hisage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楸檟]),
					result  => q(hisagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匏瓠蟸蠡]),
					result  => q(hisago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(盠),
					result  => q(hisaji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([庌廂廡梠楣檐簷]),
					result  => q(hisashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([久乆弥彌舊趍]),
					result  => q(hisashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杓璋]),
					result  => q(hishaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芰菱蔆]),
					result  => q(hishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(颯),
					result  => q(hishigu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(脠),
					result  => q(hishiho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([臡酱醓醤醬]),
					result  => q(hishio),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枓),
					result  => q(hishiyaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礵),
					result  => q(hiso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(訵),
					result  => q(hisokaniukagaishiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嚬),
					result  => q(hisomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([潛潜濳]),
					result  => q(hisomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([題額顙]),
					result  => q(hitai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鶲鹟]),
					result  => q(hitaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(洳),
					result  => q(hitariuruo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寖擩浸涔涵淫淹溲漚漬瀹蘸]),
					result  => q(hitasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([人仁儿]),
					result  => q(hito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([跬蹞]),
					result  => q(hitoashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([单単單袗褝褠褧襂襌襕襴]),
					result  => q(hitoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(晬),
					result  => q(hitomawari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([眸眹睛瞳瞵]),
					result  => q(hitomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([孑独獨]),
					result  => q(hitori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(焭),
					result  => q(hitorimono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侇侔侞凖斊朩準珿竱等鈞]),
					result  => q(hitoshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(淮),
					result  => q(hitoshikusuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(稘),
					result  => q(hitotose),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([一壱壹弌隻]),
					result  => q(hitotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圄圉牢獄]),
					result  => q(hitoya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(酤),
					result  => q(hitoyozake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匱匵嗶櫃櫉櫥熚蕟邲]),
					result  => q(hitsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匛柩棺椁槥櫬]),
					result  => q(hitsugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(轜),
					result  => q(hitsugigu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輀),
					result  => q(hitsugiguruma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(翣),
					result  => q(hitsugikazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(綍),
					result  => q(hitsuginawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([羊羖]),
					result  => q(hitsuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(挈),
					result  => q(hitsusageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(燧),
					result  => q(hiuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鶸),
					result  => q(hiwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凈),
					result  => q(hiyayakanasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囟顖]),
					result  => q(hiyomeki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(莧),
					result  => q(hiyu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(膝),
					result  => q(hiza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([巿褘鞸韍韠]),
					result  => q(hizakake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凳),
					result  => q(hizakakenotagui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([跪跼]),
					result  => q(hizamazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跽),
					result  => q(hizamazuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(暐),
					result  => q(hizashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疥),
					result  => q(hizen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(脾),
					result  => q(hizou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蹄蹏]),
					result  => q(hizume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埔媬峬帆庯潽穂穗穟葡蒱誧]),
					result  => q(ho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(檣),
					result  => q(hobashira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(程),
					result  => q(hodo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嚫徝憄施]),
					result  => q(hodokosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吠吼吽呍咆哮嘷噭虖鬫]),
					result  => q(hoeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屠),
					result  => q(hofuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喨懤朖朗洞]),
					result  => q(hogaraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吲唍]),
					result  => q(hohoemu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([脯脼腊腒膊膎膴]),
					result  => q(hojishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([他佗]),
					result  => q(hoka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([戈戛戞戟戣桙槊殳矛矟矠祋釶鉇鉈鉾鏦鐗]),
					result  => q(hoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(繄),
					result  => q(hokobakuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祠),
					result  => q(hokora),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塜),
					result  => q(hokorigatobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(綻),
					result  => q(hokorobiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仱侘姹詡誇]),
					result  => q(hokoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([釯鋒鋩铓]),
					result  => q(hokosaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僰濮]),
					result  => q(hoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([痣黡黶]),
					result  => q(hokuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樮),
					result  => q(hokuso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([誉譽]),
					result  => q(homare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([裒褒襃讃讚賞頌]),
					result  => q(homeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倴呠奙泍渀苯]),
					result  => q(hon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(籙),
					result  => q(honbako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([荕骨骴骼]),
					result  => q(hone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(曈),
					result  => q(honogurai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偎僾恍洸眆]),
					result  => q(honoka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([炎焔焰焱熖燄]),
					result  => q(honoo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([朴頬頰顪]),
					result  => q(hoo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(綂),
					result  => q(hoobiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([肫頯馗]),
					result  => q(hoobone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(耏),
					result  => q(hoohige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(惚),
					result  => q(horeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堀塹壍壕湟濠隍]),
					result  => q(hori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([幌幰縨袰]),
					result  => q(horo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兦冺泯滅烕]),
					result  => q(horobiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(戩),
					result  => q(horobosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([輜輺]),
					result  => q(horoguruma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([彫掘搰]),
					result  => q(horu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([穎頴颕]),
					result  => q(hosaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([星皨]),
					result  => q(hoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([糇糒餱]),
					result  => q(hoshiii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宨恣愓憍擅]),
					result  => q(hoshiimama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮿鱐]),
					result  => q(hoshiuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縜),
					result  => q(hosohimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([細繊纎纖芯]),
					result  => q(hosoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(緬),
					result  => q(hosoito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([絺緆]),
					result  => q(hosonuno),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(欲),
					result  => q(hossuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(干),
					result  => q(hosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榾),
					result  => q(hota),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚈蛍螢]),
					result  => q(hotaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(泬),
					result  => q(hotobashiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瓫甌甖缶]),
					result  => q(hotogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仏佛]),
					result  => q(hotoke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菩),
					result  => q(hotokegusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([汻沂涘滸瀕陲]),
					result  => q(hotori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鵊鶗]),
					result  => q(hototogisu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([脖荸鵓]),
					result  => q(hotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僼凤吥垉垹埄崶怦梆椖泙淎漰澎炰犎琫琺砰硼笣篈胮菶蒡螃蟚鄷閍雱餢鬅]),
					result  => q(hou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([帚彗箒篲]),
					result  => q(houki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔧),
					result  => q(houkigusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堋窆葬]),
					result  => q(houmuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塟),
					result  => q(houmuuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([椊榫臍]),
					result  => q(hozo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(旉),
					result  => q(hu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(囦),
					result  => q(huchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牓),
					result  => q(huda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笔),
					result  => q(hude),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([竽竾筦箛篪篴]),
					result  => q(hue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(酚),
					result  => q(huenooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(筲),
					result  => q(hugo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(櫐),
					result  => q(huji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕑),
					result  => q(hujibakama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(杬),
					result  => q(hujimodoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([漼瀴穾窔谹]),
					result  => q(hukai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(躭),
					result  => q(hukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([欨袚]),
					result  => q(huku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(琀),
					result  => q(hukumidama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咁唅唵嗛嘾噆噙]),
					result  => q(hukumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痮),
					result  => q(hukureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([帔帣槖橐裛褁]),
					result  => q(hukuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幪),
					result  => q(hukusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岟氐]),
					result  => q(humoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蹀蹋蹍蹛蹝蹩蹹躐躗躛]),
					result  => q(humu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襣),
					result  => q(hundoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([舡舺艋艎艏]),
					result  => q(hune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(趻),
					result  => q(hurahurasuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踸),
					result  => q(hurajurasuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(捂),
					result  => q(hureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐲),
					result  => q(hurigane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鞀鞉]),
					result  => q(huritsuzumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湒),
					result  => q(huru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([簁簌緼縕]),
					result  => q(hurui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塛),
					result  => q(husagaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坉垔茀逄陻]),
					result  => q(husagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墇捱]),
					result  => q(husegu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枙),
					result  => q(hushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纇),
					result  => q(hushiito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寑躺]),
					result  => q(husu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([掤盦]),
					result  => q(huta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僆孖孷孿]),
					result  => q(hutago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丫),
					result  => q(hutamata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(臶),
					result  => q(hutatabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(傜),
					result  => q(huzoroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鲾),
					result  => q(hyaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鵯),
					result  => q(hyo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楅皕鰏]),
					result  => q(hyoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凴匉墂婊熛猋臕螵豹錶雹髟]),
					result  => q(hyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柝),
					result  => q(hyoushigi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([驫骉]),
					result  => q(hyuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([井亥叞喡喴寪崣崺扅攺洧濰煒犄珆瑋矣胘芛苡荽莞葳蔿藺蛜逶鉯闈霨鰄鷾]),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([棘楚茨荆荊]),
					result  => q(ibara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笆),
					result  => q(ibaratake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(尿),
					result  => q(ibari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啡啽鼾]),
					result  => q(ibiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([疣瘊肬贅]),
					result  => q(ibo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(訝),
					result  => q(ibukaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(胃),
					result  => q(ibukuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(焄),
					result  => q(ibusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(市),
					result  => q(ichi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([檾紵纻]),
					result  => q(ichibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苺莓]),
					result  => q(ichigo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐿),
					result  => q(ichirubyuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([抱擁褱]),
					result  => q(idaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誂),
					result  => q(idomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厦宅家广廈]),
					result  => q(ie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(雖),
					result  => q(iedomo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閥),
					result  => q(iegara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([痊瘉瘥瘳癒]),
					result  => q(ieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啀嘊]),
					result  => q(igamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([熔鎔鑲]),
					result  => q(igata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(韓),
					result  => q(igeta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弋),
					result  => q(igurumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祏),
					result  => q(ihai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(庲),
					result  => q(ihe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廗),
					result  => q(ihegayugamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廎),
					result  => q(ihenokatahara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廜),
					result  => q(ihori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(粲),
					result  => q(ii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奻詻諤]),
					result  => q(iiarasou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(悱),
					result  => q(iinayamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(豣),
					result  => q(iinoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([令畃]),
					result  => q(iitsuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(咐),
					result  => q(iitsukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鰂鰞]),
					result  => q(ika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栰棑楂槎筏篺]),
					result  => q(ikada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(怎),
					result  => q(ikade),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瞋),
					result  => q(ikarasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([椗矴碇錨]),
					result  => q(ikari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嗔嫨忿怒恚愹贔赑]),
					result  => q(ikaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鵤),
					result  => q(ikaruga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(霆),
					result  => q(ikazuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([池溏潢]),
					result  => q(ike),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([牲牷犠犧]),
					result  => q(ikenie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呬咶啍噯息气気氣粋粹羲]),
					result  => q(iki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喛嚍慷憤]),
					result  => q(ikidooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(勢),
					result  => q(ikioi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(煴),
					result  => q(ikire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(活),
					result  => q(ikiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呴),
					result  => q(ikiwokaketeatatameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踧),
					result  => q(ikiyasui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([憇憩]),
					result  => q(ikoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偈愒禌]),
					result  => q(ikou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堉幾徰淯渭礇竛蜟行]),
					result  => q(iku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(栯),
					result  => q(ikuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([艟艦艨]),
					result  => q(ikusabune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袀),
					result  => q(ikusagoromo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈀),
					result  => q(ikusaguruma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輣),
					result  => q(ikusagurumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(今),
					result  => q(ima),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(未),
					result  => q(imada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嘻),
					result  => q(imashime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儆勅戒敕蕆誋誡警]),
					result  => q(imashimeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(稂),
					result  => q(imigara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芋莒薯藷]),
					result  => q(imo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜀),
					result  => q(imomushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚖螈]),
					result  => q(imori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妹娣媦]),
					result  => q(imouto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([忌諱]),
					result  => q(imu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凐噾婣昀氤狁癊磤絪贇赟闉院霪]),
					result  => q(in),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(否),
					result  => q(ina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(睗),
					result  => q(inabikari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蝗蝝螽蠜]),
					result  => q(inago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(庄),
					result  => q(inaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嘶),
					result  => q(inanaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(電),
					result  => q(inazuma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鑟),
					result  => q(inbako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(吋),
					result  => q(inchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([禾秥稌稲稻]),
					result  => q(ine),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椱),
					result  => q(inoashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(命),
					result  => q(inochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([豕豛豵]),
					result  => q(inoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([祈祷禱讄]),
					result  => q(inoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([猪猯豬猪]),
					result  => q(inoshishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([戌犬狗獒獹]),
					result  => q(inu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蓈),
					result  => q(inuawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(稊),
					result  => q(inubie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(櫰),
					result  => q(inuenju),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葶),
					result  => q(inunazuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([庵廬菴葊]),
					result  => q(iori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(硫),
					result  => q(iou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(甍),
					result  => q(iraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([函凾容鋡]),
					result  => q(ireru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([剠黥]),
					result  => q(irezumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(圦),
					result  => q(iri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湾),
					result  => q(irie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(糗),
					result  => q(irigome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銥),
					result  => q(irijuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(灣),
					result  => q(irikomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(遝),
					result  => q(irimajiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喣色]),
					result  => q(iro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彩),
					result  => q(irodoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(緃),
					result  => q(iroginu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([炉爐鈩鑪]),
					result  => q(irori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儥入冶射居彃炒煎熬要鋳鑄]),
					result  => q(iru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯆),
					result  => q(iruka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(罤),
					result  => q(isagiami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(洯),
					result  => q(isagiyooi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蜮蟈]),
					result  => q(isagomushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屑潔]),
					result  => q(isagyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仡勇惈]),
					result  => q(isamashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([諌諍諗諫]),
					result  => q(isameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勈恿]),
					result  => q(isamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([功勛勣勲勳]),
					result  => q(isao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([些聊]),
					result  => q(isasaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柤),
					result  => q(iseki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岨砠]),
					result  => q(ishama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([玹珋璑璒石矻砆砣碤碭磳磻礞]),
					result  => q(ishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(砭),
					result  => q(ishibari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(碕),
					result  => q(ishibashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(碣),
					result  => q(ishibumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礟),
					result  => q(ishihajiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰵),
					result  => q(ishimochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(毉),
					result  => q(ishiya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弮釓釚釻]),
					result  => q(ishiyumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(磴),
					result  => q(ishizaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([磉磶礎礩隚]),
					result  => q(ishizue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鐏鐓]),
					result  => q(ishizuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(砢),
					result  => q(ishizumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弩),
					result  => q(ishumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([硪磯礒]),
					result  => q(iso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匆忙惣]),
					result  => q(isogashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彺),
					result  => q(isogiyuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俓急髞]),
					result  => q(isogu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椅),
					result  => q(isu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鶍),
					result  => q(isuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([板版]),
					result  => q(ita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鼪鼬]),
					result  => q(itachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岣嶁巓巔頂顚顛]),
					result  => q(itadaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俅戴]),
					result  => q(itadaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牐),
					result  => q(itagakoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鈑鍱鏟]),
					result  => q(itagane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俑怛恫悵悼悽惻愴慇慯搐痌痛痠癆蕜衋齭]),
					result  => q(itamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佫儭到摯洊至臵臸臻詣迨郅]),
					result  => q(itaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(致),
					result  => q(itasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勚勩]),
					result  => q(itatsuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(勑),
					result  => q(itawaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([糸絃絲綅綸綹緵縷]),
					result  => q(ito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(絗),
					result  => q(itogameguru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屩),
					result  => q(itogutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(筳),
					result  => q(itokuda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(遑),
					result  => q(itoma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈮),
					result  => q(itomakinoashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉨),
					result  => q(itomaonoashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([営營]),
					result  => q(itonamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釔),
					result  => q(itoryuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([籆籰]),
					result  => q(itowaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呹燚鱊鴪]),
					result  => q(itsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偢),
					result  => q(itsukushimanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祾),
					result  => q(itsukushimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侎慈憓憮]),
					result  => q(itsukushimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(五),
					result  => q(itsutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誆),
					result  => q(itsuwari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佯偐偽僞嚜夎矯蓌訏詐詭誕諔謊譂譃譎]),
					result  => q(itsuwaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([云叹庮曰謂]),
					result  => q(iu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岩嵒碞磐]),
					result  => q(iwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮇),
					result  => q(iwana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([况況矧]),
					result  => q(iwanya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鰛鰮鰯鳁]),
					result  => q(iwashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祝),
					result  => q(iwau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(窟),
					result  => q(iwaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([斁歝]),
					result  => q(iyaninaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賎),
					result  => q(iyashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俚傖賤]),
					result  => q(iyashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(苟),
					result  => q(iyashikumo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([医療醫]),
					result  => q(iyasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詃),
					result  => q(izanau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([躃躄]),
					result  => q(izari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(焉),
					result  => q(izukunso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奫泉湶]),
					result  => q(izumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鄀),
					result  => q(jaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伱伲侕儞呢岻峏您柅洱礠粫蚭衈路鴯]),
					result  => q(ji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜾),
					result  => q(jigabachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鋌),
					result  => q(jigane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祖),
					result  => q(jiji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屻棯烬秂軠魜]),
					result  => q(jin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(陣),
					result  => q(jindate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([樒櫁]),
					result  => q(jinkou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([磁𥔵]),
					result  => q(jishaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芩),
					result  => q(jishibari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(厹),
					result  => q(jiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([籹蕠釹]),
					result  => q(jo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([媶掾瀼狀羢艿芿諚醲]),
					result  => q(jou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榘),
					result  => q(jougi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(錠),
					result  => q(joumae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(𢅥),
					result  => q(ju),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([廵犉荀]),
					result  => q(jun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囡妞媃楺毧葇]),
					result  => q(juu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咖唬坬坷姀崋幏戓欤歟渮牱猓珈瘸睱蚉-蚋蚵蝌蟁袈跏軻鈥騧]),
					result  => q(ka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([敺缼]),
					result  => q(kaakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樺),
					result  => q(kaba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鞄),
					result  => q(kaban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姓),
					result  => q(kabane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厽壁]),
					result  => q(kabe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([醭黴]),
					result  => q(kabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([株菁]),
					result  => q(kabu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([葑蓯]),
					result  => q(kabura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髐),
					result  => q(kaburaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兜冑]),
					result  => q(kabuto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱟),
					result  => q(kabutogani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(徒),
					result  => q(kachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凱),
					result  => q(kachidoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亷廉柧楞稜門鯟]),
					result  => q(kado),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(錷),
					result  => q(kadorinyuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(斣),
					result  => q(kaeau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楓槭]),
					result  => q(kaede),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([慻省眷睠顧]),
					result  => q(kaerimiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([帰復换換替皈蛙貿還鼃]),
					result  => q(kaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([孵繳返]),
					result  => q(kaesu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([獍鍳鏡鑑鑒]),
					result  => q(kagami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傛傴僂冤寃屈跔踡]),
					result  => q(kagamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尞烘燎]),
					result  => q(kagaribi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(暀),
					result  => q(kagayakiutsukushii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倝暉曄曅焜煌煜熿燿耀輝]),
					result  => q(kagayaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侌庥影晷蔭阥陰隂]),
					result  => q(kage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜏),
					result  => q(kagerou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(晹),
					result  => q(kageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亅剳鈎鉤鍵鎰鑰]),
					result  => q(kagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鼼齁]),
					result  => q(kagibana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鄂),
					result  => q(kagiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([画畫畵縭限]),
					result  => q(kagiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([筐筤筺箄篭簽籃籝籠轎]),
					result  => q(kago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傢嗅齅]),
					result  => q(kagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塼),
					result  => q(kahara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(堥),
					result  => q(kaharake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(筁),
					result  => q(kahikonosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厒峆帢]),
					result  => q(kahu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喈嗨囬块堦塏姟媧岕峐巜恝枻栧櫆澥澮濊獬玠磕礚箉緺艣艪茴蒯薢蚧蛽貝鄶銙闠靧鮰齘龤]),
					result  => q(kai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([槽櫪篼]),
					result  => q(kaibaoke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚘蛕]),
					result  => q(kaichiyuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髆),
					result  => q(kaigarabone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(胛),
					result  => q(kaigaraho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚕蝅蠶蠺]),
					result  => q(kaiko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(厷),
					result  => q(kaina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(浬),
					result  => q(kairi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(糴),
					result  => q(kaiyone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柁柂楫槳檝櫂舵]),
					result  => q(kaji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮖),
					result  => q(kajika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱏),
					result  => q(kajiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啮噛嚙]),
					result  => q(kajiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嬶),
					result  => q(kaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([挑掀掦掲揎揭]),
					result  => q(kakageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偓),
					result  => q(kakaharusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([係絓罹]),
					result  => q(kakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踹),
					result  => q(kakato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齓),
					result  => q(kakeba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栈桟棧]),
					result  => q(kakehashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(筧),
					result  => q(kakei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幀),
					result  => q(kakemono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(傿),
					result  => q(kakeneosuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亏懸拎挂掛架欠玷県縣缺罣罥翔翺虧觖賭闕駆駈騫驅]),
					result  => q(kakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鵥),
					result  => q(kakesu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垣堳堵塀墉墻廆廦枾柹柿牆硴蛎蠔蠣闤]),
					result  => q(kaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([捊穌]),
					result  => q(kakiatsumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(韞),
					result  => q(kakiiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帖),
					result  => q(kakimono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牅),
					result  => q(kakine),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圈圏埒埓]),
					result  => q(kakoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囗囲圍]),
					result  => q(kakomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唧喞詫]),
					result  => q(kakotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諈),
					result  => q(kakotsukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傕剨咟啯嘓塥壆嶨彟掊掻搔搿擿攉書漍濩爬珏癋癨硞确礐舁藿衉謋謞郝鞟鞹騞龣]),
					result  => q(kaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礁),
					result  => q(kakureiwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乚匿瞹竄蟄蠖隐隠隱]),
					result  => q(kakureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匸匽廀廋薆賍贓贜]),
					result  => q(kakusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劆灶窑窯窰釜釡鈘鈼銍銼錪鍑鍗鍥鍪鎌鏺鐮鑊鬴鬶鬹]),
					result  => q(kama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(构),
					result  => q(kamaaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呶喧嗷嘩噌嚻囂聒諠譁讙]),
					result  => q(kamabisushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啉啋嘈嘮詉韷]),
					result  => q(kamabisushii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(框),
					result  => q(kamachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([烓煁窹竃竈]),
					result  => q(kamado),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冓構]),
					result  => q(kamaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垀),
					result  => q(kamahe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟐),
					result  => q(kamakiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梎),
					result  => q(kamanoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(叺),
					result  => q(kamasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亀堈瓯瓴瓶瓷瓺瓻瓿甁甆甒甕甾缸罇鐳龜]),
					result  => q(kame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([帋彡皇神紙髪髮龗神]),
					result  => q(kami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呞),
					result  => q(kamikaesu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幗),
					result  => q(kamikazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蠰),
					result  => q(kamikirimushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([雷靁]),
					result  => q(kaminari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(裃),
					result  => q(kamishimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纚),
					result  => q(kamizutsumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鳧鳬鴨]),
					result  => q(kamo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([髢髲鬄]),
					result  => q(kamoji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴎鷖鷗]),
					result  => q(kamome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(羚),
					result  => q(kamoshika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([酎酦醖醗醞醱醸釀]),
					result  => q(kamosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咀咬嘬噍噬嚼囓豤貇齕齚齟齧齩齮齰]),
					result  => q(kamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呥),
					result  => q(kamusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偘凲劝垾埳堿壏寰尲尶尷屽峘崡嵁嵅嵈晗樌橄欵汍泔淊燗犴狟玕玪琯瑍瓛疳皖睅睆磡罐羦脘苷蒄譼谽豻貋輡轗邗邯鯇]),
					result  => q(kan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(哉),
					result  => q(kana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉆),
					result  => q(kanabasami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(奏),
					result  => q(kanaderu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鉶鎡鬲鼎鼐-鼒]),
					result  => q(kanae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鉽鎘]),
					result  => q(kanaenotsukimono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釽),
					result  => q(kanagaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(錩),
					result  => q(kanagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(侻),
					result  => q(kanahu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鋺),
					result  => q(kanamari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(腎),
					result  => q(kaname),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(必),
					result  => q(kanarazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(悲),
					result  => q(kanashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([怊悢悷惊慬]),
					result  => q(kanashimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鑕),
					result  => q(kanatoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勰協叶恊]),
					result  => q(kanau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉂),
					result  => q(kanawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([皀芳蔎]),
					result  => q(kanbashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([金釛鈊鉦鋆鍽鐘]),
					result  => q(kane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帑),
					result  => q(kanegura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐻),
					result  => q(kanekake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鎛),
					result  => q(kanekazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鎤),
					result  => q(kanenone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兼該]),
					result  => q(kaneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勘攷考]),
					result  => q(kangaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(錜),
					result  => q(kangishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蟹蠏]),
					result  => q(kani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(檋),
					result  => q(kanjiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(感),
					result  => q(kanjiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冕冠弁辧]),
					result  => q(kanmuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(緌),
					result  => q(kanmurinohimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鉋錑鐁铇]),
					result  => q(kanna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([扂扃楗閂閣]),
					result  => q(kannuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凵),
					result  => q(kannyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(庚),
					result  => q(kanoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麑),
					result  => q(kanoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兂楴簪釵鈿鎞]),
					result  => q(kanzashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([顏顔]),
					result  => q(kao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蘍),
					result  => q(kaooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([飶香馝]),
					result  => q(kaori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕙),
					result  => q(kaorigusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苾薫薰馥馨]),
					result  => q(kaoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頮),
					result  => q(kaowoarau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唐壳楎殻殼漢空]),
					result  => q(kara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([体臗躯躰軀軆骵體]),
					result  => q(karada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嬣),
					result  => q(karadanosama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縢),
					result  => q(karageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([辛辣]),
					result  => q(karai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(揶),
					result  => q(karakau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(棙),
					result  => q(karakuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(搦),
					result  => q(karameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([絡繯]),
					result  => q(karamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枲苧葈]),
					result  => q(karamushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菠),
					result  => q(karana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奈柰]),
					result  => q(karanashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芥),
					result  => q(karashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(荃),
					result  => q(karashiae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([烏鴉鵶]),
					result  => q(karasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐴),
					result  => q(karasukinomimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱲),
					result  => q(karasumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([菇萯]),
					result  => q(karasuuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枳),
					result  => q(karatachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(犛),
					result  => q(karaushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詩),
					result  => q(karauta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枷桲耞]),
					result  => q(karazao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佢彼]),
					result  => q(kare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魪魬鰈鰨]),
					result  => q(karei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鑜餉饟]),
					result  => q(kareii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榸),
					result  => q(karekinone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嗄枯槁沍涸]),
					result  => q(kareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(埣),
					result  => q(karetsuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仮假債猟獠獮獵甸畋雁鳫鴈]),
					result  => q(kari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕕),
					result  => q(kariganeso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(穧),
					result  => q(kariine),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([釭錕]),
					result  => q(karimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(殯),
					result  => q(karimogari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(櫚),
					result  => q(karin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([借僦叚耤]),
					result  => q(kariru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菉),
					result  => q(kariyasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乂刈剼狩穫芟苅薙]),
					result  => q(karu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佡佻偞僄嫖徱軽輏輕輶]),
					result  => q(karui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扑),
					result  => q(karukuutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈣),
					result  => q(karushiumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乢仐傘暈疔疽痒痜瘍瘙瘡瘺癤盖笠簦繖葢蓋]),
					result  => q(kasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痂),
					result  => q(kasabuta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佹層]),
					result  => q(kasanaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(褺),
					result  => q(kasanederomo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([套複褶貤鄭]),
					result  => q(kasaneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([舃舄鵲]),
					result  => q(kasasagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([校械綛]),
					result  => q(kase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(桛),
					result  => q(kasei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([槝樫櫧]),
					result  => q(kashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(爨),
					result  => q(kashigu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俐儇囜譓賢贒]),
					result  => q(kashikoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姧轕]),
					result  => q(kashimashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仟孟頁顱魁]),
					result  => q(kashira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柏栢槲]),
					result  => q(kashiwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姆),
					result  => q(kashizuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壂粕糟貸]),
					result  => q(kasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([銯鎹]),
					result  => q(kasugai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鷆鷏]),
					result  => q(kasui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圠微沕緲]),
					result  => q(kasuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勡掠]),
					result  => q(kasumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(霞),
					result  => q(kasumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([睳瞕]),
					result  => q(kasumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([絣緕纃]),
					result  => q(kasuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([型方楥楷模潟澙片糢肩象]),
					result  => q(kata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踦),
					result  => q(kataashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([像形状皃貌]),
					result  => q(katachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頎),
					result  => q(katachigayoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侄劧堅塙嬛孯嵪掔砎砝硈硬臤鈵鑙難鞏鞕]),
					result  => q(katai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(忝),
					result  => q(katajikena),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(敵),
					result  => q(kataki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頑),
					result  => q(katakuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(殭),
					result  => q(katakunaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(捦),
					result  => q(katakutoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塊),
					result  => q(katamari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([怘睺]),
					result  => q(katame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([固飭]),
					result  => q(katameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(篹),
					result  => q(katami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(簂),
					result  => q(kataminomono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夨),
					result  => q(katamukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仄傾昃昳觭]),
					result  => q(katamuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(刀),
					result  => q(katana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(韄),
					result  => q(katanosageo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袒),
					result  => q(katanugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嚕拐訔語談騗騙]),
					result  => q(kataru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(囏),
					result  => q(katashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([祢禰]),
					result  => q(katashiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(傂),
					result  => q(katatagahi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(俿),
					result  => q(katatagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蝸蠃]),
					result  => q(katatsumuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癈),
					result  => q(katawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傍旁]),
					result  => q(katawara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偏憸詖遹頗]),
					result  => q(katayoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粮粻糈糧]),
					result  => q(kate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([且克剋勝嗐嘎噶尅嶱戡捷旔碟磆羯輵颳]),
					result  => q(katsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夯掮搩]),
					result  => q(katsugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮦鰹]),
					result  => q(katsuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蠓蠛]),
					result  => q(katsuomushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桂楿蘰鬘]),
					result  => q(katsura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癩),
					result  => q(kattai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([曽曾]),
					result  => q(katte),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嚎嫝沽買飼飼]),
					result  => q(kau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([側巛川汜河皮皽臚革韐]),
					result  => q(kawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(裘),
					result  => q(kawagoromo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([靿鞮]),
					result  => q(kawagushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鞨),
					result  => q(kawagutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮍鲏]),
					result  => q(kawahagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([暵烜焅]),
					result  => q(kawakasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乹乾晞渇渴燥]),
					result  => q(kawaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瓦甎甓磚磧]),
					result  => q(kawara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(駱),
					result  => q(kawarage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(檉),
					result  => q(kawarayanagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([薛薼]),
					result  => q(kawarayomogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔯),
					result  => q(kawarayomugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(岱),
					result  => q(kawariau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([代变変忒恑渝變迭]),
					result  => q(kawaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([翆翠翡鴗]),
					result  => q(kawasemi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([焇躱躲]),
					result  => q(kawasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(獺),
					result  => q(kawauso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厠圂圊廁]),
					result  => q(kawaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([榧茅萱蕿藼蘐]),
					result  => q(kaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(孅),
					result  => q(kayowai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俼粥糜飦餗餬饘鬻]),
					result  => q(kayu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癢),
					result  => q(kayui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([珌璪璯鉜錺]),
					result  => q(kazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纓),
					result  => q(kazarihimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(氅),
					result  => q(kazarike),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([掚賁鉘飾餝]),
					result  => q(kazaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凨凮風飌]),
					result  => q(kaze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([揲数數祘笇算]),
					result  => q(kazoeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(峜),
					result  => q(kazoheru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(員),
					result  => q(kazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯑),
					result  => q(kazunoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([藟虆]),
					result  => q(kazura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(籌),
					result  => q(kazutori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([毛氉]),
					result  => q(ke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(汙),
					result  => q(kegaasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(毿),
					result  => q(keganagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(穢),
					result  => q(kegareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([媟汚污浼黷]),
					result  => q(kegasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岏嵃]),
					result  => q(kehashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(陗),
					result  => q(kehashikutakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劲呇唘啔嘒坙坰垧婛嵆嵇嶡巠彑桱殸汫涬潓炔煢猄璚睽硅繐罫蘏螇蟿蠵邢邽郌鍄]),
					result  => q(kei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彐),
					result  => q(keigashira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(亠),
					result  => q(keisan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(毦),
					result  => q(kekazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墼欫湨犱砉郄]),
					result  => q(keki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(毱),
					result  => q(kemari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([閱閲]),
					result  => q(kemisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([獣獸虒貐貙]),
					result  => q(kemono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(犭),
					result  => q(kemonohen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([烟煙]),
					result  => q(kemuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蟖蠋]),
					result  => q(kemushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([毯毹]),
					result  => q(kemushiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亁伭坚妶娊娹媗寋岒巏昡桊棬椦楦瀗犍獫玁痃睍碱祆腱芡蚿豜鄄鈰鋧鞙韅駽鵑]),
					result  => q(ken),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踅),
					result  => q(kenken),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鑷),
					result  => q(kenuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛄螻鉧]),
					result  => q(kera),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儓),
					result  => q(kerai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([跧踢蹴]),
					result  => q(keru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(畩),
					result  => q(kesa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(景),
					result  => q(keshiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桁檁檩]),
					result  => q(keta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吷噘坹岤嵥潏狘玦靹]),
					result  => q(ketsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垥嬓]),
					result  => q(keu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礆),
					result  => q(kewaashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坨塧岴峣峩峭峴崄崒嵂嵜嵯嵳嶃嶄嶇嶢嶬嶮嶸巃巇巌巖磈磛磪陀険隗險]),
					result  => q(kewashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嶔),
					result  => q(kewashiisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([欅𣟱]),
					result  => q(keyaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(距),
					result  => q(kezume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刊刓删刡刨刪刬刮削剗剜剟剷剹劀劂劘釗鎊]),
					result  => q(kezuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(刅),
					result  => q(kezushikeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亓僛厬嘰夔屺岓峞巙庪徛木樻歖氛淇溈滊潙炁眭睎穖簋蘄蘎虁蟢譭豨鄈驥麂麒黃黄]),
					result  => q(ki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕉),
					result  => q(kiasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牙),
					result  => q(kiba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([稷粢黍]),
					result  => q(kibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(酏),
					result  => q(kibisake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伋厳嚴絿酷]),
					result  => q(kibishii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嗃),
					result  => q(kibishiisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瘋),
					result  => q(kichigai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墄墱隥]),
					result  => q(kida),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梈),
					result  => q(kidetsukutsutaooyumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([消熄]),
					result  => q(kieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宯),
					result  => q(kigaagarinusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枖),
					result  => q(kigawakakusakannasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(棵),
					result  => q(kigire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彶),
					result  => q(kihu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葥),
					result  => q(kiichigu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(黈),
					result  => q(kiiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(顑),
					result  => q(kiiroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(侓),
					result  => q(kiisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([純綃]),
					result  => q(kiito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([榡樸翟雉鵫]),
					result  => q(kiji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(坒),
					result  => q(kijihashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(聱),
					result  => q(kikanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔇),
					result  => q(kike),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樵),
					result  => q(kikoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([利効效聆聞聴聼聽]),
					result  => q(kiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛀蝤蠧蠹]),
					result  => q(kikuimushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鶎),
					result  => q(kikuitadaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菊),
					result  => q(kikunohana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([檽薷]),
					result  => q(kikurage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(腠),
					result  => q(kime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([决決]),
					result  => q(kimeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卿后君王辟]),
					result  => q(kimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([肝胆膻膽]),
					result  => q(kimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袳),
					result  => q(kimonohirogaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噷妡庈廑瑾鑫麏]),
					result  => q(kin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杵鈝]),
					result  => q(kine),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嬖),
					result  => q(kiniiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(荖),
					result  => q(kinma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圥菌蕈]),
					result  => q(kinoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(乙),
					result  => q(kinoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枛),
					result  => q(kinotogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(昨),
					result  => q(kinou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([帛幜紦絸絹緭縑繒]),
					result  => q(kinu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(翳),
					result  => q(kinugasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(紪),
					result  => q(kinunoaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([矸砧碪]),
					result  => q(kinuta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嫌),
					result  => q(kirau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桐錐鍴鑚鑽雰雺霚霧]),
					result  => q(kiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蛬),
					result  => q(kirigirisu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柮),
					result  => q(kirihashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([梼檮]),
					result  => q(kirikabu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閝),
					result  => q(kirimado),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([胾膞臠]),
					result  => q(kirimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(剒),
					result  => q(kirimigaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(莝),
					result  => q(kiriwara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓩),
					result  => q(kiroguramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(粁),
					result  => q(kiromeetoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竏),
					result  => q(kirorittoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伐切刋刌刖刴剁剢剪剴剸劚斫斬斮斲服牫着砍翦]),
					result  => q(kiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(妃),
					result  => q(kisaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堮墺岸涯]),
					result  => q(kishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屵),
					result  => q(kishigataka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([軋轢轣]),
					result  => q(kishiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埆競竸]),
					result  => q(kisou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱚),
					result  => q(kisu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(北),
					result  => q(kita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(煅),
					result  => q(kitaaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([段釟鈉鍛鍜]),
					result  => q(kitaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鏅),
					result  => q(kitaheru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髒),
					result  => q(kitanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(逨),
					result  => q(kitaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噄汔蛣]),
					result  => q(kitsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(狐),
					result  => q(kitsune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([莪菻]),
					result  => q(kitsuneaza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倪際]),
					result  => q(kiwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竆),
					result  => q(kiwaameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([檗蘗]),
					result  => q(kiwada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([忓極究窮鞫]),
					result  => q(kiwameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偣偰嚠泚清湜漌潚潾澃澈澯瀏皟皧]),
					result  => q(kiyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(泴),
					result  => q(kiyomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瀟),
					result  => q(kiyoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墀墑阼陖陛階]),
					result  => q(kizahashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刻剞彔栔鋕鋟鑯]),
					result  => q(kizamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(禨),
					result  => q(kizashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(兆),
					result  => q(kizasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傷剙創瑕疵痆痍瘌瘢]),
					result  => q(kizu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殾築]),
					result  => q(kizuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紲絆絏緤縻靽]),
					result  => q(kizuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([个個児兒呱媩子楛泒滹焸猢琥瑚箇箎簄胍蝴衚鄠醐鬍鶘]),
					result  => q(ko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([碗鋗]),
					result  => q(kobachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(拒),
					result  => q(kobamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橢),
					result  => q(kobanga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鵻鸊]),
					result  => q(kobato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(匼),
					result  => q(kobihetsurau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哫娬媚嫵]),
					result  => q(kobiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樝),
					result  => q(koboke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(骮),
					result  => q(kobone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([毀毁]),
					result  => q(kobotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瘤癅癭]),
					result  => q(kobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(藎),
					result  => q(kobunagusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([舲艖]),
					result  => q(kobune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(拳),
					result  => q(kobushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鯒鲬]),
					result  => q(kochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岈蜽谺魎]),
					result  => q(kodama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(豾),
					result  => q(kodameki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(狉),
					result  => q(kodanuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偅囝崽]),
					result  => q(kodomo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僁吆吜吤咴咾哄哱唎啊喓嗘嗿嘭噃噈嚁嚱囉囋囐声聲胶詓]),
					result  => q(koe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葼),
					result  => q(koeda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吱咭]),
					result  => q(koenosama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([肥肪肭腯腴膆超越跇踰躝逾隃駜]),
					result  => q(koeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(魥),
					result  => q(kogame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鉙鏋]),
					result  => q(kogane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凩),
					result  => q(kogarashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(焦),
					result  => q(kogeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粞糏]),
					result  => q(kogome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(漕),
					result  => q(kogu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鋅),
					result  => q(kohai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鞐),
					result  => q(kohaze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嫪),
					result  => q(kohishitahu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([羔羜]),
					result  => q(kohitsuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([恋戀濃醕鯉鱣]),
					result  => q(koi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兾冀]),
					result  => q(koinegau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礫),
					result  => q(koishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(婟),
					result  => q(koishitau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鏢),
					result  => q(kojiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樾),
					result  => q(kokage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苔蘚]),
					result  => q(koke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(杮),
					result  => q(kokera),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([此茊]),
					result  => q(koko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(娎),
					result  => q(kokochiyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([于爰粤粵]),
					result  => q(kokoni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(九),
					result  => q(kokonotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([心恉意]),
					result  => q(kokoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(愢),
					result  => q(kokorogatagau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(憹),
					result  => q(kokoromidareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([試課]),
					result  => q(kokoromiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([快愜]),
					result  => q(kokoroyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(志),
					result  => q(kokorozasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俈呄唃囯囻塶糓觳閄]),
					result  => q(koku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薌),
					result  => q(kokumotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(黟),
					result  => q(kokutan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蚚),
					result  => q(kokuzoumushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([狛駒]),
					result  => q(koma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榀),
					result  => q(komai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([緻脞苛麼]),
					result  => q(komakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(撿),
					result  => q(komaneku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(拱),
					result  => q(komanuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(困),
					result  => q(komaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(矈),
					result  => q(komayaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([米糄]),
					result  => q(kome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(籔),
					result  => q(komeagesa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([廘廯禀稟]),
					result  => q(komegura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(顬),
					result  => q(komekami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(罩),
					result  => q(komeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([径徑蹊逕]),
					result  => q(komichi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(徯),
					result  => q(komisa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厮廝]),
					result  => q(komono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(腷),
					result  => q(komoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(込),
					result  => q(komu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麳),
					result  => q(komugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([腓腨]),
					result  => q(komura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倱哏崐崑惽晜棔琨琿紺菎蒟訤餛鯀鶤鼲]),
					result  => q(kon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粉粷]),
					result  => q(kona),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([糂糝]),
					result  => q(konagaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([糕飳餻饀麭]),
					result  => q(konamochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橪),
					result  => q(konatsume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(揑),
					result  => q(koneawaseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(捏),
					result  => q(koneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(斯),
					result  => q(kono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(欇),
					result  => q(konohagauragaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(慾),
					result  => q(konomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(好),
					result  => q(konomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮗鯯鰣鰶鰽鱅]),
					result  => q(konoshiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偌),
					result  => q(konoyouna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(漿),
					result  => q(konzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冫冰氷郡]),
					result  => q(koori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛩蟀]),
					result  => q(koorogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冱冴凅凍]),
					result  => q(kooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凕),
					result  => q(koorusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(怺),
					result  => q(koraeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(懲),
					result  => q(korasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伊唗是昰]),
					result  => q(kore),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痧),
					result  => q(korera),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頃),
					result  => q(koro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([転轉]),
					result  => q(korobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夗),
					result  => q(korogariusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(厯),
					result  => q(koromi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([衣衫衲褖襒]),
					result  => q(koromo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(衤),
					result  => q(koromohen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椸),
					result  => q(koromokake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鎶),
					result  => q(koromubyuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刘劉戕戮殛殺煞]),
					result  => q(korosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凝),
					result  => q(koru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([溦霎霡霢]),
					result  => q(kosame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([腰輿轝]),
					result  => q(koshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([髎髖]),
					result  => q(koshibone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([档榻櫈]),
					result  => q(koshikake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呮),
					result  => q(koshikakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([甑甗轂鉹鎦鐂鬳]),
					result  => q(koshiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(篆),
					result  => q(koshikishiba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(拵),
					result  => q(koshiraeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(楜),
					result  => q(koshou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([淥渌湑漉濾釃]),
					result  => q(kosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嘫応答譍]),
					result  => q(kotaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圬墁杇槾釬銲鏝]),
					result  => q(kote),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亊事叓殊珡琴琹異筝箏縡言]),
					result  => q(koto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詞),
					result  => q(kotoba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誗),
					result  => q(kotobagauruwashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壽寿]),
					result  => q(kotobuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侭儘]),
					result  => q(kotogotoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諺),
					result  => q(kotowaza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匢尳紇蓇趷]),
					result  => q(kotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丐乞仜傐儣勂匃匟叝吰咣唝嗊嗥堼堽墝奟妅姮嫦孝岲峇峵崆崤崲巆巟庨彀暠棡槹汯沟洚洨淏渹漖澒牼玽珓珩瑝璜瓨癀皜皝瞌矦硄硜硡硣硤碽磽秏笱箜篌絚緪縆纐罡翃胱芁茳莄蔲蘅虠蚣訇誟請講郈郜郟鄗鄺鈜鉷鍞鍧鐄鑅閌閎閧雊馦骯骾鯁鱇鵁鶊黋]),
					result  => q(kou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芬馟]),
					result  => q(koubashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蒒),
					result  => q(koubaumugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([揥笄]),
					result  => q(kougai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([糀麯麴麹]),
					result  => q(kouji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟙),
					result  => q(koumuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(被),
					result  => q(koumuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([雚鸛]),
					result  => q(kounotori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(忇),
					result  => q(kourougaookii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(犢),
					result  => q(koushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楮榖]),
					result  => q(kouzo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(怖),
					result  => q(kowai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壊壞]),
					result  => q(kowasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(厪),
					result  => q(koya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([暦曆]),
					result  => q(koyomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(傆),
					result  => q(kozakashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(阝),
					result  => q(kozatohen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杪桻梢梶槇槙標]),
					result  => q(kozue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冔区句咻堶崁挧灈盱眗胊蘧踽酗]),
					result  => q(ku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(配),
					result  => q(kubaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([頚頸首]),
					result  => q(kubi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(刎),
					result  => q(kubihaneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鉗銗]),
					result  => q(kubikase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賏),
					result  => q(kubikazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([槅軛]),
					result  => q(kubiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(剄),
					result  => q(kubikiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縊),
					result  => q(kubiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跟),
					result  => q(kubisu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(窪),
					result  => q(kubo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坳臾]),
					result  => q(kubomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凹窊窳]),
					result  => q(kubomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(口),
					result  => q(kuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咮喙嘴觜]),
					result  => q(kuchibashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呡),
					result  => q(kuchibata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唇脣]),
					result  => q(kuchibiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(咡),
					result  => q(kuchimoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桅梔]),
					result  => q(kuchinashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(胗),
					result  => q(kuchinohibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朽),
					result  => q(kuchiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(吻),
					result  => q(kuchisaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(管),
					result  => q(kuda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([拉摧砕碎]),
					result  => q(kudaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菓),
					result  => q(kudamono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(件),
					result  => q(kudari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諄),
					result  => q(kudokudo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釘),
					result  => q(kugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齣),
					result  => q(kugiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鵠),
					result  => q(kugui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偊),
					result  => q(kugumarusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([窬閤]),
					result  => q(kugurido),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐯),
					result  => q(kuha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杙栱椵樁橛牁]),
					result  => q(kui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厊厏鋙齬]),
					result  => q(kuichigau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(餇),
					result  => q(kuimono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([悔懴懺]),
					result  => q(kuiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([籖籤鬮]),
					result  => q(kuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([剉抏挫邋]),
					result  => q(kujiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯨),
					result  => q(kujira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([觹觽觿]),
					result  => q(kujiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(絎),
					result  => q(kukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岫茎莖莛]),
					result  => q(kuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薅),
					result  => q(kukiotoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(莇),
					result  => q(kuko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髽),
					result  => q(kukurigami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兗括摎稛]),
					result  => q(kukuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乪埢嵎澳熊阿隈隩]),
					result  => q(kuma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟟),
					result  => q(kumazemi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(粂),
					result  => q(kume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([什伍隊]),
					result  => q(kumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(絙),
					result  => q(kumihimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(與),
					result  => q(kumisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛛蜘蟱雲鼅]),
					result  => q(kumo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([昩曀曇霃]),
					result  => q(kumoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([戽抒挹斟汲組舀酌酙]),
					result  => q(kumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桾獯珺鍕]),
					result  => q(kun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囶国圀國邑邦]),
					result  => q(kuni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祇),
					result  => q(kunitsukami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栩棌椚椡椪檪櫟]),
					result  => q(kunugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倉匨厫囥囷宬峅庫庾廩廪蔵藏鞍]),
					result  => q(kura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夶),
					result  => q(kuraaberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([比較迦]),
					result  => q(kuraberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(唼),
					result  => q(kurahu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([位儚冥幽懜昏昧昬晻暗暝曖曚溟眊眛眜睧瞑瞢矒窈]),
					result  => q(kurai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(眩),
					result  => q(kuramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噉嚪飰]),
					result  => q(kurau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吳吴呉晚晩榑莫]),
					result  => q(kure),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([旰暌暮]),
					result  => q(kureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(栗),
					result  => q(kuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([駵騮驑]),
					result  => q(kurige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厨橱𢊍]),
					result  => q(kuriya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([玄緇]),
					result  => q(kuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鉄銕鋠鋨鐡鐵]),
					result  => q(kurogane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([糙糲]),
					result  => q(kurogome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泑黎黑黒黔黧黬黮黯黸]),
					result  => q(kuroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(黰),
					result  => q(kurokami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秠秬穄]),
					result  => q(kurokibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(驪),
					result  => q(kurokoma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([驔驖]),
					result  => q(kurokurige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芍),
					result  => q(kurokuwai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(騏),
					result  => q(kuromidori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([來徠来繅繰]),
					result  => q(kuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踝),
					result  => q(kurubushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伡俥車]),
					result  => q(kuruma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([橖轤]),
					result  => q(kurumagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(轘),
					result  => q(kurumazaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(眯),
					result  => q(kurumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(矪),
					result  => q(kururiya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伌倊偬傯僀厄愱憥窘]),
					result  => q(kurushimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倀僪怳抂狂猖獝瘈瘹癲]),
					result  => q(kuruu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垺郛郭]),
					result  => q(kuruwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([庖廚]),
					result  => q(kurya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卉艸芔芷苢草莽莾菏葜]),
					result  => q(kusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(臰),
					result  => q(kusaai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(噣),
					result  => q(kusabashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楔槢櫼舝軏輗轄錧鎋]),
					result  => q(kusabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蘺),
					result  => q(kusabie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([耘農]),
					result  => q(kusagiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(臭),
					result  => q(kusai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嚏),
					result  => q(kusame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叢蓁藂]),
					result  => q(kusamura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丵),
					result  => q(kusanomuragari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鋂鎖鏁鏈]),
					result  => q(kusari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([腐餲鯘]),
					result  => q(kusaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(莜),
					result  => q(kusatori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癖),
					result  => q(kuse),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嚔),
					result  => q(kushami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([串丳奇櫛竒]),
					result  => q(kushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匳奩]),
					result  => q(kushige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梳),
					result  => q(kushikezuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屎糞]),
					result  => q(kuso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樟),
					result  => q(kusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擽),
					result  => q(kusuguru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枏楠櫲]),
					result  => q(kusunoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([薬藥]),
					result  => q(kusuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(萙),
					result  => q(kutabireru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湫),
					result  => q(kute),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屨欻歘沓縀躧靴靸鞜鞾韗]),
					result  => q(kutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鞿),
					result  => q(kutsubami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(絇),
					result  => q(kutsukazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(讌),
					result  => q(kutsurogu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屜),
					result  => q(kutsushiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(衘),
					result  => q(kutsushiyu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勒啣銜鑣]),
					result  => q(kutsuwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(珂),
					result  => q(kutsuwagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幩),
					result  => q(kutsuwanokazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吙咋咵啖啗喫喰茹食]),
					result  => q(kuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嬅枽桑桒耨萪鋤钁]),
					result  => q(kuwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(企),
					result  => q(kuwadateru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([加叼尚]),
					result  => q(kuwaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嬇),
					result  => q(kuwai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墎彉彏]),
					result  => q(kuwaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([詳錆]),
					result  => q(kuwashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葛),
					result  => q(kuzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(綌),
					result  => q(kuzununo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(墮),
					result  => q(kuzure),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(阽),
					result  => q(kuzurekakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垘崩嵭隳頹頽]),
					result  => q(kuzureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岥岮]),
					result  => q(kuzurerusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(堕),
					result  => q(kuzusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噱屫]),
					result  => q(kyaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佉匷壉姖岠琚璩磲簴籧蚷魖鮔]),
					result  => q(kyo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([洌浄淨淸湲瀞]),
					result  => q(kyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茍蕀輂]),
					result  => q(kyoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亯仼刼卭呌呺唊嘺塨嵹嶠巩撟珙珦簥蔃蕎蜐蜣蟜蹻邛鄥銎鱜麘]),
					result  => q(kyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弧),
					result  => q(kyumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乣恷浗潝牞玖璆芎莍萛蚯訄貅]),
					result  => q(kyuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嘛眞]),
					result  => q(ma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幻),
					result  => q(maboroshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(眮),
					result  => q(mabuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔟),
					result  => q(mabushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([眶瞼臉]),
					result  => q(mabuta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坊町甼街襠]),
					result  => q(machi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(岔),
					result  => q(machigau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([斑斒牻駁駮]),
					result  => q(madara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([騨驎驒]),
					result  => q(madarauma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(犖),
					result  => q(madaraushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([廔楪牎牕牖窓窗窻]),
					result  => q(mado),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(惑),
					result  => q(madou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(謆),
					result  => q(madowasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(前),
					result  => q(mae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襜),
					result  => q(maekake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杝棥椐樊篳籬藩]),
					result  => q(magaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齽),
					result  => q(magariba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乀尪尫曲枉紆觩錈骪骫]),
					result  => q(magaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髷),
					result  => q(mage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(尣),
					result  => q(mageashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(紛),
					result  => q(magireru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(孫),
					result  => q(mago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([忠悃]),
					result  => q(magokoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鎂),
					result  => q(maguneshiumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮪),
					result  => q(maguro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秣芻茭蒭]),
					result  => q(magusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廥),
					result  => q(magusagura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(晌),
					result  => q(mahiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賕),
					result  => q(mainai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賂),
					result  => q(mainau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([参-叅]),
					result  => q(mairu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襍),
					result  => q(majieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(羼),
					result  => q(majiriau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殽淆礡礴糅逪錯鏙雑雜]),
					result  => q(majiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([交崔爻]),
					result  => q(majiwaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賄),
					result  => q(makanau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([任嫴]),
					result  => q(makaseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([牧篇駉]),
					result  => q(maki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鍺),
					result  => q(makigane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(筎),
					result  => q(makihada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苽菰蒋蔣]),
					result  => q(makomo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伩信允剘忱恂愊愖愫款歀真衠訦訫誠諶]),
					result  => q(makoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寔洵]),
					result  => q(makotoni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卷巻幔捲撒播綣膜]),
					result  => q(maku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枕),
					result  => q(makura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墹壗]),
					result  => q(mama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尗荳菽蓽藨豆]),
					result  => q(mame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(萁),
					result  => q(mamegara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(灝),
					result  => q(mamejiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(貒),
					result  => q(mami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(貛),
					result  => q(mamidameki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([覲謁]),
					result  => q(mamieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(魔),
					result  => q(mamono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垨),
					result  => q(mamooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([守戍掫衛衞護]),
					result  => q(mamoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([虺蝠蝮]),
					result  => q(mamushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杧饅]),
					result  => q(man),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(黌),
					result  => q(manabeya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(庠),
					result  => q(manabiya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([学學斈]),
					result  => q(manabu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鯧鰪]),
					result  => q(managatsuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俎梡爼]),
					result  => q(manaita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([眥眦睚]),
					result  => q(manajiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(眵),
					result  => q(manajirioitameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(眼),
					result  => q(manako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴰鶬]),
					result  => q(manazuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(招),
					result  => q(maneku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(錳),
					result  => q(mangan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卍卐]),
					result  => q(manji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(免),
					result  => q(manukareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([希稀罕]),
					result  => q(mare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([毬鞠]),
					result  => q(mari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麿),
					result  => q(maro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垸),
					result  => q(marobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([客賓賔]),
					result  => q(maroudo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丸円団圌圎圓團圝摶槫輐]),
					result  => q(marui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仢彴榷]),
					result  => q(marukibashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([材𣏾]),
					result  => q(maruta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(熰),
					result  => q(maruyaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柾),
					result  => q(masa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([戉鉞鍠锽]),
					result  => q(masakari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傊愈]),
					result  => q(masaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匬升埤増增斛朇枡桝益賆賸鮅鱒益]),
					result  => q(masu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(栭),
					result  => q(masugata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(冞),
					result  => q(masumasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亦俣又叉奎孋椏股胯脵]),
					result  => q(mata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跨),
					result  => q(matagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(骻),
					result  => q(matagura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([眨眴瞚瞬]),
					result  => q(matataku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蟶鮲]),
					result  => q(mate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侯埻的]),
					result  => q(mato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纝),
					result  => q(matofu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([洛綢綶繞纏纒]),
					result  => q(matou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俟偫儝待松枩柗梥竢茉靺]),
					result  => q(matsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(睫),
					result  => q(matsuge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([礿祊祻祼禓禘禡禫禯禴肜]),
					result  => q(matsuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(政),
					result  => q(matsurigoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奠祀祫祭禋郊醊醮餟]),
					result  => q(matsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偒),
					result  => q(matsusugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偗),
					result  => q(matsusugunasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俒囫]),
					result  => q(matsutashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丩),
					result  => q(matsuwaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(檞),
					result  => q(matsuyani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(完),
					result  => q(mattai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(全),
					result  => q(mattaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儛壿娑舞躚]),
					result  => q(mau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(周),
					result  => q(mawari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輥),
					result  => q(mawaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囘回廽逥]),
					result  => q(mawasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(迷),
					result  => q(mayou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([眉睂繭蠒]),
					result  => q(mayu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枋檀]),
					result  => q(mayumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(顣),
					result  => q(mayuwohisomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([黛黱]),
					result  => q(mayuzumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(混),
					result  => q(mazeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寠貧]),
					result  => q(mazushii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([目芽]),
					result  => q(me),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茁萌萠]),
					result  => q(mebae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([豏鎨鎩]),
					result  => q(mebaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(愛),
					result  => q(mederu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(霱),
					result  => q(medetaikumo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([筮筴蓍]),
					result  => q(medogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(咪),
					result  => q(meetoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓪),
					result  => q(megahara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(眢),
					result  => q(megautsuronasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(寵),
					result  => q(megumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([恩恵惠昷]),
					result  => q(megumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嶲),
					result  => q(meguri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(圛),
					result  => q(meguriyuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匝匯圜巡帀廻徼斡旋昖湋漩澋縈繚般輾迊迴週逳遶邏]),
					result  => q(meguru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蓷),
					result  => q(mehajiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牂),
					result  => q(mehitsuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妷姪蓂鄍]),
					result  => q(mei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麀),
					result  => q(mejika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幑),
					result  => q(mejirushinonuno),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(妾),
					result  => q(mekake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鍰),
					result  => q(mekata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鍍),
					result  => q(mekki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([盲瞍瞎]),
					result  => q(mekura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(茆),
					result  => q(menawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(碯),
					result  => q(menou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(娚),
					result  => q(meoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([覙覟覼]),
					result  => q(meru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([飯飯]),
					result  => q(meshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(盧),
					result  => q(meshibitsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瞽矇]),
					result  => q(meshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([召牝牸雌]),
					result  => q(mesu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妠娶]),
					result  => q(metoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(睜),
					result  => q(metsuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夒),
					result  => q(mezaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([珍珎]),
					result  => q(mezurashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([実實巳弎箕籮身躬躳]),
					result  => q(mi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(睢),
					result  => q(miageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噵堩墿廸涂衑術衜衟衢迪途道陌隧𧗷]),
					result  => q(michi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([導羐羑]),
					result  => q(michibiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弸悥満满滿畗盁盈窂]),
					result  => q(michiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劮姦婸嫟]),
					result  => q(midara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宄),
					result  => q(midare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乱亂怓惷憒懂擰擾涽濫紊紜綧莦薴訬詜鬙]),
					result  => q(midareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妄漫猥]),
					result  => q(midari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(叨),
					result  => q(midarini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([挭捁撹攪誖]),
					result  => q(midasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([碧綠緑]),
					result  => q(midori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([婗嫛孾]),
					result  => q(midorigo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丏),
					result  => q(mienu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([揅琢瑳碿磋磨鋥鋿鎣鏛]),
					result  => q(migaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(熳),
					result  => q(migarini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([趬蹺]),
					result  => q(migarui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(右),
					result  => q(migi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(砌),
					result  => q(migiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(汀),
					result  => q(migiwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮊鯫鱎鲌]),
					result  => q(migoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([袘袾裀裑褍]),
					result  => q(migoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(哨),
					result  => q(mihari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([眒瞠瞪]),
					result  => q(miharu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侏短]),
					result  => q(mijikai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([惨慘]),
					result  => q(mijime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帝),
					result  => q(mikado),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柑),
					result  => q(mikan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朏),
					result  => q(mikazuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([幹榦]),
					result  => q(miki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([巫覡]),
					result  => q(miko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詔),
					result  => q(mikotonori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芧),
					result  => q(mikuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輅),
					result  => q(mikuruma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薨),
					result  => q(mimakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丰妦妭姍姗姣姯姳娥娧婍婕婘婥婽媄媌媠媱嫙嫷嬮嬽]),
					result  => q(mimeyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妧妵姭婤嫈嫹]),
					result  => q(mimeyoisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(耳),
					result  => q(mimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(聹),
					result  => q(mimiaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([珥琩瑱]),
					result  => q(mimidama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(聤),
					result  => q(mimidare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(璫),
					result  => q(mimikazari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(刵),
					result  => q(mimikiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(馘),
					result  => q(mimikiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(耵),
					result  => q(mimikuso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(苓),
					result  => q(miminagusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(耺),
					result  => q(miminari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚓蜿螾蟺]),
					result  => q(mimizu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([雈雒鵂鵩鶹]),
					result  => q(mimizuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姅),
					result  => q(mimosagakizutsuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僉咸皆]),
					result  => q(mina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泩漲]),
					result  => q(minagiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鏖),
					result  => q(minagoroshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(南),
					result  => q(minami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厵沅渞源]),
					result  => q(minamoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(孤),
					result  => q(minashigo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凑港湊]),
					result  => q(minato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岑峯峰崟嶂嶺巒巘磦]),
					result  => q(mine),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倠儖噅噕娸醜魌]),
					result  => q(minikui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([簑簔蓑]),
					result  => q(mino),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(稼),
					result  => q(minori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秖秪稔]),
					result  => q(minoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(膲),
					result  => q(minowata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(澪),
					result  => q(mio),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓱),
					result  => q(miriguramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(粍),
					result  => q(mirimeetoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竓),
					result  => q(miririttoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宐),
					result  => q(miroshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佔監眀看眎睖睞督睤睰睲睹瞟瞰瞻瞿矑矕矙矚見覌視覛覜覠覧覩観覵覶覸覽觀診詧閿闆]),
					result  => q(miru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(睴),
					result  => q(mirusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([雎鶚]),
					result  => q(misago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(岬),
					result  => q(misaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(撡),
					result  => q(misao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牣),
					result  => q(misaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(陵),
					result  => q(misasagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厘店舖]),
					result  => q(mise),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(豉),
					result  => q(miso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(禊),
					result  => q(misogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(晦),
					result  => q(misoka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齠),
					result  => q(misoppa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(庿),
					result  => q(mitamaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(認),
					result  => q(mitomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([三叁蜜]),
					result  => q(mitsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([租稅税賦賨]),
					result  => q(mitsugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(貢),
					result  => q(mitsugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瞆瞶]),
					result  => q(mitsukusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([眙瞄]),
					result  => q(mitsumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(覴),
					result  => q(mitsumerusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蝋蠟]),
					result  => q(mitsurou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(愑),
					result  => q(mitsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(戚),
					result  => q(miuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宫宮]),
					result  => q(miya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嫺嫻雅]),
					result  => q(miyabiyaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([京亰師畿都都]),
					result  => q(miyako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蘘),
					result  => q(miyouga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圳洫涇涜渠溝瀆甽畎]),
					result  => q(mizo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鴋),
					result  => q(mizogoisagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(霙),
					result  => q(mizore),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([水瀣]),
					result  => q(mizu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([彲虬虯蛟螭]),
					result  => q(mizuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(汞),
					result  => q(mizugane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([湄溿漈漘]),
					result  => q(mizugiwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蹼),
					result  => q(mizukaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(自),
					result  => q(mizukara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(壬),
					result  => q(mizunoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癸),
					result  => q(mizunoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薔),
					result  => q(mizutade),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([潴瀦]),
					result  => q(mizutamari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湖),
					result  => q(mizuumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喪莙藻裳]),
					result  => q(mo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([檍糫飥餅餈餌餜餠饆饠黐]),
					result  => q(mochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([朮术秫]),
					result  => q(mochiawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(糯),
					result  => q(mochigome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([庸用]),
					result  => q(mochiiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擌),
					result  => q(mochizao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朢),
					result  => q(mochizuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([忶怟悶懣]),
					result  => q(modaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(乖),
					result  => q(modoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([戻戾]),
					result  => q(modosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(熌),
					result  => q(moeagaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(燼),
					result  => q(moenokori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([然燃]),
					result  => q(moeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踠),
					result  => q(mogaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([疱痘]),
					result  => q(mogasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鼴鼹]),
					result  => q(mogura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚡鼢]),
					result  => q(moguramochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(絻),
					result  => q(mohuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(綟),
					result  => q(moji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縠),
					result  => q(mojiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(沴),
					result  => q(mokonau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(悾),
					result  => q(mokoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(杢),
					result  => q(moku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橒),
					result  => q(mokume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樨),
					result  => q(mokusei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(氎),
					result  => q(momennonuno),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(訌),
					result  => q(momeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([樅籾]),
					result  => q(momi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(稃),
					result  => q(momigara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椛),
					result  => q(momiji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桃百腿髀髁髈]),
					result  => q(momo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([挪揉]),
					result  => q(momu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圚燜]),
					result  => q(mon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閽),
					result  => q(monban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塾),
					result  => q(monbeya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(匁),
					result  => q(monme),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([物者]),
					result  => q(mono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([斎齋]),
					result  => q(monoimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(喇),
					result  => q(monoiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哧堠]),
					result  => q(monomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(魅),
					result  => q(mononoke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尺矱]),
					result  => q(monosashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寙慵]),
					result  => q(monoui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(沗),
					result  => q(mooeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([专専專醇]),
					result  => q(moppara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(貰),
					result  => q(morau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(泄),
					result  => q(moreru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傅森]),
					result  => q(mori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([諸諸]),
					result  => q(moro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([脃脆脺]),
					result  => q(moroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([庶庻]),
					result  => q(moromoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屚捄溌漏潑盛鉻]),
					result  => q(moru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(倘),
					result  => q(moshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(若),
					result  => q(moshikuha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(裙),
					result  => q(mosuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襆),
					result  => q(mosuso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([抬擡]),
					result  => q(motageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瓮罌]),
					result  => q(motai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([賷齎]),
					result  => q(motarasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弄挊挵捓玩翫謅]),
					result  => q(moteasobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(饗),
					result  => q(motenasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([元啇本葆貭資質酵]),
					result  => q(moto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髻),
					result  => q(motodori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(基),
					result  => q(motoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亘匄攼欿求覓覔迀]),
					result  => q(motomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丿佷倄傟剌墏婞很悖悻愂愎狠盶紾]),
					result  => q(motoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丮抦持撣]),
					result  => q(motsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔂),
					result  => q(motsuko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嫥),
					result  => q(motsupara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([縺繎]),
					result  => q(motsureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(最),
					result  => q(mottomo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(甿),
					result  => q(mou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夃設]),
					result  => q(moukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([毡氈氍]),
					result  => q(mousen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(申),
					result  => q(mousu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([霏靄]),
					result  => q(moya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(舫),
					result  => q(moyaibune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(催),
					result  => q(moyoosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴃鵙鵧鶪]),
					result  => q(mozu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([礭笘笞策鞭]),
					result  => q(muchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([抶捶撻敇韃]),
					result  => q(muchiutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(冗),
					result  => q(muda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儯),
					result  => q(mugai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([稞麥麦]),
					result  => q(mugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麮),
					result  => q(mugigayu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([麪麵麺]),
					result  => q(mugiko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麨),
					result  => q(mugikogashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葎),
					result  => q(mugura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([狢貆貉]),
					result  => q(mujina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俉迎迓邀]),
					result  => q(mukaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(昔),
					result  => q(mukashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偭傃嚮对対對]),
					result  => q(mukau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壻婿聟]),
					result  => q(muko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([向棶椋槵]),
					result  => q(muku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([椴槿毳氄葮蕣]),
					result  => q(mukuge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賽),
					result  => q(mukuimatsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(尨),
					result  => q(mukuinu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([讎讐酧酬酭醻]),
					result  => q(mukuiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(骸),
					result  => q(mukuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([靳鞅]),
					result  => q(munagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(棼),
					result  => q(munagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(肓),
					result  => q(munamoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奅婁廖廫忐忑桍椌盅罄虗虚虛]),
					result  => q(munashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匈宗旨棟橦檼欐胸膺臆]),
					result  => q(mune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(膈),
					result  => q(munenouchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擗),
					result  => q(muneoutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([村邨閭闒]),
					result  => q(mura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([樷簇羣群茽]),
					result  => q(muragaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紫茈]),
					result  => q(murasaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宭),
					result  => q(mureiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([室榁窩]),
					result  => q(muro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰘),
					result  => q(muroaji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(恈),
					result  => q(musaborioshimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亄嚂婪嬠忨惏懢牟貪饕饞]),
					result  => q(musaboru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(妋),
					result  => q(musaborusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鼫鼯鼺]),
					result  => q(musasabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侅呦哽嗢噎嚘旡]),
					result  => q(musebu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([禹虫蟲]),
					result  => q(mushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(溽),
					result  => q(mushiatsui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齲),
					result  => q(mushiba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蝕),
					result  => q(mushibamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(飩),
					result  => q(mushimochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寍席筵莚蒻蓆]),
					result  => q(mushiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([挘毟毮]),
					result  => q(mushiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(罿),
					result  => q(musouami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([烝蒸餴餾饙]),
					result  => q(musu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(結),
					result  => q(musubu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([娘嬢孃]),
					result  => q(musume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(伕),
					result  => q(musumemuko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銠),
					result  => q(mutenyuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([六鯥鱫]),
					result  => q(mutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(噰),
					result  => q(mutsubu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礥),
					result  => q(mutsukashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([緥襁]),
					result  => q(mutsuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(睦),
					result  => q(mutsumajii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(跂),
					result  => q(mutsuyubi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([名菜蔌]),
					result  => q(na),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([銚錥鍋鎬鐎鐺鑃]),
					result  => q(nabe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([旖靡]),
					result  => q(nabiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嫐嬲]),
					result  => q(naburu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(洋),
					result  => q(nada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([抿捫捬撫敉]),
					result  => q(naderu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秧苗]),
					result  => q(nae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([痿萎]),
					result  => q(naeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(镸),
					result  => q(nagaai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([滈霖]),
					result  => q(nagaame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(轅),
					result  => q(nagae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(轆),
					result  => q(nagaeshiha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兏昶永縯長镹隑餑]),
					result  => q(nagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉥),
					result  => q(nagaibari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幱),
					result  => q(nagaikoromo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(僺),
					result  => q(nagaisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襡),
					result  => q(nagajuban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(眺),
					result  => q(nagameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瀷),
					result  => q(nagare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乁汩汭沇泌泫流湝滮漦瀠瀰灤磷]),
					result  => q(nagareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袤),
					result  => q(nagasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([眄眤睥]),
					result  => q(nagashime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痼),
					result  => q(nagawazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偯唈唌唏喂嗞嗺嘁嘅嘆忼惋慟慨欷欸歎]),
					result  => q(nageku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([投沰]),
					result  => q(nageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([抛拋搥擲攛]),
					result  => q(nageutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([彅梛椥]),
					result  => q(nagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([沚渚澰]),
					result  => q(nagisa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(摝),
					result  => q(nagokasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凪),
					result  => q(nagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殴毆]),
					result  => q(naguru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(慰),
					result  => q(nagusameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亡亾无毋無]),
					result  => q(nai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([中仲]),
					result  => q(naka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([半央]),
					result  => q(nakaba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(隆),
					result  => q(nakadaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儈),
					result  => q(nakagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([党黨]),
					result  => q(nakama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喤嘠]),
					result  => q(nakigoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(妣),
					result  => q(nakihaha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(坻),
					result  => q(nakisa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妁媒]),
					result  => q(nakoudo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呃咷哭唳唴唶啼啾嗁嚶泣鳴鷕]),
					result  => q(naku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鍒),
					result  => q(namagane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葷),
					result  => q(namagusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([羴羶腥鮏鯹]),
					result  => q(namagusai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([慭憖憗]),
					result  => q(namajiini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嬌艶艷豓豔]),
					result  => q(namamekashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(妖),
					result  => q(namameku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([訛譌鈆鉛]),
					result  => q(namari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([膾韲鱠鲙齏]),
					result  => q(namasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([癜魸鮀鮷鯰鯷鰋]),
					result  => q(namazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蛞),
					result  => q(namekuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冭捸滑达]),
					result  => q(nameraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呫哾啛嗒嘗嚌嚐甞舐舓舔]),
					result  => q(nameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([靼鞣韋]),
					result  => q(nameshigawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(舏),
					result  => q(nametoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([並傡波浪涛漛漪濤瀾灎灔灧灩]),
					result  => q(nami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泪涕涙淚]),
					result  => q(namida),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蝻諵]),
					result  => q(nan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([斜迆迤陁]),
					result  => q(naname),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踷),
					result  => q(nanameniyuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(七),
					result  => q(nanatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([何啥曷]),
					result  => q(nani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([你倷尓尔汝爾]),
					result  => q(nanji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奚胡詎那]),
					result  => q(nanzo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([犹猶]),
					result  => q(nao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(矗),
					result  => q(naoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(直),
					result  => q(naosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(楢),
					result  => q(nara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竝),
					result  => q(naraberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(乑),
					result  => q(narabitatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秝輌輛駢騈]),
					result  => q(narabu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([櫌耰]),
					result  => q(narasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俲倣傚僓忲摜習肄臹]),
					result  => q(narau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(俗),
					result  => q(narawashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([慣狃狎褻馴]),
					result  => q(nareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麋),
					result  => q(nareshika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(也),
					result  => q(nari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侀成裍]),
					result  => q(naru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(茮),
					result  => q(naruhajikami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(情),
					result  => q(nasake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勿梨]),
					result  => q(nashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(茄),
					result  => q(nasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屶),
					result  => q(nata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夏夓螓螗]),
					result  => q(natsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([懐懷]),
					result  => q(natsuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([棗樲]),
					result  => q(natsume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([綯绹]),
					result  => q(nau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(匘),
					result  => q(nauzuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紉索縄繩纆]),
					result  => q(nawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(畷),
					result  => q(nawate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儜悩惱懊艱訒]),
					result  => q(nayamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([謎讔]),
					result  => q(nazo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儗准擬]),
					result  => q(nazoraeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詺),
					result  => q(nazukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([萕薺]),
					result  => q(nazuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([値值柢根桗氒茇荄袮]),
					result  => q(ne),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(溓),
					result  => q(nebaritsuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粘黏]),
					result  => q(nebaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寗甯]),
					result  => q(negai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僥懩覦願]),
					result  => q(negau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芤葱蔥]),
					result  => q(negi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勞犒]),
					result  => q(negirau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囈寱讆讏]),
					result  => q(negoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([塒窼]),
					result  => q(negura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([輬輭]),
					result  => q(neguruma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([檸矃]),
					result  => q(nei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屃屓齃]),
					result  => q(neiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(拗),
					result  => q(nejikeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扭),
					result  => q(nejimawasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(捩),
					result  => q(nejiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟊),
					result  => q(nekirimushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([猫貓]),
					result  => q(neko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(棭),
					result  => q(nemunoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哻眠睏睡]),
					result  => q(nemuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([懃懇]),
					result  => q(nengoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([狙躵]),
					result  => q(nerau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(絨),
					result  => q(neriito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寐寝寢湅煉練錬鍊]),
					result  => q(neru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妎妒妬媔媢嫉猜]),
					result  => q(netamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閨),
					result  => q(neya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鼠鼡]),
					result  => q(nezumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楨楰]),
					result  => q(nezumimochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(棝),
					result  => q(nezumiotoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(荷),
					result  => q(ni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮸),
					result  => q(nibe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嬯釰鈍鈯銖駑]),
					result  => q(nibui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([贄錵]),
					result  => q(nie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苦酓鹶]),
					result  => q(nigai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(荼),
					result  => q(nigana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([迯逃]),
					result  => q(nigeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柲),
					result  => q(nigiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(握),
					result  => q(nigiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賑),
					result  => q(nigiwau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮩),
					result  => q(nigoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(醪),
					result  => q(nigoriza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([涹淟淰渾溷濁]),
					result  => q(nigoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(淈),
					result  => q(nigosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(极),
					result  => q(nigura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蛥),
					result  => q(niiniizemi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([虹蝃霓]),
					result  => q(niji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卄廿]),
					result  => q(nijuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(膠),
					result  => q(nikawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彿),
					result  => q(nikayou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([皰靤]),
					result  => q(nikibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([朒腅]),
					result  => q(niku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垐憎懀魗]),
					result  => q(nikumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蜷螄螺]),
					result  => q(nina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儋担擔]),
					result  => q(ninau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蔘薓]),
					result  => q(ninjin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葫),
					result  => q(ninniku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鳰),
					result  => q(nio),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殠馛]),
					result  => q(nioi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幐),
					result  => q(nioibukuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匂胺]),
					result  => q(niou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([韭韮]),
					result  => q(nira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(淬),
					result  => q(niragu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([盻眈睨矉]),
					result  => q(niramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楡榆]),
					result  => q(nire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齝),
					result  => q(niregamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([似俏湘烹煑煮燖肖胹飪餁饔鬺]),
					result  => q(niru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(贋),
					result  => q(nise),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(西),
					result  => q(nishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蠁),
					result  => q(nishidochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(錦),
					result  => q(nishiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蚦),
					result  => q(nishikihebi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鯡鰊鰜]),
					result  => q(nishin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([庭廷]),
					result  => q(niwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俄劦卆卒忩怱悤猝遽霍]),
					result  => q(niwaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(涷),
					result  => q(niwakaame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(勃),
					result  => q(niwakani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瀑),
					result  => q(niwakaume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(潦),
					result  => q(niwatazumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([雞鳮鶏鷄]),
					result  => q(niwatori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薁),
					result  => q(niwaume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(萹),
					result  => q(niwayanagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(棣),
					result  => q(niwazakura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兮埜壄野]),
					result  => q(no),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([廴捵衦]),
					result  => q(nobasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偱掞摴攄演舒述]),
					result  => q(noberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(燹),
					result  => q(nobi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伸延暢洩畼鬯]),
					result  => q(nobiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(僋),
					result  => q(nobirusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幟),
					result  => q(nobori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([徏斘昇曻歊登竎襄躋陞陟隮隲騰]),
					result  => q(noboru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(抻),
					result  => q(nobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吭咽喉嗌嗓噲嚨胭臙頏]),
					result  => q(nodo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鴇),
					result  => q(nogan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佚逋逭遁遯]),
					result  => q(nogareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葙),
					result  => q(nogeitou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秒芒]),
					result  => q(nogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕒),
					result  => q(nokeshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宇宸樀軒]),
					result  => q(noki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牔),
					result  => q(nokiita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鋸錡]),
					result  => q(nokogiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銊),
					result  => q(nokogirinooto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([残殘]),
					result  => q(nokoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(遺),
					result  => q(nokosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蚤銶鐫鑿]),
					result  => q(nomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釂),
					result  => q(nomihosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梂),
					result  => q(nominosaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吞呑咰哈嚥歠阷飡飮飲]),
					result  => q(nomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傌僽罵訽詈]),
					result  => q(nonoshiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椉),
					result  => q(nooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佱典刑則卞帠式律憲法灋笵範糊詮礼]),
					result  => q(nori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([獐麇麕麞]),
					result  => q(noro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(秼),
					result  => q(norofu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嚩),
					result  => q(noroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([烽煹熢]),
					result  => q(noroshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呪咒祩詛詶譸]),
					result  => q(norou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乗乘宣淩駕騎驀]),
					result  => q(noru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儎搭攱碊載馱駄]),
					result  => q(noseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喃腦]),
					result  => q(nou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(脳),
					result  => q(noumiso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勾除]),
					result  => q(nozoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卬忺望歛涖臨莅覬闞]),
					result  => q(nozomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橳),
					result  => q(nude),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鵺鵼]),
					result  => q(nue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([脫脱褪駘]),
					result  => q(nugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幯),
					result  => q(nuguhu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([拭揩撇]),
					result  => q(nuguu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(緎),
					result  => q(nuikagiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([綉繍繡]),
					result  => q(nuitori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([穅粇糠糩]),
					result  => q(nuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(粏),
					result  => q(nukamiso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垬),
					result  => q(nukari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倥濘]),
					result  => q(nukaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頓),
					result  => q(nukazuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛻蜕]),
					result  => q(nukegara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蹐),
					result  => q(nukiashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擢),
					result  => q(nukinderu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([扎扒抜抽拔挺揠楕繹]),
					result  => q(nuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(沼),
					result  => q(numa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纊),
					result  => q(nume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蒓蓲蓴]),
					result  => q(nunawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([布幊幛絧緦]),
					result  => q(nuno),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纑),
					result  => q(nunoito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([褐褞褹]),
					result  => q(nunoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鈓需]),
					result  => q(nureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埿堇塈塓塗墍墐搠]),
					result  => q(nuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([洏涗涚]),
					result  => q(nurumayu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幣),
					result  => q(nusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(主),
					result  => q(nushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([睇睊睒瞧]),
					result  => q(nusumimiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偷偸盗盜窃竊]),
					result  => q(nusumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垈),
					result  => q(nuta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([摓緙縫黹]),
					result  => q(nuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(獶),
					result  => q(nyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尾嵨洿瑦緒緖螉螐鄔]),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姨),
					result  => q(oba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([带帯帶緄褵]),
					result  => q(obi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佩珮]),
					result  => q(obidama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐍),
					result  => q(obidome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哼寎寣怯]),
					result  => q(obieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夥),
					result  => q(obitada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(脋),
					result  => q(obiyaakasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劫愶]),
					result  => q(obiyakasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([憶覚覺]),
					result  => q(oboeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(覐),
					result  => q(obooeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([湎溺闝]),
					result  => q(oboreru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([曨朦朧]),
					result  => q(oboro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刧剽脅]),
					result  => q(obyakasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蘀),
					result  => q(ochiba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墊陥陷]),
					result  => q(ochiiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉿),
					result  => q(ochikomuoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墜磒落襰陏隋隕隤零鬌]),
					result  => q(ochiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儰),
					result  => q(ochitsukanu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([廮闟]),
					result  => q(ochitsuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([怗稳穏穩]),
					result  => q(odayaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(矍),
					result  => q(odoroki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傽咢啐忪愕戃戄駭駴驚]),
					result  => q(odoroku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([趟踉踊踴躍]),
					result  => q(odoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縅),
					result  => q(odoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吓嗋嚇威]),
					result  => q(odosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([拜拝]),
					result  => q(ogamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([濚瀅瀯]),
					result  => q(ogawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([荻菼萑蒹蔐]),
					result  => q(ogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([補裨靪]),
					result  => q(oginau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(匎),
					result  => q(ogoranai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夋),
					result  => q(ogoriiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伳侈侉倨傏傲僣僭夸奢媻怚慠驁驕]),
					result  => q(ogoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姱),
					result  => q(ogorusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儼荘莊]),
					result  => q(ogosoka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(噩),
					result  => q(ogosokanasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弙),
					result  => q(ohatsutenerafu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([羘羝]),
					result  => q(ohitsuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鑡),
					result  => q(ohoban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([幠幭]),
					result  => q(ohohi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廕),
					result  => q(ohohu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([甥笈]),
					result  => q(oi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吂耄]),
					result  => q(oiboreru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([老耆-耉]),
					result  => q(oiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(馺),
					result  => q(oitsuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(刦),
					result  => q(oiyakasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(叔),
					result  => q(oji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麌),
					result  => q(ojika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丘丠坏坯坵堁壣岡崗邱阜陸]),
					result  => q(oka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侵倰冐冒奸敯犯]),
					result  => q(okasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(桶),
					result  => q(oke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冲沖澚]),
					result  => q(oki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傁叟翁]),
					result  => q(okina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(起),
					result  => q(okiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(掟),
					result  => q(okite),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(埇),
					result  => q(okitsuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([痁痎瘧]),
					result  => q(okori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噁嫳浡興艴]),
					result  => q(okoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粰糤饊馓]),
					result  => q(okoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(慉),
					result  => q(okosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伿倯儽冘媷嬾怠惰慢懈懶]),
					result  => q(okotaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰧),
					result  => q(okoze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奥奧寘嶴措擱置]),
					result  => q(oku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([賾邃]),
					result  => q(okubukai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(窵),
					result  => q(okuhukai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袵),
					result  => q(okumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夂後]),
					result  => q(okureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(餼),
					result  => q(okurimono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([諡謚]),
					result  => q(okurina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([媵貽賵贈輸送餫餽饁饋]),
					result  => q(okuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([稺穜]),
					result  => q(okute),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(楲),
					result  => q(omaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(臣),
					result  => q(omi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([面靣]),
					result  => q(omo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(藚),
					result  => q(omodaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([羇羈覉覊鍚靻鞚]),
					result  => q(omogai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倕重騺驇]),
					result  => q(omoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(俤),
					result  => q(omokage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(趣),
					result  => q(omomuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(赴),
					result  => q(omomuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([徐邌]),
					result  => q(omomuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佞侫]),
					result  => q(omoneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(慮),
					result  => q(omonpaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(恖),
					result  => q(omoou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([権權]),
					result  => q(omori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(表),
					result  => q(omote),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([以侖念思怤恁悕惟想懯諰]),
					result  => q(omou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壈御蒽轀]),
					result  => q(on),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(禺),
					result  => q(onagasaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仝同詷]),
					result  => q(onaji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葹),
					result  => q(onamomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([祙鬼魕]),
					result  => q(oni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(燐),
					result  => q(onibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菪),
					result  => q(onihirugusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儺),
					result  => q(oniyarai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([女娪]),
					result  => q(onna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(孁),
					result  => q(onnanoazana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([斤斧鈇錍]),
					result  => q(ono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(各),
					result  => q(onoono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(己),
					result  => q(onore),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蚍),
					result  => q(ooari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薘),
					result  => q(oobako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉼),
					result  => q(ooban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(軱),
					result  => q(oobone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(櫓),
					result  => q(oodate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([釤鬵]),
					result  => q(oogama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鰲鼇]),
					result  => q(oogame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鑮),
					result  => q(oogane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(唪),
					result  => q(oogoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瑟),
					result  => q(oogoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜃),
					result  => q(oohamaguri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈹),
					result  => q(oohari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髥),
					result  => q(oohige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([众傇冪多夡庰溱甧眾笰羃苠藹衆輨閦陾駪鬒]),
					result  => q(ooi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(侜),
					result  => q(ooikakusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祁),
					result  => q(ooini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(伾),
					result  => q(ooisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鉊),
					result  => q(ookama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([狼猲獦]),
					result  => q(ookami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丕佬侾俁倬傀厖哆嚭大夿奃奆奕奜奝奯奲巨昄晊汾瑰碩頇頡頵顒]),
					result  => q(ookii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(顢),
					result  => q(ookinakao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(吧),
					result  => q(ookuchinosama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(潡),
					result  => q(oomizu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鮧),
					result  => q(oonamazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(澇),
					result  => q(oonami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茘荔]),
					result  => q(oonira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鏓),
					result  => q(oonome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鍯),
					result  => q(oonomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(紳),
					result  => q(ooobi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夅),
					result  => q(ooriru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([麃麅麖]),
					result  => q(ooshika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葒),
					result  => q(ootade),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凰鳯鳳鴻鵬鷟]),
					result  => q(ootori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鼖鼛]),
					result  => q(ootsuzumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冖冡剦奄帡帲幂幕庇弇掩搒盍蒙蔽藾襾覆]),
					result  => q(oou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輮),
					result  => q(oowa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伀公]),
					result  => q(ooyake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鷮),
					result  => q(ooyamadori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(盤),
					result  => q(oozara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([玃蠼貜]),
					result  => q(oozaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紘纮]),
					result  => q(oozuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([熕砲]),
					result  => q(oozutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(俺),
					result  => q(ore),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柆),
					result  => q(oretaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垽柙槞檻渣滓澱牿苙阺]),
					result  => q(ori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(繢),
					result  => q(oriamari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(降),
					result  => q(oriru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侗呆唭婄怐惛愗愚憃憨懝戇獃疙痬痴瘒癡騃魯]),
					result  => q(oroka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(孈),
					result  => q(orokadeshinaotsukuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佁倲]),
					result  => q(orokanasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(颪),
					result  => q(oroshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卸缷]),
					result  => q(orosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凥処抈折攦綑織]),
					result  => q(oru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伯佰尹筬簆酋]),
					result  => q(osa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([制压圧壓尉扼抑按撙撳擪熨]),
					result  => q(osaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乿俢修僌厤収庀弆戢摂撩攝收敒斂殮治略畧紀納脩芖釐]),
					result  => q(osameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([幼种稚穉齔]),
					result  => q(osanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儑),
					result  => q(osatsukanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啕喦]),
					result  => q(oshaberi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唖啞喑瘂瘖]),
					result  => q(oshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴦鶒鸂]),
					result  => q(oshidori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([徳德]),
					result  => q(oshie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([敎教敩斅斆訓誨譔]),
					result  => q(oshieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(億),
					result  => q(oshihakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(排),
					result  => q(oshihiraku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(惜),
					result  => q(oshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魴鯿]),
					result  => q(oshikiuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(褓),
					result  => q(oshime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吝啚嗇恡慳]),
					result  => q(oshimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喢嗑]),
					result  => q(oshiyaberi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(謰),
					result  => q(oshiyabiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([晏遅遟遲]),
					result  => q(osoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(虞),
					result  => q(osore),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佂怔]),
					result  => q(osoreawateru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伈侙兇兢咺嘵忷怕怵恐恗恟恾悎悑悚悸惧惴惶慄慞慴懍懔懼懾畏虩讋龖]),
					result  => q(osoreru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襲),
					result  => q(osou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(魘),
					result  => q(osowareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([押捺捼推擠攮牡雄]),
					result  => q(osu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銤),
					result  => q(osumiumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(豭),
					result  => q(osunoinoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(騭),
					result  => q(osuuma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([耹音]),
					result  => q(oto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([頉頤顄顊]),
					result  => q(otogai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侽男郎郒郞]),
					result  => q(otoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侠俠]),
					result  => q(otokodate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(侹),
					result  => q(otokogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔚),
					result  => q(otokoyomoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仛奼嫭嫮]),
					result  => q(otome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(囮),
					result  => q(otori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(衰),
					result  => q(otoroeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(劣),
					result  => q(otoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([穽臽]),
					result  => q(otoshiana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([挼磓礌貶]),
					result  => q(otosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弟),
					result  => q(otouto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(訪),
					result  => q(otozureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殟淴腽膃]),
					result  => q(otsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(僐),
					result  => q(otsukurisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夫),
					result  => q(otto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圔曱泱滃瀇狕猇砵罃蘡負趁趕跴軮追逐鸚]),
					result  => q(ou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(舶),
					result  => q(oubune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楝樗欒]),
					result  => q(ouchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疸),
					result  => q(oudan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([扇箑衮袞]),
					result  => q(ougi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朸),
					result  => q(ougo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(逵),
					result  => q(ouji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麈),
					result  => q(oujika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蘢),
					result  => q(ouketade),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(洪),
					result  => q(oumizu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([媪媼嫗]),
					result  => q(ouna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夛牨牯特]),
					result  => q(oushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([了傮儅竟竣終訖]),
					result  => q(owaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕖),
					result  => q(oyaimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([拇胲]),
					result  => q(oyayubi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([及暨曁趙迄逮隶]),
					result  => q(oyobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泅泳游]),
					result  => q(oyogu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(氿),
					result  => q(ozumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嫇),
					result  => q(ozuozutosuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(磅),
					result  => q(pondo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([玀腡鏍]),
					result  => q(ra),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([馲駃騾驝]),
					result  => q(raba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(啦),
					result  => q(rahu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俫倈壨崍檑淶磊礧騋鵣鶆]),
					result  => q(rai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銧),
					result  => q(rajuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([薤藠]),
					result  => q(rakkyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峈珞硌鵅]),
					result  => q(raku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圞欖瓓繿襽钄鸞]),
					result  => q(ran),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鑭),
					result  => q(rantaniumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垃溂鬎]),
					result  => q(ratsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(僗),
					result  => q(rau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厉囹坽岭岺廲彾昤柃櫔欞澧玲瓈禮蛉蛠酃醽霝鴒鸰]),
					result  => q(rei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儮嚦磿藶蚸靂]),
					result  => q(reki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嗹堜嬚浰蠊]),
					result  => q(ren),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薥),
					result  => q(rengetsutsuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(櫺),
					result  => q(renji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咧哷蛚鋝]),
					result  => q(retsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(灬),
					result  => q(retsuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嘹),
					result  => q(reu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喱嚟悧氂璃艃酈鬁鸝]),
					result  => q(ri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鋰),
					result  => q(richuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坴淕磟]),
					result  => q(riku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圇嶙斴棆琳璘粦麟]),
					result  => q(rin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傈溧箻篥]),
					result  => q(ritsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(忄),
					result  => q(ritsushinben),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(刂),
					result  => q(ritsutou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([媹嵧廇]),
					result  => q(riu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嚧潞瀘璐瓐粐絽虂魲]),
					result  => q(ro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(錴),
					result  => q(rojuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叻嘞扐氻濼碌簶阞]),
					result  => q(roku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([樚鏇]),
					result  => q(rokuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([崘崙]),
					result  => q(ron),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垏),
					result  => q(rotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偻劳咔嗡壠嫏栳桹棱榔樃爉琅瑯瓏硠磖簍耬耮膢臈臘蕯薐蜋螂豅鋃鏧镴閬髏]),
					result  => q(rou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(漊),
					result  => q(ru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嫘瘰]),
					result  => q(rui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癧),
					result  => q(ruireki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(壚),
					result  => q(rurori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堨壩]),
					result  => q(ruseki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(堝),
					result  => q(rutsubo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([穭藘郘]),
					result  => q(ryo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([逯騄]),
					result  => q(ryoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儠唡啢屪崚嶚嶛憀漻錂鷯]),
					result  => q(ryou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([岦嶐泵琉瑠璢籕翏蟉遛鉝鏐镠霳鰡]),
					result  => q(ryuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仨傞傻儍嗏嗦嗩嵖汊溠痄矬粆肞裟褨醡銟鎈髿]),
					result  => q(sa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮄鯖]),
					result  => q(saba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儸劾捌讞]),
					result  => q(sabaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鉎銹鏽]),
					result  => q(sabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伵寂寞寥淋]),
					result  => q(sabishii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(娿),
					result  => q(sadamaranai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(定),
					result  => q(sadameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嗻峺攔迣迾遮]),
					result  => q(saegiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吵哢囀]),
					result  => q(saezuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(性),
					result  => q(saga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([捜搜]),
					result  => q(sagasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(提),
					result  => q(sageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔑),
					result  => q(sagesumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴼鷺]),
					result  => q(sagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([抺探摸詗]),
					result  => q(saguru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(庢),
					result  => q(sahegiritodomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(卡),
					result  => q(sahu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傤凗哸喍埼墔嶵犀璀睬穝紣綷縗蕞衩鞖骰]),
					result  => q(sai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梍),
					result  => q(saikachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(仯),
					result  => q(saisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倖嘏幸烋礽祉祚祜祥祹祺祿禎福禑禔禧祥福]),
					result  => q(saiwai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匕匙枇柶]),
					result  => q(saji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坂阤阪]),
					result  => q(saka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐖),
					result  => q(sakabari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([榼櫑罍罏]),
					result  => q(sakadaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栄榮]),
					result  => q(sakaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埸墈]),
					result  => q(sakahi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圻坫垠域堺境封界畍畤畺疅疆]),
					result  => q(sakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榊),
					result  => q(sakaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峛嶝]),
					result  => q(sakamichi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([醵醼]),
					result  => q(sakamori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侊傓壮壯奘奭屭弉旺昌殷氲氳熀熾燁爗芃芣闐韡]),
					result  => q(sakan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(肴),
					result  => q(sakana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儦暿]),
					result  => q(sakannasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泝洄溯遡]),
					result  => q(sakanoboru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(魫),
					result  => q(sakanonoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啎夆屰忤忮牾逆]),
					result  => q(sakarau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(傎),
					result  => q(sakasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(譞),
					result  => q(sakashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈁),
					result  => q(sakatsubo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卮卺巵杯桮爵盃盞觗觚觴觶醆醘鍾鎐锺]),
					result  => q(sakazuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([酒鱖]),
					result  => q(sake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帘),
					result  => q(sakebata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叫号喊嘄嘑嘖嚆嚝號諕譹趯]),
					result  => q(sakebu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銒),
					result  => q(sakeine),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([酛酴酶]),
					result  => q(sakenomoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嘂坼擋爆迂避]),
					result  => q(sakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(糦),
					result  => q(sakesakana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(卣),
					result  => q(saketsubo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([㟢先崎曩﨑𥔎]),
					result  => q(saki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蹕),
					result  => q(sakibarai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(曏),
					result  => q(sakini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(逧),
					result  => q(sako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刐刕刢剅剮劈劐咲嘀岝撕撦擘析瞔磔葪薾蚱裂]),
					result  => q(saku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桜櫻]),
					result  => q(sakura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([態様樣]),
					result  => q(sama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丂),
					result  => q(samatagerareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妨碍礙]),
					result  => q(samatageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仿佪俍婓彷徉徊徘徜徨逍]),
					result  => q(samayou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魦鮫鮻鱁]),
					result  => q(same),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寤醒]),
					result  => q(sameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髴),
					result  => q(samonitari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冼冽凄凊凒凔凛凜寒泂淒滄澟]),
					result  => q(samui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(凓),
					result  => q(samuisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瘮),
					result  => q(samuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侍士]),
					result  => q(samurai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偺匴嵼巉巑昝欃殩滻潸潺濽狻珊璨瓉瓚舢轏鐕鬖]),
					result  => q(san),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([絛縧]),
					result  => q(sanada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髣),
					result  => q(sanagara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蛹),
					result  => q(sanagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(核),
					result  => q(sane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(卅),
					result  => q(sanjuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丯),
					result  => q(sanransuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯢),
					result  => q(sanshouuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(氵),
					result  => q(sanzui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([棹竿篙]),
					result  => q(sao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([划找]),
					result  => q(saosasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([更皿]),
					result  => q(sara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓼),
					result  => q(sarake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([晒晾曝曬]),
					result  => q(sarasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([浚渫濬]),
					result  => q(sarau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丟丢厺去朅猨猱猴猻猿獼蜼遰]),
					result  => q(saru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笹),
					result  => q(sasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(挶),
					result  => q(sasae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(厔),
					result  => q(sasaerareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([搘搙撐撑支漳]),
					result  => q(sasaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(豇),
					result  => q(sasage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([廾捧擎]),
					result  => q(sasageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鴂),
					result  => q(sasagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([筅箲簓]),
					result  => q(sasara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呤),
					result  => q(sasayaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吺咠噥囁耾聶]),
					result  => q(sasayaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(矩),
					result  => q(sashigane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縉),
					result  => q(sashihasamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扜),
					result  => q(sashimaneku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(敔),
					result  => q(sashitomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(麾),
					result  => q(sashizuba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(唀),
					result  => q(sasoou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蝲蠍]),
					result  => q(sasori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哘誀誘]),
					result  => q(sasou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倳刲刺剚劄差戳扠挃挿掙插揷擉攙箚蜇螫蠚鈌]),
					result  => q(sasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偖扨]),
					result  => q(sate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埡郷鄉鄕里閈]),
					result  => q(sato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倢勄啠嶷怜恔愰慧憭懏聡聦聰詇詝諝黠]),
					result  => q(satoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諬),
					result  => q(satoosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([忢悟惺憬]),
					result  => q(satoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喩喻泠諭]),
					result  => q(satosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔗),
					result  => q(satoukibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([巀鍘]),
					result  => q(satsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芫),
					result  => q(satsumafuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([塽崝嶆]),
					result  => q(sau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([孇汧沛沢澤皋皐睾隰]),
					result  => q(sawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唕閙鬧]),
					result  => q(sawagashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喳喿噪譟躁騒騷]),
					result  => q(sawagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(啈),
					result  => q(sawagukoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([葚鰆]),
					result  => q(sawara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(障),
					result  => q(sawaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苻莢袟鞘鞞]),
					result  => q(saya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱵),
					result  => q(sayori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鷦),
					result  => q(sazaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(漣),
					result  => q(sazanami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嘸),
					result  => q(sazo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(授),
					result  => q(sazukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吔瀨瀬灘畆畒畝畞背脊]),
					result  => q(se),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吕呂膂膐]),
					result  => q(sebone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伜倅忰躮]),
					result  => q(segare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(崨),
					result  => q(sehu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([势卤卥垶埥墭峸嵗彁泲淛渻狾猘瑆甠眚硒箐箵篂荿萋蠐裞郕鋮靚鼱]),
					result  => q(sei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(醎),
					result  => q(seishiyu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咳唽埭堰庴椻欬碵膌蜥襫鉐関闗關鶺鹡]),
					result  => q(seki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(謦),
					result  => q(sekibarai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([戹狭狹窄笮褊陋陜陿隘]),
					result  => q(semai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偪劸勥奰拶筰蹙迫逎逼遒齪齱]),
					result  => q(semaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鬩),
					result  => q(semegu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呰攻誚誶謫譴責]),
					result  => q(semeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蜩蝉蟬]),
					result  => q(semi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(攖),
					result  => q(semuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佝痀瘻軁駝駞]),
					result  => q(semushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佺侟墠奷奾姾媊屳幝枘栴梘棈氙渲澶灊狝瑄璇璿籑綪腺薝蟤詹谸軐輇鄯鐉陝騸鬋鰁鱄]),
					result  => q(sen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(甅),
					result  => q(senchigura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(糎),
					result  => q(senchimeeto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竰),
					result  => q(senchiritto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(胰),
					result  => q(seniku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([疝痳]),
					result  => q(senki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(藭),
					result  => q(senkiyuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(仙),
					result  => q(sennin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(栓),
					result  => q(sennoki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯪),
					result  => q(senzankou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(揹),
					result  => q(seou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([斳芹]),
					result  => q(seri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鍶),
					result  => q(seryuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(粼),
					result  => q(seseragi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銫),
					result  => q(seshuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卨嚽岊榍蕝蠘蠞]),
					result  => q(setsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(憋),
					result  => q(setsukachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([崵嶕]),
					result  => q(seu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(甹),
					result  => q(sewashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(不),
					result  => q(sezu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佘厙嫬猞硨賒鷓麝]),
					result  => q(sha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呭哠喋訯]),
					result  => q(shaberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯱),
					result  => q(shachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鴣),
					result  => q(shako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勺婼癪笏]),
					result  => q(shaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嗝噦]),
					result  => q(shakuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鵾),
					result  => q(shamo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嶈廧]),
					result  => q(shau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兕凘厜呲壐妛媤嬨宩峕崼庛旘淄湽溮濨禩秭籽糍胏胔蓰螅螆褆訑趑鉰鍿饎駟鳷]),
					result  => q(shi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柴樕芝]),
					result  => q(shiba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(暫),
					result  => q(shibaraku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([累綁縛縲]),
					result  => q(shibaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屡屢遄]),
					result  => q(shibashiba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蕊蕋蘂]),
					result  => q(shibe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([痲痹痺癱]),
					result  => q(shibireru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凋蔫]),
					result  => q(shibomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纈),
					result  => q(shibori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榨),
					result  => q(shiboriki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(搾),
					result  => q(shiboru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(歮),
					result  => q(shibu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([渋澀澁]),
					result  => q(shibui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蓚),
					result  => q(shibukusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儊歰瀒]),
					result  => q(shiburu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椣),
					result  => q(shide),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(棰),
					result  => q(shie),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笧),
					result  => q(shigaramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兹岶枎橆欉欝滋玆秞稠稫稹穙穠箼芊茂茬茲茷茸葏蕃蕡蕻薈薋蘙蘛鬰鬱]),
					result  => q(shigeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宻密縟繁]),
					result  => q(shigeshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴫鷸]),
					result  => q(shigi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薿),
					result  => q(shigiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誷),
					result  => q(shihiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(酫),
					result  => q(shihozuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嶍),
					result  => q(shihu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(桘),
					result  => q(shii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秕粃]),
					result  => q(shiina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鱪鱰]),
					result  => q(shiira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([慂誣譄]),
					result  => q(shiiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弑弒]),
					result  => q(shiisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(虐),
					result  => q(shiitageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(虣),
					result  => q(shiitagiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜆),
					result  => q(shijimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鹿𢈘]),
					result  => q(shika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尸屍]),
					result  => q(shikabane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(顰),
					result  => q(shikameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俞兪尒]),
					result  => q(shikari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呾),
					result  => q(shikariau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叱呧呵咄咜咤哬啌喝喥訶譙]),
					result  => q(shikaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(聢),
					result  => q(shikato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(甃),
					result  => q(shikigawara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閾),
					result  => q(shikii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([梱梻橉軾閫闑]),
					result  => q(shikimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閑),
					result  => q(shikiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([荐頻]),
					result  => q(shikirini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屧),
					result  => q(shikiwara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嫫),
					result  => q(shikome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癥),
					result  => q(shikori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([錏錣鐚铔]),
					result  => q(shikoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(而),
					result  => q(shikoushite),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尃摛敷舗藉譒鋪]),
					result  => q(shiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([島嶋嶌嶹嶼洲陼隝隯]),
					result  => q(shima),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宲),
					result  => q(shimaikomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(締),
					result  => q(shimaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乄鴲]),
					result  => q(shime),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([占湿濕絞閡]),
					result  => q(shimeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呈示]),
					result  => q(shimesu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礻),
					result  => q(shimesuhen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟫),
					result  => q(shimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(灕),
					result  => q(shimikomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([沁渗滲]),
					result  => q(shimiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湃),
					result  => q(shimiwataru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丅霜]),
					result  => q(shimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僕皁閹隷隸]),
					result  => q(shimobe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痔),
					result  => q(shimogasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瘃),
					result  => q(shimoyake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(墅),
					result  => q(shimoyashiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(俾),
					result  => q(shimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伔侺儬吣唚埐妽姺嫀嬧嬸孞屾峷嵾嶜幓槮溍澵珅瑨璡甡眕砷祲秦聄茞莀莘葠轃邥鄩鉮駸骎鮼鵢麎]),
					result  => q(shin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([品科級𠯮]),
					result  => q(shina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偠娜裊靭靱韌]),
					result  => q(shinayaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(婠),
					result  => q(shinayoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(檫),
					result  => q(shinbashira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(軸),
					result  => q(shingi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(殑),
					result  => q(shinikakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([辵辶]),
					result  => q(shinnyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([筱筿篠簳蓧]),
					result  => q(shino),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誄),
					result  => q(shinobigo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偲忍荵]),
					result  => q(shinobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([箘箟]),
					result  => q(shinodake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凌夌]),
					result  => q(shinogu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(籡),
					result  => q(shinshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(雘),
					result  => q(shinshiya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([死歾歿殁殂殞]),
					result  => q(shinu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([塩汐潮鹵鹺鹽𪉩]),
					result  => q(shio),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(滷),
					result  => q(shiochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(醢),
					result  => q(shiokara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鹹),
					result  => q(shiokarai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鹻),
					result  => q(shioke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(栞),
					result  => q(shiori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(腌),
					result  => q(shiozuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([查査検檢覈]),
					result  => q(shiraberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諊),
					result  => q(shirabiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粺精粿精]),
					result  => q(shirageyone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([駓驃]),
					result  => q(shirakage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([虱蝨蟣]),
					result  => q(shirami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鷥),
					result  => q(shirasagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(訃),
					result  => q(shirase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(報),
					result  => q(shiraseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尻臀臋骶]),
					result  => q(shiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紂鞦]),
					result  => q(shirigai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([擯斥黜]),
					result  => q(shirizokeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([却卻屏屛踆退逡]),
					result  => q(shirizoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([城白]),
					result  => q(shiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(螱),
					result  => q(shiroari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([璙銀鋈鐐]),
					result  => q(shirogane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紈素縞縳]),
					result  => q(shiroginu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([皎皙皚皠皢皦皪皭顥顴]),
					result  => q(shiroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(盰),
					result  => q(shirome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(潘),
					result  => q(shiromizu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堊墡]),
					result  => q(shirotsuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([葧蘩]),
					result  => q(shiroyomogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([察汁液瀋知糔識]),
					result  => q(shiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([印幖徴徵瑞璽症讖騐験]),
					result  => q(shirushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([記誌譜銘錄録]),
					result  => q(shirusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宍獅肉]),
					result  => q(shishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(繪),
					result  => q(shishuumoyo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([下埝簧舌]),
					result  => q(shita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襗),
					result  => q(shitabakama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([从倭傔叒啝巹従從循扈拼殉繇跰遵陪随隨]),
					result  => q(shitagau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([裋襳]),
					result  => q(shitagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(韉),
					result  => q(shitagura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(氺),
					result  => q(shitamizu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寴親]),
					result  => q(shitashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(忈),
					result  => q(shitashimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([淌溜滴澑瀝]),
					result  => q(shitataru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([孌慕]),
					result  => q(shitau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔀),
					result  => q(shitomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茵蓐褥]),
					result  => q(shitone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([婳嫕嫿頠]),
					result  => q(shitoyaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姽),
					result  => q(shitoyakanisusumusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厀蟋]),
					result  => q(shitsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(躾),
					result  => q(shitsuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([崷嶯]),
					result  => q(shiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嫜),
					result  => q(shiuto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(皺),
					result  => q(shiwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詍),
					result  => q(shiyabiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(狌),
					result  => q(shiyoujiyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(絑),
					result  => q(shiyu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(茼),
					result  => q(shiyungiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葰),
					result  => q(shiyuuga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侐嗼嘿妌妰姶謐閴闃静靜]),
					result  => q(shizuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彵),
					result  => q(shizukaniyuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([涓雫]),
					result  => q(shizuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鎭鎮]),
					result  => q(shizumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([搵汨沈沒没洇淪湮]),
					result  => q(shizumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(沉),
					result  => q(shizuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刞垿墸癙稰蜍趄]),
					result  => q(sho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嬂崱庂戠溭瘜禝聀臅荗軄]),
					result  => q(shoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仉埫堘塖墒妐妱姠嫞尙尰嵊嵷嶒徢扄昮晿暲橸淞澠灄焻玿瑲瘴硝穕艢芀蔏蜙蜨螿蟭邵鄣鏘閶鞢顳鱂]),
					result  => q(shou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菖),
					result  => q(shoubu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埾宔棕椶橾洙硃腧馵]),
					result  => q(shu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嗖),
					result  => q(shuhu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倐喌婌柷蓿蹜驌鷫]),
					result  => q(shuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(郵),
					result  => q(shukuba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墫峋暙畯盹郇錞鵔]),
					result  => q(shun),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(駬),
					result  => q(shunme),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([摔甩蒁]),
					result  => q(shutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偮唒啃团娀媝峀崈拫搊犨琇緅茺蓻螋譅輖郰鄹鏥駲齺𧰧]),
					result  => q(shuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(舅),
					result  => q(shuuto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姑),
					result  => q(shuutome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嗉囎媎嫊蒩]),
					result  => q(so),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埈屹峙崛崧崫嶟欹陡]),
					result  => q(sobadatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嬙),
					result  => q(sobame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嵑聳]),
					result  => q(sobieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屴),
					result  => q(sobierusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(洓),
					result  => q(sobouru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([毓育]),
					result  => q(sodateru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([袖袪褎褏襼]),
					result  => q(sode),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(褾),
					result  => q(sodekuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儲),
					result  => q(soe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梜),
					result  => q(soeita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([添簉]),
					result  => q(soeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([駙騑驂]),
					result  => q(soeuma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枌),
					result  => q(sogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(簺),
					result  => q(sogo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竻),
					result  => q(soji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([底椢]),
					result  => q(soko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仠劌害惎戔戝損毒蠱豙賊]),
					result  => q(sokonau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([畟蝍觫]),
					result  => q(soku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([芨蒴]),
					result  => q(sokuzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(杣),
					result  => q(soma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橧),
					result  => q(somai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([抐染涅]),
					result  => q(someru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倍傠僢叛癶舛踳]),
					result  => q(somuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噀蓀]),
					result  => q(son),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([供偹備僃僎僝具餚饌龔]),
					result  => q(sonaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丌其厥囿園苑菀薗]),
					result  => q(sono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蔶),
					result  => q(sonoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宆宙昊昦穹霄]),
					result  => q(sora),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([諳諷]),
					result  => q(soranjiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(某),
					result  => q(soregashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(非),
					result  => q(soreru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([橇艝轌]),
					result  => q(sori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弨),
					result  => q(sorikaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(筭),
					result  => q(soroban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([剤劑砡]),
					result  => q(soroeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偡),
					result  => q(sorotsutesusumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亝揃斉齊]),
					result  => q(sorou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偨畽篸]),
					result  => q(sorowanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([剃反髠鬀]),
					result  => q(soru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釮),
					result  => q(sorudoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倃吡訕詆誹誻謗譏譖譛讒讕]),
					result  => q(soshiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([汛沃注洎淙溉漑潅澆濺瀉灌灑盥酹]),
					result  => q(sosogu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唆嗾]),
					result  => q(sosonokasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(外),
					result  => q(soto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(堭),
					result  => q(sotobori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(槨),
					result  => q(sotohitsugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(窣),
					result  => q(sotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倧副啑婃孮崢嵕嵢愡憁楤楱沿焋猙獊琤琮璁璅甴矰篵罾艙艭螬銺錝鍐骔]),
					result  => q(sou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笽),
					result  => q(souke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(候),
					result  => q(sourou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(颭),
					result  => q(soyogu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([州巣潬犓窠簀酢醋醦醯醶釅鬆]),
					result  => q(su),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(昴),
					result  => q(subaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯐),
					result  => q(subashiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嬐耍趫]),
					result  => q(subayai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(揔),
					result  => q(sube),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([統綜辷]),
					result  => q(suberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凡-凣摠]),
					result  => q(subete),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(緫),
					result  => q(subite),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(佽),
					result  => q(suboshikoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魈魑]),
					result  => q(sudama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([箔簾]),
					result  => q(sudare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(已),
					result  => q(sudeni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([季末甄陶]),
					result  => q(sue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([据饐]),
					result  => q(sueru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(眇),
					result  => q(sugame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(縋),
					result  => q(sugaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姿),
					result  => q(sugata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菅),
					result  => q(suge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杉杦柀椙榅榲檆]),
					result  => q(sugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宕軼逿過]),
					result  => q(sugiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(簙),
					result  => q(sugoroku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枰),
					result  => q(sugorokuban),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俊倜偙傑儁儻卓杰雋駿]),
					result  => q(sugureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嗍),
					result  => q(suhu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([噿嶉嶊巂捘璲璻畾膵臎蟕襚酸]),
					result  => q(sui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夊),
					result  => q(suinyou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([理筋綫線缐脈脉觔]),
					result  => q(suji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([賺贃𨻶]),
					result  => q(sukasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯳),
					result  => q(sukesou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杞杴枱梩槈犁犂耒耜耝鈐鉏鉡鉵銛鋘錤鍤鍬鎒鐱钃铦隙隟]),
					result  => q(suki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([耓耟]),
					result  => q(sukinoha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(毫),
					result  => q(sukoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([健勫]),
					result  => q(sukoyaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(傄),
					result  => q(sukoyakanasama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([耡透]),
					result  => q(suku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(撈),
					result  => q(sukuiage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(汕),
					result  => q(sukuiami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粠粭糘蒅]),
					result  => q(sukumo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蛒蝎]),
					result  => q(sukumomushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勻匀尐少尟尠]),
					result  => q(sukunai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丞匊抔拯掬救氶薩贍]),
					result  => q(sukuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宋),
					result  => q(sumai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([墨炭陬隅]),
					result  => q(sumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菫),
					result  => q(sumire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亟侚寁焏遬]),
					result  => q(sumiyaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(李),
					result  => q(sumomo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([住捿栖棲済澂澄濟]),
					result  => q(sumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([沙砂磠]),
					result  => q(suna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(漁),
					result  => q(sunadoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(漠),
					result  => q(sunahara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([娓悌順]),
					result  => q(sunao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(堧),
					result  => q(sunatsuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乃廼迺]),
					result  => q(sunawachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([脛臑跤踁]),
					result  => q(sune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鱉鼈龞]),
					result  => q(suppon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([娍娗娙]),
					result  => q(suraritoshitemimeyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刷抹摩擂擦擵砑]),
					result  => q(suru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兓剡戜釞銳鋓鋭鋹鏉鏸鑱]),
					result  => q(surudoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯣),
					result  => q(surume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(苆),
					result  => q(susa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鮓鮨鲊]),
					result  => q(sushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([裓裔裾]),
					result  => q(suso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襉),
					result  => q(susonohida),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([炱煤]),
					result  => q(susu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([涑漱酳]),
					result  => q(susugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(躩),
					result  => q(susumanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(劺),
					result  => q(susumehagemasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([享侑儐劷勧勸奨奬惥慫獎羞膳薦饈饍]),
					result  => q(susumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丨乵偂兟冿勪夲夵晉晋暹漸趐逘進餤騤]),
					result  => q(susumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(歔),
					result  => q(susurinaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啜嚃嚵歃]),
					result  => q(susuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([廃廢]),
					result  => q(sutareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偝墽弃拌捐捨撤棄]),
					result  => q(suteru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鎴),
					result  => q(sutoronshuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吮吸呷咂嗽噏欶歙鄒]),
					result  => q(suu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坐座]),
					result  => q(suwaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鈬鈴鈸錫鐸鑞鑾]),
					result  => q(suzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱸),
					result  => q(suzuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([雀鴴]),
					result  => q(suzume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(硯),
					result  => q(suzuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凉涼]),
					result  => q(suzushii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(颸),
					result  => q(suzushiikaze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亸吒咃咫嚲垞埵嶞搽沱沲爹牠田紽軃鰖鴕]),
					result  => q(ta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([束稯]),
					result  => q(taba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(莨),
					result  => q(tabako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紮綳髺鬠]),
					result  => q(tabaneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(餐),
					result  => q(tabemono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(餕),
					result  => q(tabenokoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(噇),
					result  => q(taberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([度旅袜襪韈韤]),
					result  => q(tabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髱),
					result  => q(tabo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誑),
					result  => q(taburakasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帵),
					result  => q(tachiamarinokire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橘),
					result  => q(tachibana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乍倏溘]),
					result  => q(tachimachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彽),
					result  => q(tachimotohoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([裴裵躑]),
					result  => q(tachimotooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(魛),
					result  => q(tachiuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([只唯啻]),
					result  => q(tada),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殨湏爛爤]),
					result  => q(tadareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(但),
					result  => q(tadashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佖佶儨正竌貞鉩靕韙頊頙]),
					result  => q(tadashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(讜),
					result  => q(tadashiikotoba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([揳贗]),
					result  => q(tadashikunai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匡匩擶格董諟]),
					result  => q(tadasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(澼),
					result  => q(tadayoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([汎漂漾潒]),
					result  => q(tadayou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蓼),
					result  => q(tade),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(辿),
					result  => q(tadoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栲玅]),
					result  => q(tae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仔堪絕絶耐]),
					result  => q(taeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椨),
					result  => q(tafu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([笟箍]),
					result  => q(taga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(互),
					result  => q(tagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([逓遞]),
					result  => q(tagaini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鏨),
					result  => q(tagane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咈靠]),
					result  => q(tagau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俋圣垡埩畇畉畊耕耖耠]),
					result  => q(tagayasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([滚滾]),
					result  => q(tagiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伉倫偶匹類]),
					result  => q(tagui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姷),
					result  => q(taguu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(舙),
					result  => q(tahakaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(坢),
					result  => q(tahiraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(娭),
					result  => q(tahomureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叇囆夳弚溙艜蠆邰靆颱魋鮉鯛]),
					result  => q(tai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([玳瑇]),
					result  => q(taimai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([炬燋爝苣]),
					result  => q(taimatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坦平]),
					result  => q(taira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夷),
					result  => q(tairageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(珧),
					result  => q(tairagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圢幵]),
					result  => q(tairaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鷞鷹]),
					result  => q(taka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鐈),
					result  => q(takaashinonabe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(亢),
					result  => q(takaburu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堂楼樓龐]),
					result  => q(takadono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僑兀卲喬堯尭岌峻崇嵟嵩嵬嵺嶫巍慸敞肦軇陮高髙髜魏兀]),
					result  => q(takai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竨),
					result  => q(takakukewashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(篁),
					result  => q(takamura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(簟),
					result  => q(takamushiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(峨),
					result  => q(takane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宝寚寳寶琛財貨貲貹賝賯鈺]),
					result  => q(takara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(猂),
					result  => q(takashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(籩),
					result  => q(takatauki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([梪豋鐙]),
					result  => q(takatsuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丈岳嶽竹竺筀筇筠筪箖箠箶箺箽篔簬簹籛]),
					result  => q(take),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(虘),
					result  => q(takedakeshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僙僩]),
					result  => q(takedakeshiisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(侷),
					result  => q(takegahikui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(箯),
					result  => q(takegoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([筕篨]),
					result  => q(takemushiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(酣),
					result  => q(takenawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([箬篛籜]),
					result  => q(takenokawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([笋筍箰]),
					result  => q(takenoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(獗),
					result  => q(takeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([徤悍武猛驍黆]),
					result  => q(takeshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桓猤]),
					result  => q(takeshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([滝瀧]),
					result  => q(taki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栝蕘薪]),
					result  => q(takigi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凧胝蛸鮹鱆]),
					result  => q(tako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乇劅桌炊燀燌舴踔]),
					result  => q(taku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(墆),
					result  => q(takuhaheru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([逞駫]),
					result  => q(takumashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倆匞匠工巧]),
					result  => q(takumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(灥),
					result  => q(takusannoizumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宁庤畜蓄貯飣]),
					result  => q(takuwaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圭弹弾彈灵玉玘玜玢珒珖珝珠珣珪珹珻球琄琦琪琭瑤瑧瑭瑶璠璣璧璮璹瓊瓌瓘閠霊霛靈𩂳]),
					result  => q(tama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卵孚蛋]),
					result  => q(tamago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(環),
					result  => q(tamaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魂魄]),
					result  => q(tamashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(衹),
					result  => q(tamatama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([給貺賚贛]),
					result  => q(tamau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賜),
					result  => q(tamawaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廟),
					result  => q(tamaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([檃櫽]),
					result  => q(tamegi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(氹),
					result  => q(tameike),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喟愾]),
					result  => q(tameiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([狷蹰蹱躇躊躕]),
					result  => q(tamerau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([民氓]),
					result  => q(tami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(櫤),
					result  => q(tamo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袂),
					result  => q(tamoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([保存賲]),
					result  => q(tamotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屯),
					result  => q(tamurosuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癬),
					result  => q(tamushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傝勯坍埮婒媏帎旵柦氮痰碳耼詀趈郯鄲醰錟髧]),
					result  => q(tan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([庎棚鄽]),
					result  => q(tana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(旎),
					result  => q(tanabiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魣鮬鰱鱮]),
					result  => q(tanago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(掌),
					result  => q(tanagokoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(穀),
					result  => q(tanatsumotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([種胤]),
					result  => q(tane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(莂),
					result  => q(taneomaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壑峪嵠嶰渓溪澗磎礀谷陘]),
					result  => q(tani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(谿),
					result  => q(tanigawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叮嘱囑忋怙恀恃托賴頼]),
					result  => q(tanomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楽樂]),
					result  => q(tanoshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倇嘕娛娯嬉忭悰愉愷憪]),
					result  => q(tanoshimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(昪),
					result  => q(tanoshimusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([狸猍貍]),
					result  => q(tanuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垰嵶]),
					result  => q(tao),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仆倒僨僵斃踣]),
					result  => q(taoreru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(殪),
					result  => q(taosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妴婀婐嫋嬝]),
					result  => q(taoyaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姼),
					result  => q(taoyame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桵棫樰膤鰔鱈鱤]),
					result  => q(tara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(槃),
					result  => q(tarai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嚋孰]),
					result  => q(tare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([髦髳]),
					result  => q(taregami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(裧),
					result  => q(tareginu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([垂埀橤]),
					result  => q(tareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(賅),
					result  => q(tariru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([栨椑樽]),
					result  => q(taru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桷椽榱橑]),
					result  => q(taruki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈶),
					result  => q(taryuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(碻),
					result  => q(tashiika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([慥確]),
					result  => q(tashika),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呩嗜]),
					result  => q(tashinamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([曛曫]),
					result  => q(tasogare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(挋),
					result  => q(tasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佐佴俌]),
					result  => q(tasuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([介伒佋佑倗助勴帮幇幚幫弻弼扶援撛祄祐賛賻贊輔]),
					result  => q(tasukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襷),
					result  => q(tasuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湛),
					result  => q(tataeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([戦戰闘鬥鬦鬪鬬鬭]),
					result  => q(tatakau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叩噋扣搞撽敲椓毃]),
					result  => q(tataku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叠曡畳疂疉疊]),
					result  => q(tatamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(祟),
					result  => q(tatari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亍佇偟儃竚蹢]),
					result  => q(tatazumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楯盾縦縱]),
					result  => q(tate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(榜),
					result  => q(tatefuda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([巤騌騣鬃鬉鬐鬛鬣]),
					result  => q(tategami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(楬),
					result  => q(tatehuda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(碑),
					result  => q(tateishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亨奉献獻]),
					result  => q(tatematsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(奒),
					result  => q(tatematsuuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([壴尌建]),
					result  => q(tateru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(悓),
					result  => q(tatoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([例譬]),
					result  => q(tatoeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刉刏刟剬剿劁劊劋劖哳噠截断斷榯燵立站竜竪竬羍裁製謖豎辰迮釿鈷銽鐽龍龒]),
					result  => q(tatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([巺巽]),
					result  => q(tatsumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(尊),
					result  => q(tattoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嫍嵣裪]),
					result  => q(tau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(譫),
					result  => q(tawagoto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(婬),
					result  => q(tawakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([撓箞轑]),
					result  => q(tawameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橈),
					result  => q(tawamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諢),
					result  => q(tawamure),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啁嫽悝戯戱戲詼謔]),
					result  => q(tawamureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(俵),
					result  => q(tawara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(便),
					result  => q(tayori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([幉繮軜轡靮靶鞗鞼韁]),
					result  => q(tazuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(尋),
					result  => q(tazuneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擕),
					result  => q(tazusaaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([携攜]),
					result  => q(tazusaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弖手]),
					result  => q(te),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(肢),
					result  => q(teashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(繾),
					result  => q(teatsui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鈒鋋]),
					result  => q(teboko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([曌瞾]),
					result  => q(teeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(棨),
					result  => q(tegata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輦),
					result  => q(teguruma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扌),
					result  => q(tehen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帨),
					result  => q(tehuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仃厗奵寊屟崹嵉嵿帄弤晸杕泜渧玎珵珽瑅璏碲螮袛軑醍銈銻頲騠鴺鷉]),
					result  => q(tei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([拲杻梏]),
					result  => q(tekase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唙彳籊馰]),
					result  => q(teki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杆杠桿槓]),
					result  => q(teko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丶吅囅壥婖婝婰掭沺湉滇瀍碘磌舚蜓蜔貂靦鵈鼦]),
					result  => q(ten),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蝯),
					result  => q(tenagazaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囪囱]),
					result  => q(tenmado),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廙),
					result  => q(tenmaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(拚),
					result  => q(teoutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([塔寺]),
					result  => q(tera),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(暟),
					result  => q(terai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(燾),
					result  => q(terasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(衒),
					result  => q(terau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([炤照]),
					result  => q(teru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(炛),
					result  => q(terusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(軨),
					result  => q(tesori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([欄欗闌𣟬]),
					result  => q(tesuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哋喆嚞峌嵽瓞絰耊鍇餮]),
					result  => q(tetsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(贉),
					result  => q(tetsuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鏄),
					result  => q(tetsunokatamari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刁岧庣]),
					result  => q(teu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(帇),
					result  => q(tewazagasubayai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厎厝厲嘟堍峹嵞嶀戶-戸砥荰跿]),
					result  => q(to),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([㡡帳帷幃幄幎幨幬幮賬]),
					result  => q(tobari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彋),
					result  => q(tobarinohirugaherukoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(癟),
					result  => q(tobenai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鳶鴟鵄鷳鷴𪀒]),
					result  => q(tobi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([笩翀]),
					result  => q(tobiagaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(矼),
					result  => q(tobiishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([扉闔]),
					result  => q(tobira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鷔),
					result  => q(tobiuo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(乏),
					result  => q(toboshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枢樞]),
					result  => q(toboso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仚卂翌翬翲翾飛鶱]),
					result  => q(tobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杤栃橡]),
					result  => q(tochi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(檰),
					result  => q(tochiyuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(庋),
					result  => q(todana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(魹),
					result  => q(todo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([屆届]),
					result  => q(todokeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([掯滞滯濇軭]),
					result  => q(todokooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([停渟跱逗駐]),
					result  => q(todomaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([拘禁稽遏𥡴]),
					result  => q(todomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(轟),
					result  => q(todoroki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([軣輷]),
					result  => q(todoroku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咎栂]),
					result  => q(toga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尤罸讁]),
					result  => q(togameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(尖),
					result  => q(togaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枅),
					result  => q(togata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([朿莿]),
					result  => q(toge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(遂),
					result  => q(togeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(伽),
					result  => q(togi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(韴),
					result  => q(togireru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(滫),
					result  => q(togishiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([研硏礱]),
					result  => q(togu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塣),
					result  => q(tohoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(篊),
					result  => q(toi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(咦),
					result  => q(toiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([砺硎碬]),
					result  => q(toishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(酻),
					result  => q(toishireru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([緘聠閉閟闇闋]),
					result  => q(tojiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜴),
					result  => q(tokage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([概槪]),
					result  => q(tokaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([爍鑠]),
					result  => q(tokasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冸毷溶豸銷]),
					result  => q(tokeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([旹時朞鬨鴾鵇]),
					result  => q(toki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([所攸處]),
					result  => q(tokoro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(輹),
					result  => q(tokoshibari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劙嘚彖悳惪挩捝棏涿碡解觧訷註說説釈釋髑]),
					result  => q(toku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([竼篷苫]),
					result  => q(toma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傺坁抳止泊]),
					result  => q(tomaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(斗),
					result  => q(tomasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(籞),
					result  => q(tomeba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([掕摚歫畄留綝]),
					result  => q(tomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侣侶傰僚共友捛攩朋舳艄鞆]),
					result  => q(tomo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(巴),
					result  => q(tomoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([們儔儕輩]),
					result  => q(tomogara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(伴),
					result  => q(tomonau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俱倶偕]),
					result  => q(tomoni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([燈燭]),
					result  => q(tomoshibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纜),
					result  => q(tomozuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冨富賰]),
					result  => q(tomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唁喭弔]),
					result  => q(tomurau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伅吨噸墩崸庉炖瓲芚]),
					result  => q(ton),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誯),
					result  => q(tonaaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唱徇狥穪誦]),
					result  => q(tonaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(爯),
					result  => q(tonahe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鄰隣]),
					result  => q(tonari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(厸),
					result  => q(tonaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜻),
					result  => q(tonbo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(倌),
					result  => q(toneri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梣),
					result  => q(toneriko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(殿),
					result  => q(tono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儤),
					result  => q(tonoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冂悠茫賖趠逖逴逷逺遐遠邈]),
					result  => q(tooi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(轇),
					result  => q(tookunagai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(畱),
					result  => q(toomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偦徹疏融踈迵通逹達]),
					result  => q(tooru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乕寅虎]),
					result  => q(tora),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囚捉捕搤擒]),
					result  => q(toraeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(虍),
					result  => q(torakanmuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丣酉隹鳥]),
					result  => q(tori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(搯),
					result  => q(toridasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堡塁塢壔壘寨廓砦]),
					result  => q(toride),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(穡),
					result  => q(toriire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(茛),
					result  => q(torikabuto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(奐),
					result  => q(torikaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笯),
					result  => q(torikago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俘禽虜]),
					result  => q(toriko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擄),
					result  => q(toriku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([取執寽抄抾捋捎捔採揓揜搴摣摻撏撮擥攏攓攬秉緶虝詵采鍩韆]),
					result  => q(toru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([釷鋀]),
					result  => q(toryuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亗年敏歲歳秊]),
					result  => q(toshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(圕),
					result  => q(toshokan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(耋),
					result  => q(toshori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(迚),
					result  => q(totemo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([均悈捆整盉]),
					result  => q(totonoeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儳),
					result  => q(totonohanu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([婩歵調]),
					result  => q(totonou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姻嫁歸]),
					result  => q(totsugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蹔),
					result  => q(totsushinsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佟匒十哃問噔噹埬塌墖姛娉嬞峒崠幍撘朷湞漯獞瑫眔秱筩篖籐籘耷聘膅膛蓊蕫蘯蚪蝀蝪螣螳蟷衕訊譣遢鄧酘釖鈄鎕鏜陦鞳鞺餖鼕鼟龘]),
					result  => q(tou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(峠),
					result  => q(touge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薜),
					result  => q(touki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菘),
					result  => q(touna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(炷),
					result  => q(toushin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(貴),
					result  => q(toutoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閇),
					result  => q(tozasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(津),
					result  => q(tsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唾鍔鐔]),
					result  => q(tsuba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椿),
					result  => q(tsubaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([燕雟鳦鷰]),
					result  => q(tsubame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苐荑]),
					result  => q(tsubana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(咅),
					result  => q(tsubaohaiteinamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([翅翼]),
					result  => q(tsubasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(𡱖),
					result  => q(tsubi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([坩坪垌壷壺]),
					result  => q(tsubo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([莟蓓蕾]),
					result  => q(tsubomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(局),
					result  => q(tsubone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([粒顆]),
					result  => q(tsubu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(呟),
					result  => q(tsubuyaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([土地坤埁塿墋壌壤椎槌汢鎚]),
					result  => q(tsuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塤),
					result  => q(tsuchibue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(霾),
					result  => q(tsuchifuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([培碚秄耔]),
					result  => q(tsuchikau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(壒),
					result  => q(tsuchikemuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凷圤堛]),
					result  => q(tsuchikure),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(戊),
					result  => q(tsuchinoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杖枴梃棍棒棓檛櫕欑]),
					result  => q(tsue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樛),
					result  => q(tsuga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(番),
					result  => q(tsugai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樿),
					result  => q(tsuge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吿告嚳紏誥]),
					result  => q(tsugeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亜亞嗣接椄次紹継繼纉纘賡踵韶]),
					result  => q(tsugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鶇鶫]),
					result  => q(tsugumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(噤),
					result  => q(tsugumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([償賠]),
					result  => q(tsugunau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(娷),
					result  => q(tsui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啄嗆鳹鶼]),
					result  => q(tsuibamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([序秩第]),
					result  => q(tsuide),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叙敍敘]),
					result  => q(tsuideru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(潰),
					result  => q(tsuieru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(闥),
					result  => q(tsuiji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(墣),
					result  => q(tsuikure),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朔),
					result  => q(tsuitachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(扆),
					result  => q(tsuitate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(費),
					result  => q(tsuiyasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(辻),
					result  => q(tsuji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冢厧埌埠埰堬塚墦把杷梲棁欛緱塚𣠽]),
					result  => q(tsuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痞),
					result  => q(tsukae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仕宦閊]),
					result  => q(tsukaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([捽掴摑攫爴]),
					result  => q(tsukamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(繃),
					result  => q(tsukane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(繆),
					result  => q(tsukaneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(攰),
					result  => q(tsukarekiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倦劬労勦弊憊殢疲瘁癃羸苶]),
					result  => q(tsukareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(劵),
					result  => q(tsukaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吏官寮曹曺職]),
					result  => q(tsukasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([司宰敟]),
					result  => q(tsukasadoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伻使俜馭]),
					result  => q(tsukau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(遣),
					result  => q(tsukawasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襻),
					result  => q(tsukehimo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([菹葅]),
					result  => q(tsukemono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([付坿]),
					result  => q(tsukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([月槻欟]),
					result  => q(tsuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(騢),
					result  => q(tsukige),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(澨),
					result  => q(tsukiji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朜),
					result  => q(tsukinohikari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(朎),
					result  => q(tsukinoushiinikari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([既旣殄殫澌竭]),
					result  => q(tsukiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(徬),
					result  => q(tsukisou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([即卽就慿掽揬搗搶摏撞擣朾檇皍硾突蒞衝附]),
					result  => q(tsuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蹲),
					result  => q(tsukubau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(佃),
					result  => q(tsukuda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([几机案桯榥檯]),
					result  => q(tsukue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(咿),
					result  => q(tsukuriwarai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([繕衱裰]),
					result  => q(tsukurou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([作做為爲造]),
					result  => q(tsukuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儩尽悉殱殲盡]),
					result  => q(tsukusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蜺蟪]),
					result  => q(tsukutsukuboushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冣妻媐褄]),
					result  => q(tsuma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(襭),
					result  => q(tsumabasamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([媞宷審悘諦讅]),
					result  => q(tsumabiraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(翹),
					result  => q(tsumadateru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(趼),
					result  => q(tsumadatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袺),
					result  => q(tsumadoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(孥),
					result  => q(tsumako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈕),
					result  => q(tsumami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([抓拈掐揸]),
					result  => q(tsumamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([詘誳鼽]),
					result  => q(tsumaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([疐跌跎跲蹉蹎蹶躂躓]),
					result  => q(tsumazuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(爪),
					result  => q(tsume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(虢),
					result  => q(tsumeato),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(爫),
					result  => q(tsumekanmuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詰),
					result  => q(tsumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([罪罰辜辠辥]),
					result  => q(tsumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(垜),
					result  => q(tsumikasareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(剭),
					result  => q(tsumisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([摘槯稸積蕰薀藴蘊錘]),
					result  => q(tsumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([絁綈]),
					result  => q(tsumugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(軖),
					result  => q(tsumugikuruma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紡紬緝績]),
					result  => q(tsumugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([颶飃飄]),
					result  => q(tsumujikase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([颮颴颷飆-飈]),
					result  => q(tsumujikaze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紼綋維綱]),
					result  => q(tsuna),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([娄敽敿汸系縶繋繫馽]),
					result  => q(tsunagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([聵聾]),
					result  => q(tsunbo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([常彛-彞恆恇恒毎每甬]),
					result  => q(tsune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([甪角]),
					result  => q(tsuno),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(募),
					result  => q(tsunoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(觘),
					result  => q(tsunosaji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(觥),
					result  => q(tsunosakazuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([峮嶧巋緜聫聮聯連]),
					result  => q(tsuranaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([列展廞聨肆陳]),
					result  => q(tsuraneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([擐毌琲貫]),
					result  => q(tsuranuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([凇凙]),
					result  => q(tsurara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(媲),
					result  => q(tsureahi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儷),
					result  => q(tsureai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釣),
					result  => q(tsuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([銿鏞]),
					result  => q(tsurigane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苨茋]),
					result  => q(tsuriganesou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([緍緡]),
					result  => q(tsuriito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([寉弦蔓鉉靎靏魡鶮鶴鸖鶴]),
					result  => q(tsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鑵),
					result  => q(tsurube),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([綆繘]),
					result  => q(tsurubinawa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([剣剱劍劎劒劔釼鋏]),
					result  => q(tsurugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鋻),
					result  => q(tsuruginoha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(吊),
					result  => q(tsurusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([樢蔦蘿]),
					result  => q(tsuta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伝傳]),
					result  => q(tsutaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伹拙]),
					result  => q(tsutanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苞苴]),
					result  => q(tsuto),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勆勜]),
					result  => q(tsutoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(役),
					result  => q(tsutome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(訾),
					result  => q(tsutomenai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(儢),
					result  => q(tsutomenaisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亹伮僶努劭劰劶勀勉勌勏勓勔勖勗務勤勬勱孜忞愐懋敃暋辦黽]),
					result  => q(tsutomeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夙),
					result  => q(tsutoni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([筒銃]),
					result  => q(tsutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(恙),
					result  => q(tsutsuga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(憜),
					result  => q(tsutsumanai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圩坡坥垻埞埧堌堤堹塘陂隁隄隖鼙]),
					result  => q(tsutsumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([勹勽包娖帕絈葤蔪裹轁錔鞱]),
					result  => q(tsutsumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牮),
					result  => q(tsutsupori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(夤),
					result  => q(tsutsushimiosoreru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劼叀姞娕孎孨忯恪惓惕惖愙愨愼愿慎憼戁捒欽毖碏祗竦粛肅臫虔謹龏]),
					result  => q(tsutsushimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(擑),
					result  => q(tsuugu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宊),
					result  => q(tsuuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兵戎軍]),
					result  => q(tsuwamono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(翯),
					result  => q(tsuyagaaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侃侼倔倞傹剛劜劥劯勁勍姜弜強强彊憠毅鏻]),
					result  => q(tsuyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弡),
					result  => q(tsuyokuisamashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([霉露]),
					result  => q(tsuyu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([続續纞邐]),
					result  => q(tsuzuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倹儉]),
					result  => q(tsuzumayaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(約),
					result  => q(tsuzumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([皷鼓鼔]),
					result  => q(tsuzumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([叕綴纍]),
					result  => q(tsuzuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卯夘玗瑀茡虶邘釪骬鵜鶖鶿鷧]),
					result  => q(u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姥娒]),
					result  => q(uba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奪篡簒褫]),
					result  => q(ubau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([肯諾]),
					result  => q(ubenau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([內内衷]),
					result  => q(uchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(殹),
					result  => q(uchiatarukoe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宑),
					result  => q(uchiido),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(磬),
					result  => q(uchiishi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([袿裲褂]),
					result  => q(uchikake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痏),
					result  => q(uchikizu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([捥腕]),
					result  => q(ude),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纕),
					result  => q(udemakurisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釧),
					result  => q(udewa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(饂),
					result  => q(udon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丄上筌]),
					result  => q(ue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殍殣]),
					result  => q(uejini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埶栽植樹稵穥腇蒔藝飢餒餓餧餵饉饑]),
					result  => q(ueru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([穿鏆]),
					result  => q(ugatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(撼),
					result  => q(ugokasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([動吪慅扤蕩蜄蹌躒]),
					result  => q(ugoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蝡蠕蠢]),
					result  => q(ugomeku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鯎),
					result  => q(ugui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴬鶯]),
					result  => q(uguisu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([氏蛆]),
					result  => q(uji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蜡),
					result  => q(ujimushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(氽),
					result  => q(ukaberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([泛瀲]),
					result  => q(ukabu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(靗),
					result  => q(ukagafu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(睪),
					result  => q(ukagaimeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頣),
					result  => q(ukagaimiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伣伺俔偵窺覗覘覰覷諜遉闖闚]),
					result  => q(ukagau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([受歆禛]),
					result  => q(ukeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(承),
					result  => q(uketamawaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瑑),
					result  => q(ukibori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰾),
					result  => q(ukibukuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薸),
					result  => q(ukigusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([苹萍蓱蘋]),
					result  => q(ukikusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(浮),
					result  => q(uku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([午馬駔]),
					result  => q(uma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(尵),
					result  => q(umagayamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([甛甜膁覃餂]),
					result  => q(umai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(騶),
					result  => q(umakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妏產産]),
					result  => q(umareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([厩厰廐廠駅驛]),
					result  => q(umaya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([醁醑]),
					result  => q(umazake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([梅楳槑]),
					result  => q(ume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吚噢]),
					result  => q(umeku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圽埋]),
					result  => q(umeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([海瀛膿]),
					result  => q(umi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰢),
					result  => q(umiebi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鼂),
					result  => q(umigame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鱓鱔]),
					result  => q(umihebi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([娩孳孶尯]),
					result  => q(umu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妘溳澐繧蒕鄆鄖]),
					result  => q(un),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(促),
					result  => q(unagasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鰑鰻]),
					result  => q(unagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(髫),
					result  => q(unai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([脰項領]),
					result  => q(unaji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(唸),
					result  => q(unaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([堟壟畦畴疇隴]),
					result  => q(une),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(婇),
					result  => q(uneme),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蜲魿]),
					result  => q(uneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([魚𩵋]),
					result  => q(uo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([罛罽]),
					result  => q(uoami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([浦裏裡]),
					result  => q(ura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(卦),
					result  => q(urakata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([怏怨恨惆愇愠慊慍憝憾懎懟懭譈讟]),
					result  => q(uramu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([乩卜]),
					result  => q(uranau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鈾),
					result  => q(uranyuumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([羡羨]),
					result  => q(urayamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(惂),
					result  => q(ureekurushimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([卹唿啒忉忡忳恤悁悄悒惔惙惸愀慁慱慼憂懆賉]),
					result  => q(ureeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([愪愵]),
					result  => q(ureerusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(愁),
					result  => q(urei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亃熟稇]),
					result  => q(ureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瓜蓏]),
					result  => q(uri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瓤),
					result  => q(uriwata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(糶),
					result  => q(uriyone),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鱗),
					result  => q(uroko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([售売詅賣]),
					result  => q(uru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秈秔稉稴籼粳]),
					result  => q(uruchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(堻),
					result  => q(uruhohi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(洽),
					result  => q(uruosu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([汋沾浞浥溻潤澍濅濡霑]),
					result  => q(uruou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嘍),
					result  => q(urusaisaama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(噡),
					result  => q(urusakushaberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柒桼漆髤髹]),
					result  => q(urushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(幦),
					result  => q(urushinurinonuno),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閏),
					result  => q(uruu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(丽),
					result  => q(uruwashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([斌鬈麗]),
					result  => q(uruwashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([兎兔毚莵菟]),
					result  => q(usagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([罘錀]),
					result  => q(usagiami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([馿驢]),
					result  => q(usagiuma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([丑丒牛]),
					result  => q(ushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牜),
					result  => q(ushihen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([失抎]),
					result  => q(ushinau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(艮),
					result  => q(ushitora),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鷽鸴]),
					result  => q(uso),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嘨嘯虓]),
					result  => q(usobuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([硙碓碾磑臼]),
					result  => q(usu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(黲),
					result  => q(usuaoguroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(齨),
					result  => q(usuba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([紗繻]),
					result  => q(usuginu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僿匾恌漓濂菲薄]),
					result  => q(usui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(纁),
					result  => q(usuiakairo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(枼),
					result  => q(usuikifuda),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(臿),
					result  => q(usujiku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(醨),
					result  => q(usuzake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(舂),
					result  => q(usuzuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(唄),
					result  => q(uta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([惢疑謟]),
					result  => q(utagau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宴酺]),
					result  => q(utage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([謠謡]),
					result  => q(utai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吟呻咏哥哦唻嗙嘔歌謌謳]),
					result  => q(utau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([台坮柎臺萼蕚闍阇]),
					result  => q(utena),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疎),
					result  => q(utoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([刜剆征打批抃拊拍拷挌揈揕搉搏搨摋摽撃撲撾擊攊攴攵敋硺笪討誅豗趵鏗𢫦]),
					result  => q(utsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([笂靫鞴]),
					result  => q(utsubo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(杔),
					result  => q(utsugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(躻),
					result  => q(utsuke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伃佼倩妍妗姚姝姴姸娃婉婜婷婻媋媙嬁楙珢瑮窕美藇頔]),
					result  => q(utsukushii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鎏),
					result  => q(utsukushiigane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(頫),
					result  => q(utsumuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枵窐腔谾]),
					result  => q(utsuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([徙拪敫移迁迻遷]),
					result  => q(utsuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([写冩寫搬謄]),
					result  => q(utsusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諑),
					result  => q(utsutae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俙詾]),
					result  => q(utsutaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(辡),
					result  => q(utsutaheru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(惝),
					result  => q(utsutorisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匫噐器斝璉盨鋐鍉鑨]),
					result  => q(utsuwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諼),
					result  => q(utsuwaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([愬訴]),
					result  => q(uttaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(卾),
					result  => q(uwaago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([蟒蠎]),
					result  => q(uwabami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(釉),
					result  => q(uwagusuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(瞯),
					result  => q(uwamezukai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(噂),
					result  => q(uwasa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(礼),
					result  => q(uya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匑悊敬]),
					result  => q(uyamau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([恭顓顗]),
					result  => q(uyauyashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(渦),
					result  => q(uzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疼),
					result  => q(uzuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(踞),
					result  => q(uzukumaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([瘞薶]),
					result  => q(uzumeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([煨熅]),
					result  => q(uzumibi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鴳鴽鵪鶉鷃]),
					result  => q(uzura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(堆),
					result  => q(uzutakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咊萵輞輪鐶镮]),
					result  => q(wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([軌轍]),
					result  => q(wadachi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(綰),
					result  => q(waganeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鬟),
					result  => q(wage),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哩崴椳獩碨鰃]),
					result  => q(wai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夭妙嫩]),
					result  => q(wakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([歽殀殤]),
					result  => q(wakajini),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仳別别另晆派訣誃]),
					result  => q(wakareru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鰙),
					result  => q(wakasagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鴘),
					result  => q(wakataka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([劃泮釆頖]),
					result  => q(wakatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([訳譯]),
					result  => q(wake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冎分判剫區叏叧夬攽朌班辨辯部頒]),
					result  => q(wakeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([胳脇腋]),
					result  => q(waki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([孼孽膀]),
					result  => q(wakibara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(掖),
					result  => q(wakibasamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(簃),
					result  => q(wakibeya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([輒輙]),
					result  => q(wakigi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(胠),
					result  => q(wakinoshita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枠汹沸洶涌湧滕滭潗濆篗]),
					result  => q(waku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([哅嚄嚷讍]),
					result  => q(wameku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([埦盋盌]),
					result  => q(wan),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(羂),
					result  => q(wana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鰐鱷鼉]),
					result  => q(wani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笿),
					result  => q(wankago),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([秸稈稧稭稾稿藁藳]),
					result  => q(wara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侲僮童]),
					result  => q(warabe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蕨),
					result  => q(warabi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(繥),
					result  => q(warafu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(咍),
					result  => q(warahu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鞋鞵]),
					result  => q(waraji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蟠),
					result  => q(warajimushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(稕),
					result  => q(warataba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([听咥哂唷唹嗤歒笑蚩]),
					result  => q(warau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([吾咱喒我朕]),
					result  => q(ware),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([券劕卩符]),
					result  => q(warifu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([剖割]),
					result  => q(waru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([猾獪]),
					result  => q(warugashiko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([偛婾媮嬀]),
					result  => q(warugashikoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傸凶嚚悪惡慝歹獰]),
					result  => q(warui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(酲),
					result  => q(waruyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(稑),
					result  => q(wase),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儂雕鵰鷲]),
					result  => q(washi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([忘悆慲]),
					result  => q(wasureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([棉絋絖絮綿縴]),
					result  => q(wata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(廊),
					result  => q(watadono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([袍褚襺]),
					result  => q(wataire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(姎),
					result  => q(watakushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([亙杭涉渉渡砅航镾]),
					result  => q(wataru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(私),
					result  => q(watashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伎技業芸]),
					result  => q(waza),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伶俳倡妓]),
					result  => q(wazaogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([灾烖]),
					result  => q(wazawaai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殃災祅禍訞]),
					result  => q(wazawai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([纔錙]),
					result  => q(wazuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僅才]),
					result  => q(wazukani),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(菐),
					result  => q(wazurahashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([患煩]),
					result  => q(wazurau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(諉),
					result  => q(wazurawasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嬈),
					result  => q(wazuruwashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([倻屋峫琊矢笶箭耶輻邪鋣鍭鎁]),
					result  => q(ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([薮藪]),
					result  => q(yabu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([薟蘞]),
					result  => q(yabukarashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(乜),
					result  => q(yabunirami),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(袽),
					result  => q(yaburegoromo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俷儡垝惉敗敝殕殬殰贁]),
					result  => q(yabureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(陒),
					result  => q(yaburetakaki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圮湈破]),
					result  => q(yaburu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(悋),
					result  => q(yabusaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薽),
					result  => q(yabutabako),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宿舍舎]),
					result  => q(yadoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(笴),
					result  => q(yagara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([軅軈]),
					result  => q(yagate),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(樔),
					result  => q(yagura),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詥),
					result  => q(yaharagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(筈),
					result  => q(yahazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鋎),
					result  => q(yaiba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(灸),
					result  => q(yaito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(萢),
					result  => q(yaji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([砮鉃鏃鏑骲]),
					result  => q(yajiri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(軰),
					result  => q(yakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啅嚅謷霅]),
					result  => q(yakamashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([属屬族]),
					result  => q(yakara),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([舘館館]),
					result  => q(yakata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疁),
					result  => q(yakibata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(匋),
					result  => q(yakimono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鏊),
					result  => q(yakinabe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(堲),
					result  => q(yakitsuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(奴),
					result  => q(yakko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([喲徫梄槱灼烙焌焚焠焫焼煠燒-燔燬爇爈爚爟]),
					result  => q(yaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([庁府廨廰廳衙]),
					result  => q(yakusho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(署),
					result  => q(yakuwari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([圸山岵岾]),
					result  => q(yama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(葴),
					result  => q(yamaai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(豪),
					result  => q(yamaarashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(僊),
					result  => q(yamabito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([翰鶡鸐]),
					result  => q(yamadori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柘檿]),
					result  => q(yamaguwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([疤疴疾痾瘀瘄瘕]),
					result  => q(yamai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(疒),
					result  => q(yamaidare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([犲豺]),
					result  => q(yamainu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(岪),
					result  => q(yamamichi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(饛),
					result  => q(yamamori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([杜棠欏]),
					result  => q(yamanashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茖韯韱]),
					result  => q(yamanira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(梗),
					result  => q(yamanire),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嵤),
					result  => q(yamanofukaisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(峲),
					result  => q(yamanonarabusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嵡巐]),
					result  => q(yamanosama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(岇),
					result  => q(yamanotakiisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嵰),
					result  => q(yamanotakuisama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嵙),
					result  => q(yamashina),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(豦),
					result  => q(yamenai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([歇罷輟辝辞辤辭]),
					result  => q(yameru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嫠嬼孀寡]),
					result  => q(yamome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鰥鱞]),
					result  => q(yamoo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殗疓疚病痗痡痯瘏瘓瘝瘣瘵瘼癁]),
					result  => q(yamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([簗罶羀]),
					result  => q(yana),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柳桺楊]),
					result  => q(yanagi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(宀),
					result  => q(yane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([枑柵栅]),
					result  => q(yarai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([槍鎗鑓]),
					result  => q(yari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誮),
					result  => q(yasashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([優易]),
					result  => q(yasashii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奀疺痩瘠瘦癄癯癴膄臞]),
					result  => q(yaseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(塉),
					result  => q(yasetsuchi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(椰),
					result  => q(yashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([廛邸]),
					result  => q(yashiki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嘼羪豢養]),
					result  => q(yashinau),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(社),
					result  => q(yashiro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([癉簎]),
					result  => q(yasu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蠲),
					result  => q(yasude),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佾倓妥安寕寜寧康恬泰綏靖靖]),
					result  => q(yasui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([休屖]),
					result  => q(yasumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(訅),
					result  => q(yasunzuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侒妟宓宖徖惵憺懕竫]),
					result  => q(yasuraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鋁鑢]),
					result  => q(yasuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([傭僱賃雇]),
					result  => q(yatou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(八),
					result  => q(yatsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([嫶悴憔窶顇顦]),
					result  => q(yatsureru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(碼),
					result  => q(yaudo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(燮),
					result  => q(yawarageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俰冾凞吘和廱愔濈秚穆脜諧諴諿雍雝韸龢凞]),
					result  => q(yawaragu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([儒軟]),
					result  => q(yawaraka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(柔),
					result  => q(yawarakai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([韇韊]),
					result  => q(yazutsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([世丗乎亖亱卋夜妤澦狳璵礜艅蕷鸒]),
					result  => q(yo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([昒昢]),
					result  => q(yoake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([呼唤喚嚾籲謼龥]),
					result  => q(yobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鳲),
					result  => q(yobukodori),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(涎),
					result  => q(yodare),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(淀),
					result  => q(yodo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(艠),
					result  => q(yofune),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(秢),
					result  => q(yohai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([价佳俶傪儀可吉哿善媺嬥宵徽慶懿毣淑禕羏義臧良葸誼譱]),
					result  => q(yoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([釥鉚]),
					result  => q(yoikane),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(誐),
					result  => q(yoikotoba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([奱攀]),
					result  => q(yojiru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([横橫]),
					result  => q(yoko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桄簨軫]),
					result  => q(yokogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(緯),
					result  => q(yokoito),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([咼哇]),
					result  => q(yokoshima),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([罭薏]),
					result  => q(yoku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([諃諓]),
					result  => q(yokuiu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(囌),
					result  => q(yokushaberu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(僟),
					result  => q(yokutsutsushimu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([娵婦媳]),
					result  => q(yome),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(詁),
					result  => q(yomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([殅甦蘇蘓]),
					result  => q(yomigaeru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(嘉),
					result  => q(yomisuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([艾蒿蓬蔞蕭]),
					result  => q(yomogi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([籀籒詠読讀]),
					result  => q(yomu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([汰浙淘]),
					result  => q(yonageru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(淅),
					result  => q(yonagu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(卌),
					result  => q(yonjuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([罒罓]),
					result  => q(yonkashira),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(偩),
					result  => q(yorikatadoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([甲鉀鎧]),
					result  => q(yoroi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([茝葯虈]),
					result  => q(yoroigusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俽僖兊兌兑喜嗂姇娾忔忻怡恱悅悦惞慆憘憙懌懽欣欯歓歡衎訢賀驩]),
					result  => q(yorokobu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(竴),
					result  => q(yorokobusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(敐),
					result  => q(yorokondeugokusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([跚蹁蹣蹬蹭]),
					result  => q(yoromeku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冝宜]),
					result  => q(yoroshii),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([万萬]),
					result  => q(yorozu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([仍仗依倚儴凭囙因寄寓庽憑扔拠搓據穸縒託讬馮]),
					result  => q(yoru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(侂),
					result  => q(yoseru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(由),
					result  => q(yoshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([媾竩]),
					result  => q(yoshimi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([妝娤扮粧糚装裝]),
					result  => q(yosoou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(鵟),
					result  => q(yotaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(四),
					result  => q(yotsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([伷嫡胄]),
					result  => q(yotsugi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([佣嗈噟嚈垟塎岰峟嵱敭氧滽瀁灉炴猺瑢皣瞱穃窅苚苭葽蓉蹡軺邕鄘酊酔酩醉醺颻駚鸎]),
					result  => q(you),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(稍),
					result  => q(youyaku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俀偄冉嬬孱弱愞懦懧耎齡齢]),
					result  => q(yowai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([崳湯瑜羭茰萸]),
					result  => q(yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([指歧]),
					result  => q(yubi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(艻),
					result  => q(yubinomata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(韜),
					result  => q(yubukuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([桰棐檠]),
					result  => q(yudame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(委),
					result  => q(yudaneru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(湢),
					result  => q(yudono),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(故),
					result  => q(yue),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弽韘]),
					result  => q(yugake),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啙喎歪]),
					result  => q(yugamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(汽),
					result  => q(yuge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([鞲韝]),
					result  => q(yugote),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弭弰彄]),
					result  => q(yuhazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([床牀笫]),
					result  => q(yuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([裄雪]),
					result  => q(yuki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([尥尦趦跙]),
					result  => q(yukinayamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(芠),
					result  => q(yukinoshita),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([之倁儌彭往徂徃徆徍跥跺躞辸迋迠迬迱迶逝遃遦適邁]),
					result  => q(yuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([侁徸]),
					result  => q(yukusama),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([夢夣梦]),
					result  => q(yume),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弓),
					result  => q(yumi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弢鞬韔]),
					result  => q(yumibukuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弫弿]),
					result  => q(yumigatsuyoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(窿),
					result  => q(yuminari),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(弬),
					result  => q(yuminona),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(螠),
					result  => q(yumushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(杅),
					result  => q(yunomi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([遴邅]),
					result  => q(yuonayamu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(岼),
					result  => q(yuri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(閖),
					result  => q(yuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(忽),
					result  => q(yurugaseni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([僈嬗紓緩繟]),
					result  => q(yurui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弛跅]),
					result  => q(yurumu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([宥恕許赦]),
					result  => q(yurusu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([俆偍勨綽縵逌]),
					result  => q(yuruyaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([揺搖摇]),
					result  => q(yusuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([啿愃穣穰胖裕豊豐饒]),
					result  => q(yutaka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([优夕浟狖紒蚰蚴蝣邎魷]),
					result  => q(yuu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(晡),
					result  => q(yuugata),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(餔),
					result  => q(yuumeshi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(彇),
					result  => q(yuwazu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([柚樤]),
					result  => q(yuzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([弝弣]),
					result  => q(yuzuka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(牃),
					result  => q(yuzuriha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([禅禪譲讓遜]),
					result  => q(yuzuru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(蓙),
					result  => q(za),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([楉榴橊]),
					result  => q(zakuro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([囤笊篅]),
					result  => q(zaru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([唑芮]),
					result  => q(zei),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([姌梮琁碝苒蛅]),
					result  => q(zen),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([賿銭錢鏹]),
					result  => q(zeni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(荍),
					result  => q(zeniaoi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(缿),
					result  => q(zenigame),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([繈繦]),
					result  => q(zenisashi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(薇),
					result  => q(zenmai),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(屣),
					result  => q(zouri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([絝褲]),
					result  => q(zubon),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([甤蕤髄髓]),
					result  => q(zui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(螟),
					result  => q(zuimushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([冃幁幘幞幧裷]),
					result  => q(zukin),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(銑),
					result  => q(zuku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(狡),
					result  => q(zurui),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(橲),
					result  => q(zusa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([匰龕]),
					result  => q(zushi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(痟),
					result  => q(zutsuu),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
