SYNOPSIS
========

        use parent qw( Class );
        
        sub init
        {
            my $self = shift( @_ );
            return( $self->SUPER::init( @_ ) );
        }

Support for legacy code:

        package Foo;
        use Class;

        print CLASS;                  # Foo
        print "My class is $CLASS\n"; # My class is Foo

        sub bar { 23 }

        print CLASS->bar;     # 23
        print $CLASS->bar;    # 23

VERSION
=======

        v1.1.2

DESCRIPTION
===========

This package inherits all its features from
[Module::Generic](https://metacpan.org/pod/Module::Generic){.perl-module}
and provides a generic framework of methods to inherit from and speed up
development.

It also provide support for legacy code whereby `CLASS` and `$CLASS` are
both synonyms for `__PACKAGE__`. Easier to type.

`$CLASS` has the additional benefit of working in strings.

`Class` is a constant, not a subroutine call. `$CLASS` is a plain
variable, it is not tied. There is no performance loss for using `Class`
over `__PACKAGE__` except the loading of the module. (Thanks Juerd)

SEE ALSO
========

[Class::Stack](https://metacpan.org/pod/Class::Stack){.perl-module},
[Class::String](https://metacpan.org/pod/Class::String){.perl-module},
[Class::Number](https://metacpan.org/pod/Class::Number){.perl-module},
[Class::Boolean](https://metacpan.org/pod/Class::Boolean){.perl-module},
[Class::Assoc](https://metacpan.org/pod/Class::Assoc){.perl-module},
[Class::File](https://metacpan.org/pod/Class::File){.perl-module},
[Class::DateTime](https://metacpan.org/pod/Class::DateTime){.perl-module},
[Class::Exception](https://metacpan.org/pod/Class::Exception){.perl-module},
[Class::Finfo](https://metacpan.org/pod/Class::Finfo){.perl-module},
[Class::NullChain](https://metacpan.org/pod/Class::NullChain){.perl-module}

AUTHOR
======

From February 2022 onward: Jacques Deguest
\<`jack@deguest.jp`{classes="ARRAY(0x55bf21363c30)"}\>

Michael G Schwern
\<`schwern@pobox.com`{classes="ARRAY(0x55bf213676a8)"}\>

COPYRIGHT & LICENSE
===================

Copyright (c) 2021 DEGUEST Pte. Ltd.

You can use, copy, modify and redistribute this package and associated
files under the same terms as Perl itself.
