# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153921;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-79]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            8|
            90
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [589]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2(?:
            [0-27-9]\\d|
            6
          )\\d{6,7}|
          2(?:
            1\\d|
            75
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            1[13-57-9]\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[16-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            6[235-9]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6499451", "Warkworth",
"6436529", "Westport",
"6434222", "Gore",
"6472625", "Opotiki",
"6472146", "Otorohanga",
"64790", "Taupo",
"643237", "Riverton\/Winton",
"6439020", "Gore",
"6473931", "Whangamata",
"649398", "Auckland\/Waiheke\ Island",
"6499878", "Warkworth",
"643260", "Christchurch",
"6436589", "Otautau",
"6434282", "Queenstown",
"6439869", "Blenheim",
"6432802", "Gore",
"6496013", "Whangarei",
"64737", "Taupo",
"647463", "Whakatane",
"6435699", "Amberley",
"6469282", "Mokau",
"6467779", "Masterton",
"6439729", "Fox\ Glacier",
"649392", "Auckland",
"6496995", "Maungaturoto",
"6439267", "Dunedin",
"64330", "Ashburton\/Akaroa\/Chatham\ Islands",
"6497772", "Kaitaia",
"6479848", "Te\ Kuiti",
"6435554", "Cromwell",
"6479029", "Waihi",
"6439344", "Timaru",
"6479421", "Tauranga",
"6474651", "Otorohanga",
"6472823", "Whakatane",
"643213", "Invercargill",
"6434404", "Alexandra",
"6499006", "Whangarei",
"6432628", "Ranfurly",
"64343", "Oamaru",
"6479857", "Opotiki",
"6465619", "Masterton",
"6472817", "Taupo",
"6437483", "Otautau",
"6479708", "Thames",
"6493208", "Helensville",
"6468887", "Gisborne",
"6462162", "Masterton",
"643682", "Timaru\/Waimate\/Fairlie",
"643908", "Ashburton",
"6436622", "Cheviot",
"6479714", "Huntly",
"6479005", "Tauranga",
"6493937", "Warkworth",
"6466018", "Napier",
"644890", "Wellington",
"6468827", "New\ Plymouth",
"6439876", "Roxburgh",
"6432641", "Franz\ Josef",
"6468813", "Taihape",
"6435563", "Queenstown",
"6466004", "Waipukurau",
"6433959", "Balclutha",
"647325", "Opotiki",
"6478082", "Tauranga",
"643956", "Timaru",
"6432224", "Invercargill",
"6436682", "Dunedin",
"647986", "Hamilton",
"6436505", "Culverden",
"6472609", "Whangamata",
"6499478", "Pukekohe",
"644203", "Wellington",
"6435668", "Kurow",
"6478994", "Tauranga",
"6469305", "New\ Plymouth",
"6463903", "Ruatoria",
"6439008", "Timaru",
"6439061", "Greymouth",
"6439521", "Dunedin",
"6432742", "Twizel",
"646843", "Napier\/Hastings",
"643221", "Invercargill",
"6439014", "Ashburton",
"6439705", "Motueka",
"643925", "Christchurch",
"647889", "Morrinsville",
"6499819", "Helensville",
"6466526", "Waiouru",
"6469200", "Gisborne",
"6436523", "Hokitika",
"6432748", "Cromwell",
"646387", "Waiouru",
"643758", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6436517", "Motueka",
"6439002", "Rangiora",
"6463991", "Masterton",
"6435693", "Nelson",
"6463925", "Waiouru",
"6432757", "Lumsden",
"6439326", "Rangiora",
"6439717", "Fairlie",
"6435662", "Geraldine",
"6439863", "Motueka",
"6436583", "Te\ Anau",
"6499472", "Great\ Barrier\ Island",
"643660", "Christchurch",
"643752", "Franz\ Josef",
"6439454", "Lumsden",
"6469241", "Napier",
"647211", "Hamilton",
"6439723", "Blenheim",
"6469317", "Pahiatua",
"6434241", "Rangiora",
"6437776", "Cromwell",
"6467773", "Wanganui",
"643457", "Dunedin",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"64325", "South\ Island",
"646830", "Napier",
"6433911", "Nelson",
"643248", "Lumsden",
"6442198", "Paraparaumu",
"6435881", "Dunedin",
"6475950", "Hamilton",
"6498900", "Pukekohe",
"6478077", "Waihi",
"6436628", "Ashburton",
"6465627", "Levin",
"6472829", "Tauranga",
"6437489", "South\ Island",
"6465613", "Wairoa",
"6462168", "Featherston",
"643461", "Dunedin\/Palmerston",
"6462101", "Levin",
"6478144", "Tauranga",
"6472124", "Matamata",
"6472133", "Taupo",
"6495530", "Great\ Barrier\ Island",
"64757", "Tauranga",
"6432622", "Balclutha",
"64483", "Wellington",
"6466555", "Hawera",
"6469570", "Palmerston\ North",
"6472429", "Whakatane",
"643276", "South\ Island",
"6472805", "Morrinsville",
"6436641", "Lawrence",
"643288", "Christchurch",
"64931", "Auckland\/Waiheke\ Island",
"643420", "Christchurch",
"6479842", "Matamata",
"6497778", "Pukekohe",
"6435545", "Gore",
"6433953", "Geraldine",
"6468819", "Mokau",
"6439734", "Edendale",
"6432814", "Mt\ Cook",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"6472603", "Hamilton",
"6434277", "Ranfurly",
"649459", "Whangarei",
"6477880", "Hamilton",
"6469277", "Gisborne",
"6432721", "Motueka",
"6499011", "Kaitaia",
"6469288", "Waiouru",
"6432808", "Westport",
"6469610", "Wanganui",
"6434288", "Cromwell",
"6499064", "Helensville",
"6432420", "Christchurch",
"646214", "Gisborne",
"644975", "Paraparaumu",
"649470", "Whangarei",
"6466990", "Mokau",
"64378", "Westport",
"6434228", "Tokanui",
"6463941", "Masterton",
"6469619", "Wanganui\/New\ Plymouth",
"6496511", "Whangarei",
"6432429", "Timaru",
"64357", "Blenheim",
"644810", "Wellington",
"6477889", "Whakatane",
"6472622", "Tauranga",
"647884", "Morrinsville",
"644905", "Paraparaumu",
"649400", "Kaikohe",
"6434225", "Edendale",
"6436656", "Hokitika",
"646765", "Stratford",
"6434291", "Westport",
"6466999", "New\ Plymouth",
"643447", "Alexandra",
"643742", "Dunedin",
"6469291", "Gisborne",
"646841", "Napier\ City",
"6469285", "Hawera",
"6432805", "Winton",
"6492831", "Maungaturoto",
"6432996", "Riverton",
"6463900", "Gisborne",
"6434285", "Cheviot",
"6472808", "Putaruru\/Tokoroa",
"6472119", "Thames",
"6472420", "Hamilton",
"6469579", "Pahiatua",
"6434407", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6449031", "Paraparaumu",
"6497775", "Helensville",
"6472814", "Putaruru\/Tokoroa",
"6435548", "Westport",
"6479854", "Rotorua",
"6462606", "Waiouru",
"6496992", "Kawakawa",
"643595", "Christchurch",
"6435560", "Mt\ Cook",
"643206", "Edendale",
"6468810", "Ohakune",
"646320", "Palmerston\ North\/Marton",
"6439347", "Christchurch",
"6466558", "Opunake",
"6437461", "Fairlie",
"6435557", "Geraldine",
"6479002", "Matamata",
"6468824", "Wanganui",
"6436625", "Rangiora",
"643525", "Takaka",
"6462165", "Stratford",
"6432227", "Queenstown",
"6466007", "Stratford",
"6462149", "Ruatoria",
"64328", "South\ Island",
"6437480", "Gore",
"6436685", "Nelson",
"6478085", "Tauranga",
"6468884", "Palmerston\ North",
"6477776", "Whangamata",
"643211", "Invercargill",
"644551", "Paraparaumu",
"6493934", "Kaitaia",
"6479717", "Otorohanga",
"6472820", "Hamilton",
"6478091", "Matamata",
"6463928", "Pahiatua",
"647870", "Te\ Awamutu",
"6434991", "Cromwell",
"6439023", "Te\ Anau",
"6439017", "Cromwell",
"6436502", "Amberley",
"6432889", "Blenheim",
"6499810", "Hibiscus\ Coast",
"6439702", "Nelson",
"6475616", "Whangamata",
"647315", "Opotiki",
"6475821", "Hamilton",
"6439083", "Cheviot",
"6432745", "Roxburgh",
"6496010", "Kaitaia",
"6478997", "Morrinsville",
"6469302", "Napier",
"6462426", "Levin",
"6432423", "Dunedin",
"64452", "Wellington",
"6469308", "Opunake",
"6432656", "Nelson",
"6439714", "Waimate",
"6469613", "Levin",
"6432754", "Tokanui",
"6439005", "Invercargill",
"6469314", "Waiouru",
"6439457", "Winton",
"6499551", "Whangarei",
"6439761", "Kurow",
"6477883", "Hamilton",
"6472196", "Taupo",
"6439708", "Murchison",
"6472600", "Hamilton",
"6439881", "Greymouth",
"6436508", "Rangiora",
"6472224", "Taupo",
"6466993", "Waiouru",
"6436996", "Takaka",
"6436561", "Oamaru",
"6499475", "Hibiscus\ Coast",
"6463922", "Palmerston\ North",
"646590", "Palmerston\ North",
"6435665", "Waimate",
"644887", "Wellington",
"6466015", "Napier",
"6465624", "Featherston",
"64364", "South\ Island",
"6469573", "Palmerston\ North",
"6475601", "Hamilton",
"6474639", "Opotiki",
"6472127", "Paeroa",
"6432609", "Mt\ Cook",
"6495533", "Whangarei",
"6472130", "Tauranga",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6479014", "Matamata",
"647925", "Tauranga",
"643978", "Christchurch",
"6478074", "Taumarunui",
"647866", "Thames",
"6479008", "Rotorua",
"643438", "Kurow",
"6479020", "Te\ Awamutu",
"6466552", "New\ Plymouth",
"6432625", "Twizel",
"6496998", "Helensville",
"643946", "Invercargill",
"6435542", "Riverton",
"6465610", "Napier",
"646963", "Wanganui\/New\ Plymouth",
"6479845", "Paeroa",
"64368", "Timaru",
"64337", "Christchurch",
"643463", "Palmerston",
"6472802", "Paeroa",
"6499875", "Dargaville",
"6439029", "Tokanui",
"6436520", "Greymouth",
"6469203", "New\ Plymouth",
"644245", "Wellington",
"64730", "Whakatane",
"6498815", "Helensville",
"6469274", "New\ Plymouth",
"6467770", "Gisborne",
"6439720", "Blenheim",
"6472628", "Taupo",
"6439857", "Akaroa",
"6434274", "Kurow",
"6432817", "Christchurch",
"6439737", "Tokanui",
"6468261", "Masterton",
"647213", "Hamilton",
"6436580", "Invercargill",
"6499067", "Pukekohe",
"64932", "Auckland\/Waiheke\ Island",
"643410", "Balclutha\/Milton",
"6439860", "Nelson",
"6435690", "Motueka",
"6462611", "Napier",
"6439336", "Cromwell",
"6499063", "Hibiscus\ Coast",
"6478999", "Hamilton",
"6432750", "Invercargill",
"6439710", "Timaru",
"649552", "Pukekohe",
"643753", "Hokitika",
"6469310", "Wanganui",
"6462621", "New\ Plymouth",
"6472604", "Hamilton",
"6439853", "Amberley",
"6462816", "Gisborne",
"6432813", "Geraldine",
"6439733", "Te\ Anau",
"6432887", "Nelson",
"6479292", "Hamilton",
"643334", "Christchurch",
"6439019", "Roxburgh",
"6472220", "Tauranga",
"6498825", "Maungaturoto",
"646374", "Dannevirke",
"6465620", "New\ Plymouth",
"6436638", "Kurow",
"644393", "Paraparaumu",
"6479719", "Te\ Kuiti",
"6462158", "Opunake",
"643243", "Tokanui\/Lumsden\/Te\ Anau",
"6495561", "Whangarei",
"6466009", "Waiouru",
"6433954", "Lawrence",
"6432229", "Dunedin",
"6479010", "Thames",
"6478070", "Morrinsville",
"6437475", "Palmerston",
"6432615", "Amberley",
"6468802", "New\ Plymouth",
"6435559", "Haast",
"6433992", "Riverton",
"6439349", "South\ Island",
"647824", "Hamilton",
"6469001", "New\ Plymouth",
"646860", "Gisborne\/Ruatoria",
"643651", "Nelson",
"6472123", "Morrinsville",
"6466549", "Ruatoria",
"646837", "Wairoa",
"6465614", "Wanganui",
"6478143", "Opotiki",
"6498856", "Maungaturoto",
"6432632", "Lumsden",
"6434409", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6469577", "Ohakune",
"6469040", "Wairoa",
"649429", "Great\ Barrier\ Island",
"6465608", "Dannevirke",
"6468307", "Napier\/Wairoa",
"6474441", "Waihi",
"6435998", "Rangiora",
"64329", "South\ Island",
"643450", "Queenstown",
"6435506", "Amberley",
"6463912", "New\ Plymouth",
"6436524", "Hokitika",
"643667", "Christchurch",
"646950", "Palmerston\ North\/New\ Plymouth",
"6466997", "New\ Plymouth",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6439724", "Blenheim",
"6467774", "Dannevirke",
"6469270", "Marton",
"6439453", "Te\ Anau",
"643939", "South\ Island",
"6477887", "Te\ Awamutu",
"6462416", "Waipukurau",
"6434270", "Oamaru",
"6432731", "Timaru",
"6432427", "Greymouth",
"6436584", "Winton",
"6492008", "Hibiscus\ Coast",
"6435694", "Franz\ Josef",
"6469617", "Wanganui\/New\ Plymouth",
"6439072", "Ashburton",
"6439864", "Takaka",
"6437446", "Franz\ Josef",
"6439078", "Ashburton",
"6478993", "Waihi",
"6499045", "Hibiscus\ Coast",
"6499069", "Pukekohe",
"647462", "Taupo",
"6475626", "Taupo",
"6473995", "Putaruru\/Tokoroa",
"6499748", "Whangarei",
"6432819", "Christchurch",
"6439739", "Invercargill",
"6439859", "Christchurch\/Blenheim\/Nelson",
"64362", "South\ Island",
"6434232", "Ashburton",
"6479245", "Matamata",
"6439013", "Ashburton",
"6469016", "Ohakune",
"6463918", "Wanganui",
"6478136", "Te\ Awamutu",
"6435992", "Fox\ Glacier",
"6473921", "Matamata",
"6435671", "Oamaru",
"6463904", "Napier",
"6439027", "Winton",
"64371", "South\ Island",
"6499461", "Whangarei",
"6465602", "Palmerston\ North",
"6479713", "Morrinsville",
"643212", "Invercargill",
"644897", "Wellington",
"6472424", "Tauranga",
"6479850", "Tokoroa",
"6432638", "Tokanui",
"6472810", "Tauranga",
"643218", "Invercargill",
"6462226", "Napier",
"6432223", "Akaroa",
"6468814", "Dannevirke",
"6468246", "Hawera",
"6436615", "Ashburton",
"6466003", "Ruatoria",
"64938", "Auckland\/Waiheke\ Island",
"6439096", "Ashburton",
"6433998", "Lumsden",
"6435511", "Kaikoura",
"6468808", "Palmerston\ North",
"643955", "Dunedin",
"6468820", "Palmerston\ North",
"6439343", "Waimate",
"6433945", "Cheviot",
"6435553", "Wanaka",
"6498016", "Hibiscus\ Coast",
"64934", "Auckland\/Waiheke\ Island",
"643903", "Christchurch",
"6439746", "Dunedin",
"6468880", "Napier\/Hastings",
"6437484", "Riverton",
"6432607", "Dunedin",
"6436546", "Fairlie",
"6472129", "Whangamata",
"6474637", "Opotiki",
"6439295", "Nelson",
"6479751", "Tauranga",
"6462801", "Palmerston\ North",
"6493930", "Whangarei",
"6462152", "New\ Plymouth",
"6439281", "Christchurch",
"6436632", "Murchison",
"6434403", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"643926", "Christchurch",
"6499420", "Pukekohe",
"643741", "Christchurch",
"64369", "Geraldine",
"6439531", "Timaru",
"643267", "South\ Island",
"6479298", "Taupo",
"646842", "Napier\/Hastings",
"6496008", "Hibiscus\ Coast",
"64685", "Waipukurau",
"643230", "Invercargill",
"6439459", "Tokanui",
"6473948", "Opotiki",
"6472612", "Te\ Awamutu",
"6496014", "Dargaville",
"644202", "Wellington",
"6498", "Auckland",
"646848", "Napier\ City",
"647903", "Hamilton",
"6479746", "Opotiki",
"6498882", "Whangarei",
"643417", "Milton",
"6473945", "Tauranga",
"6439751", "Culverden",
"6432711", "Akaroa",
"6498822", "Kaikohe",
"6434273", "Lawrence",
"6472607", "Paeroa",
"6439450", "Invercargill",
"6434351", "Mt\ Cook",
"6432666", "South\ Island",
"6479295", "Whakatane",
"6439276", "Nelson",
"6469273", "New\ Plymouth",
"647865", "Whangamata",
"6433957", "Palmerston",
"6462144", "Ruatoria",
"6439298", "Motueka",
"6442821", "Wellington",
"649958", "Helensville",
"647926", "Tauranga",
"643653", "Blenheim",
"6493939", "Auckland",
"64636", "Levin",
"6433948", "Kaikoura",
"6432612", "Rangiora",
"6437472", "Lawrence",
"6439046", "Kurow",
"6478140", "Rotorua",
"6468889", "Levin",
"6472120", "Putaruru\/Tokoroa",
"6472819", "Rotorua",
"6433981", "Twizel",
"6465617", "Mokau",
"6479859", "Tauranga",
"64935", "Auckland",
"6436618", "Blenheim",
"646962", "Wanganui\/New\ Plymouth",
"643539", "Nelson",
"6468996", "Napier",
"6465623", "Opunake",
"6433995", "Tokanui",
"643462", "Dunedin\/Palmerston",
"643241", "Tokanui\/Lumsden\/Te\ Anau",
"649348", "Auckland",
"6469574", "Taihape",
"6468805", "Wanganui",
"6479027", "Paeroa",
"644576", "Wellington",
"6478073", "Putaruru\/Tokoroa",
"6432635", "Riverton",
"646968", "New\ Plymouth\ W100",
"6436596", "Queenstown",
"64998", "Whangarei",
"643468", "Dunedin",
"6435686", "Gore",
"6439269", "Dunedin",
"6477884", "Tauranga",
"6499296", "Kaitaia",
"6436578", "Wanaka",
"6439850", "Ashburton",
"6479248", "Rotorua\/Whakatane\/Tauranga",
"6432810", "Franz\ Josef",
"6439730", "Invercargill",
"6469313", "Marton",
"6439316", "Edendale",
"6439727", "Dunedin",
"6463915", "Opunake",
"6467777", "Napier",
"6432753", "Winton",
"6469614", "Levin",
"6435697", "Westport",
"6468251", "Wanganui",
"6469716", "Opunake",
"6439713", "Mt\ Cook",
"6439867", "Christchurch\/Blenheim\/Nelson",
"6436587", "Gore",
"643751", "Fox\ Glacier",
"6499060", "Warkworth",
"6432424", "Nelson",
"643571", "Nelson",
"6439075", "Takaka",
"6499048", "Pukekohe",
"6468304", "Napier\/Wairoa",
"6473998", "Taumarunui",
"6472223", "Hamilton",
"647218", "Tauranga",
"6466994", "Ohakune",
"643396", "South\ Island",
"6436527", "Haast",
"643743", "Christchurch",
"643409", "Queenstown",
"6473992", "Opotiki",
"6463907", "Waipukurau",
"6439024", "Lumsden",
"6499042", "Hibiscus\ Coast",
"646766", "New\ Plymouth",
"6499423", "Great\ Barrier\ Island",
"644906", "Paraparaumu",
"647877", "Te\ Kuiti",
"6439084", "Amberley",
"6435995", "Darfield",
"6469279", "Levin",
"6462126", "Pahiatua",
"643339", "Christchurch",
"6479242", "Rotorua",
"6434279", "Twizel",
"6434235", "Akaroa",
"643480", "Dunedin\/Lawrence\/Mosgiel",
"6468817", "Stratford",
"6437451", "Blenheim",
"6495589", "Pukekohe",
"6435550", "Fox\ Glacier",
"6439340", "Mt\ Cook",
"6468823", "Napier\/Hastings",
"6465605", "Marton",
"6434400", "Alexandra",
"6472427", "Rotorua",
"64372", "South\ Island",
"6493933", "Kaikohe",
"64361", "Timaru",
"6436612", "Akaroa",
"6468883", "Palmerston\ North",
"64379", "South\ Island",
"6479853", "Putaruru",
"6472813", "Waihi",
"6437487", "Winton",
"647829", "Hamilton",
"6472827", "Tauranga",
"6437478", "Twizel",
"646327", "Marton",
"6432618", "Culverden",
"6479710", "Putaruru\/Tokoroa",
"6433942", "Akaroa",
"6478079", "Hamilton",
"649424", "Hibiscus\ Coast",
"6436635", "Fairlie",
"6432446", "Blenheim",
"6462155", "Hawera",
"6466000", "Napier",
"647334", "Rotorua",
"6439292", "Timaru",
"6435531", "Nelson",
"6434266", "Palmerston",
"643526", "Motueka",
"6432220", "Dunedin",
"6479019", "Whangamata",
"6469319", "Masterton",
"649391", "Auckland",
"6478990", "Thames",
"646654", "Gisborne",
"6496017", "Great\ Barrier\ Island",
"6439719", "Waimate",
"6432759", "South\ Island",
"6436519", "Takaka",
"6472615", "Te\ Kuiti",
"649407", "Kaikohe",
"644817", "Wellington",
"6439010", "Queenstown",
"6473996", "Otorohanga",
"6475625", "Rotorua",
"6435517", "Lawrence",
"6499046", "Pukekohe",
"6437454", "Ashburton",
"6462122", "Palmerston\ North",
"6439318", "Lumsden",
"6478135", "Te\ Kuiti",
"6479246", "Thames",
"6499298", "Pukekohe",
"6436576", "Cromwell",
"643958", "Dunedin\/Timaru",
"6479420", "Tauranga",
"6478093", "Rotorua",
"6474650", "Morrinsville",
"6473930", "Waihi",
"6499467", "Kaitaia",
"6439021", "Ashburton",
"6473927", "Te\ Kuiti",
"643923", "Nelson",
"6435677", "Ranfurly",
"6434993", "Alexandra",
"646845", "Napier\/Hastings",
"647988", "Rotorua",
"6435688", "Queenstown",
"6499450", "Warkworth",
"6436598", "Wanaka",
"646761", "Opunake",
"644205", "Wellington",
"6475823", "Hamilton",
"6436616", "Geraldine",
"6468245", "Wairoa",
"6468269", "New\ Plymouth",
"64734", "Rotorua",
"6462225", "Levin",
"647982", "Hamilton",
"6462619", "Featherston",
"6439095", "Ashburton",
"6444888", "Paraparaumu",
"6468998", "Napier",
"6496513", "Whangarei",
"6439048", "Lawrence",
"6463943", "Masterton",
"643419", "Balclutha",
"6433946", "Culverden",
"6439745", "Greymouth",
"649396", "Auckland\/Waiheke\ Island",
"64738", "Taupo",
"6499559", "Whangarei",
"6439769", "Roxburgh",
"6439296", "Invercargill",
"64795", "Hamilton",
"6469293", "New\ Plymouth",
"6494313", "Warkworth",
"6439889", "Christchurch\/Blenheim\/Nelson",
"6434293", "Haast",
"6434262", "Alexandra",
"6499727", "Whangarei",
"6439057", "Waimate",
"6436569", "Alexandra",
"6492833", "Warkworth",
"6432442", "Christchurch",
"6439537", "Dunedin\/Timaru",
"6439520", "Dunedin",
"6439060", "Greymouth",
"644894", "Wellington",
"6462807", "Napier\/Hastings",
"6475609", "Paeroa",
"6439287", "Oamaru",
"644555", "Wellington",
"643215", "Invercargill",
"646365", "Palmerston\ North",
"6439278", "Invercargill",
"6432668", "Blenheim",
"6432640", "Hokitika",
"6435534", "Takaka",
"6479748", "Taumarunui",
"64335", "Christchurch",
"6479045", "Taumarunui",
"6437463", "Mt\ Cook",
"64360", "South\ Island",
"643521", "Nelson",
"647827", "Hamilton",
"6498901", "Pukekohe",
"6442129", "Paraparaumu",
"6439335", "Haast",
"6435880", "Dunedin",
"6435529", "Roxburgh",
"643278", "South\ Island",
"6462815", "Wairoa",
"647921", "Rotorua",
"6433910", "Nelson",
"6466579", "Featherston",
"6462100", "Levin",
"6432662", "Christchurch",
"6495567", "Kaitaia",
"6439272", "Timaru",
"6498826", "Warkworth",
"6434999", "Dunedin",
"6463990", "Featherston",
"6432448", "Dunedin",
"64377", "South\ Island",
"6434268", "Roxburgh",
"6469201", "Ruatoria",
"644281", "Wellington",
"6469240", "Gisborne",
"644819", "Wellington",
"6468263", "Napier",
"6434240", "Ashburton",
"6475829", "Hamilton",
"649409", "Kaitaia",
"6462627", "Wanganui",
"6432616", "Ashburton",
"6462613", "Waipukurau",
"6439754", "Darfield",
"6432714", "Cheviot",
"6439042", "Oamaru",
"6437476", "Ranfurly",
"6469611", "Wanganui",
"6468992", "Wairoa",
"6468254", "Ohakune",
"6432421", "Tokanui\/Lumsden\/Te\ Anau",
"6496519", "Maungaturoto",
"6499553", "Kaikohe",
"6439763", "Palmerston",
"6477881", "Hamilton",
"6432737", "Palmerston",
"6499010", "Kaitaia",
"643576", "Nelson",
"643756", "Hokitika",
"6432720", "Nelson",
"6498855", "Kawakawa",
"643337", "Christchurch",
"6436563", "Lawrence",
"6436592", "Nelson",
"6466991", "Wanganui",
"6434299", "Haast",
"6439883", "Hokitika",
"6435682", "Riverton",
"6469299", "Napier\/Hastings",
"647879", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6474447", "Te\ Kuiti",
"6492839", "Whangarei",
"6499719", "Whangarei",
"6469712", "New\ Plymouth",
"64754", "Tauranga",
"6475603", "Hamilton",
"6469571", "Palmerston\ North",
"6433984", "Roxburgh",
"6495531", "Helensville",
"643246", "Tokanui",
"6462128", "Ohakune",
"6435505", "Akaroa",
"6439312", "Riverton",
"64320", "Gore",
"644571", "Wellington",
"6436640", "Palmerston",
"6437445", "Fox\ Glacier",
"6469007", "Masterton",
"6493942", "Great\ Barrier\ Island",
"647552", "Tauranga",
"6437469", "Alexandra",
"6449030", "Paraparaumu",
"6462418", "Palmerston\ North",
"6492229", "Hibiscus\ Coast",
"6437448", "Haast",
"6492006", "Helensville",
"6475622", "Tauranga",
"6436649", "Gore",
"649427", "Hibiscus\ Coast",
"647391", "Hamilton",
"6435514", "Palmerston",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"6434236", "Amberley",
"643523", "Murchison",
"6469012", "Waiouru",
"6468811", "Marton",
"6462125", "Taihape",
"6432643", "Haast",
"6435508", "Cheviot",
"6478132", "Paeroa",
"6435996", "Akaroa",
"6437457", "Darfield",
"6435561", "Dunedin",
"643669", "Christchurch",
"6498858", "Kaikohe",
"6432729", "Westport",
"6499019", "Maungaturoto",
"6465606", "Waiouru",
"6463940", "Levin",
"64354", "Nelson",
"6496510", "Whangarei",
"646657", "Masterton",
"6435674", "Milton",
"6473924", "Paeroa",
"6439523", "Balclutha",
"6439063", "Westport",
"6439092", "Rangiora",
"643552", "Dunedin",
"6463901", "Gisborne",
"6499464", "Whangarei",
"643937", "South\ Island",
"649404", "Kawakawa",
"6444", "Wellington",
"644212", "Wellington",
"647880", "Matamata",
"6462222", "Ohakune",
"6434290", "Greymouth",
"6499733", "Warkworth",
"6468242", "Ruatoria",
"6469290", "Napier\/Hastings",
"643225", "Otautau",
"643921", "Blenheim",
"6499453", "Warkworth",
"6499811", "Hibiscus\ Coast",
"6439742", "Christchurch",
"6434990", "Queenstown",
"6492427", "Warkworth",
"646763", "Opunake",
"6463999", "Palmerston\ North",
"6473933", "Rotorua",
"6439534", "Mt\ Cook",
"6462156", "Hawera",
"6432445", "Greymouth",
"6436636", "Waimate",
"6473338", "Rotorua",
"647874", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6469249", "Masterton",
"6434265", "Milton",
"64370", "South\ Island",
"6434249", "Kaikoura",
"6475820", "Hamilton",
"6433919", "Haast",
"6435537", "Winton",
"649431", "Maungaturoto",
"6435889", "Timaru",
"6479754", "Tauranga",
"6472616", "Taumarunui",
"6462804", "Palmerston\ North",
"6439284", "Blenheim",
"6474653", "Putaruru\/Tokoroa",
"6478090", "Thames",
"6439338", "Queenstown",
"6472821", "Hamilton",
"6462109", "Waiouru",
"6472457", "Rotorua",
"6437481", "Invercargill",
"6462818", "New\ Plymouth",
"64367", "South\ Island",
"646965", "Wanganui\ W100",
"6462812", "Napier\/Hastings",
"6472131", "Rotorua",
"6469852", "Napier",
"6495564", "Whangarei",
"64338", "Christchurch",
"643942", "Christchurch",
"643465", "Palmerston",
"6439332", "Hokitika",
"6475600", "Hamilton",
"6473946", "Taupo",
"643948", "Invercargill",
"6436643", "Balclutha",
"6433951", "Timaru",
"6439275", "Nelson",
"6479296", "Tauranga",
"6432649", "Waimate",
"6432665", "South\ Island",
"6499013", "Kawakawa",
"6462624", "Opunake",
"647215", "Rotorua",
"6432723", "Takaka",
"6436548", "Waimate",
"6472601", "Hamilton",
"6439760", "Twizel",
"6473332", "Rotorua",
"643269", "South\ Island",
"6432717", "Kaikoura",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6439045", "Twizel",
"6439529", "Palmerston",
"6439069", "Haast",
"6479230", "Opotiki",
"6439748", "Dunedin",
"64735", "Rotorua",
"6439880", "Greymouth",
"6436560", "Palmerston",
"643393", "Christchurch",
"6498018", "Whangarei",
"6499459", "Maungaturoto",
"6468248", "New\ Plymouth",
"6436521", "Greymouth",
"6462228", "Wanganui",
"6468806", "New\ Plymouth",
"643414", "Balclutha\/Milton",
"6463993", "Pahiatua",
"6433996", "Edendale",
"6439098", "Akaroa",
"6468995", "Napier",
"6474444", "Hamilton",
"6436581", "Invercargill",
"6468257", "Taihape",
"6462610", "Napier",
"6435691", "Murchison",
"6439861", "Nelson",
"6439721", "Blenheim",
"6435685", "Tokanui",
"6467771", "New\ Plymouth",
"6434243", "Akaroa",
"6436595", "Mt\ Cook",
"6468260", "Featherston",
"6432636", "Te\ Anau",
"6498852", "Warkworth",
"6432734", "Waimate",
"6469243", "New\ Plymouth",
"6478138", "Waihi",
"6463916", "Mokau",
"6433913", "Murchison",
"6435502", "Christchurch",
"6439315", "Tokanui",
"6499295", "Kaikohe",
"6435883", "Dunedin",
"6479021", "Te\ Awamutu",
"647862", "Paeroa",
"6469715", "Mokau",
"6469004", "Napier\/Hastings",
"647923", "Whakatane",
"6475628", "Tauranga",
"6474659", "Whangamata",
"64429", "Paraparaumu",
"6439076", "Ashburton",
"6437442", "Murchison",
"643436", "Kurow",
"647868", "Thames",
"6465611", "Napier",
"6462412", "Gisborne",
"6433987", "Cromwell",
"6499746", "Kawakawa",
"64334", "Christchurch",
"643982", "Christchurch",
"6462103", "Levin",
"6466525", "Marton",
"6472192", "Whakatane",
"6475618", "Opotiki",
"6495560", "Whangarei",
"6433983", "Ranfurly",
"6472459", "Rotorua",
"6462107", "Dannevirke",
"6465621", "New\ Plymouth",
"6462422", "Napier\/Hastings",
"643981", "Christchurch",
"64391", "South\ Island",
"6432652", "Cromwell",
"6475604", "Hamilton",
"6435887", "Invercargill",
"6478071", "Otorohanga",
"6439325", "Kaikoura",
"6463926", "Taihape",
"6435539", "Otautau",
"6437775", "Wanaka",
"6433917", "Franz\ Josef",
"647861", "Paeroa\/Waihi\/Thames\/Whangamata",
"6436992", "Greymouth",
"6469311", "Palmerston\ North",
"6462620", "New\ Plymouth",
"6477778", "Te\ Awamutu",
"6434247", "Kaikoura",
"6439764", "Lawrence",
"6499554", "Kaitaia",
"6469247", "Wanganui",
"6468253", "Marton",
"6439711", "Geraldine",
"6432751", "Riverton",
"64731", "Whakatane\/Opotiki",
"6463997", "Palmerston\ North",
"6492429", "Pukekohe",
"6442609", "Paraparaumu",
"6439884", "Franz\ Josef",
"6472221", "Tauranga",
"6436564", "Milton",
"6474440", "Paeroa",
"6466556", "Stratford",
"643755", "Hokitika",
"6432713", "Ashburton",
"6472806", "Matamata",
"6462614", "Wairoa",
"6439753", "Amberley",
"6469271", "Pahiatua",
"646954", "Palmerston\ North\ W100",
"6499017", "Kaikohe",
"6432727", "Fox\ Glacier",
"646949", "Levin\ W100",
"6432730", "Blenheim",
"6434271", "Balclutha",
"643454", "Dunedin",
"6462608", "Dannevirke",
"6435546", "Greymouth",
"6468264", "Palmerston\ North",
"6434353", "Twizel",
"643449", "Alexandra",
"6437459", "Rangiora",
"6466509", "Napier\/Waipukurau",
"6432998", "Tokanui",
"6469000", "New\ Plymouth",
"6436647", "Te\ Anau",
"646864", "Ruatoria",
"647820", "Hamilton\/Huntly",
"643941", "Christchurch",
"643245", "Tokanui\/Lumsden\/Te\ Anau",
"6436658", "Fox\ Glacier",
"6492227", "Whangarei",
"6479108", "Whakatane",
"6462138", "Palmerston\ North",
"643685", "Fairlie",
"6433989", "Waimate",
"6472811", "Tauranga",
"6479102", "Rotorua",
"6479851", "Waihi",
"6472626", "Rotorua",
"6472145", "Huntly",
"6436652", "Winton",
"6474657", "Thames",
"649652", "Warkworth",
"6432992", "Gore",
"6437464", "Timaru",
"643905", "Ashburton",
"6435510", "Darfield",
"64783", "Hamilton",
"6474648", "Huntly",
"6442429", "Paraparaumu",
"6435533", "Murchison",
"6462602", "Palmerston\ North",
"647983", "Hamilton",
"6496508", "Hibiscus\ Coast",
"6496996", "Warkworth",
"6463944", "Featherston",
"6468259", "Levin",
"644595", "Wellington",
"6496514", "Whangarei",
"6473920", "Huntly",
"6435670", "Palmerston",
"6499460", "Whangarei",
"643922", "Nelson",
"6492834", "Kawakawa",
"646846", "Napier\ City",
"6434294", "Franz\ Josef",
"6494314", "Warkworth",
"6499457", "Kaitaia",
"6469294", "Palmerston\ North",
"6479229", "Opotiki",
"6439050", "Geraldine",
"643234", "Riverton",
"6439527", "Kurow",
"6439067", "Franz\ Josef",
"6434994", "Palmerston",
"6499421", "Hibiscus\ Coast",
"644211", "Wellington",
"6439530", "Timaru",
"64332", "Christchurch",
"6439759", "Cromwell",
"6439875", "Ranfurly",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"647466", "Tauranga",
"644889", "Wellington",
"649395", "Auckland\/Waiheke\ Island",
"6434359", "Twizel",
"6475824", "Hamilton",
"6477772", "Rotorua",
"6436998", "Blenheim",
"6436506", "Darfield",
"6432647", "Fairlie",
"6437453", "Amberley",
"6462115", "Wairoa",
"6468821", "Featherston",
"64937", "Auckland",
"6469022", "Hawera",
"6439280", "Nelson",
"6462800", "Palmerston\ North",
"6493931", "Whangarei",
"6432658", "Murchison",
"6479750", "Tauranga",
"6469306", "Hawera",
"6478094", "Tauranga",
"643216", "Invercargill",
"6439706", "Nelson",
"6475612", "Te\ Kuiti",
"6472198", "Opotiki",
"6468881", "Napier\/Hastings",
"646750", "Mokau",
"644572", "Wellington",
"6469003", "Napier\/Hastings",
"6439006", "Nelson",
"6432655", "Nelson",
"6435884", "Dunedin",
"64732", "Whakatane",
"6462425", "Masterton",
"647551", "Tauranga",
"6472195", "Rotorua",
"6442820", "Wellington",
"64943", "Whangarei",
"644586", "Wellington",
"6466522", "Palmerston\ North",
"6433914", "Takaka",
"6436995", "Westport",
"6462104", "Marton",
"6478141", "Taupo",
"6472121", "Te\ Kuiti",
"643943", "Christchurch",
"64930", "Auckland",
"6437772", "Timaru",
"6439322", "Culverden",
"6462118", "Waipukurau",
"6435666", "Oamaru",
"643466", "Dunedin",
"6439289", "Akaroa",
"6475607", "Morrinsville",
"6469893", "Ruatoria",
"6462809", "Napier\/Hastings",
"646966", "Wanganui\/New\ Plymouth",
"6439878", "Christchurch\/Blenheim\/Nelson",
"6474443", "Matamata",
"6439539", "Dunedin\/Timaru",
"6463994", "Dannevirke",
"6467525", "Mokau",
"6466016", "Napier",
"6436567", "Ranfurly",
"6439887", "Christchurch\/Blenheim\/Nelson",
"643392", "South\ Island",
"6499557", "Warkworth",
"6439767", "Alexandra",
"6493206", "Pukekohe",
"6434350", "Twizel",
"6439451", "Invercargill",
"6432733", "Geraldine",
"6434244", "Amberley",
"6432710", "Christchurch",
"6439750", "Kaikoura",
"647216", "Rotorua",
"6462617", "Masterton",
"6468250", "Stratford",
"6499008", "Pukekohe",
"6499061", "Hibiscus\ Coast",
"6432811", "Fox\ Glacier",
"6439731", "Gore",
"6439851", "Culverden",
"643239", "Invercargill",
"6432724", "Greymouth",
"6432626", "Kurow",
"6499014", "Dargaville",
"6462623", "Stratford",
"64399", "South\ Island",
"6473929", "Thames",
"6435679", "Alexandra",
"6499469", "Maungaturoto",
"6479846", "Taumarunui",
"64687", "Napier\/Hastings",
"643435", "Oamaru\/Mount\ Cook\/Twizel\/Kurow",
"6499876", "Kaikohe",
"6498816", "Great\ Barrier\ Island",
"6433980", "Milton",
"6495563", "Whangarei",
"6467556", "New\ Plymouth\/Mokau",
"647928", "Tauranga",
"643983", "Christchurch",
"649902", "Warkworth",
"6478128", "Huntly",
"6442420", "Wellington",
"6472148", "Waihi",
"643655", "Dunedin",
"647863", "Waihi",
"6436644", "Alexandra",
"6435519", "Twizel",
"647922", "Whakatane",
"6435551", "Franz\ Josef",
"6437467", "Queenstown",
"6469009", "Palmerston\ North",
"6439341", "Fairlie",
"6436655", "Westport",
"6437450", "Westport",
"643522", "Nelson",
"6434226", "Lumsden",
"644260", "Wellington",
"6472142", "Te\ Awamutu",
"6474654", "Taumarunui",
"6434401", "Cromwell",
"6432995", "Winton",
"6434286", "Christchurch",
"643528", "Motueka",
"6462803", "Palmerston\ North",
"6432806", "Edendale",
"6479753", "Taupo",
"6469468", "Featherston",
"6469286", "Dannevirke",
"6439283", "Rangiora",
"6499717", "Whangarei",
"6492837", "Hibiscus\ Coast",
"6473934", "Rotorua",
"6439533", "Geraldine",
"6474449", "Opotiki",
"6499454", "Whangarei",
"644213", "Wellington",
"6469297", "Masterton",
"6462605", "Marton",
"6434297", "Westport",
"6497776", "Hibiscus\ Coast",
"6432739", "Balclutha",
"647245", "Hamilton",
"6496517", "Kaitaia",
"647312", "Whakatane",
"647981", "Hamilton",
"6436626", "Akaroa",
"644902", "Paraparaumu",
"6478991", "Whangamata",
"646768", "New\ Plymouth",
"6462629", "Levin",
"6475827", "Hamilton",
"643930", "Christchurch",
"647887", "Morrinsville",
"6462166", "Opunake",
"643444", "Ranfurly",
"6477775", "Huntly",
"643459", "Dunedin\/Queenstown",
"6478086", "Hamilton",
"644908", "Paraparaumu",
"646959", "Palmerston\ North\/New\ Plymouth",
"6436686", "Invercargill",
"6439011", "Queenstown",
"6499463", "Whangarei",
"646762", "Stratford",
"646650", "Napier",
"6492808", "Great\ Barrier\ Island",
"6473923", "Otorohanga",
"6435673", "Lawrence",
"6434997", "Lawrence",
"6439872", "Alexandra",
"643226", "Otautau",
"6439524", "Oamaru",
"6439064", "Ashburton",
"6469025", "Mokau",
"6478097", "Whakatane",
"649420", "Helensville",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6479711", "Whangamata",
"6439328", "South\ Island",
"6437778", "Greymouth",
"6495569", "Maungaturoto",
"6449008", "Paraparaumu",
"6432746", "Alexandra",
"6466528", "Dannevirke",
"6435530", "Nelson",
"6432644", "Westport",
"6466001", "Napier",
"6475615", "Waihi",
"6435527", "Alexandra",
"6432221", "Nelson",
"6442127", "Paraparaumu",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"6443708", "Paraparaumu",
"643951", "Dunedin",
"646869", "Gisborne\/Ruatoria",
"6432621", "Oamaru",
"6439310", "Invercargill",
"6462813", "Wanganui",
"6439736", "Riverton",
"6432816", "Waimate",
"6439856", "Darfield",
"6469853", "Waiouru",
"6439333", "Franz\ Josef",
"6499066", "Helensville",
"6474658", "Waihi",
"6469710", "New\ Plymouth",
"6479841", "Huntly",
"6436642", "Milton",
"6478139", "Whangamata",
"6469019", "Pahiatua",
"6496507", "Helensville",
"6499012", "Kawakawa",
"6432722", "Murchison",
"6468990", "Ruatoria",
"6439099", "Kaikoura",
"647974", "Hamilton",
"6462615", "Gisborne",
"6435680", "Dunedin",
"6499458", "Kawakawa",
"6468249", "Opunake",
"6436590", "Nelson",
"64923", "Pukekohe",
"6439749", "Christchurch",
"646651", "Napier",
"649394", "Auckland",
"6439765", "Milton",
"6499555", "Kawakawa",
"6498019", "Pukekohe",
"6447771", "Paraparaumu",
"6463992", "Levin",
"6439528", "Lawrence",
"6439068", "Fox\ Glacier",
"6439001", "Christchurch",
"6439040", "Balclutha",
"6499471", "Hibiscus\ Coast",
"643235", "Invercargill",
"6435661", "Fairlie",
"647980", "Hamilton",
"6472126", "Otorohanga",
"6436549", "Mt\ Cook",
"6439885", "Fox\ Glacier",
"6434242", "Darfield",
"6436565", "Twizel",
"6469242", "Levin",
"6498853", "Whangarei",
"6466524", "Ohakune",
"6433912", "Motueka",
"6435503", "Christchurch",
"6432648", "Geraldine",
"6436997", "Motueka",
"643950", "Dunedin",
"6435882", "Dunedin",
"644896", "Wellington",
"6466011", "Marton",
"6475605", "Huntly",
"6479049", "Te\ Kuiti",
"643979", "Christchurch",
"6432657", "Motueka",
"6439324", "Darfield",
"6437443", "Nelson",
"6439270", "Greymouth",
"6437774", "Queenstown",
"6462413", "Gisborne",
"6472197", "Tauranga",
"6432660", "Christchurch",
"6439456", "Riverton",
"649421", "Hibiscus\ Coast",
"6462102", "Levin",
"6462108", "Ohakune",
"6475617", "Whakatane",
"6462819", "Levin",
"6462161", "Masterton",
"6436621", "Culverden",
"6462114", "Waipukurau",
"6478996", "Huntly",
"647823", "Hamilton",
"6439339", "South\ Island",
"6442125", "Paraparaumu",
"6475623", "Tauranga",
"64423", "Wellington",
"6478095", "Taupo",
"6435888", "Timaru",
"6478081", "Rotorua",
"6439016", "Alexandra",
"6436681", "Dunedin",
"6499631", "Pukekohe",
"6432642", "Fox\ Glacier",
"6478133", "Putaruru\/Tokoroa",
"6433918", "Fox\ Glacier",
"643666", "Christchurch",
"6434248", "Cheviot",
"6477777", "Hamilton",
"6434995", "Te\ Anau",
"6479716", "Waihi",
"6473339", "Taupo",
"6439062", "Ashburton",
"6439874", "Cromwell",
"6439522", "Dunedin",
"6439093", "Ashburton",
"6432440", "Christchurch",
"6463998", "Palmerston\ North",
"6432226", "Timaru",
"6462223", "Palmerston\ North",
"6434260", "Oamaru",
"6432741", "Milton",
"6499101", "Pukekohe",
"6468243", "Napier",
"6466006", "Opunake",
"64784", "Hamilton",
"6475825", "Hamilton",
"643749", "Christchurch",
"643754", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6434221", "Invercargill",
"6499452", "Warkworth",
"646903", "Palmerston\ North",
"6439743", "Christchurch",
"646955", "Palmerston\ North\/New\ Plymouth",
"6439346", "Christchurch",
"6496515", "Dargaville",
"6473932", "Rotorua",
"6435556", "Fairlie",
"643455", "Dunedin",
"6432801", "Lumsden",
"64396", "Christchurch",
"6469281", "Wairoa",
"646385", "Ohakune",
"6434406", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6492835", "Kaikohe",
"6434281", "Queenstown",
"6499004", "Hibiscus\ Coast",
"6498859", "Kaitaia",
"6462607", "Taihape",
"6434295", "Fox\ Glacier",
"6432728", "Haast",
"6499018", "Maungaturoto",
"6469295", "Wanganui",
"6494315", "Warkworth",
"6497771", "Kaikohe",
"6435509", "Culverden",
"6472144", "Matamata",
"6436648", "Lumsden",
"6432997", "Edendale",
"6437449", "Hokitika",
"64736", "Rotorua",
"6474652", "Paeroa",
"6479422", "Tauranga",
"643270", "Christchurch",
"6437465", "Waimate",
"6479107", "Whakatane",
"6462419", "Masterton",
"6462137", "Palmerston\ North",
"6462120", "Palmerston\ North",
"6492228", "Warkworth",
"6436657", "Franz\ Josef",
"6466551", "New\ Plymouth",
"644834", "Paraparaumu",
"6437468", "Wanaka",
"6492225", "Pukekohe",
"6435500", "Christchurch",
"6434276", "Palmerston",
"643527", "Motueka",
"6435541", "Te\ Anau",
"6432663", "Christchurch",
"6462410", "New\ Plymouth",
"6469276", "Wanganui",
"6439273", "Blenheim",
"6462129", "Waiouru",
"6437440", "Nelson",
"649423", "Warkworth",
"6436645", "Ranfurly",
"6472801", "Huntly",
"64796", "Hamilton",
"6496100", "Pukekohe",
"649458", "Dargaville",
"646653", "Wanganui",
"6499718", "Whangarei",
"6492838", "Pukekohe",
"6434298", "Hokitika",
"64944", "Auckland",
"6499015", "Dargaville",
"6432725", "Hokitika",
"6469298", "Masterton",
"644816", "Wellington",
"6498850", "Great\ Barrier\ Island",
"64785", "Hamilton",
"6468262", "Napier",
"649406", "Kaitaia",
"649452", "Auckland",
"6443990", "Paraparaumu",
"64336", "South\ Island",
"643485", "Lawrence",
"6439043", "Ashburton",
"6496518", "Kawakawa",
"6468993", "Taihape",
"643445", "Cromwell",
"646767", "New\ Plymouth\/Opunake\/Stratford",
"6465626", "Ruatoria",
"647888", "Matamata",
"6463995", "Marton",
"6499552", "Dargaville",
"6439762", "Oamaru",
"643759", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6475828", "Hamilton",
"6436562", "Balclutha",
"6434269", "Twizel",
"6436593", "Nelson",
"64948", "Auckland",
"644210", "Wellington",
"6439882", "Westport",
"6434245", "Culverden",
"6435683", "Te\ Anau",
"647882", "Putaruru\/Tokoroa",
"647876", "Te\ Kuiti",
"6434998", "Dunedin",
"6463921", "Palmerston\ North",
"6492807", "Helensville",
"6432449", "Queenstown",
"6478076", "Te\ Awamutu",
"6469713", "Stratford",
"6432654", "Blenheim",
"6439716", "Geraldine",
"6439327", "Ashburton",
"6432756", "Gore",
"6475602", "Hamilton",
"6462424", "Wanganui",
"6439330", "Westport",
"6435885", "Invercargill",
"6472194", "Whakatane",
"6462810", "Gisborne",
"6469850", "Napier",
"6433915", "Greymouth",
"6439313", "Te\ Anau",
"6469316", "Dannevirke",
"643249", "Te\ Anau",
"6437777", "Christchurch",
"6472226", "Te\ Kuiti",
"6462105", "Taihape",
"6435528", "Ranfurly",
"6436994", "Murchison",
"6466527", "Taihape",
"6493943", "Helensville",
"6442128", "Paraparaumu",
"6479001", "Hamilton",
"647860", "Paeroa\/Waihi\/Thames\/Whangamata",
"6462123", "Palmerston\ North",
"6435", "South\ Island",
"643980", "Christchurch",
"6432645", "Greymouth",
"6439279", "Christchurch",
"6432669", "Rangiora",
"6475614", "Thames",
"6479040", "Otorohanga",
"644577", "Wellington",
"6478092", "Huntly",
"6493990", "Great\ Barrier\ Island",
"6475608", "Otorohanga",
"643689", "Waimate",
"6468826", "Levin",
"6434992", "Ranfurly",
"6439877", "Christchurch\/Blenheim\/Nelson",
"6439740", "Christchurch",
"6439888", "Christchurch\/Blenheim\/Nelson",
"6436568", "Roxburgh",
"6436501", "Akaroa",
"646371", "Masterton\/Dannevirke\/Pahiatua",
"6477774", "Thames",
"6439701", "Nelson",
"6439768", "Ranfurly",
"6499558", "Great\ Barrier\ Island",
"6468886", "Wanganui",
"643397", "South\ Island",
"6469301", "Ruatoria",
"6439049", "Palmerston",
"6439065", "Ashburton",
"643331", "Christchurch",
"6439525", "Milton",
"6493936", "Maungaturoto",
"6496512", "Whangarei",
"6499007", "Kaikohe",
"6473935", "Rotorua",
"6463942", "Masterton",
"6462618", "Masterton",
"6444889", "Paraparaumu",
"643416", "Balclutha\/Milton",
"6468999", "Napier",
"647533", "Tauranga",
"6472621", "Tauranga",
"6499455", "Dargaville",
"649399", "Auckland",
"6468268", "New\ Plymouth",
"6472816", "Morrinsville",
"6479856", "Tauranga",
"6462604", "Ohakune",
"6435689", "Otautau",
"6469292", "Ruatoria",
"6494312", "Warkworth",
"6439266", "Dunedin",
"6434292", "Hokitika",
"6436599", "Blenheim",
"6462220", "New\ Plymouth",
"6434263", "Lawrence",
"6492832", "Dargaville",
"6432443", "Christchurch",
"6439090", "Rangiora",
"6475620", "Tauranga",
"643654", "Timaru",
"647927", "Tauranga",
"647821", "Hamilton\/Huntly",
"643940", "Christchurch",
"6439319", "Otautau",
"6496991", "Kaikohe",
"6436654", "Tokanui",
"6499299", "Whangarei",
"6478130", "Morrinsville",
"6472147", "Paeroa",
"6469010", "Taihape",
"649907", "Warkworth",
"6432994", "Otautau",
"6437462", "Geraldine",
"6474655", "Te\ Kuiti",
"6479500", "Whakatane",
"6469020", "Stratford",
"643277", "South\ Island",
"6443709", "Paraparaumu",
"6466529", "Pahiatua",
"6472143", "Morrinsville",
"647828", "Huntly",
"6435535", "Invercargill",
"6437779", "Invercargill",
"64733", "Rotorua\/Taupo",
"6495568", "Kawakawa",
"6475610", "Putaruru\/Tokoroa",
"6449741", "Paraparaumu",
"6436631", "Motueka",
"6462151", "New\ Plymouth",
"647822", "Hamilton\/Huntly",
"6462802", "Palmerston\ North",
"6479752", "Rotorua",
"6469869", "Ruatoria",
"6439282", "Christchurch",
"6439329", "South\ Island",
"6496016", "Warkworth",
"6432447", "Timaru",
"6439532", "Timaru",
"6492809", "Maungaturoto",
"6496", "Auckland",
"6439744", "Queenstown",
"6439052", "Mt\ Cook",
"6434267", "Ranfurly",
"64630", "Featherston",
"6462628", "Wanganui",
"6424", "Scott\ Base",
"6477770", "Tauranga",
"6437486", "Tokanui",
"64347", "Dunedin",
"6499003", "Warkworth",
"6472826", "Matamata",
"646213", "Wanganui",
"6472611", "Matamata",
"64697", "Napier",
"644650", "Wellington",
"643332", "Christchurch",
"6462600", "Palmerston\ North",
"6432738", "Oamaru",
"6468816", "Hawera",
"6468244", "Waipukurau",
"6435991", "Franz\ Josef",
"643456", "Dunedin",
"6434231", "Christchurch",
"646956", "Palmerston\ North\/New\ Plymouth",
"6462224", "Masterton",
"6499462", "Whangarei",
"643338", "Christchurch",
"649554", "Hibiscus\ Coast",
"647590", "Hamilton",
"6474448", "Taumarunui",
"6435672", "Balclutha",
"6473922", "Morrinsville",
"6439094", "Ashburton",
"6439873", "Wanaka",
"6475624", "Rotorua",
"6465601", "Palmerston\ North",
"647557", "Tauranga",
"6437455", "Cheviot",
"6436650", "Otautau",
"6462127", "Dannevirke",
"6479100", "Rotorua",
"6478134", "Taumarunui",
"643425", "Dunedin",
"6469014", "Dannevirke",
"6463906", "Napier",
"6432990", "Lumsden",
"6435512", "Rangiora",
"6469008", "Palmerston\ North",
"646866", "Gisborne\/Ruatoria",
"6469002", "Hawera",
"6435518", "Milton",
"6468801", "Wanganui",
"6433991", "Invercargill",
"647390", "Hamilton",
"649349", "Auckland",
"6433985", "Alexandra",
"6478129", "Matamata",
"6472149", "Whangamata",
"644589", "Wellington",
"6435504", "Christchurch",
"643538", "Nelson",
"6436526", "Fox\ Glacier",
"6466523", "Palmerston\ North",
"6499297", "Hibiscus\ Coast",
"6462414", "Napier",
"6498690", "Kawakawa",
"643957", "Timaru",
"6432631", "Gore",
"6439726", "Timaru",
"6439317", "Gore",
"6437773", "Dunedin",
"6467776", "Levin",
"6439323", "Cheviot",
"6435696", "Haast",
"643469", "Dunedin",
"6439866", "Christchurch\/Blenheim\/Nelson",
"6437444", "Takaka",
"6436586", "Edendale",
"646969", "New\ Plymouth",
"6492", "Auckland",
"644204", "Wellington",
"6473928", "Te\ Awamutu",
"647881", "Matamata",
"6474442", "Morrinsville",
"6468255", "Pahiatua",
"6435678", "Roxburgh",
"6499468", "Kawakawa",
"6479026", "Paeroa",
"6436597", "Cromwell",
"647987", "Tauranga",
"6463911", "New\ Plymouth",
"6435687", "Lumsden",
"6465616", "Hawera",
"6432732", "Fairlie",
"6498854", "Hibiscus\ Coast",
"646844", "Napier\/Hastings",
"6468997", "Napier",
"6444887", "Paraparaumu",
"6439071", "Motueka",
"644250", "Wellington",
"649451", "Auckland",
"6439047", "Alexandra",
"643236", "Winton",
"6499728", "Dargaville",
"6433956", "Dunedin",
"6479291", "Hamilton",
"6439879", "Christchurch\/Blenheim\/Nelson",
"6432715", "Culverden",
"643920", "Rangiora",
"6439755", "Rangiora",
"6439538", "Dunedin\/Timaru",
"647464", "Hamilton",
"6462119", "Wairoa",
"6439288", "Ashburton",
"6462808", "Napier\/Hastings",
"6432650", "Christchurch",
"6439334", "Fox\ Glacier",
"6462420", "Palmerston\ North",
"6472606", "Huntly",
"6469854", "Waipukurau",
"6462814", "Hawera",
"6432667", "South\ Island",
"6472190", "Whakatane",
"6495562", "Whangarei",
"6439277", "Invercargill",
"649959", "Hibiscus\ Coast",
"6436990", "Cheviot",
"6479747", "Te\ Kuiti",
"644895", "Paraparaumu",
"643214", "Invercargill",
"64675", "New\ Plymouth",
"6472199", "Opotiki",
"6436653", "Edendale",
"6433941", "Blenheim",
"6432659", "Takaka",
"6439285", "Invercargill",
"646964", "Wanganui",
"6462805", "Napier\/Hastings",
"647920", "Rotorua",
"6432993", "Balclutha",
"643464", "Dunedin",
"6436999", "Nelson",
"6439291", "Dunedin",
"6435532", "Motueka",
"643947", "Invercargill",
"6432606", "Dunedin",
"6462603", "Palmerston\ North",
"6499725", "Hibiscus\ Coast",
"6439055", "Fairlie",
"6436547", "Geraldine",
"6439758", "Ashburton",
"6432718", "Rangiora",
"6439535", "Fairlie",
"6467529", "Mokau",
"644209", "Wellington",
"64941", "Auckland",
"6439870", "Queenstown",
"647812", "Hamilton",
"64480", "Wellington",
"644280", "Wellington",
"6432444", "Nelson",
"6498017", "Hibiscus\ Coast",
"6434264", "Kurow",
"646849", "Napier\ City",
"6439747", "Wanaka",
"643390", "Christchurch",
"6462227", "Napier",
"6468247", "Mokau",
"6499041", "Helensville",
"6439097", "Darfield",
"6473991", "Whakatane",
"644240", "Wellington",
"6468258", "Waiouru",
"6473925", "Putaruru\/Tokoroa",
"6435675", "Twizel",
"644886", "Wellington",
"6499465", "Dargaville",
"6479241", "Whakatane",
"643415", "Balclutha",
"6477773", "Taupo",
"6496509", "Pukekohe",
"646211", "Napier",
"6469017", "Marton",
"6474649", "Matamata",
"6472140", "Putaruru\/Tokoroa",
"6478137", "Thames",
"6437452", "Akaroa",
"6465950", "Palmerston\ North",
"6439026", "Riverton",
"644570", "Wellington",
"647867", "Thames",
"6435515", "Oamaru",
"643219", "Invercargill",
"6475627", "Taupo",
"6433988", "Wanaka",
"6475613", "Te\ Awamutu",
"6436611", "Rangiora",
"6462124", "Marton",
"6439314", "Winton",
"6436659", "Haast",
"647332", "Rotorua",
"6479109", "Opotiki",
"6477886", "Rotorua",
"6462417", "Wanganui",
"6472193", "Whakatane",
"6462139", "Palmerston\ North",
"6433982", "Kurow",
"649422", "Warkworth",
"6432426", "Blenheim",
"6462423", "Gisborne",
"6469616", "Featherston",
"6469005", "Wanganui",
"6469714", "Hawera",
"6432653", "Wanaka",
"6437447", "Greymouth",
"6493944", "Hibiscus\ Coast",
"6432999", "Invercargill",
"6468306", "Napier\/Wairoa",
"643590", "Christchurch",
"6437458", "Kaikoura",
"649428", "Hibiscus\ Coast",
"6435507", "Ashburton",
"6466508", "Napier\/Wairoa",
"6466996", "Stratford",
"6436993", "Kaikoura",
"6462609", "Pahiatua",
"6498857", "Dargaville",
"649405", "Kaikohe",
"6469576", "Dannevirke",
"6474445", "Hamilton",
"6468252", "Dannevirke",
"6472116", "Thames",
"6468994", "Waipukurau",
"644815", "Wellington",
"643938", "South\ Island",
"646760", "New\ Plymouth\/Opunake\/Stratford",
"6435684", "Winton",
"6432735", "Mt\ Cook",
"6436594", "Waimate",
"6462625", "Hawera",
"6498881", "Hibiscus\ Coast",
"64340", "South\ Island",
"647883", "Putaruru\/Tokoroa",
"647875", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6492428", "Hibiscus\ Coast",
"6442608", "Paraparaumu",
"6439044", "Milton",
"6498821", "Dargaville",
"643224", "Invercargill",
"6473337", "Rotorua",
"64637", "Masterton",
"6432712", "Amberley",
"6439752", "Cheviot",
"646946", "Masterton",
"6477779", "Putaruru\/Tokoroa",
"643446", "Roxburgh",
"6435538", "Lumsden",
"6466520", "Palmerston\ North",
"6495565", "Dargaville",
"643520", "Blenheim",
"6469029", "Opunake",
"6437471", "Kurow",
"6439337", "Wanaka",
"6446509", "Paraparaumu",
"6432611", "Kaikoura",
"6439320", "Akaroa",
"6437770", "Nelson",
"6439274", "Queenstown",
"64793", "Tauranga",
"6462817", "Napier",
"6475619", "Hamilton",
"6472458", "Rotorua",
"64789", "Taumarunui",
"6432664", "Christchurch",
"6432422", "Tokanui\/Lumsden\/Te\ Anau",
"649320", "Auckland",
"647970", "Hamilton",
"6469612", "Wanganui\/New\ Plymouth",
"6468991", "Gisborne",
"6439077", "Ashburton",
"6436525", "Franz\ Josef",
"6472629", "Taupo",
"6433986", "Queenstown",
"644590", "Wellington",
"6477882", "Hamilton",
"643233", "Riverton\/Winton",
"6499747", "Dargaville",
"6467775", "Palmerston\ North",
"6435681", "Invercargill",
"6439725", "Christchurch",
"6463917", "Wanganui",
"6466992", "Hawera",
"6436591", "Nelson",
"6439028", "Edendale",
"6436585", "Tokanui",
"6439865", "Murchison",
"6435695", "Fox\ Glacier",
"6463923", "Ohakune",
"6479025", "Huntly",
"6469572", "Palmerston\ North",
"6468256", "Palmerston\ North",
"6469711", "New\ Plymouth",
"643680", "Fairlie",
"6432620", "Palmerston",
"6439311", "Invercargill",
"643989", "Nelson",
"6495532", "Warkworth",
"6432637", "Winton",
"644777", "Wellington",
"6465615", "Wanganui",
"6468807", "Gisborne",
"6433997", "Gore",
"643217", "Invercargill",
"647869", "Thames",
"644892", "Paraparaumu",
"6466010", "Taihape",
"64376", "Greymouth",
"6466553", "New\ Plymouth",
"6479009", "Hamilton",
"6474638", "Opotiki",
"643954", "Dunedin\/Timaru",
"6439271", "Westport",
"643949", "Dunedin",
"6433955", "Mt\ Cook",
"6432608", "Dunedin",
"6435543", "Tokanui",
"6432661", "Christchurch",
"6437474", "Oamaru",
"6432614", "South\ Island",
"6439756", "Akaroa",
"6472803", "Waihi",
"6432716", "Darfield",
"6447770", "Paraparaumu",
"6439000", "Christchurch",
"644619", "Wellington",
"6469202", "Levin",
"6479297", "Tauranga",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"643268", "South\ Island",
"6472605", "Thames",
"649390", "Auckland",
"646847", "Napier\/Hastings",
"6439709", "Motueka",
"6496007", "Helensville",
"6499470", "Hibiscus\ Coast",
"6498824", "Kawakawa",
"6439041", "Ashburton",
"6469309", "Mokau",
"643441", "Queenstown",
"6473947", "Whakatane",
"6435660", "Haast",
"643335", "Christchurch",
"6472623", "Tauranga",
"646375", "Pahiatua",
"6434261", "Balclutha",
"646953", "Palmerston\ North\ W100",
"6432888", "Nelson",
"6499100", "Pukekohe",
"6435536", "Invercargill",
"643453", "Dunedin",
"6432740", "Lawrence",
"6496015", "Maungaturoto",
"6432441", "Christchurch",
"6433944", "Ashburton",
"6462157", "Stratford",
"6436620", "Kaikoura",
"6436637", "Twizel",
"6462160", "Masterton",
"6496993", "Whangarei",
"6436680", "Akaroa",
"6437485", "Te\ Anau",
"6478080", "Hamilton",
"6439294", "Dunedin",
"6499630", "Pukekohe",
"6492426", "Whangarei",
"6475958", "Taupo",
"6479003", "Thames",
"6466559", "Mokau",
"64632", "Palmerston\ North",
"6497770", "Whangarei",
"646832", "Napier\/Wairoa",
"6435549", "Hokitika",
"6436614", "Timaru",
"643240", "Tokanui\/Lumsden\/Te\ Anau",
"6468815", "Pahiatua",
"647825", "Hamilton",
"6462121", "Palmerston\ North",
"6472809", "Otorohanga",
"6465607", "Taihape",
"646838", "Wairoa",
"6472118", "Taumarunui",
"647589", "Hamilton",
"6469578", "Marton",
"6499044", "Hibiscus\ Coast",
"6473994", "Rotorua",
"6439022", "Ashburton",
"64933", "Auckland",
"6434237", "Culverden",
"6466998", "New\ Plymouth",
"6436503", "Ashburton",
"644219", "Wellington",
"6437456", "Culverden",
"6434220", "Invercargill",
"6435997", "Amberley",
"6479244", "Tauranga",
"6439703", "Takaka",
"6477888", "Taupo",
"6439082", "Culverden",
"643750", "Haast",
"6469280", "Waipukurau",
"6469618", "Wanganui\/New\ Plymouth",
"6432800", "Te\ Anau",
"6469303", "Waipukurau",
"6463905", "Napier",
"6492007", "Warkworth",
"6434280", "Queenstown",
"6432428", "Queenstown",
"647886", "Putaruru\/Tokoroa",
"6477885", "Tauranga",
"6436522", "Greymouth",
"6463914", "Stratford",
"6434229", "Winton",
"64947", "Auckland",
"6469615", "Masterton",
"6469006", "Gisborne",
"6439003", "Ashburton",
"647872", "Te\ Awamutu",
"6463908", "Wairoa",
"6432425", "Invercargill",
"6469289", "Taihape",
"6468305", "Napier\/Wairoa",
"6435692", "Takaka",
"6435663", "Twizel",
"6432809", "Hokitika",
"6439074", "Ashburton",
"6439862", "Nelson",
"6436582", "Riverton",
"6434289", "Wanaka",
"6499473", "Helensville",
"6466995", "Opunake",
"6498851", "Pukekohe",
"643443", "Wanaka",
"6439722", "Blenheim",
"647878", "Te\ Kuiti",
"6467772", "Hawera",
"6497779", "Great\ Barrier\ Island",
"6435501", "Christchurch",
"6468818", "Opunake",
"6472115", "Taumarunui",
"6466550", "New\ Plymouth",
"6474446", "Otorohanga",
"6479022", "Morrinsville",
"6468804", "Napier",
"6469575", "Waiouru",
"6466013", "Featherston",
"6433994", "Winton",
"6472800", "Thames",
"6437441", "Motueka",
"6472428", "Taupo",
"6465612", "Waipukurau",
"6462411", "New\ Plymouth",
"6435540", "Edendale",
"6432634", "Invercargill",
"6432736", "Dunedin",
"6472132", "Taupo",
"6437488", "South\ Island",
"6469851", "Napier",
"6462811", "New\ Plymouth",
"6462169", "Featherston",
"649425", "Warkworth",
"6432623", "Lawrence",
"6462626", "Mokau",
"6436629", "Christchurch",
"6432617", "Cheviot",
"6439331", "Greymouth",
"6472828", "Tauranga",
"6437477", "Roxburgh",
"643279", "South\ Island",
"6442199", "Paraparaumu",
"646322", "Marton",
"6479843", "Morrinsville",
"643250", "Christchurch",
"6436689", "Christchurch",
"64349", "South\ Island",
"64683", "Napier\/Hastings",
"6433952", "Fairlie",
"6472602", "Hamilton",
"6495566", "Kaikohe",
"649402", "Kawakawa",
"643483", "Dunedin\/Lawrence\/Mosgiel",
"6473944", "Tauranga",
"643231", "Invercargill",
"643935", "South\ Island",
"6499873", "Kaitaia",
"6473331", "Rotorua",
"649408", "Kaitaia",
"6463920", "Palmerston\ North",
"644818", "Wellington",
"643740", "Christchurch",
"6499818", "Great\ Barrier\ Island",
"6432749", "Wanaka",
"6479294", "Hamilton",
"6434223", "Otautau",
"6439741", "Christchurch",
"643418", "Balclutha",
"6436500", "Christchurch",
"6439009", "Greymouth",
"643412", "Balclutha",
"6499479", "Pukekohe",
"6469300", "Gisborne",
"6434283", "Cromwell",
"6472614", "Otorohanga",
"6462806", "Napier\/Hastings",
"6432803", "Otautau",
"6435669", "Wanaka",
"6496012", "Kawakawa",
"6469283", "Opunake",
"6439286", "Cromwell",
"647949", "Hamilton",
"6472608", "Waihi",
"6439700", "Nelson",
"6439297", "Takaka",
"649957", "Pukekohe",
"6433958", "Oamaru",
"6499726", "Kawakawa",
"643984", "Blenheim",
"6497773", "Dargaville",
"6466019", "Napier",
"6439536", "Waimate",
"6479000", "Hamilton",
"6436634", "Mt\ Cook",
"6472822", "Rotorua",
"647864", "Thames",
"6462154", "New\ Plymouth",
"6433947", "Darfield",
"6493991", "Pukekohe",
"6479709", "Matamata",
"6493209", "Great\ Barrier\ Island",
"6437482", "Lumsden",
"6436617", "Cromwell",
"6496990", "Kaitaia",
"643430", "Mt\ Cook",
"644587", "Wellington",
"6432629", "Roxburgh",
"6465618", "Masterton",
"6462163", "New\ Plymouth",
"649347", "Auckland",
"6475621", "Tauranga",
"6465604", "Ohakune",
"6436623", "Amberley",
"6479849", "Thames",
"6479501", "Opotiki",
"646967", "New\ Plymouth",
"6499466", "Kaikohe",
"6473926", "Taumarunui",
"643467", "Dunedin",
"6435676", "Kurow",
"6478131", "Otorohanga",
"6468812", "Waiouru",
"6435562", "Invercargill",
"6478083", "Hamilton",
"643944", "Christchurch",
"643959", "Dunedin\/Timaru",
"6436683", "Rangiora",
"6467778", "Wairoa",
"647989", "Taupo",
"6472620", "Tauranga",
"6439728", "Franz\ Josef",
"6479247", "Hamilton",
"6436577", "Cromwell",
"6439025", "Otautau",
"6499879", "Warkworth",
"6436588", "Lumsden",
"6439868", "Blenheim",
"6435698", "Hokitika",
"6473997", "Te\ Kuiti",
"647217", "Taupo",
"643451", "Queenstown",
"6435516", "Balclutha",
"6463902", "Gisborne",
"6499047", "Pukekohe",
"646951", "Palmerston\ North",
"6439091", "Rangiora",
"6468241", "Gisborne",
"6436528", "Westport",
"6432743", "Kurow",
"6435994", "Ashburton",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"6434234", "Darfield",
"6462221", "Gisborne",
"643757", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6432747", "Queenstown",
"646952", "Palmerston\ North\ W100",
"6436504", "Cheviot",
"643452", "Wanaka",
"6435526", "Kurow",
"6473993", "Te\ Awamutu",
"6445", "Wellington\/Hutt\ Valley",
"64936", "Auckland",
"6436518", "Murchison",
"6499043", "Hibiscus\ Coast",
"6478995", "Matamata",
"646388", "Taihape",
"6499422", "Helensville",
"646769", "New\ Plymouth",
"646376", "Pahiatua",
"6469304", "Wairoa",
"646958", "Palmerston\ North\/New\ Plymouth",
"643458", "Dunedin\/Queenstown",
"6439718", "Mt\ Cook",
"6472610", "Morrinsville",
"6432758", "Otautau",
"6477771", "Whakatane",
"6469318", "Levin",
"6479243", "Rotorua\/Whakatane\/Tauranga",
"6439704", "Murchison",
"643336", "Christchurch",
"6439015", "Wanaka",
"64694", "Masterton\/Levin",
"646382", "Taihape",
"643247", "Tokanui\/Lumsden\/Te\ Anau",
"6479018", "Putaruru\/Tokoroa",
"6436687", "Nelson",
"6478078", "Whangamata",
"6442197", "Paraparaumu",
"6479004", "Te\ Awamutu",
"647220", "Tauranga",
"6468822", "Masterton",
"6479715", "Paeroa",
"6434996", "Roxburgh",
"6436630", "Takaka",
"6437479", "Edendale",
"6449740", "Paraparaumu",
"6432619", "Christchurch",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"6462150", "New\ Plymouth",
"6493932", "Dargaville",
"6475826", "Hamilton",
"6436613", "Wanaka",
"6466005", "Mokau",
"6432225", "Greymouth",
"6468882", "Napier\/Hastings",
"6462167", "Mokau",
"6475611", "Taumarunui",
"6496994", "Dargaville",
"6436651", "Riverton",
"6479852", "Whangamata",
"6479101", "Rotorua",
"6472812", "Tauranga",
"647826", "Huntly",
"6435555", "Timaru",
"6496516", "Kaikohe",
"6439345", "Christchurch",
"6433943", "Amberley",
"6465600", "Palmerston\ North",
"6499716", "Helensville",
"6432991", "Milton",
"6492836", "Kaitaia",
"6434405", "Alexandra",
"6495588", "Hibiscus\ Coast",
"6469296", "Levin",
"6439293", "Blenheim",
"643529", "Nelson",
"6434296", "Greymouth",
"6497777", "Auckland",
"6472624", "Whakatane",
"6469278", "Gisborne",
"64348", "Dunedin",
"643411", "Balclutha\/Milton",
"6434278", "Roxburgh",
"64698", "Gisborne",
"6462601", "Palmerston\ North",
"6434287", "Queenstown",
"6432807", "Tokanui",
"6469287", "Ohakune",
"6437466", "Cromwell",
"64456", "Wellington",
"6435990", "Hokitika",
"6434227", "Riverton",
"64635", "Palmerston\ North",
"6443333", "Paraparaumu",
"6434230", "Christchurch",
"646840", "Napier\ City",
"6439855", "Rangiora",
"6432815", "Fairlie",
"6439735", "Lumsden",
"649397", "Auckland\/Waiheke\ Island",
"6498883", "Whangarei",
"6499049", "Great\ Barrier\ Island",
"6499065", "Helensville",
"643238", "Riverton\/Winton",
"6473999", "Taupo",
"6439070", "Motueka",
"6498823", "Kaitaia",
"6499877", "Maungaturoto",
"649401", "Kaikohe",
"6436579", "Wanaka",
"6498817", "Hibiscus\ Coast",
"6434272", "Alexandra",
"6479249", "Huntly",
"6469272", "Featherston",
"643232", "Riverton\/Winton",
"646321", "Marton",
"64373", "Greymouth",
"6495", "Auckland",
"6439268", "Dunedin",
"6466554", "Hawera",
"6433990", "South\ Island",
"6468800", "Napier\/Hastings",
"6479847", "Te\ Awamutu",
"644893", "Wellington",
"6472804", "Whangamata",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"6462616", "Ruatoria",
"6437473", "Milton",
"6472818", "Rotorua",
"6435544", "Winton",
"6479858", "Whakatane",
"6432630", "Christchurch",
"6498691", "Maungaturoto",
"6432627", "Alexandra",
"6436619", "Cheviot",
"6499556", "Maungaturoto",
"644550", "Wellington",
"6493207", "Hibiscus\ Coast",
"6472191", "Whakatane",
"6468888", "Masterton",
"6439766", "Balclutha",
"6493938", "Auckland",
"6432651", "Queenstown",
"6433949", "Rangiora",
"6462421", "New\ Plymouth",
"6465622", "Stratford",
"6466017", "Napier",
"6478072", "Paeroa",
"6436991", "Culverden",
"6436566", "Kurow",
"6439886", "Christchurch\/Blenheim\/Nelson",
"6443", "Wellington",
"6439299", "Murchison",
"6472125", "Huntly",
"6435650", "Greymouth",
"6469312", "Ohakune",
"6432752", "Te\ Anau",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"6439712", "Fairlie",
"647460", "Rotorua",
"6475606", "Matamata",
"643924", "Christchurch",
"6499477", "Pukekohe",
"6499428", "Warkworth",
"6463924", "Marton",
"6439007", "Dunedin",
"6472222", "Hamilton",
"647871", "Te\ Awamutu",
"6439455", "Otautau",
"6479290", "Hamilton",
"643413", "Balclutha",
"6473949", "Taupo",
"64627", "Hawera",
"6478992", "Paeroa",
"6469307", "Stratford",
"647210", "Hamilton",
"6496009", "Pukekohe",
"6439707", "Takaka",
"6439458", "Edendale",
"6434233", "Rangiora",
"6436507", "Kaikoura",
"6439012", "Queenstown",
"6432744", "Ranfurly",
"6479299", "Rotorua",
"6432646", "Timaru",
"644888", "Wellington",
"6435993", "Mt\ Cook",
"6439871", "Queenstown",
"643690", "Waimate",
"6436624", "Darfield",
"6465603", "Palmerston\ North",
"643460", "Dunedin\/Palmerston",
"6468825", "Gisborne",
"6433940", "Westport",
"6479712", "Te\ Awamutu",
"646960", "Wanganui\/New\ Plymouth",
"643657", "Queenstown",
"6462164", "New\ Plymouth",
"6472128", "Waihi",
"6468885", "New\ Plymouth",
"6478084", "Hamilton",
"6436684", "Dunedin",
"6432222", "Christchurch",
"6449", "Wellington",
"6466002", "Napier",
"6439290", "Christchurch",
"6479007", "Whakatane",
"6493935", "Kawakawa",
"6439066", "Hokitika",
"644666", "Wellington",
"6439526", "Twizel",
"643977", "Christchurch",
"6439342", "Geraldine",
"6448880", "Paraparaumu",
"6433999", "Otautau",
"6435552", "Queenstown",
"6468809", "Masterton",
"6479855", "Taupo",
"6472815", "Whakatane",
"649439", "Dargaville",
"6497774", "Warkworth",
"6499456", "Kaikohe",
"643421", "Christchurch",
"6472141", "Te\ Kuiti",
"6432639", "Edendale",
"6436610", "Kaikoura",
"6496997", "Hibiscus\ Coast",
"6462153", "New\ Plymouth",
"6436633", "Geraldine",
"6434402", "Alexandra",
"6499040", "Helensville",
"6473990", "Te\ Awamutu",
"6434224", "Te\ Anau",
"6432818", "Christchurch",
"6479240", "Taupo",
"6439738", "Winton",
"6439858", "Kaikoura",
"6472627", "Rotorua",
"6432804", "Riverton",
"6439079", "Murchison",
"6472613", "Putaruru\/Tokoroa",
"6469284", "Stratford",
"6474656", "Te\ Awamutu",
"6499068", "Pukekohe",
"6434284", "Wanaka",
"646764", "Stratford",
"6492009", "Pukekohe",
"6499062", "Hibiscus\ Coast",
"6499874", "Kawakawa",
"64363", "South\ Island",
"643442", "Queenstown",
"6492226", "Helensville",
"6439852", "Cheviot",
"6498814", "Pukekohe",
"6439732", "Otautau",
"6432812", "Haast",
"64638", "Taihape\/Ohakune\/Waiouru",
"6435999", "Christchurch",
"6469275", "Wanganui",
"6479293", "Hamilton",
"6434275", "Milton",
"6434239", "Christchurch",
"643448", "Alexandra",
"647885", "Putaruru\/Tokoroa",
"647873", "Otorohanga",
"6436646", "Roxburgh",
"644904", "Paraparaumu",
"6499", "Auckland",
"6434408", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6465609", "Pahiatua",
"6472807", "Te\ Awamutu",
"6432726", "Franz\ Josef",
"6466548", "Ruatoria",
"6432624", "Milton",
"6499016", "Kaikohe",
"6435547", "Blenheim",
"64686", "Gisborne",
"6479844", "Otorohanga",
"6435558", "Waimate",
"6469045", "Waipukurau",
"6466557", "Stratford",
"6439348", "South\ Island",
"6468803", "Gisborne",
"6463996", "Palmerston\ North",
"6465625", "Gisborne",
"6433993", "Te\ Anau",
"6466014", "Napier",
"6466008", "Ohakune",
"6466521", "Palmerston\ North",
"644891", "Wellington",
"6432228", "Wanaka",
"6472122", "Te\ Awamutu",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"643524", "Takaka",
"6437771", "Blenheim",
"6469246", "Palmerston\ North",
"6478142", "Whakatane",
"6432633", "Otautau",
"6478075", "Te\ Kuiti",
"6436639", "Oamaru",
"6437470", "Balclutha",
"6479718", "Taumarunui",
"649426", "Hibiscus\ Coast",
"6439321", "Amberley",
"6432610", "Darfield",
"6462159", "Mokau",
"6435886", "Invercargill",
"646656", "Levin",
"6439004", "Gore",
"6463927", "Dannevirke",
"6432755", "Edendale",
"6439715", "Timaru",
"6498880", "Helensville",
"6469315", "Taihape",
"6463913", "Hawera",
"6433916", "Hokitika",
"6439018", "Ranfurly",
"649403", "Kawakawa",
"643936", "South\ Island",
"6439452", "Gore",
"6462106", "Pahiatua",
"6472225", "Rotorua",
"64634", "Wanganui",
"6498820", "Whangarei",
"6499474", "Helensville",
"6478998", "Hamilton",
"6435664", "Timaru",
"6439073", "Motueka",};
my $timezones = {
               '' => [
                       'Pacific/Auckland',
                       'Pacific/Chatham'
                     ],
               '1' => [
                        'Pacific/Auckland'
                      ],
               '2' => [
                        'Pacific/Auckland'
                      ],
               '3' => [
                        'Pacific/Auckland'
                      ],
               '330' => [
                          'Pacific/Chatham'
                        ],
               '4' => [
                        'Pacific/Auckland'
                      ],
               '5' => [
                        'Pacific/Auckland'
                      ],
               '6' => [
                        'Pacific/Auckland'
                      ],
               '7' => [
                        'Pacific/Auckland'
                      ],
               '8' => [
                        'Pacific/Auckland'
                      ],
               '9' => [
                        'Pacific/Auckland'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;